/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Bucket;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.upplication.s3fs.S3FileStore;
import com.upplication.s3fs.S3FileSystemProvider;
import com.upplication.s3fs.S3Path;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.List;
import java.util.Set;

public class S3FileSystem
extends FileSystem
implements Comparable<S3FileSystem> {
    private final S3FileSystemProvider provider;
    private final String key;
    private final AmazonS3 client;
    private final String endpoint;
    private int cache;

    public S3FileSystem(S3FileSystemProvider provider, String key, AmazonS3 client, String endpoint) {
        this.provider = provider;
        this.key = key;
        this.client = client;
        this.endpoint = endpoint;
        this.cache = 60000;
    }

    @Override
    public S3FileSystemProvider provider() {
        return this.provider;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public void close() throws IOException {
        this.provider.close(this);
    }

    @Override
    public boolean isOpen() {
        return this.provider.isOpen(this);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (FileStore fileStore : this.getFileStores()) {
            builder.add((Object)((S3FileStore)fileStore).getRootDirectory());
        }
        return builder.build();
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Bucket bucket : this.client.listBuckets()) {
            builder.add((Object)new S3FileStore(this, bucket.getName()));
        }
        return builder.build();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return ImmutableSet.of((Object)"basic", (Object)"posix");
    }

    @Override
    public S3Path getPath(String first, String ... more) {
        if (more.length == 0) {
            return new S3Path(this, first);
        }
        return new S3Path(this, first, more);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException();
    }

    public AmazonS3 getClient() {
        return this.client;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String[] key2Parts(String keyParts) {
        String[] parts = keyParts.split("/");
        String[] split = new String[parts.length];
        int i = 0;
        for (String part : parts) {
            split[i++] = part;
        }
        return split;
    }

    public String parts2Key(List<String> parts) {
        if (parts.isEmpty()) {
            return "";
        }
        return Joiner.on((String)"/").join((Iterable)ImmutableList.copyOf(parts));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3FileSystem)) {
            return false;
        }
        S3FileSystem other = (S3FileSystem)obj;
        if (this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint)) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    @Override
    public int compareTo(S3FileSystem o) {
        return this.key.compareTo(o.getKey());
    }

    public int getCache() {
        return this.cache;
    }
}

