/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.upplication.s3fs.S3FileAttributes;
import com.upplication.s3fs.S3FileStore;
import com.upplication.s3fs.S3FileSystem;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class S3Path
implements Path {
    public static final String PATH_SEPARATOR = "/";
    private final S3FileStore fileStore;
    private final List<String> parts;
    private S3FileSystem fileSystem;
    private S3FileAttributes fileAttributes;

    public S3Path(S3FileSystem fileSystem, String path) {
        this(fileSystem, path, "");
    }

    public S3Path(S3FileSystem fileSystem, String first, String ... more) {
        String bucket = null;
        List pathParts = Lists.newArrayList((Iterable)Splitter.on((String)PATH_SEPARATOR).split((CharSequence)first));
        if (first.endsWith(PATH_SEPARATOR)) {
            pathParts.remove(pathParts.size() - 1);
        }
        if (first.startsWith(PATH_SEPARATOR)) {
            Preconditions.checkArgument(((pathParts = pathParts.subList(1, pathParts.size())).size() >= 1 ? 1 : 0) != 0, (Object)"path must start with bucket name");
            Preconditions.checkArgument((!((String)pathParts.get(0)).isEmpty() ? 1 : 0) != 0, (Object)"bucket name must be not empty");
            bucket = (String)pathParts.get(0);
            pathParts = pathParts.subList(1, pathParts.size());
        }
        ArrayList moreSplitted = Lists.newArrayList();
        for (String part : more) {
            moreSplitted.addAll(Lists.newArrayList((Iterable)Splitter.on((String)PATH_SEPARATOR).split((CharSequence)part)));
        }
        pathParts.addAll(moreSplitted);
        this.fileStore = bucket != null ? new S3FileStore(fileSystem, bucket) : null;
        this.parts = KeyParts.parse(pathParts);
        this.fileSystem = fileSystem;
    }

    S3Path(S3FileSystem fileSystem, S3FileStore fileStore, Iterable<String> keys) {
        this.fileStore = fileStore;
        this.parts = KeyParts.parse(keys);
        this.fileSystem = fileSystem;
    }

    S3Path(S3FileSystem fileSystem, S3FileStore fileStore, String ... keys) {
        this.fileStore = fileStore;
        this.parts = KeyParts.parse(keys);
        this.fileSystem = fileSystem;
    }

    public S3FileStore getFileStore() {
        return this.fileStore;
    }

    public String getKey() {
        return this.fileSystem.parts2Key(this.parts);
    }

    @Override
    public S3FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.fileStore != null;
    }

    @Override
    public Path getRoot() {
        if (this.isAbsolute()) {
            return new S3Path(this.fileSystem, this.fileStore, (Iterable<String>)ImmutableList.of());
        }
        return null;
    }

    @Override
    public Path getFileName() {
        if (!this.parts.isEmpty()) {
            return new S3Path(this.fileSystem, null, this.parts.subList(this.parts.size() - 1, this.parts.size()));
        }
        return new S3Path(this.fileSystem, (S3FileStore)null, this.fileStore != null ? this.fileStore.name() : null);
    }

    @Override
    public Path getParent() {
        if (this.parts.isEmpty()) {
            return null;
        }
        if (this.parts.size() == 1 && this.fileStore == null) {
            return null;
        }
        return new S3Path(this.fileSystem, this.fileStore, this.parts.subList(0, this.parts.size() - 1));
    }

    @Override
    public int getNameCount() {
        return this.parts.size();
    }

    @Override
    public Path getName(int index) {
        return new S3Path(this.fileSystem, null, this.parts.subList(index, index + 1));
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        return new S3Path(this.fileSystem, null, this.parts.subList(beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(Path other) {
        if (other.getNameCount() > this.getNameCount()) {
            return false;
        }
        if (!(other instanceof S3Path)) {
            return false;
        }
        S3Path path = (S3Path)other;
        if (path.parts.size() == 0 && path.fileStore == null && (this.parts.size() != 0 || this.fileStore != null)) {
            return false;
        }
        if (path.getFileStore() != null && !path.getFileStore().equals(this.getFileStore()) || path.getFileStore() == null && this.getFileStore() != null) {
            return false;
        }
        for (int i = 0; i < path.parts.size(); ++i) {
            if (path.parts.get(i).equals(this.parts.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean startsWith(String path) {
        S3Path other = new S3Path(this.fileSystem, path);
        return this.startsWith(other);
    }

    @Override
    public boolean endsWith(Path other) {
        if (other.getNameCount() > this.getNameCount()) {
            return false;
        }
        if (other.getNameCount() == 0 && this.getNameCount() != 0) {
            return false;
        }
        if (!(other instanceof S3Path)) {
            return false;
        }
        S3Path path = (S3Path)other;
        if (path.getFileStore() != null && !path.getFileStore().equals(this.getFileStore()) || path.getFileStore() != null && this.getFileStore() == null) {
            return false;
        }
        int i = path.parts.size() - 1;
        for (int j = this.parts.size() - 1; i >= 0 && j >= 0; --i, --j) {
            if (path.parts.get(i).equals(this.parts.get(j))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(String other) {
        return this.endsWith(new S3Path(this.fileSystem, other));
    }

    @Override
    public Path normalize() {
        return this;
    }

    @Override
    public Path resolve(Path other) {
        if (other.isAbsolute()) {
            Preconditions.checkArgument((boolean)(other instanceof S3Path), (String)"other must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
            return other;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < other.getNameCount(); ++i) {
            builder.add((Object)other.getName(i).toString());
        }
        ImmutableList otherParts = builder.build();
        if (otherParts.isEmpty()) {
            return this;
        }
        return new S3Path(this.fileSystem, this.fileStore, Iterables.concat(this.parts, (Iterable)otherParts));
    }

    @Override
    public Path resolve(String other) {
        return this.resolve(new S3Path(this.getFileSystem(), other));
    }

    @Override
    public Path resolveSibling(Path other) {
        Preconditions.checkArgument((boolean)(other instanceof S3Path), (String)"other must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        S3Path s3Path = (S3Path)other;
        Path parent = this.getParent();
        if (parent == null || s3Path.isAbsolute()) {
            return s3Path;
        }
        if (s3Path.parts.isEmpty()) {
            return parent;
        }
        return new S3Path(this.fileSystem, this.fileStore, Iterables.concat(this.parts.subList(0, this.parts.size() - 1), s3Path.parts));
    }

    @Override
    public Path resolveSibling(String other) {
        return this.resolveSibling(new S3Path(this.getFileSystem(), other));
    }

    @Override
    public Path relativize(Path other) {
        Preconditions.checkArgument((boolean)(other instanceof S3Path), (String)"other must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        S3Path s3Path = (S3Path)other;
        if (this.equals(other)) {
            return new S3Path(this.getFileSystem(), "");
        }
        Preconditions.checkArgument((boolean)this.isAbsolute(), (String)"Path is already relative: %s", (Object[])new Object[]{this});
        Preconditions.checkArgument((boolean)s3Path.isAbsolute(), (String)"Cannot relativize against a relative path: %s", (Object[])new Object[]{s3Path});
        Preconditions.checkArgument((boolean)this.fileStore.equals(s3Path.getFileStore()), (String)"Cannot relativize paths with different buckets: '%s', '%s'", (Object[])new Object[]{this, other});
        Preconditions.checkArgument((this.parts.size() <= s3Path.parts.size() ? 1 : 0) != 0, (String)"Cannot relativize against a parent path: '%s', '%s'", (Object[])new Object[]{this, other});
        int startPart = 0;
        for (int i = 0; i < this.parts.size(); ++i) {
            if (!this.parts.get(i).equals(s3Path.parts.get(i))) continue;
            ++startPart;
        }
        return new S3Path(this.fileSystem, null, s3Path.parts.subList(startPart, s3Path.parts.size()));
    }

    @Override
    public URI toUri() {
        if (this.fileStore == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("s3://");
        builder.append(this.fileSystem.getKey());
        builder.append(PATH_SEPARATOR);
        builder.append(this.fileStore.name());
        builder.append(PATH_SEPARATOR);
        builder.append(Joiner.on((String)PATH_SEPARATOR).join(this.parts));
        return URI.create(builder.toString());
    }

    @Override
    public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        throw new IllegalStateException(String.format("Relative path cannot be made absolute: %s", this));
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Path> iterator() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String part : this.parts) {
            builder.add((Object)new S3Path(this.fileSystem, null, (Iterable<String>)ImmutableList.of((Object)part)));
        }
        return builder.build().iterator();
    }

    @Override
    public int compareTo(Path other) {
        return this.toString().compareTo(other.toString());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isAbsolute()) {
            builder.append(PATH_SEPARATOR);
            builder.append(this.fileStore.name());
            builder.append(PATH_SEPARATOR);
        }
        List<String> parts2 = this.parts;
        Iterator<String> iterator = parts2.iterator();
        while (iterator.hasNext()) {
            String part = iterator.next();
            builder.append(part);
            if (!iterator.hasNext()) continue;
            builder.append(PATH_SEPARATOR);
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3Path paths = (S3Path)o;
        if (this.fileStore != null ? !this.fileStore.equals(paths.fileStore) : paths.fileStore != null) {
            return false;
        }
        return this.parts.equals(paths.parts);
    }

    @Override
    public int hashCode() {
        int result = this.fileStore != null ? this.fileStore.name().hashCode() : 0;
        result = 31 * result + this.parts.hashCode();
        return result;
    }

    public S3FileAttributes getFileAttributes() {
        return this.fileAttributes;
    }

    public void setFileAttributes(S3FileAttributes fileAttributes) {
        this.fileAttributes = fileAttributes;
    }

    private static Function<String, String> strip(final String ... strs) {
        return new Function<String, String>(){

            public String apply(String input) {
                String res = input;
                if (res != null) {
                    for (String str : strs) {
                        res = res.replace(str, "");
                    }
                }
                return res;
            }
        };
    }

    private static Predicate<String> notEmpty() {
        return new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return input != null && !input.isEmpty();
            }
        };
    }

    private static abstract class KeyParts {
        private KeyParts() {
        }

        private static ImmutableList<String> parse(String[] parts) {
            return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(Arrays.asList(parts), (Function)S3Path.strip(new String[]{S3Path.PATH_SEPARATOR})), (Predicate)S3Path.notEmpty()));
        }

        private static ImmutableList<String> parse(List<String> parts) {
            return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(parts, (Function)S3Path.strip(new String[]{S3Path.PATH_SEPARATOR})), (Predicate)S3Path.notEmpty()));
        }

        private static ImmutableList<String> parse(Iterable<String> parts) {
            return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(parts, (Function)S3Path.strip(new String[]{S3Path.PATH_SEPARATOR})), (Predicate)S3Path.notEmpty()));
        }
    }
}

