/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs.util;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.upplication.s3fs.AmazonS3Client;
import com.upplication.s3fs.S3Path;
import java.nio.file.NoSuchFileException;

public class S3ObjectSummaryLookup {
    public S3ObjectSummary lookup(S3Path s3Path) throws NoSuchFileException {
        AmazonS3Client client = s3Path.getFileSystem().getClient();
        S3Object object = this.getS3Object(s3Path);
        if (object != null) {
            S3ObjectSummary result = new S3ObjectSummary();
            result.setBucketName(object.getBucketName());
            result.setETag(object.getObjectMetadata().getETag());
            result.setKey(object.getKey());
            result.setLastModified(object.getObjectMetadata().getLastModified());
            result.setSize(object.getObjectMetadata().getContentLength());
            return result;
        }
        String key = s3Path.getKey() + "/";
        ListObjectsRequest request = new ListObjectsRequest();
        request.setBucketName(s3Path.getBucket());
        request.setPrefix(key);
        request.setMaxKeys(Integer.valueOf(1));
        ObjectListing current = client.listObjects(request);
        if (!current.getObjectSummaries().isEmpty()) {
            return (S3ObjectSummary)current.getObjectSummaries().get(0);
        }
        throw new NoSuchFileException(s3Path.toString());
    }

    private S3Object getS3Object(S3Path s3Path) {
        try {
            return s3Path.getFileSystem().getClient().getObject(s3Path.getBucket(), s3Path.getKey());
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() != 404) {
                throw e;
            }
            try {
                return s3Path.getFileSystem().getClient().getObject(s3Path.getBucket(), s3Path.getKey() + "/");
            }
            catch (AmazonS3Exception e2) {
                if (e2.getStatusCode() != 404) {
                    throw e;
                }
                return null;
            }
        }
    }
}

