/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Grant;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.upplication.s3fs.AmazonS3Client;
import com.upplication.s3fs.S3FileAttributes;
import com.upplication.s3fs.S3FileSystem;
import com.upplication.s3fs.S3Path;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class S3FileSystemProvider
extends FileSystemProvider {
    public static final String ACCESS_KEY = "access_key";
    public static final String SECRET_KEY = "secret_key";
    final AtomicReference<S3FileSystem> fileSystem = new AtomicReference();

    @Override
    public String getScheme() {
        return "s3";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        Preconditions.checkNotNull((Object)uri, (Object)"uri is null");
        Preconditions.checkArgument((boolean)uri.getScheme().equals("s3"), (String)"uri scheme must be 's3': '%s'", (Object[])new Object[]{uri});
        Properties props = this.loadAmazonProperties();
        String accessKey = props.getProperty(ACCESS_KEY);
        String secretKey = props.getProperty(SECRET_KEY);
        if (env.get(ACCESS_KEY) != null) {
            accessKey = env.get(ACCESS_KEY);
        }
        if (env.get(SECRET_KEY) != null) {
            secretKey = env.get(SECRET_KEY);
        }
        Preconditions.checkArgument((accessKey == null && secretKey == null || accessKey != null && secretKey != null ? 1 : 0) != 0, (String)"%s and %s should both be provided or should both be omitted", (Object[])new Object[]{ACCESS_KEY, SECRET_KEY});
        S3FileSystem result = this.createFileSystem(uri, accessKey, secretKey);
        if (!this.fileSystem.compareAndSet(null, result)) {
            throw new FileSystemAlreadyExistsException("S3 filesystem already exists. Use getFileSystem() instead");
        }
        return result;
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        FileSystem fileSystem = this.fileSystem.get();
        if (fileSystem == null) {
            throw new FileSystemNotFoundException(String.format("S3 filesystem not yet created. Use newFileSystem() instead", new Object[0]));
        }
        return fileSystem;
    }

    @Override
    public Path getPath(URI uri) {
        Preconditions.checkArgument((boolean)uri.getScheme().equals(this.getScheme()), (String)"URI scheme must be %s", (Object[])new Object[]{this.getScheme()});
        if (uri.getHost() != null && !uri.getHost().isEmpty() && !uri.getHost().equals(this.fileSystem.get().getEndpoint())) {
            throw new IllegalArgumentException(String.format("only empty URI host or URI host that matching the current fileSystem: %s", this.fileSystem.get().getEndpoint()));
        }
        return this.getFileSystem(uri).getPath(uri.getPath(), new String[0]);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        Preconditions.checkArgument((boolean)(dir instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        final S3Path s3Path = (S3Path)dir;
        return new DirectoryStream<Path>(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public Iterator<Path> iterator() {
                return new Iterator<Path>(){
                    private S3Path dir;
                    private Iterator<S3Path> it;
                    {
                        this.dir = s3Path;
                    }

                    @Override
                    public void remove() {
                    }

                    @Override
                    public Path next() {
                        return this.getIterator().next();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.getIterator().hasNext();
                    }

                    private Iterator<S3Path> getIterator() {
                        if (this.it == null) {
                            ArrayList<S3Path> listPath = new ArrayList<S3Path>();
                            ListObjectsRequest request = new ListObjectsRequest();
                            request.setBucketName(s3Path.getBucket());
                            request.setPrefix(s3Path.getKey());
                            request.setMarker(s3Path.getKey());
                            ObjectListing current = this.dir.getFileSystem().getClient().listObjects(request);
                            while (current.isTruncated()) {
                                this.parseObjectListing(listPath, current);
                                current = this.dir.getFileSystem().getClient().listNextBatchOfObjects(current);
                            }
                            this.parseObjectListing(listPath, current);
                            this.it = listPath.iterator();
                        }
                        return this.it;
                    }

                    private void parseObjectListing(List<S3Path> listPath, ObjectListing current) {
                        for (S3ObjectSummary objectSummary : current.getObjectSummaries()) {
                            S3Path descendentPart;
                            String key = objectSummary.getKey();
                            String folder = this.getInmediateDescendent(s3Path.getKey(), key);
                            if (folder == null || listPath.contains(descendentPart = new S3Path(this.dir.getFileSystem(), objectSummary.getBucketName(), folder.split("/")))) continue;
                            listPath.add(descendentPart);
                        }
                    }

                    private String getInmediateDescendent(String keyParent, String keyChild) {
                        keyParent = this.deleteExtraPath(keyParent);
                        if (!(keyChild = this.deleteExtraPath(keyChild)).startsWith(keyParent)) {
                            throw new IllegalArgumentException("Invalid child '" + keyChild + "' for parent '" + keyParent + "'");
                        }
                        int parentLen = keyParent.length();
                        String childWithoutParent = this.deleteExtraPath(keyChild.substring(parentLen));
                        String[] parts = childWithoutParent.split("/");
                        if (parts.length > 0 && !parts[0].isEmpty()) {
                            return keyParent + "/" + parts[0];
                        }
                        return null;
                    }

                    private String deleteExtraPath(String keyChild) {
                        if (keyChild.startsWith("/")) {
                            keyChild = keyChild.substring(1);
                        }
                        if (keyChild.endsWith("/")) {
                            keyChild = keyChild.substring(0, keyChild.length() - 1);
                        }
                        return keyChild;
                    }
                };
            }
        };
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        Preconditions.checkArgument((options.length == 0 ? 1 : 0) != 0, (String)"OpenOptions not yet supported: %s", (Object[])new Object[]{ImmutableList.copyOf((Object[])options)});
        Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        S3Path s3Path = (S3Path)path;
        Preconditions.checkArgument((!s3Path.getKey().equals("") ? 1 : 0) != 0, (String)"cannot create InputStream for root directory: %s", (Object[])new Object[]{s3Path});
        S3ObjectInputStream res = s3Path.getFileSystem().getClient().getObject(s3Path.getBucket(), s3Path.getKey()).getObjectContent();
        if (res == null) {
            throw new IOException("path is a directory");
        }
        return res;
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        final S3Path s3Path = (S3Path)path;
        final Path tempFile = Files.createTempFile("file", s3Path.getFileName().toString(), new FileAttribute[0]);
        return new FileOutputStream(tempFile.toFile()){

            @Override
            public void close() throws IOException {
                super.close();
                s3Path.getFileSystem().getClient().putObject(s3Path.getBucket(), s3Path.getKey(), tempFile.toFile());
                Files.deleteIfExists(tempFile);
            }
        };
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        final S3Path s3Path = (S3Path)path;
        final Path tempDir = Files.createTempDirectory("temp-s3", new FileAttribute[0]);
        final Path file = tempDir.resolve(path.getFileName().toString());
        final SeekableByteChannel seekable = Files.newByteChannel(file, options, new FileAttribute[0]);
        return new SeekableByteChannel(){

            @Override
            public boolean isOpen() {
                return seekable.isOpen();
            }

            @Override
            public void close() throws IOException {
                seekable.close();
                s3Path.getFileSystem().getClient().putObject(s3Path.getBucket(), s3Path.getKey(), file.toFile());
                Files.walkFileTree(tempDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (exc == null) {
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }
                        throw exc;
                    }
                });
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return seekable.write(src);
            }

            @Override
            public SeekableByteChannel truncate(long size) throws IOException {
                return seekable.truncate(size);
            }

            @Override
            public long size() throws IOException {
                return seekable.size();
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                return seekable.read(dst);
            }

            @Override
            public SeekableByteChannel position(long newPosition) throws IOException {
                return seekable.position(newPosition);
            }

            @Override
            public long position() throws IOException {
                return seekable.position();
            }
        };
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        S3Path s3Path = (S3Path)dir;
        Preconditions.checkArgument((attrs.length == 0 ? 1 : 0) != 0, (String)"attrs not yet supported: %s", (Object[])new Object[]{ImmutableList.copyOf((Object[])attrs)});
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(0L);
        String keyName = s3Path.getKey() + (s3Path.getKey().endsWith("/") ? "" : "/");
        s3Path.getFileSystem().getClient().putObject(s3Path.getBucket(), keyName, new ByteArrayInputStream(new byte[0]), metadata);
    }

    @Override
    public void delete(Path path) throws IOException {
        Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        S3Path s3Path = (S3Path)path;
        s3Path.getFileSystem().getClient().deleteObject(s3Path.getBucket(), s3Path.getKey());
        s3Path.getFileSystem().getClient().deleteObject(s3Path.getBucket(), s3Path.getKey() + "/");
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        Preconditions.checkArgument((boolean)(source instanceof S3Path), (String)"source must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        Preconditions.checkArgument((boolean)(target instanceof S3Path), (String)"target must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        if (this.isSameFile(source, target)) {
            return;
        }
        S3Path s3Source = (S3Path)source;
        S3Path s3Target = (S3Path)target;
        ImmutableSet actualOptions = ImmutableSet.copyOf((Object[])options);
        this.verifySupportedOptions((Set)EnumSet.of(StandardCopyOption.REPLACE_EXISTING), (Set)actualOptions);
        if (!actualOptions.contains((Object)StandardCopyOption.REPLACE_EXISTING) && this.exists(s3Target)) {
            throw new FileAlreadyExistsException(String.format("target already exists: %s", target));
        }
        s3Source.getFileSystem().getClient().copyObject(s3Source.getBucket(), s3Source.getKey(), s3Target.getBucket(), s3Target.getKey());
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) throws IOException {
        return path1.isAbsolute() && path2.isAbsolute() && path1.equals(path2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        S3Path s3Path = (S3Path)path;
        Preconditions.checkArgument((boolean)s3Path.isAbsolute(), (String)"path must be absolute: %s", (Object[])new Object[]{s3Path});
        AmazonS3Client client = s3Path.getFileSystem().getClient();
        AccessControlList acl = this.getAccessControl(s3Path);
        block5: for (AccessMode accessMode : modes) {
            switch (accessMode) {
                case EXECUTE: {
                    throw new AccessDeniedException(s3Path.toString(), null, "file is not executable");
                }
                case READ: {
                    if (this.hasPermissions(acl, client.getS3AccountOwner(), EnumSet.of(Permission.FullControl, Permission.Read))) continue block5;
                    throw new AccessDeniedException(s3Path.toString(), null, "file is not readable");
                }
                case WRITE: {
                    if (this.hasPermissions(client.getBucketAcl(s3Path.getBucket()), client.getS3AccountOwner(), EnumSet.of(Permission.FullControl, Permission.Write))) continue block5;
                    throw new AccessDeniedException(s3Path.toString(), null, String.format("bucket '%s' is not writable", s3Path.getBucket()));
                }
                default: {
                    throw new UnsupportedOperationException(String.format("access mode '%s' not supported", new Object[]{accessMode}));
                }
            }
        }
    }

    private boolean hasPermissions(AccessControlList acl, Owner owner, EnumSet<Permission> permissions) {
        boolean result = false;
        for (Grant grant : acl.getGrants()) {
            if (!grant.getGrantee().getIdentifier().equals(owner.getId()) || !permissions.contains(grant.getPermission())) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        S3Path s3Path = (S3Path)path;
        if (type == BasicFileAttributes.class) {
            S3ObjectSummary objectSummary = this.getFirstObjectSummary(s3Path);
            FileTime lastModifiedTime = FileTime.from(objectSummary.getLastModified().getTime(), TimeUnit.MILLISECONDS);
            long size = objectSummary.getSize();
            boolean directory = false;
            boolean regularFile = true;
            String key = objectSummary.getKey();
            if (objectSummary.getKey().equals(s3Path.getKey()) && objectSummary.getKey().endsWith("/")) {
                directory = true;
            } else if (!objectSummary.getKey().equals(s3Path.getKey()) && objectSummary.getKey().startsWith(s3Path.getKey())) {
                directory = true;
                size = 0L;
            } else if (objectSummary.getKey().equals(s3Path.getKey())) {
                directory = false;
            } else {
                throw new NoSuchFileException(path.toString());
            }
            return (A)((BasicFileAttributes)type.cast(new S3FileAttributes(key, lastModifiedTime, size, directory, regularFile)));
        }
        return null;
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected S3FileSystem createFileSystem(URI uri, Object accessKey, Object secretKey) {
        AmazonS3Client client = accessKey == null && secretKey == null ? new AmazonS3Client((AmazonS3)new com.amazonaws.services.s3.AmazonS3Client()) : new AmazonS3Client((AmazonS3)new com.amazonaws.services.s3.AmazonS3Client((AWSCredentials)new BasicAWSCredentials(accessKey.toString(), secretKey.toString())));
        if (uri.getHost() != null) {
            client.setEndpoint(uri.getHost());
        }
        S3FileSystem result = new S3FileSystem(this, client, uri.getHost());
        return result;
    }

    protected Properties loadAmazonProperties() {
        Properties props = new Properties();
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("amazon.properties");){
            if (in != null) {
                props.load(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    private <T> void verifySupportedOptions(Set<? extends T> allowedOptions, Set<? extends T> actualOptions) {
        Sets.SetView unsupported = Sets.difference(actualOptions, allowedOptions);
        Preconditions.checkArgument((boolean)unsupported.isEmpty(), (String)"the following options are not supported: %s", (Object[])new Object[]{unsupported});
    }

    private boolean exists(S3Path path) {
        try {
            this.getFirstObjectSummary(path);
            return true;
        }
        catch (NoSuchFileException e) {
            return false;
        }
    }

    private S3ObjectSummary getFirstObjectSummary(S3Path s3Path) throws NoSuchFileException {
        S3ObjectSummary res = null;
        try {
            AmazonS3Client client = s3Path.getFileSystem().getClient();
            ListObjectsRequest request = new ListObjectsRequest();
            request.setBucketName(s3Path.getBucket());
            request.setPrefix(s3Path.getKey());
            request.setMaxKeys(Integer.valueOf(1));
            List query = client.listObjects(request).getObjectSummaries();
            if (query.isEmpty()) {
                throw new NoSuchFileException(s3Path.toString());
            }
            res = (S3ObjectSummary)query.get(0);
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 404) {
                throw new NoSuchFileException(s3Path.toString());
            }
            Throwables.propagate((Throwable)e);
        }
        return res;
    }

    private AccessControlList getAccessControl(S3Path path) throws NoSuchFileException {
        AccessControlList res = null;
        S3ObjectSummary obj = this.getFirstObjectSummary(path);
        try {
            res = path.getFileSystem().getClient().getObjectAcl(obj.getBucketName(), obj.getKey());
        }
        catch (AmazonS3Exception e) {
            Throwables.propagate((Throwable)e);
        }
        return res;
    }
}

