/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.OptionsParser;

public final class JSONOptions {
    public static final JSONOptions Default = new JSONOptions();
    private final boolean propVarbase64padding;
    private final boolean propVarpreservenegativezero;
    private final ConversionMode propVarnumberconversion;
    private final boolean propVarwritebasic;
    private final boolean propVarkeepkeyorder;
    private final boolean propVarallowduplicatekeys;
    private final boolean propVarreplacesurrogates;

    public JSONOptions() {
        this("");
    }

    @Deprecated
    public JSONOptions(boolean base64Padding) {
        this("base64Padding=" + (base64Padding ? "1" : "0"));
    }

    @Deprecated
    public JSONOptions(boolean base64Padding, boolean replaceSurrogates) {
        this("base64Padding=" + (base64Padding ? "1" : "0") + ";replacesurrogates=" + (replaceSurrogates ? "1" : "0"));
    }

    public JSONOptions(String paramString) {
        if (paramString == null) {
            throw new NullPointerException("paramString");
        }
        OptionsParser parser = new OptionsParser(paramString);
        this.propVarpreservenegativezero = parser.GetBoolean("preservenegativezero", true);
        this.propVarallowduplicatekeys = parser.GetBoolean("allowduplicatekeys", false);
        this.propVarkeepkeyorder = parser.GetBoolean("keepkeyorder", false);
        this.propVarbase64padding = parser.GetBoolean("base64padding", true);
        this.propVarreplacesurrogates = parser.GetBoolean("replacesurrogates", false);
        this.propVarnumberconversion = JSONOptions.ToNumberConversion(parser.GetLCString("numberconversion", null));
        this.propVarwritebasic = parser.GetBoolean("writebasic", false);
    }

    public String toString() {
        return "base64padding=" + (this.getBase64Padding() ? "true" : "false") + ";replacesurrogates=" + (this.getReplaceSurrogates() ? "true" : "false") + ";preservenegativezero=" + (this.getPreserveNegativeZero() ? "true" : "false") + ";keepkeyorder=" + (this.getKeepKeyOrder() ? "true" : "false") + ";numberconversion=" + this.FromNumberConversion() + ";allowduplicatekeys=" + (this.getAllowDuplicateKeys() ? "true" : "false") + ";writebasic=" + (this.getWriteBasic() ? "true" : "false");
    }

    @Deprecated
    public final boolean getBase64Padding() {
        return this.propVarbase64padding;
    }

    private String FromNumberConversion() {
        ConversionMode kind = this.getNumberConversion();
        return kind == ConversionMode.Full ? "full" : (kind == ConversionMode.Double ? "double" : (kind == ConversionMode.Decimal128 ? "decimal128" : (kind == ConversionMode.IntOrFloat ? "intorfloat" : (kind == ConversionMode.IntOrFloatFromDouble ? "intorfloatfromdouble" : "full"))));
    }

    private static ConversionMode ToNumberConversion(String str) {
        if (str != null) {
            if (str.equals("full")) {
                return ConversionMode.Full;
            }
            if (str.equals("double")) {
                return ConversionMode.Double;
            }
            if (str.equals("decimal128")) {
                return ConversionMode.Decimal128;
            }
            if (str.equals("intorfloat")) {
                return ConversionMode.IntOrFloat;
            }
            if (str.equals("intorfloatfromdouble")) {
                return ConversionMode.IntOrFloatFromDouble;
            }
        } else {
            return ConversionMode.IntOrFloat;
        }
        throw new IllegalArgumentException("Unrecognized conversion mode");
    }

    public final boolean getPreserveNegativeZero() {
        return this.propVarpreservenegativezero;
    }

    public final ConversionMode getNumberConversion() {
        return this.propVarnumberconversion;
    }

    public final boolean getWriteBasic() {
        return this.propVarwritebasic;
    }

    public final boolean getKeepKeyOrder() {
        return this.propVarkeepkeyorder;
    }

    public final boolean getAllowDuplicateKeys() {
        return this.propVarallowduplicatekeys;
    }

    public final boolean getReplaceSurrogates() {
        return this.propVarreplacesurrogates;
    }

    public static enum ConversionMode {
        Full,
        Double,
        IntOrFloat,
        IntOrFloatFromDouble,
        Decimal128;

    }
}

