/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORDataUtilities;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.JSONOptions;
import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;

final class CBORDataUtilitiesCharArrayString {
    private static final long DoubleNegInfinity = -4503599627370496L;
    private static final long DoublePosInfinity = 0x7FF0000000000000L;

    private CBORDataUtilitiesCharArrayString() {
    }

    static CBORObject ParseJSONNumber(char[] chars, int offset, int count, JSONOptions options, int[] endOfNumber) {
        if (chars == null || chars.length == 0 || count <= 0) {
            return null;
        }
        if (offset < 0 || offset > chars.length) {
            return null;
        }
        if (count > chars.length || chars.length - offset < count) {
            return null;
        }
        options = options == null ? CBORDataUtilities.DefaultOptions : options;
        boolean preserveNegativeZero = options.getPreserveNegativeZero();
        JSONOptions.ConversionMode kind = options.getNumberConversion();
        int endPos = offset + count;
        int initialOffset = offset++;
        boolean negative = false;
        if (chars[initialOffset] == '-') {
            negative = true;
        }
        int numOffset = offset;
        boolean haveDecimalPoint = false;
        boolean haveDigits = false;
        boolean haveDigitsAfterDecimal = false;
        boolean haveNonzeroDigits = false;
        boolean haveExponent = false;
        int i = offset;
        int decimalPointPos = -1;
        int k = i;
        if (endPos - 1 > k && chars[k] == '0' && chars[k + 1] >= '0' && chars[k + 1] <= '9') {
            if (endOfNumber != null) {
                endOfNumber[0] = k + 2;
            }
            return null;
        }
        while (k < endPos) {
            char c = chars[k];
            if (c == '0') {
                haveDigits = true;
                haveDigitsAfterDecimal |= haveDecimalPoint;
            } else if (c >= '1' && c <= '9') {
                haveDigits = true;
                haveDigitsAfterDecimal |= haveDecimalPoint;
                haveNonzeroDigits = true;
            } else if (c == '.') {
                if (!haveDigits || haveDecimalPoint) {
                    if (endOfNumber != null) {
                        endOfNumber[0] = k;
                    }
                    return null;
                }
                haveDecimalPoint = true;
                decimalPointPos = k;
            } else {
                if (c == 'E' || c == 'e') {
                    ++k;
                    haveExponent = true;
                    break;
                }
                if (endOfNumber != null) {
                    endOfNumber[0] = k;
                    if (c != ',' && c != ']' && c != '}' && c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                        return null;
                    }
                    endPos = k;
                    break;
                }
                return null;
            }
            ++k;
        }
        if (!haveDigits || haveDecimalPoint && !haveDigitsAfterDecimal) {
            if (endOfNumber != null) {
                endOfNumber[0] = k;
            }
            return null;
        }
        int exponentPos = -1;
        boolean negativeExp = false;
        if (haveExponent) {
            haveDigits = false;
            if (k == endPos) {
                if (endOfNumber != null) {
                    endOfNumber[0] = k;
                }
                return null;
            }
            char c = chars[k];
            if (c == '+') {
                ++k;
            } else if (c == '-') {
                negativeExp = true;
                ++k;
            }
            while (k < endPos) {
                c = chars[k];
                if (c >= '0' && c <= '9') {
                    if (exponentPos < 0 && c != '0') {
                        exponentPos = k;
                    }
                } else {
                    if (endOfNumber != null) {
                        endOfNumber[0] = k;
                        if (c != ',' && c != ']' && c != '}' && c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                            return null;
                        }
                        endPos = k;
                        break;
                    }
                    return null;
                }
                haveDigits = true;
                ++k;
            }
            if (!haveDigits) {
                if (endOfNumber != null) {
                    endOfNumber[0] = k;
                }
                return null;
            }
        }
        if (endOfNumber != null) {
            endOfNumber[0] = endPos;
        }
        if (exponentPos >= 0 && endPos - exponentPos > 20) {
            if (!haveNonzeroDigits) {
                if (kind == JSONOptions.ConversionMode.Double) {
                    return !negative ? CBORObject.FromFloatingPointBits(0L, 2) : CBORObject.FromFloatingPointBits(32768L, 2);
                }
                if (kind == JSONOptions.ConversionMode.IntOrFloatFromDouble || kind == JSONOptions.ConversionMode.IntOrFloat) {
                    return CBORObject.FromInt32(0);
                }
            } else if (negativeExp) {
                if (kind == JSONOptions.ConversionMode.Double || kind == JSONOptions.ConversionMode.IntOrFloat) {
                    return !negative ? CBORObject.FromFloatingPointBits(0L, 2) : CBORObject.FromFloatingPointBits(32768L, 2);
                }
                if (kind == JSONOptions.ConversionMode.IntOrFloatFromDouble) {
                    return CBORObject.FromInt32(0);
                }
            } else {
                if (kind == JSONOptions.ConversionMode.Double || kind == JSONOptions.ConversionMode.IntOrFloatFromDouble || kind == JSONOptions.ConversionMode.IntOrFloat) {
                    return CBORObject.FromFloatingPointBits(negative ? -4503599627370496L : 0x7FF0000000000000L, 8);
                }
                if (kind == JSONOptions.ConversionMode.Decimal128) {
                    return CBORObject.FromEDecimal(negative ? EDecimal.NegativeInfinity : EDecimal.PositiveInfinity);
                }
            }
        }
        if (!haveExponent && !haveDecimalPoint && endPos - numOffset <= 16) {
            long v = 0L;
            for (int vi = numOffset; vi < endPos; ++vi) {
                v = v * 10L + (long)(chars[vi] - 48);
            }
            if (!(v == 0L && negative || v >= 0x1FFFFFFFFFFFFFL)) {
                if (negative) {
                    v = -v;
                }
                return kind == JSONOptions.ConversionMode.Double ? CBORObject.FromFloatingPointBits(EFloat.FromInt64((long)v).ToDoubleBits(), 8) : (kind == JSONOptions.ConversionMode.Decimal128 ? CBORObject.FromEDecimal(EDecimal.FromInt64((long)v)) : CBORObject.FromInt64(v));
            }
        }
        if (kind == JSONOptions.ConversionMode.Full) {
            EDecimal ed;
            if (!haveDecimalPoint && !haveExponent) {
                EInteger ei = EInteger.FromSubstring((char[])chars, (int)initialOffset, (int)endPos);
                return preserveNegativeZero && ei.isZero() && negative ? CBORObject.FromEDecimal(EDecimal.NegativeZero) : CBORObject.FromEInteger(ei);
            }
            if (!haveExponent && haveDecimalPoint) {
                int vi;
                long lv = 0L;
                int expo = -(endPos - (decimalPointPos + 1));
                int digitCount = 0;
                for (vi = numOffset; vi < decimalPointPos; ++vi) {
                    if (digitCount < 0 || digitCount >= 18) {
                        digitCount = -1;
                        break;
                    }
                    if (digitCount > 0 || chars[vi] != '0') {
                        ++digitCount;
                    }
                    lv = lv * 10L + (long)(chars[vi] - 48);
                }
                for (vi = decimalPointPos + 1; vi < endPos; ++vi) {
                    if (digitCount < 0 || digitCount >= 18) {
                        digitCount = -1;
                        break;
                    }
                    if (digitCount > 0 || chars[vi] != '0') {
                        ++digitCount;
                    }
                    lv = lv * 10L + (long)(chars[vi] - 48);
                }
                if (negative) {
                    lv = -lv;
                }
                if (!(digitCount < 0 || negative && lv == 0L)) {
                    if (expo == 0) {
                        return CBORObject.FromInt64(lv);
                    }
                    CBORObject cbor = CBORObject.FromArrayBackedObject(new CBORObject[]{CBORObject.FromInt32(expo), CBORObject.FromInt64(lv)});
                    return cbor.WithTag(4);
                }
            }
            if ((ed = EDecimal.FromString((char[])chars, (int)initialOffset, (int)(endPos - initialOffset))).isZero() && negative) {
                if (ed.getExponent().isZero()) {
                    return preserveNegativeZero ? CBORObject.FromEDecimal(EDecimal.NegativeZero) : CBORObject.FromInt32(0);
                }
                return !preserveNegativeZero ? CBORObject.FromEDecimal(ed.Negate()) : CBORObject.FromEDecimal(ed);
            }
            return ed.getExponent().isZero() ? CBORObject.FromEInteger(ed.getMantissa()) : CBORObject.FromEDecimal(ed);
        }
        if (kind == JSONOptions.ConversionMode.Double) {
            EFloat ef = EFloat.FromString((char[])chars, (int)initialOffset, (int)(endPos - initialOffset), (EContext)EContext.Binary64);
            long lb = ef.ToDoubleBits();
            if (!(preserveNegativeZero || lb != Long.MIN_VALUE && lb != 0L)) {
                lb = 0L;
            }
            return CBORObject.FromFloatingPointBits(lb, 8);
        }
        if (kind == JSONOptions.ConversionMode.Decimal128) {
            EDecimal ed = EDecimal.FromString((char[])chars, (int)initialOffset, (int)(endPos - initialOffset), (EContext)EContext.Decimal128);
            if (!preserveNegativeZero && ed.isNegative() && ed.isZero()) {
                ed = ed.Negate();
            }
            return CBORObject.FromEDecimal(ed);
        }
        if (kind == JSONOptions.ConversionMode.IntOrFloatFromDouble) {
            EFloat ef = EFloat.FromString((char[])chars, (int)initialOffset, (int)(endPos - initialOffset), (EContext)EContext.Binary64);
            long lb = ef.ToDoubleBits();
            return !CBORUtilities.IsBeyondSafeRange(lb) && CBORUtilities.IsIntegerValue(lb) ? CBORObject.FromInt64(CBORUtilities.GetIntegerValue(lb)) : CBORObject.FromFloatingPointBits(lb, 8);
        }
        if (kind == JSONOptions.ConversionMode.IntOrFloat) {
            EContext ctx = EContext.Binary64.WithBlankFlags();
            EFloat ef = EFloat.FromString((char[])chars, (int)initialOffset, (int)(endPos - initialOffset), (EContext)ctx);
            long lb = ef.ToDoubleBits();
            if ((ctx.getFlags() & 1) != 0) {
                if (!(preserveNegativeZero || lb != Long.MIN_VALUE && lb != 0L)) {
                    lb = 0L;
                }
                return CBORObject.FromFloatingPointBits(lb, 8);
            }
            return !CBORUtilities.IsBeyondSafeRange(lb) && CBORUtilities.IsIntegerValue(lb) ? CBORObject.FromInt64(CBORUtilities.GetIntegerValue(lb)) : CBORObject.FromFloatingPointBits(lb, 8);
        }
        throw new IllegalArgumentException("Unsupported conversion kind.");
    }
}

