/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORDataUtilitiesByteArrayString;
import com.upokecenter.cbor.CBORDataUtilitiesCharArrayString;
import com.upokecenter.cbor.CBORDataUtilitiesTextString;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.JSONOptions;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.util.DataUtilities;
import java.util.Collection;
import java.util.Map;

public final class CBORDataUtilities {
    private static final String HexAlphabet = "0123456789ABCDEF";
    private static final long DoubleNegInfinity = -4503599627370496L;
    private static final long DoublePosInfinity = 0x7FF0000000000000L;
    static final JSONOptions DefaultOptions = new JSONOptions("");
    private static final JSONOptions PreserveNegZeroNo = new JSONOptions("preservenegativezero=0");
    private static final JSONOptions PreserveNegZeroYes = new JSONOptions("preservenegativezero=1");

    private CBORDataUtilities() {
    }

    static String ToStringHelper(CBORObject obj, int depth) {
        CBORObject curobject;
        StringBuilder sb = null;
        CBORType type = obj.getType();
        if (obj.isTagged()) {
            if (sb == null) {
                if (type == CBORType.TextString) {
                    String str = obj.AsString();
                    sb = new StringBuilder(Math.min(str.length(), 4096) + 16);
                } else {
                    sb = new StringBuilder();
                }
            }
            curobject = obj;
            while (curobject.isTagged()) {
                EInteger ei = curobject.getMostOuterTag();
                sb.append(ei.toString());
                sb.append('(');
                curobject = curobject.UntagOne();
            }
        }
        switch (type) {
            case SimpleValue: {
                char c;
                StringBuilder stringBuilder = sb = sb == null ? new StringBuilder() : sb;
                if (obj.isUndefined()) {
                    sb.append("undefined");
                    break;
                }
                if (obj.isNull()) {
                    sb.append("null");
                    break;
                }
                sb.append("simple(");
                int thisItemInt = obj.getSimpleValue();
                if (thisItemInt >= 100) {
                    c = (char)(48 + thisItemInt / 100 % 10);
                    sb.append(c);
                }
                if (thisItemInt >= 10) {
                    c = (char)(48 + thisItemInt / 10 % 10);
                    sb.append(c);
                    c = (char)(48 + thisItemInt % 10);
                } else {
                    c = (char)(48 + thisItemInt);
                }
                sb.append(c);
                sb.append(')');
                break;
            }
            case Boolean: 
            case Integer: {
                String simvalue = obj.Untag().ToJSONString();
                if (sb == null) {
                    return simvalue;
                }
                sb.append(simvalue);
                break;
            }
            case FloatingPoint: {
                String simvalue;
                long bits = obj.AsDoubleBits();
                String string = bits == -4503599627370496L ? "-Infinity" : (bits == 0x7FF0000000000000L ? "Infinity" : (simvalue = CBORUtilities.DoubleBitsNaN(bits) ? "NaN" : obj.Untag().ToJSONString()));
                if (sb == null) {
                    return simvalue;
                }
                sb.append(simvalue);
                break;
            }
            case ByteString: {
                sb = sb == null ? new StringBuilder() : sb;
                sb.append("h'");
                byte[] data = obj.GetByteString();
                int length = data.length;
                for (int i = 0; i < length; ++i) {
                    sb.append(HexAlphabet.charAt(data[i] >> 4 & 0xF));
                    sb.append(HexAlphabet.charAt(data[i] & 0xF));
                }
                sb.append('\'');
                break;
            }
            case TextString: {
                sb = sb == null ? new StringBuilder() : sb;
                sb.append('\"');
                String ostring = obj.AsString();
                int length = ostring.length();
                for (int i = 0; i < length; ++i) {
                    int cp = DataUtilities.CodePointAt(ostring, i, 0);
                    if (cp >= 65536) {
                        sb.append("\\U");
                        sb.append(HexAlphabet.charAt(cp >> 20 & 0xF));
                        sb.append(HexAlphabet.charAt(cp >> 16 & 0xF));
                        sb.append(HexAlphabet.charAt(cp >> 12 & 0xF));
                        sb.append(HexAlphabet.charAt(cp >> 8 & 0xF));
                        sb.append(HexAlphabet.charAt(cp >> 4 & 0xF));
                        sb.append(HexAlphabet.charAt(cp & 0xF));
                        ++i;
                        continue;
                    }
                    if (cp >= 127 || cp < 32 || cp == 92 || cp == 34) {
                        sb.append("\\u");
                        sb.append(HexAlphabet.charAt(cp >> 12 & 0xF));
                        sb.append(HexAlphabet.charAt(cp >> 8 & 0xF));
                        sb.append(HexAlphabet.charAt(cp >> 4 & 0xF));
                        sb.append(HexAlphabet.charAt(cp & 0xF));
                        continue;
                    }
                    sb.append((char)cp);
                }
                sb.append('\"');
                break;
            }
            case Array: {
                sb = sb == null ? new StringBuilder() : sb;
                boolean first = true;
                sb.append('[');
                if (depth >= 50) {
                    sb.append("...");
                } else {
                    for (int i = 0; i < obj.size(); ++i) {
                        if (!first) {
                            sb.append(", ");
                        }
                        sb.append(CBORDataUtilities.ToStringHelper(obj.get(i), depth + 1));
                        first = false;
                    }
                }
                sb.append(']');
                break;
            }
            case Map: {
                sb = sb == null ? new StringBuilder() : sb;
                boolean first = true;
                sb.append('{');
                if (depth >= 50) {
                    sb.append("...");
                } else {
                    Collection<Map.Entry<CBORObject, CBORObject>> entries = obj.getEntries();
                    for (Map.Entry<CBORObject, CBORObject> entry : entries) {
                        CBORObject key = entry.getKey();
                        CBORObject value = entry.getValue();
                        if (!first) {
                            sb.append(", ");
                        }
                        sb.append(CBORDataUtilities.ToStringHelper(key, depth + 1));
                        sb.append(": ");
                        sb.append(CBORDataUtilities.ToStringHelper(value, depth + 1));
                        first = false;
                    }
                }
                sb.append('}');
                break;
            }
            default: {
                sb = sb == null ? new StringBuilder() : sb;
                sb.append("???");
            }
        }
        curobject = obj;
        while (curobject.isTagged()) {
            sb.append(')');
            curobject = curobject.UntagOne();
        }
        return sb.toString();
    }

    public static CBORObject ParseJSONNumber(String str) {
        return CBORDataUtilities.ParseJSONNumber(str, JSONOptions.Default);
    }

    public static CBORObject ParseJSONNumber(String str, JSONOptions options) {
        return str == null || str.length() == 0 ? null : CBORDataUtilities.ParseJSONNumber(str, 0, str.length(), options);
    }

    public static CBORObject ParseJSONNumber(String str, int offset, int count) {
        return str == null || str.length() == 0 ? null : CBORDataUtilities.ParseJSONNumber(str, offset, count, JSONOptions.Default);
    }

    static CBORObject ParseSmallNumberAsNegative(int digit, JSONOptions options) {
        if (options != null && options.getNumberConversion() == JSONOptions.ConversionMode.Double) {
            return CBORObject.FromFloatingPointBits(CBORUtilities.IntegerToDoubleBits(-digit), 8);
        }
        if (options != null && options.getNumberConversion() == JSONOptions.ConversionMode.Decimal128) {
            return CBORObject.FromEDecimal(EDecimal.FromInt32((int)(-digit)));
        }
        return CBORObject.FromInt32(-digit);
    }

    static CBORObject ParseSmallNumber(int digit, JSONOptions options) {
        if (options != null && options.getNumberConversion() == JSONOptions.ConversionMode.Double) {
            return CBORObject.FromFloatingPointBits(CBORUtilities.IntegerToDoubleBits(digit), 8);
        }
        if (options != null && options.getNumberConversion() == JSONOptions.ConversionMode.Decimal128) {
            return CBORObject.FromEDecimal(EDecimal.FromInt32((int)digit));
        }
        return CBORObject.FromInt32(digit);
    }

    public static CBORObject ParseJSONNumber(String str, int offset, int count, JSONOptions options) {
        return CBORDataUtilitiesTextString.ParseJSONNumber(str, offset, count, options, null);
    }

    public static CBORObject ParseJSONNumber(byte[] bytes, int offset, int count, JSONOptions options) {
        return CBORDataUtilitiesByteArrayString.ParseJSONNumber(bytes, offset, count, options, null);
    }

    public static CBORObject ParseJSONNumber(byte[] bytes, JSONOptions options) {
        return bytes == null || bytes.length == 0 ? null : CBORDataUtilities.ParseJSONNumber(bytes, 0, bytes.length, options);
    }

    public static CBORObject ParseJSONNumber(byte[] bytes, int offset, int count) {
        return bytes == null || bytes.length == 0 ? null : CBORDataUtilities.ParseJSONNumber(bytes, offset, count, JSONOptions.Default);
    }

    public static CBORObject ParseJSONNumber(byte[] bytes) {
        return CBORDataUtilities.ParseJSONNumber(bytes, JSONOptions.Default);
    }

    public static CBORObject ParseJSONNumber(char[] chars, int offset, int count, JSONOptions options) {
        return CBORDataUtilitiesCharArrayString.ParseJSONNumber(chars, offset, count, options, null);
    }

    public static CBORObject ParseJSONNumber(char[] chars, JSONOptions options) {
        return chars == null || chars.length == 0 ? null : CBORDataUtilities.ParseJSONNumber(chars, 0, chars.length, options);
    }

    public static CBORObject ParseJSONNumber(char[] chars, int offset, int count) {
        return chars == null || chars.length == 0 ? null : CBORDataUtilities.ParseJSONNumber(chars, offset, count, JSONOptions.Default);
    }

    public static CBORObject ParseJSONNumber(char[] chars) {
        return CBORDataUtilities.ParseJSONNumber(chars, JSONOptions.Default);
    }
}

