/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORDataUtilities;
import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.JSONOptions;
import java.util.ArrayList;
import java.util.HashMap;

final class CBORJson2 {
    private final byte[] bytes;
    private final JSONOptions options;
    private StringBuilder sb = null;
    private int index;
    private int endPos;

    private int SkipWhitespaceJSON() {
        while (this.index < this.endPos) {
            byte c;
            if ((c = this.bytes[this.index++]) == 32 || c == 10 || c == 13 || c == 9) continue;
            return c;
        }
        return -1;
    }

    void RaiseError(String str) {
        throw new CBORException(str + " (approx. offset: " + Math.max(0, this.index - 1) + ")");
    }

    private String NextJSONString() {
        this.sb = this.sb == null ? new StringBuilder() : this.sb;
        this.sb.delete(0, this.sb.length());
        block13: while (true) {
            int c1;
            int c2;
            int c;
            int n = c = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
            if (c == -1 || c < 32) {
                this.RaiseError("Unterminated String");
            }
            switch (c) {
                case 92: {
                    c = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                    switch (c) {
                        case 34: 
                        case 47: 
                        case 92: {
                            this.sb.append((char)c);
                            continue block13;
                        }
                        case 98: {
                            this.sb.append('\b');
                            continue block13;
                        }
                        case 102: {
                            this.sb.append('\f');
                            continue block13;
                        }
                        case 110: {
                            this.sb.append('\n');
                            continue block13;
                        }
                        case 114: {
                            this.sb.append('\r');
                            continue block13;
                        }
                        case 116: {
                            this.sb.append('\t');
                            continue block13;
                        }
                        case 117: {
                            c = 0;
                            for (int i = 0; i < 4; ++i) {
                                int ch;
                                int n2 = ch = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                                if (ch >= 48 && ch <= 57) {
                                    c <<= 4;
                                    c |= ch - 48;
                                    continue;
                                }
                                if (ch >= 65 && ch <= 70) {
                                    c <<= 4;
                                    c |= ch + 10 - 65;
                                    continue;
                                }
                                if (ch >= 97 && ch <= 102) {
                                    c <<= 4;
                                    c |= ch + 10 - 97;
                                    continue;
                                }
                                this.RaiseError("Invalid Unicode escaped character");
                            }
                            if ((c & 0xF800) != 55296) {
                                this.sb.append((char)c);
                                continue block13;
                            }
                            if ((c & 0xFC00) == 55296) {
                                int ch;
                                int n3 = ch = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                                if (ch != 92 || (this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1) != 117) {
                                    this.RaiseError("Invalid escaped character");
                                }
                                c2 = 0;
                                for (int i = 0; i < 4; ++i) {
                                    int n4 = ch = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                                    if (ch >= 48 && ch <= 57) {
                                        c2 <<= 4;
                                        c2 |= ch - 48;
                                        continue;
                                    }
                                    if (ch >= 65 && ch <= 70) {
                                        c2 <<= 4;
                                        c2 |= ch + 10 - 65;
                                        continue;
                                    }
                                    if (ch >= 97 && ch <= 102) {
                                        c2 <<= 4;
                                        c2 |= ch + 10 - 97;
                                        continue;
                                    }
                                    this.RaiseError("Invalid Unicode escaped character");
                                }
                                if ((c2 & 0xFC00) != 56320) {
                                    this.RaiseError("Unpaired surrogate code point");
                                    continue block13;
                                }
                                this.sb.append((char)c);
                                this.sb.append((char)c2);
                                continue block13;
                            }
                            this.RaiseError("Unpaired surrogate code point");
                            continue block13;
                        }
                    }
                    this.RaiseError("Invalid escaped character");
                    continue block13;
                }
                case 34: {
                    return this.sb.toString();
                }
            }
            if (c <= 127) {
                this.sb.append((char)c);
                continue;
            }
            if (c >= 194 && c <= 223) {
                int n5 = c1 = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                if (c1 < 128 || c1 > 191) {
                    this.RaiseError("Invalid encoding");
                }
                c = c - 192 << 6 | c1 - 128;
                this.sb.append((char)c);
                continue;
            }
            if (c >= 224 && c <= 239) {
                int upper;
                c1 = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                c2 = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                int lower = c == 224 ? 160 : 128;
                int n6 = upper = c == 237 ? 159 : 191;
                if (c1 < lower || c1 > upper || c2 < 128 || c2 > 191) {
                    this.RaiseError("Invalid encoding");
                }
                c = c - 192 << 12 | c1 - 128 << 6 | c2 - 128;
                this.sb.append((char)c);
                continue;
            }
            if (c >= 240 && c <= 244) {
                int upper;
                c1 = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                c2 = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                int c3 = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                int lower = c == 240 ? 144 : 128;
                int n7 = upper = c == 244 ? 143 : 191;
                if (c1 < lower || c1 > upper || c2 < 128 || c2 > 191 || c3 < 128 || c3 > 191) {
                    this.RaiseError("Invalid encoding");
                }
                if ((c = c - 192 << 12 | c1 - 128 << 12 | c2 - 128 << 6 | c3 - 128) <= 65535) {
                    this.sb.append((char)c);
                    continue;
                }
                if (c > 0x10FFFF) continue;
                this.sb.append((char)(c - 65536 >> 10 & 0x3FF | 0xD800));
                this.sb.append((char)(c - 65536 & 0x3FF | 0xDC00));
                continue;
            }
            this.RaiseError("Invalid encoding");
        }
    }

    private CBORObject NextJSONNegativeNumber(int[] nextChar) {
        CBORObject obj;
        int numberEndIndex;
        int c;
        int numberStartIndex = this.index - 1;
        int n = c = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
        if (c < 48 || c > 57) {
            this.RaiseError("JSON number can't be parsed.");
        }
        int cstart = c;
        while (c == 45 || c == 43 || c == 46 || c >= 48 && c <= 57 || c == 101 || c == 69) {
            c = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
        }
        if (c != 44 && c != 93 && c != 125 && c != -1 && c != 32 && c != 10 && c != 13 && c != 9) {
            this.RaiseError("Invalid character after JSON number");
        }
        int n2 = numberEndIndex = c < 0 ? this.endPos : this.index - 1;
        if (numberEndIndex - numberStartIndex == 2 && cstart != 48) {
            obj = CBORDataUtilities.ParseSmallNumberAsNegative(cstart - 48, this.options);
        } else {
            StringBuilder ssb = new StringBuilder(numberEndIndex - numberStartIndex);
            for (int ki = numberStartIndex; ki < numberEndIndex; ++ki) {
                ssb.append((char)(this.bytes[ki] & 0xFF));
            }
            String str = ssb.toString();
            obj = CBORDataUtilities.ParseJSONNumber(str, this.options);
            if (obj == null) {
                String errstr = str.length() <= 100 ? str : str.substring(0, 100) + "...";
                this.RaiseError("JSON number can't be parsed. " + errstr);
            }
        }
        nextChar[0] = c == -1 || c != 32 && c != 10 && c != 13 && c != 9 ? c : this.SkipWhitespaceJSON();
        return obj;
    }

    private CBORObject NextJSONNonnegativeNumber(int c, int[] nextChar) {
        CBORObject obj = null;
        int cval = c - 48;
        int cstart = c;
        int startIndex = this.index - 1;
        boolean needObj = true;
        int numberStartIndex = this.index - 1;
        int n = c = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
        if (c != 45 && c != 43 && c != 46 && (c < 48 || c > 57) && c != 101 && c != 69) {
            obj = CBORDataUtilities.ParseSmallNumber(cval, this.options);
            needObj = false;
        } else if (c >= 48 && c <= 57) {
            int csecond = c;
            if (cstart == 48) {
                this.RaiseError("JSON number can't be parsed.");
            }
            cval = cval * 10 + (c - 48);
            int n2 = c = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
            if (c >= 48 && c <= 57) {
                for (int digits = 2; digits < 9 && c >= 48 && c <= 57; ++digits) {
                    cval = cval * 10 + (c - 48);
                    c = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                }
                if (c != 101 && c != 69 && c != 46 && (c < 48 || c > 57)) {
                    obj = CBORDataUtilities.ParseSmallNumber(cval, this.options);
                    needObj = false;
                }
            } else if (c != 45 && c != 43 && c != 46 && c != 101 && c != 69) {
                obj = CBORDataUtilities.ParseSmallNumber(cval, this.options);
                needObj = false;
            }
        }
        if (needObj) {
            while (c == 45 || c == 43 || c == 46 || c >= 48 && c <= 57 || c == 101 || c == 69) {
                c = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
            }
            if (c != 44 && c != 93 && c != 125 && c != -1 && c != 32 && c != 10 && c != 13 && c != 9) {
                this.RaiseError("Invalid character after JSON number");
            }
            int numberEndIndex = c < 0 ? this.endPos : this.index - 1;
            StringBuilder ssb = new StringBuilder(numberEndIndex - startIndex);
            for (int ki = startIndex; ki < numberEndIndex; ++ki) {
                ssb.append((char)(this.bytes[ki] & 0xFF));
            }
            String str = ssb.toString();
            obj = CBORDataUtilities.ParseJSONNumber(str, this.options);
            if (obj == null) {
                String errstr = str.length() <= 100 ? str : str.substring(0, 100) + "...";
                this.RaiseError("JSON number can't be parsed. " + errstr);
            }
        }
        nextChar[0] = c == -1 || c != 32 && c != 10 && c != 13 && c != 9 ? c : this.SkipWhitespaceJSON();
        return obj;
    }

    private CBORObject NextJSONValue(int firstChar, int[] nextChar, int depth) {
        int c = firstChar;
        CBORObject obj = null;
        if (c < 0) {
            this.RaiseError("Unexpected end of data");
        }
        switch (c) {
            case 34: {
                obj = CBORObject.FromRaw(this.NextJSONString());
                nextChar[0] = this.SkipWhitespaceJSON();
                return obj;
            }
            case 123: {
                obj = this.ParseJSONObject(depth + 1);
                nextChar[0] = this.SkipWhitespaceJSON();
                return obj;
            }
            case 91: {
                obj = this.ParseJSONArray(depth + 1);
                nextChar[0] = this.SkipWhitespaceJSON();
                return obj;
            }
            case 116: {
                if (this.endPos - this.index <= 2 || (this.bytes[this.index] & 0xFF) != 114 || (this.bytes[this.index + 1] & 0xFF) != 117 || (this.bytes[this.index + 2] & 0xFF) != 101) {
                    this.RaiseError("Value can't be parsed.");
                }
                this.index += 3;
                nextChar[0] = this.SkipWhitespaceJSON();
                return CBORObject.True;
            }
            case 102: {
                if (this.endPos - this.index <= 3 || (this.bytes[this.index] & 0xFF) != 97 || (this.bytes[this.index + 1] & 0xFF) != 108 || (this.bytes[this.index + 2] & 0xFF) != 115 || (this.bytes[this.index + 3] & 0xFF) != 101) {
                    this.RaiseError("Value can't be parsed.");
                }
                this.index += 4;
                nextChar[0] = this.SkipWhitespaceJSON();
                return CBORObject.False;
            }
            case 110: {
                if (this.endPos - this.index <= 2 || (this.bytes[this.index] & 0xFF) != 117 || (this.bytes[this.index + 1] & 0xFF) != 108 || (this.bytes[this.index + 2] & 0xFF) != 108) {
                    this.RaiseError("Value can't be parsed.");
                }
                this.index += 3;
                nextChar[0] = this.SkipWhitespaceJSON();
                return CBORObject.Null;
            }
            case 45: {
                return this.NextJSONNegativeNumber(nextChar);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.NextJSONNonnegativeNumber(c, nextChar);
            }
        }
        this.RaiseError("Value can't be parsed.");
        return null;
    }

    public CBORJson2(byte[] bytes, int index, int endPos, JSONOptions options) {
        this.bytes = bytes;
        this.index = index;
        this.endPos = endPos;
        this.options = options;
    }

    public CBORObject ParseJSON(int[] nextchar) {
        int c = this.SkipWhitespaceJSON();
        if (c == 91) {
            CBORObject ret = this.ParseJSONArray(0);
            nextchar[0] = this.SkipWhitespaceJSON();
            return ret;
        }
        if (c == 123) {
            CBORObject ret = this.ParseJSONObject(0);
            nextchar[0] = this.SkipWhitespaceJSON();
            return ret;
        }
        return this.NextJSONValue(c, nextchar, 0);
    }

    static CBORObject ParseJSONValue(byte[] bytes, int index, int endPos, JSONOptions options) {
        int[] nextchar = new int[1];
        CBORJson2 cj = new CBORJson2(bytes, index, endPos, options);
        CBORObject obj = cj.ParseJSON(nextchar);
        if (nextchar[0] != -1) {
            cj.RaiseError("End of bytes not reached");
        }
        return obj;
    }

    static CBORObject ParseJSONValue(byte[] bytes, int index, int endPos, JSONOptions options, int[] nextchar) {
        CBORJson2 cj = new CBORJson2(bytes, index, endPos, options);
        return cj.ParseJSON(nextchar);
    }

    private CBORObject ParseJSONObject(int depth) {
        if (depth > 1000) {
            this.RaiseError("Too deeply nested");
        }
        CBORObject key = null;
        int[] nextchar = new int[1];
        boolean seenComma = false;
        HashMap<CBORObject, CBORObject> myHashMap = new HashMap<CBORObject, CBORObject>();
        block8: while (true) {
            int c = this.SkipWhitespaceJSON();
            switch (c) {
                case -1: {
                    this.RaiseError("A JSON Object must end with '}'");
                    break;
                }
                case 125: {
                    if (seenComma) {
                        this.RaiseError("Trailing comma");
                        return null;
                    }
                    return CBORObject.FromRaw(myHashMap);
                }
                default: {
                    CBORObject obj;
                    if (c < 0) {
                        this.RaiseError("Unexpected end of data");
                        return null;
                    }
                    if (c != 34) {
                        this.RaiseError("Expected a String as a key");
                        return null;
                    }
                    key = obj = CBORObject.FromRaw(this.NextJSONString());
                    if (this.options.getAllowDuplicateKeys() || !myHashMap.containsKey(obj)) break;
                    this.RaiseError("Key already exists: " + key);
                    return null;
                }
            }
            if (this.SkipWhitespaceJSON() != 58) {
                this.RaiseError("Expected a ':' after a key");
            }
            myHashMap.put(key, this.NextJSONValue(this.SkipWhitespaceJSON(), nextchar, depth));
            switch (nextchar[0]) {
                case 44: {
                    seenComma = true;
                    continue block8;
                }
                case 125: {
                    return CBORObject.FromRaw(myHashMap);
                }
            }
            this.RaiseError("Expected a ',' or '}'");
        }
    }

    CBORObject ParseJSONArray(int depth) {
        if (depth > 1000) {
            this.RaiseError("Too deeply nested");
        }
        ArrayList<CBORObject> myArrayList = new ArrayList<CBORObject>();
        boolean seenComma = false;
        int[] nextchar = new int[1];
        block4: while (true) {
            int c;
            if ((c = this.SkipWhitespaceJSON()) == 93) {
                if (seenComma) {
                    this.RaiseError("Trailing comma");
                }
                return CBORObject.FromRaw(myArrayList);
            }
            if (c == 44) {
                this.RaiseError("Empty array element");
            }
            myArrayList.add(this.NextJSONValue(c, nextchar, depth));
            c = nextchar[0];
            switch (c) {
                case 44: {
                    seenComma = true;
                    continue block4;
                }
                case 93: {
                    return CBORObject.FromRaw(myArrayList);
                }
            }
            this.RaiseError("Expected a ',' or ']'");
        }
    }
}

