/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.ICBORNumber;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;

class CBORExtendedFloat
implements ICBORNumber {
    CBORExtendedFloat() {
    }

    @Override
    public boolean IsPositiveInfinity(Object obj) {
        EFloat ef = (EFloat)obj;
        return ef.IsPositiveInfinity();
    }

    @Override
    public boolean IsInfinity(Object obj) {
        EFloat ef = (EFloat)obj;
        return ef.IsInfinity();
    }

    @Override
    public boolean IsNegativeInfinity(Object obj) {
        EFloat ef = (EFloat)obj;
        return ef.IsNegativeInfinity();
    }

    @Override
    public boolean IsNaN(Object obj) {
        EFloat ef = (EFloat)obj;
        return ef.IsNaN();
    }

    @Override
    public double AsDouble(Object obj) {
        EFloat ef = (EFloat)obj;
        return ef.ToDouble();
    }

    @Override
    public EDecimal AsEDecimal(Object obj) {
        EFloat ef = (EFloat)obj;
        return ef.ToEDecimal();
    }

    @Override
    public EFloat AsEFloat(Object obj) {
        EFloat ef = (EFloat)obj;
        return ef;
    }

    @Override
    public float AsSingle(Object obj) {
        EFloat ef = (EFloat)obj;
        return ef.ToSingle();
    }

    @Override
    public EInteger AsEInteger(Object obj) {
        EFloat ef = (EFloat)obj;
        return ef.ToEInteger();
    }

    @Override
    public long AsInt64(Object obj) {
        EFloat ef = (EFloat)obj;
        if (this.CanTruncatedIntFitInInt64(obj)) {
            EInteger bi = ef.ToEInteger();
            return bi.ToInt64Checked();
        }
        throw new ArithmeticException("This Object's value is out of range");
    }

    @Override
    public boolean CanFitInSingle(Object obj) {
        EFloat ef = (EFloat)obj;
        return !ef.isFinite() || ef.compareTo(EFloat.FromSingle((float)ef.ToSingle())) == 0;
    }

    @Override
    public boolean CanFitInDouble(Object obj) {
        EFloat ef = (EFloat)obj;
        return !ef.isFinite() || ef.compareTo(EFloat.FromDouble((double)ef.ToDouble())) == 0;
    }

    @Override
    public boolean CanFitInInt32(Object obj) {
        return this.IsIntegral(obj) && this.CanTruncatedIntFitInInt32(obj);
    }

    @Override
    public boolean CanFitInInt64(Object obj) {
        return this.IsIntegral(obj) && this.CanTruncatedIntFitInInt64(obj);
    }

    @Override
    public boolean CanTruncatedIntFitInInt64(Object obj) {
        EFloat ef = (EFloat)obj;
        if (!ef.isFinite()) {
            return false;
        }
        if (ef.isZero()) {
            return true;
        }
        if (ef.getExponent().compareTo(EInteger.FromInt64((long)65L)) >= 0) {
            return false;
        }
        EInteger bi = ef.ToEInteger();
        return bi.CanFitInInt64();
    }

    @Override
    public boolean CanTruncatedIntFitInInt32(Object obj) {
        EFloat ef = (EFloat)obj;
        if (!ef.isFinite()) {
            return false;
        }
        if (ef.isZero()) {
            return true;
        }
        if (ef.getExponent().compareTo(EInteger.FromInt64((long)33L)) >= 0) {
            return false;
        }
        EInteger bi = ef.ToEInteger();
        return bi.CanFitInInt32();
    }

    @Override
    public boolean IsNumberZero(Object obj) {
        EFloat ef = (EFloat)obj;
        return ef.isZero();
    }

    @Override
    public int Sign(Object obj) {
        EFloat ef = (EFloat)obj;
        return ef.IsNaN() ? 2 : ef.signum();
    }

    @Override
    public boolean IsIntegral(Object obj) {
        EFloat ef = (EFloat)obj;
        if (!ef.isFinite()) {
            return false;
        }
        if (ef.getExponent().signum() >= 0) {
            return true;
        }
        EFloat ef2 = EFloat.FromEInteger((EInteger)ef.ToEInteger());
        return ef2.compareTo(ef) == 0;
    }

    @Override
    public int AsInt32(Object obj, int minValue, int maxValue) {
        EInteger bi;
        int ret;
        EFloat ef = (EFloat)obj;
        if (this.CanTruncatedIntFitInInt32(obj) && (ret = (bi = ef.ToEInteger()).ToInt32Checked()) >= minValue && ret <= maxValue) {
            return ret;
        }
        throw new ArithmeticException("This Object's value is out of range");
    }

    @Override
    public Object Negate(Object obj) {
        EFloat ed = (EFloat)obj;
        return ed.Negate();
    }

    @Override
    public Object Abs(Object obj) {
        EFloat ed = (EFloat)obj;
        return ed.Abs();
    }

    @Override
    public ERational AsERational(Object obj) {
        return ERational.FromEFloat((EFloat)((EFloat)obj));
    }

    @Override
    public boolean IsNegative(Object obj) {
        return ((EFloat)obj).isNegative();
    }
}

