/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.JSONOptions;
import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import java.util.Collection;
import java.util.Map;

public final class CBORDataUtilities {
    private static final String HexAlphabet = "0123456789ABCDEF";
    private static final JSONOptions DefaultOptions = new JSONOptions("");
    private static final JSONOptions PreserveNegZeroNo = new JSONOptions("preservenegativezero=0");
    private static final JSONOptions PreserveNegZeroYes = new JSONOptions("preservenegativezero=1");

    private CBORDataUtilities() {
    }

    static String ToStringHelper(CBORObject obj, int depth) {
        CBORObject curobject;
        StringBuilder sb = null;
        String simvalue = null;
        CBORType type = obj.getType();
        if (obj.isTagged()) {
            if (sb == null) {
                if (type == CBORType.TextString) {
                    String str = obj.AsString();
                    sb = new StringBuilder(Math.min(str.length(), 4096) + 16);
                } else {
                    sb = new StringBuilder();
                }
            }
            curobject = obj;
            while (curobject.isTagged()) {
                EInteger ei = curobject.getMostOuterTag();
                sb.append(ei.toString());
                sb.append('(');
                curobject = curobject.UntagOne();
            }
        }
        switch (type) {
            case SimpleValue: {
                char c;
                StringBuilder stringBuilder = sb = sb == null ? new StringBuilder() : sb;
                if (obj.isUndefined()) {
                    sb.append("undefined");
                    break;
                }
                if (obj.isNull()) {
                    sb.append("null");
                    break;
                }
                sb.append("simple(");
                int thisItemInt = obj.getSimpleValue();
                if (thisItemInt >= 100) {
                    c = (char)(48 + thisItemInt / 100 % 10);
                    sb.append(c);
                }
                if (thisItemInt >= 10) {
                    c = (char)(48 + thisItemInt / 10 % 10);
                    sb.append(c);
                    c = (char)(48 + thisItemInt % 10);
                } else {
                    c = (char)(48 + thisItemInt);
                }
                sb.append(c);
                sb.append(")");
                break;
            }
            case Boolean: 
            case Integer: {
                simvalue = obj.Untag().ToJSONString();
                if (sb == null) {
                    return simvalue;
                }
                sb.append(simvalue);
                break;
            }
            case FloatingPoint: {
                double f = obj.AsDoubleValue();
                String string = f == Double.NEGATIVE_INFINITY ? "-Infinity" : (f == Double.POSITIVE_INFINITY ? "Infinity" : (simvalue = Double.isNaN(f) ? "NaN" : obj.Untag().ToJSONString()));
                if (sb == null) {
                    return simvalue;
                }
                sb.append(simvalue);
                break;
            }
            case ByteString: {
                sb = sb == null ? new StringBuilder() : sb;
                sb.append("h'");
                byte[] data = obj.GetByteString();
                int length = data.length;
                for (int i = 0; i < length; ++i) {
                    sb.append(HexAlphabet.charAt(data[i] >> 4 & 0xF));
                    sb.append(HexAlphabet.charAt(data[i] & 0xF));
                }
                sb.append("'");
                break;
            }
            case TextString: {
                if (sb == null) {
                    return "\"" + obj.AsString() + "\"";
                }
                sb.append('\"');
                sb.append(obj.AsString());
                sb.append('\"');
                break;
            }
            case Array: {
                sb = sb == null ? new StringBuilder() : sb;
                boolean first = true;
                sb.append("[");
                if (depth >= 50) {
                    sb.append("...");
                } else {
                    for (int i = 0; i < obj.size(); ++i) {
                        if (!first) {
                            sb.append(", ");
                        }
                        sb.append(CBORDataUtilities.ToStringHelper(obj.get(i), depth + 1));
                        first = false;
                    }
                }
                sb.append("]");
                break;
            }
            case Map: {
                sb = sb == null ? new StringBuilder() : sb;
                boolean first = true;
                sb.append("{");
                if (depth >= 50) {
                    sb.append("...");
                } else {
                    Collection<Map.Entry<CBORObject, CBORObject>> entries = obj.getEntries();
                    for (Map.Entry<CBORObject, CBORObject> entry : entries) {
                        CBORObject key = entry.getKey();
                        CBORObject value = entry.getValue();
                        if (!first) {
                            sb.append(", ");
                        }
                        sb.append(CBORDataUtilities.ToStringHelper(key, depth + 1));
                        sb.append(": ");
                        sb.append(CBORDataUtilities.ToStringHelper(value, depth + 1));
                        first = false;
                    }
                }
                sb.append("}");
                break;
            }
            default: {
                sb = sb == null ? new StringBuilder() : sb;
                sb.append("???");
            }
        }
        curobject = obj;
        while (curobject.isTagged()) {
            sb.append(')');
            curobject = curobject.UntagOne();
        }
        return sb.toString();
    }

    public static CBORObject ParseJSONNumber(String str) {
        return CBORDataUtilities.ParseJSONNumber(str, PreserveNegZeroNo);
    }

    @Deprecated
    public static CBORObject ParseJSONNumber(String str, boolean integersOnly, boolean positiveOnly) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if (integersOnly) {
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) < '0' || str.charAt(i) > '9' || i <= 0 && str.charAt(i) == '-') continue;
                return null;
            }
        }
        return positiveOnly && str.charAt(0) == '-' ? null : CBORDataUtilities.ParseJSONNumber(str, 0, str.length(), PreserveNegZeroNo);
    }

    @Deprecated
    public static CBORObject ParseJSONNumber(String str, boolean integersOnly, boolean positiveOnly, boolean preserveNegativeZero) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if (integersOnly) {
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) < '0' || str.charAt(i) > '9' || i <= 0 && str.charAt(i) == '-') continue;
                return null;
            }
        }
        JSONOptions jo = preserveNegativeZero ? PreserveNegZeroYes : PreserveNegZeroNo;
        return positiveOnly && str.charAt(0) == '-' ? null : CBORDataUtilities.ParseJSONNumber(str, 0, str.length(), jo);
    }

    public static CBORObject ParseJSONNumber(String str, JSONOptions options) {
        return str == null || str.length() == 0 ? null : CBORDataUtilities.ParseJSONNumber(str, 0, str.length(), options);
    }

    public static CBORObject ParseJSONNumber(String str, int offset, int count) {
        return str == null || str.length() == 0 ? null : CBORDataUtilities.ParseJSONNumber(str, offset, count, JSONOptions.Default);
    }

    static CBORObject ParseSmallNumberAsNegative(int digit, JSONOptions options) {
        if (options != null && options.getNumberConversion() == JSONOptions.ConversionMode.Double) {
            return CBORObject.FromObject((double)(-digit));
        }
        return CBORObject.FromObject(-digit);
    }

    static CBORObject ParseSmallNumber(int digit, JSONOptions options) {
        if (options != null && options.getNumberConversion() == JSONOptions.ConversionMode.Double) {
            return CBORObject.FromObject((double)digit);
        }
        return CBORObject.FromObject(digit);
    }

    public static CBORObject ParseJSONNumber(String str, int offset, int count, JSONOptions options) {
        return CBORDataUtilities.ParseJSONNumber(str, offset, count, options, null);
    }

    static CBORObject ParseJSONNumber(String str, int offset, int count, JSONOptions options, int[] endOfNumber) {
        char c;
        if (str == null || str.length() == 0 || count <= 0) {
            return null;
        }
        if (offset < 0 || offset > str.length()) {
            return null;
        }
        if (count > str.length() || str.length() - offset < count) {
            return null;
        }
        JSONOptions opt = options == null ? DefaultOptions : options;
        boolean preserveNegativeZero = options.getPreserveNegativeZero();
        JSONOptions.ConversionMode kind = options.getNumberConversion();
        int endPos = offset + count;
        int initialOffset = offset++;
        boolean negative = false;
        if (str.charAt(initialOffset) == '-') {
            negative = true;
        }
        int numOffset = offset;
        boolean haveDecimalPoint = false;
        boolean haveDigits = false;
        boolean haveDigitsAfterDecimal = false;
        boolean haveExponent = false;
        int i = offset;
        int decimalPointPos = -1;
        int k = i;
        if (endPos - 1 > k && str.charAt(k) == '0' && str.charAt(k + 1) >= '0' && str.charAt(k + 1) <= '9') {
            if (endOfNumber != null) {
                endOfNumber[0] = k + 2;
            }
            return null;
        }
        while (k < endPos) {
            c = str.charAt(k);
            if (c >= '0' && c <= '9') {
                haveDigits = true;
                haveDigitsAfterDecimal |= haveDecimalPoint;
            } else if (c == '.') {
                if (!haveDigits || haveDecimalPoint) {
                    if (endOfNumber != null) {
                        endOfNumber[0] = k;
                    }
                    return null;
                }
                haveDecimalPoint = true;
                decimalPointPos = k;
            } else {
                if (c == 'E' || c == 'e') {
                    ++k;
                    haveExponent = true;
                    break;
                }
                if (endOfNumber != null) {
                    endOfNumber[0] = k;
                    if (c != ',' && c != ']' && c != '}' && c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                        return null;
                    }
                    endPos = k;
                    break;
                }
                return null;
            }
            ++k;
        }
        if (!haveDigits || haveDecimalPoint && !haveDigitsAfterDecimal) {
            if (endOfNumber != null) {
                endOfNumber[0] = k;
            }
            return null;
        }
        if (haveExponent) {
            haveDigits = false;
            if (k == endPos) {
                if (endOfNumber != null) {
                    endOfNumber[0] = k;
                }
                return null;
            }
            c = str.charAt(k);
            if (c == '+' || c == '-') {
                ++k;
            }
            while (k < endPos) {
                c = str.charAt(k);
                if (c < '0' || c > '9') {
                    if (endOfNumber != null) {
                        endOfNumber[0] = k;
                        if (c != ',' && c != ']' && c != '}' && c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                            return null;
                        }
                        endPos = k;
                        break;
                    }
                    return null;
                }
                haveDigits = true;
                ++k;
            }
            if (!haveDigits) {
                if (endOfNumber != null) {
                    endOfNumber[0] = k;
                }
                return null;
            }
        }
        if (endOfNumber != null) {
            endOfNumber[0] = endPos;
        }
        if (!haveExponent && !haveDecimalPoint && endPos - numOffset <= 16) {
            long v = 0L;
            for (int vi = numOffset; vi < endPos; ++vi) {
                v = v * 10L + (long)(str.charAt(vi) - 48);
            }
            if (!(v == 0L && negative || v >= 0x1FFFFFFFFFFFFFL)) {
                if (negative) {
                    v = -v;
                }
                if (kind == JSONOptions.ConversionMode.Double) {
                    return CBORObject.FromObject((double)v);
                }
                if (kind == JSONOptions.ConversionMode.Decimal128) {
                    return CBORObject.FromObject(EDecimal.FromInt64((long)v));
                }
                return CBORObject.FromObject(v);
            }
        }
        if (kind == JSONOptions.ConversionMode.Full) {
            EDecimal ed;
            if (!haveDecimalPoint && !haveExponent) {
                EInteger ei = EInteger.FromSubstring((String)str, (int)initialOffset, (int)endPos);
                if (preserveNegativeZero && ei.isZero() && negative) {
                    return CBORObject.FromFloatingPointBits(32768L, 2);
                }
                return CBORObject.FromObject(ei);
            }
            if (!haveExponent && haveDecimalPoint && endPos - numOffset <= 19) {
                int vi;
                long lv = 0L;
                int expo = -(endPos - (decimalPointPos + 1));
                for (vi = numOffset; vi < decimalPointPos; ++vi) {
                    lv = lv * 10L + (long)(str.charAt(vi) - 48);
                }
                for (vi = decimalPointPos + 1; vi < endPos; ++vi) {
                    lv = lv * 10L + (long)(str.charAt(vi) - 48);
                }
                if (negative) {
                    lv = -lv;
                }
                if (!negative || lv != 0L) {
                    CBORObject cbor = CBORObject.NewArray().Add(expo).Add(lv);
                    return CBORObject.FromObjectAndTag((Object)cbor, 4);
                }
            }
            if ((ed = EDecimal.FromString((String)str, (int)initialOffset, (int)(endPos - initialOffset))).isZero() && negative) {
                if (preserveNegativeZero && ed.getExponent().isZero()) {
                    return CBORObject.FromFloatingPointBits(32768L, 2);
                }
                if (!preserveNegativeZero) {
                    ed = ed.Negate();
                }
            }
            return CBORObject.FromObject(ed);
        }
        if (kind == JSONOptions.ConversionMode.Double) {
            double dbl = EFloat.FromString((String)str, (int)initialOffset, (int)(endPos - initialOffset), (EContext)EContext.Binary64).ToDouble();
            if (!preserveNegativeZero && dbl == 0.0) {
                dbl = 0.0;
            }
            return CBORObject.FromObject(dbl);
        }
        if (kind == JSONOptions.ConversionMode.Decimal128) {
            EDecimal ed = EDecimal.FromString((String)str, (int)initialOffset, (int)(endPos - initialOffset), (EContext)EContext.Decimal128);
            if (!preserveNegativeZero && ed.isNegative() && ed.isZero()) {
                ed = ed.Negate();
            }
            return CBORObject.FromObject(ed);
        }
        if (kind == JSONOptions.ConversionMode.IntOrFloatFromDouble) {
            double dbl = EFloat.FromString((String)str, (int)initialOffset, (int)(endPos - initialOffset), (EContext)EContext.Binary64).ToDouble();
            if (!Double.isNaN(dbl) && dbl >= -9.007199254740991E15 && dbl <= 9.007199254740991E15 && Math.floor(dbl) == dbl) {
                long idbl = (long)dbl;
                return CBORObject.FromObject(idbl);
            }
            return CBORObject.FromObject(dbl);
        }
        if (kind == JSONOptions.ConversionMode.IntOrFloat) {
            EContext ctx = EContext.Binary64.WithBlankFlags();
            double dbl = EFloat.FromString((String)str, (int)initialOffset, (int)(endPos - initialOffset), (EContext)ctx).ToDouble();
            if ((ctx.getFlags() & 1) != 0) {
                if (!preserveNegativeZero && dbl == 0.0) {
                    dbl = 0.0;
                }
                return CBORObject.FromObject(dbl);
            }
            if (!Double.isNaN(dbl) && dbl >= -9.007199254740991E15 && dbl <= 9.007199254740991E15 && Math.floor(dbl) == dbl) {
                long idbl = (long)dbl;
                return CBORObject.FromObject(idbl);
            }
            return CBORObject.FromObject(dbl);
        }
        throw new IllegalArgumentException("Unsupported conversion kind.");
    }
}

