/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERounding;

final class CBORUtilities {
    private static final String HexAlphabet = "0123456789ABCDEF";
    private static final int[] ValueNormalDays = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] ValueLeapDays = new int[]{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] ValueNormalToMonth = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final int[] ValueLeapToMonth = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};

    private CBORUtilities() {
    }

    public static void ToBase16(StringBuilder str, byte[] data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        int length = data.length;
        for (int i = 0; i < length; ++i) {
            str.append(HexAlphabet.charAt(data[i] >> 4 & 0xF));
            str.append(HexAlphabet.charAt(data[i] & 0xF));
        }
    }

    public static boolean ByteArrayEquals(byte[] a, byte[] b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static int ByteArrayHashCode(byte[] a) {
        if (a == null) {
            return 0;
        }
        int ret = 19;
        ret = ret * 31 + a.length;
        for (int i = 0; i < a.length; ++i) {
            ret = ret * 31 + a[i];
        }
        return ret;
    }

    public static int ByteArrayCompare(byte[] a, byte[] b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        int c = Math.min(a.length, b.length);
        for (int i = 0; i < c; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] < b[i] ? -1 : 1;
        }
        return a.length != b.length ? (a.length < b.length ? -1 : 1) : 0;
    }

    public static String DoubleToString(double dbl) {
        return EFloat.FromDouble((double)dbl).ToShortestString(EContext.Binary64);
    }

    public static String SingleToString(float sing) {
        return EFloat.FromSingle((float)sing).ToShortestString(EContext.Binary32);
    }

    public static EInteger BigIntegerFromSingle(float flt) {
        boolean neg;
        int value = Float.floatToRawIntBits(flt);
        int fpexponent = value >> 23 & 0xFF;
        if (fpexponent == 255) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        int mantissa = value & 0x7FFFFF;
        if (fpexponent == 0) {
            ++fpexponent;
        } else {
            mantissa |= 0x800000;
        }
        if (mantissa == 0) {
            return EInteger.FromInt32((int)0);
        }
        fpexponent -= 150;
        while ((mantissa & 1) == 0) {
            ++fpexponent;
            mantissa >>= 1;
        }
        boolean bl = neg = value >> 31 != 0;
        if (fpexponent == 0) {
            if (neg) {
                mantissa = -mantissa;
            }
            return EInteger.FromInt32((int)mantissa);
        }
        if (fpexponent > 0) {
            EInteger bigmantissa = EInteger.FromInt32((int)mantissa);
            bigmantissa = bigmantissa.ShiftLeft(fpexponent);
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return bigmantissa;
        }
        int exp = -fpexponent;
        for (int i = 0; i < exp && mantissa != 0; mantissa >>= 1, ++i) {
        }
        return EInteger.FromInt32((int)mantissa);
    }

    public static String LongToString(long longValue) {
        char digit;
        long divValue;
        if (longValue == Long.MIN_VALUE) {
            return "-9223372036854775808";
        }
        if (longValue == 0L) {
            return "0";
        }
        if (longValue == Integer.MIN_VALUE) {
            return "-2147483648";
        }
        boolean neg = longValue < 0L;
        int count = 0;
        int intlongValue = (int)longValue;
        if ((long)intlongValue == longValue) {
            char digit2;
            int intdivValue;
            char[] chars = new char[12];
            count = 11;
            if (neg) {
                intlongValue = -intlongValue;
            }
            while (intlongValue > 43698) {
                intdivValue = intlongValue / 10;
                digit2 = HexAlphabet.charAt(intlongValue - intdivValue * 10);
                chars[count--] = digit2;
                intlongValue = intdivValue;
            }
            while (intlongValue > 9) {
                intdivValue = intlongValue * 26215 >> 18;
                digit2 = HexAlphabet.charAt(intlongValue - intdivValue * 10);
                chars[count--] = digit2;
                intlongValue = intdivValue;
            }
            if (intlongValue != 0) {
                chars[count--] = HexAlphabet.charAt(intlongValue);
            }
            if (neg) {
                chars[count] = 45;
            } else {
                ++count;
            }
            return new String(chars, count, 12 - count);
        }
        char[] chars = new char[24];
        count = 23;
        if (neg) {
            longValue = -longValue;
        }
        while (longValue > 43698L) {
            divValue = longValue / 10L;
            digit = HexAlphabet.charAt((int)(longValue - divValue * 10L));
            chars[count--] = digit;
            longValue = divValue;
        }
        while (longValue > 9L) {
            divValue = longValue * 26215L >> 18;
            digit = HexAlphabet.charAt((int)(longValue - divValue * 10L));
            chars[count--] = digit;
            longValue = divValue;
        }
        if (longValue != 0L) {
            chars[count--] = HexAlphabet.charAt((int)longValue);
        }
        if (neg) {
            chars[count] = 45;
        } else {
            ++count;
        }
        return new String(chars, count, 24 - count);
    }

    private static EInteger FloorDiv(EInteger a, EInteger n) {
        return a.signum() >= 0 ? a.Divide(n) : EInteger.FromInt32((int)-1).Subtract(EInteger.FromInt32((int)-1).Subtract(a).Divide(n));
    }

    private static EInteger FloorMod(EInteger a, EInteger n) {
        return a.Subtract(CBORUtilities.FloorDiv(a, n).Multiply(n));
    }

    public static void GetNormalizedPartProlepticGregorian(EInteger year, int month, EInteger day, EInteger[] dest) {
        int[] dayArray;
        if (month <= 0 || month > 12) {
            throw new IllegalArgumentException("month");
        }
        int[] nArray = dayArray = year.Remainder(4).signum() != 0 || year.Remainder(100).signum() == 0 && year.Remainder(400).signum() != 0 ? ValueNormalDays : ValueLeapDays;
        if (day.compareTo(101) > 0) {
            EInteger count = day.Subtract(100).Divide(146097);
            day = day.Subtract(count.Multiply(146097));
            year = year.Add(count.Multiply(400));
        }
        while (true) {
            EInteger days = EInteger.FromInt32((int)dayArray[month]);
            if (day.signum() > 0 && day.compareTo(days) <= 0) break;
            if (day.compareTo(days) > 0) {
                day = day.Subtract(days);
                if (month == 12) {
                    month = 1;
                    dayArray = (year = year.Add(1)).Remainder(4).signum() != 0 || year.Remainder(100).signum() == 0 && year.Remainder(400).signum() != 0 ? ValueNormalDays : ValueLeapDays;
                } else {
                    ++month;
                }
            }
            if (day.signum() > 0) continue;
            if (--month <= 0) {
                year = year.Add(-1);
                month = 12;
            }
            dayArray = year.Remainder(4).signum() != 0 || year.Remainder(100).signum() == 0 && year.Remainder(400).signum() != 0 ? ValueNormalDays : ValueLeapDays;
            day = day.Add(dayArray[month]);
        }
        dest[0] = year;
        dest[1] = EInteger.FromInt32((int)month);
        dest[2] = day;
    }

    public static EInteger GetNumberOfDaysProlepticGregorian(EInteger year, int month, int mday) {
        if (month <= 0 || month > 12) {
            throw new IllegalArgumentException();
        }
        if (mday <= 0 || mday > 31) {
            throw new IllegalArgumentException();
        }
        EInteger numDays = EInteger.FromInt32((int)0);
        int startYear = 1970;
        if (year.compareTo(startYear) < 0) {
            EInteger ei = EInteger.FromInt32((int)(startYear - 1));
            EInteger diff = ei.Subtract(year);
            if (diff.compareTo(401) > 0) {
                EInteger blocks = diff.Subtract(401).Divide(400);
                numDays = numDays.Subtract(blocks.Multiply(146097));
                diff = diff.Subtract(blocks.Multiply(400));
                ei = ei.Subtract(blocks.Multiply(400));
            }
            numDays = numDays.Subtract(diff.Multiply(365));
            int decrement = 1;
            while (ei.compareTo(year) > 0) {
                if (decrement == 1 && ei.Remainder(4).signum() == 0) {
                    decrement = 4;
                }
                if (ei.Remainder(4).signum() == 0 && (ei.Remainder(100).signum() != 0 || ei.Remainder(400).signum() == 0)) {
                    numDays = numDays.Subtract(1);
                }
                ei = ei.Subtract(decrement);
            }
            numDays = year.Remainder(4).signum() != 0 || year.Remainder(100).signum() == 0 && year.Remainder(400).signum() != 0 ? numDays.Subtract(365 - ValueNormalToMonth[month]).Subtract(ValueNormalDays[month] - mday + 1) : numDays.Subtract(366 - ValueLeapToMonth[month]).Subtract(ValueLeapDays[month] - mday + 1);
        } else {
            boolean isNormalYear = year.Remainder(4).signum() != 0 || year.Remainder(100).signum() == 0 && year.Remainder(400).signum() != 0;
            EInteger ei = EInteger.FromInt32((int)startYear);
            if (ei.Add(401).compareTo(year) < 0) {
                EInteger y2 = year.Subtract(2);
                numDays = numDays.Add(y2.Subtract(startYear).Divide(400).Multiply(146097));
                ei = y2.Subtract(y2.Subtract(startYear).Remainder(400));
            }
            EInteger diff = year.Subtract(ei);
            numDays = numDays.Add(diff.Multiply(365));
            EInteger eileap = ei;
            if (ei.Remainder(4).signum() != 0) {
                eileap = eileap.Add(4 - eileap.Remainder(4).ToInt32Checked());
            }
            numDays = numDays.Add(year.Subtract(eileap).Add(3).Divide(4));
            if (ei.Remainder(100).signum() != 0) {
                ei = ei.Add(100 - ei.Remainder(100).ToInt32Checked());
            }
            while (ei.compareTo(year) < 0) {
                if (ei.Remainder(400).signum() != 0) {
                    numDays = numDays.Subtract(1);
                }
                ei = ei.Add(100);
            }
            int yearToMonth = isNormalYear ? ValueNormalToMonth[month - 1] : ValueLeapToMonth[month - 1];
            numDays = numDays.Add(yearToMonth).Add(mday - 1);
        }
        return numDays;
    }

    public static void BreakDownSecondsSinceEpoch(EDecimal edec, EInteger[] year, int[] lesserFields) {
        EInteger integerPart = edec.Quantize(0, ERounding.Floor).ToEInteger();
        EDecimal fractionalPart = edec.Abs().Subtract(EDecimal.FromEInteger((EInteger)integerPart).Abs());
        int nanoseconds = fractionalPart.Multiply(1000000000).ToInt32Checked();
        EInteger[] normPart = new EInteger[3];
        EInteger days = CBORUtilities.FloorDiv(integerPart, EInteger.FromInt32((int)86400)).Add(1);
        int secondsInDay = CBORUtilities.FloorMod(integerPart, EInteger.FromInt32((int)86400)).ToInt32Checked();
        CBORUtilities.GetNormalizedPartProlepticGregorian(EInteger.FromInt32((int)1970), 1, days, normPart);
        lesserFields[0] = normPart[1].ToInt32Checked();
        lesserFields[1] = normPart[2].ToInt32Checked();
        lesserFields[2] = secondsInDay / 3600;
        lesserFields[3] = secondsInDay % 3600 / 60;
        lesserFields[4] = secondsInDay % 60;
        lesserFields[5] = nanoseconds / 100;
        lesserFields[6] = 0;
        year[0] = normPart[0];
    }

    public static boolean NameStartsWithWord(String name, String word) {
        int wl = word.length();
        return !(name.length() <= wl || !name.substring(0, wl).equals(word) || name.charAt(wl) >= 'a' && name.charAt(wl) <= 'z' || name.charAt(wl) >= '0' && name.charAt(wl) <= '9');
    }

    public static String FirstCharLower(String name) {
        if (name.length() > 0 && name.charAt(0) >= 'A' && name.charAt(0) <= 'Z') {
            StringBuilder sb = new StringBuilder();
            sb.append((char)(name.charAt(0) + 32));
            sb.append(name.substring(1));
            return sb.toString();
        }
        return name;
    }

    public static String FirstCharUpper(String name) {
        if (name.length() > 0 && name.charAt(0) >= 'a' && name.charAt(0) <= 'z') {
            StringBuilder sb = new StringBuilder();
            sb.append((char)(name.charAt(0) - 32));
            sb.append(name.substring(1));
            return sb.toString();
        }
        return name;
    }

    private static boolean IsValidDateTime(int[] dateTime) {
        if (dateTime == null || dateTime.length < 8) {
            return false;
        }
        if (dateTime[1] < 1 || dateTime[1] > 12 || dateTime[2] < 1) {
            return false;
        }
        boolean leap = CBORUtilities.IsLeapYear(dateTime[0]);
        if (dateTime[1] == 4 || dateTime[1] == 6 || dateTime[1] == 9 || dateTime[1] == 11 ? dateTime[2] > 30 : (dateTime[1] == 2 ? dateTime[2] > (leap ? 29 : 28) : dateTime[2] > 31)) {
            return false;
        }
        return dateTime[3] >= 0 && dateTime[4] >= 0 && dateTime[5] >= 0 && dateTime[3] < 24 && dateTime[4] < 60 && dateTime[5] < 61 && dateTime[6] >= 0 && dateTime[6] < 1000000000 && dateTime[7] > -1440 && dateTime[7] < 1440;
    }

    private static boolean IsLeapYear(int yr) {
        if ((yr %= 400) < 0) {
            yr += 400;
        }
        return yr % 4 == 0 && yr % 100 != 0 || yr % 400 == 0;
    }

    public static void ParseAtomDateTimeString(String str, EInteger[] bigYearArray, int[] lf) {
        int[] d = CBORUtilities.ParseAtomDateTimeString(str);
        bigYearArray[0] = EInteger.FromInt32((int)d[0]);
        System.arraycopy(d, 1, lf, 0, 7);
    }

    private static int[] ParseAtomDateTimeString(String str) {
        boolean bad = false;
        if (str.length() < 19) {
            throw new IllegalArgumentException("Invalid date/time");
        }
        for (int i = 0; i < 19 && !bad; ++i) {
            if (i == 4 || i == 7) {
                bad |= str.charAt(i) != '-';
                continue;
            }
            if (i == 13 || i == 16) {
                bad |= str.charAt(i) != ':';
                continue;
            }
            if (i == 10) {
                bad |= str.charAt(i) != 'T';
                continue;
            }
            bad |= str.charAt(i) < '0' || str.charAt(i) > '9';
        }
        if (bad) {
            throw new IllegalArgumentException("Invalid date/time");
        }
        int year = (str.charAt(0) - 48) * 1000 + (str.charAt(1) - 48) * 100 + (str.charAt(2) - 48) * 10 + (str.charAt(3) - 48);
        int month = (str.charAt(5) - 48) * 10 + (str.charAt(6) - 48);
        int day = (str.charAt(8) - 48) * 10 + (str.charAt(9) - 48);
        int hour = (str.charAt(11) - 48) * 10 + (str.charAt(12) - 48);
        int minute = (str.charAt(14) - 48) * 10 + (str.charAt(15) - 48);
        int second = (str.charAt(17) - 48) * 10 + (str.charAt(18) - 48);
        int index = 19;
        int nanoSeconds = 0;
        if (index <= str.length() && str.charAt(index) == '.') {
            int icount = 0;
            ++index;
            while (index < str.length() && str.charAt(index) >= '0' && str.charAt(index) <= '9') {
                if (icount < 9) {
                    nanoSeconds = nanoSeconds * 10 + (str.charAt(index) - 48);
                    ++icount;
                }
                ++index;
            }
            while (icount < 9) {
                nanoSeconds *= 10;
                ++icount;
            }
        }
        int utcToLocal = 0;
        if (index + 1 == str.length() && str.charAt(index) == 'Z') {
            utcToLocal = 0;
        } else if (index + 6 == str.length()) {
            bad = false;
            for (int i = 0; i < 6 && !bad; ++i) {
                if (i == 0) {
                    bad |= str.charAt(index + i) != '-' && str.charAt(index + i) != '+';
                    continue;
                }
                if (i == 3) {
                    bad |= str.charAt(index + i) != ':';
                    continue;
                }
                bad |= str.charAt(index + i) < '0' || str.charAt(index + i) > '9';
            }
            if (bad) {
                throw new IllegalArgumentException("Invalid date/time");
            }
            boolean neg = str.charAt(index) == '-';
            int tzhour = (str.charAt(index + 1) - 48) * 10 + (str.charAt(index + 2) - 48);
            int tzminute = (str.charAt(index + 4) - 48) * 10 + (str.charAt(index + 5) - 48);
            if (tzminute >= 60) {
                throw new IllegalArgumentException("Invalid date/time");
            }
            utcToLocal = (neg ? -1 : 1) * (tzhour * 60) + tzminute;
        } else {
            throw new IllegalArgumentException("Invalid date/time");
        }
        int[] dt = new int[]{year, month, day, hour, minute, second, nanoSeconds, utcToLocal};
        if (!CBORUtilities.IsValidDateTime(dt)) {
            throw new IllegalArgumentException("Invalid date/time");
        }
        return dt;
    }

    public static String ToAtomDateTimeString(EInteger bigYear, int[] lesserFields) {
        if (lesserFields[6] != 0) {
            throw new UnsupportedOperationException("Local time offsets not supported");
        }
        int smallYear = bigYear.ToInt32Checked();
        if (smallYear < 0) {
            throw new IllegalArgumentException("year (" + smallYear + ") is not greater or equal to 0");
        }
        if (smallYear > 9999) {
            throw new IllegalArgumentException("year (" + smallYear + ") is not less or equal to 9999");
        }
        int month = lesserFields[0];
        int day = lesserFields[1];
        int hour = lesserFields[2];
        int minute = lesserFields[3];
        int second = lesserFields[4];
        int fracSeconds = lesserFields[5];
        char[] charbuf = new char[32];
        charbuf[0] = (char)(48 + smallYear / 1000 % 10);
        charbuf[1] = (char)(48 + smallYear / 100 % 10);
        charbuf[2] = (char)(48 + smallYear / 10 % 10);
        charbuf[3] = (char)(48 + smallYear % 10);
        charbuf[4] = 45;
        charbuf[5] = (char)(48 + month / 10 % 10);
        charbuf[6] = (char)(48 + month % 10);
        charbuf[7] = 45;
        charbuf[8] = (char)(48 + day / 10 % 10);
        charbuf[9] = (char)(48 + day % 10);
        charbuf[10] = 84;
        charbuf[11] = (char)(48 + hour / 10 % 10);
        charbuf[12] = (char)(48 + hour % 10);
        charbuf[13] = 58;
        charbuf[14] = (char)(48 + minute / 10 % 10);
        charbuf[15] = (char)(48 + minute % 10);
        charbuf[16] = 58;
        charbuf[17] = (char)(48 + second / 10 % 10);
        charbuf[18] = (char)(48 + second % 10);
        int charbufLength = 19;
        if (fracSeconds > 0) {
            charbuf[19] = 46;
            ++charbufLength;
            int index = 20;
            for (int digitdiv = 100000000; digitdiv > 0 && fracSeconds != 0; digitdiv /= 10) {
                int digit = fracSeconds / digitdiv % 10;
                fracSeconds -= digit * digitdiv;
                charbuf[index++] = (char)(48 + digit);
                ++charbufLength;
            }
            charbuf[index] = 90;
            ++charbufLength;
        } else {
            charbuf[19] = 90;
            ++charbufLength;
        }
        return new String(charbuf, 0, charbufLength);
    }

    public static EInteger BigIntegerFromDouble(double dbl) {
        boolean neg;
        long lvalue = Double.doubleToRawLongBits(dbl);
        int value0 = (int)(lvalue & 0xFFFFFFFFL);
        int value1 = (int)(lvalue >> 32 & 0xFFFFFFFFL);
        int floatExponent = value1 >> 20 & 0x7FF;
        boolean bl = neg = value1 >> 31 != 0;
        if (floatExponent == 2047) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        value1 &= 0xFFFFF;
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            value1 |= 0x100000;
        }
        if ((value1 | value0) != 0) {
            while ((value0 & 1) == 0) {
                value0 >>= 1;
                value0 &= Integer.MAX_VALUE;
                value0 |= value1 << 31;
                value1 >>= 1;
                ++floatExponent;
            }
        }
        byte[] bytes = new byte[]{(byte)(value0 & 0xFF), (byte)(value0 >> 8 & 0xFF), (byte)(value0 >> 16 & 0xFF), (byte)(value0 >> 24 & 0xFF), (byte)(value1 & 0xFF), (byte)(value1 >> 8 & 0xFF), (byte)(value1 >> 16 & 0xFF), (byte)(value1 >> 24 & 0xFF), 0};
        EInteger bigmantissa = EInteger.FromBytes((byte[])bytes, (boolean)true);
        if ((floatExponent -= 1075) == 0) {
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return bigmantissa;
        }
        if (floatExponent > 0) {
            bigmantissa = bigmantissa.ShiftLeft(floatExponent);
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return bigmantissa;
        }
        int exp = -floatExponent;
        bigmantissa = bigmantissa.ShiftRight(exp);
        if (neg) {
            bigmantissa = bigmantissa.Negate();
        }
        return bigmantissa;
    }

    public static float HalfPrecisionToSingle(int value) {
        int negvalue;
        int n = negvalue = value >= 32768 ? Integer.MIN_VALUE : 0;
        if ((value &= Short.MAX_VALUE) >= 31744) {
            value = (0x3FC00 | value & 0x3FF) << 13 | negvalue;
            return Float.intBitsToFloat(value);
        }
        if (value > 1024) {
            value = value + 114688 << 13 | negvalue;
            return Float.intBitsToFloat(value);
        }
        if ((value & 0x400) == value) {
            value = (value == 0 ? 0 : 0x38800000) | negvalue;
            return Float.intBitsToFloat(value);
        }
        int m = value & 0x3FF;
        value = 115712;
        while (m >> 10 == 0) {
            value -= 1024;
            m <<= 1;
        }
        value = (value | m & 0x3FF) << 13 | negvalue;
        return Float.intBitsToFloat(value);
    }
}

