/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.ICBORNumber;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;

class CBORDouble
implements ICBORNumber {
    CBORDouble() {
    }

    @Override
    public boolean IsPositiveInfinity(Object obj) {
        return (Double)obj == Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean IsInfinity(Object obj) {
        return Double.valueOf((Double)obj).isInfinite();
    }

    @Override
    public boolean IsNegativeInfinity(Object obj) {
        return (Double)obj == Double.NEGATIVE_INFINITY;
    }

    @Override
    public boolean IsNaN(Object obj) {
        return Double.isNaN((Double)obj);
    }

    @Override
    public double AsDouble(Object obj) {
        return (Double)obj;
    }

    @Override
    public EDecimal AsExtendedDecimal(Object obj) {
        return EDecimal.FromDouble((double)((Double)obj));
    }

    @Override
    public EFloat AsExtendedFloat(Object obj) {
        return EFloat.FromDouble((double)((Double)obj));
    }

    @Override
    public float AsSingle(Object obj) {
        return ((Double)obj).floatValue();
    }

    @Override
    public EInteger AsEInteger(Object obj) {
        return CBORUtilities.BigIntegerFromDouble((Double)obj);
    }

    @Override
    public long AsInt64(Object obj) {
        double fltItem = (Double)obj;
        if (Double.isNaN(fltItem)) {
            throw new ArithmeticException("This Object's value is out of range");
        }
        double d = fltItem = fltItem < 0.0 ? Math.ceil(fltItem) : Math.floor(fltItem);
        if (fltItem >= -9.223372036854776E18 && fltItem < 9.223372036854776E18) {
            return (long)fltItem;
        }
        throw new ArithmeticException("This Object's value is out of range");
    }

    @Override
    public boolean CanFitInSingle(Object obj) {
        double fltItem = (Double)obj;
        if (Double.isNaN(fltItem)) {
            return true;
        }
        float sing = (float)fltItem;
        return (double)sing == fltItem;
    }

    @Override
    public boolean CanFitInDouble(Object obj) {
        return true;
    }

    @Override
    public boolean CanFitInInt32(Object obj) {
        return this.IsIntegral(obj) && this.CanTruncatedIntFitInInt32(obj);
    }

    @Override
    public boolean CanFitInInt64(Object obj) {
        return this.IsIntegral(obj) && this.CanTruncatedIntFitInInt64(obj);
    }

    @Override
    public boolean CanTruncatedIntFitInInt64(Object obj) {
        double fltItem = (Double)obj;
        if (Double.isNaN(fltItem) || Double.valueOf(fltItem).isInfinite()) {
            return false;
        }
        double fltItem2 = fltItem < 0.0 ? Math.ceil(fltItem) : Math.floor(fltItem);
        return fltItem2 >= -9.223372036854776E18 && fltItem2 < 9.223372036854776E18;
    }

    @Override
    public boolean CanTruncatedIntFitInInt32(Object obj) {
        double fltItem = (Double)obj;
        if (Double.isNaN(fltItem) || Double.valueOf(fltItem).isInfinite()) {
            return false;
        }
        double fltItem2 = fltItem < 0.0 ? Math.ceil(fltItem) : Math.floor(fltItem);
        return fltItem2 >= -2.147483648E9 && fltItem2 <= 2.147483647E9;
    }

    @Override
    public int AsInt32(Object obj, int minValue, int maxValue) {
        double fltItem = (Double)obj;
        if (Double.isNaN(fltItem)) {
            throw new ArithmeticException("This Object's value is out of range");
        }
        double d = fltItem = fltItem < 0.0 ? Math.ceil(fltItem) : Math.floor(fltItem);
        if (fltItem >= (double)minValue && fltItem <= (double)maxValue) {
            int ret = (int)fltItem;
            return ret;
        }
        throw new ArithmeticException("This Object's value is out of range");
    }

    @Override
    public boolean IsZero(Object obj) {
        return (Double)obj == 0.0;
    }

    @Override
    public int Sign(Object obj) {
        double flt = (Double)obj;
        return Double.isNaN(flt) ? 2 : (flt == 0.0 ? 0 : (flt < 0.0 ? -1 : 1));
    }

    @Override
    public boolean IsIntegral(Object obj) {
        double fltItem = (Double)obj;
        if (Double.isNaN(fltItem) || Double.valueOf(fltItem).isInfinite()) {
            return false;
        }
        double fltItem2 = fltItem < 0.0 ? Math.ceil(fltItem) : Math.floor(fltItem);
        return fltItem == fltItem2;
    }

    @Override
    public Object Negate(Object obj) {
        double val = (Double)obj;
        return -val;
    }

    @Override
    public Object Abs(Object obj) {
        double val = (Double)obj;
        return val < 0.0 ? Double.valueOf(-val) : obj;
    }

    @Override
    public ERational AsExtendedRational(Object obj) {
        return ERational.FromDouble((double)((Double)obj));
    }

    @Override
    public boolean IsNegative(Object obj) {
        double dbl = (Double)obj;
        long lvalue = Double.doubleToRawLongBits(dbl);
        return lvalue >> 63 != 0L;
    }
}

