/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORTypeFilter;
import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.ICBORTag;
import com.upokecenter.cbor.PropertyMap;
import com.upokecenter.cbor.SharedRefs;
import com.upokecenter.cbor.StringRefs;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.util.DataUtilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class CBORReader {
    private final InputStream stream;
    private int depth;
    private boolean resolveReferences;
    private CBORDuplicatePolicy policy;
    private StringRefs stringRefs;
    private boolean hasSharableObjects;

    public CBORReader(InputStream inStream) {
        this.stream = inStream;
        this.policy = CBORDuplicatePolicy.Overwrite;
        this.resolveReferences = false;
    }

    public final CBORDuplicatePolicy getDuplicatePolicy() {
        return this.policy;
    }

    public final void setDuplicatePolicy(CBORDuplicatePolicy value) {
        this.policy = value;
    }

    public final boolean getResolveReferences() {
        return this.resolveReferences;
    }

    public final void setResolveReferences(boolean value) {
        this.resolveReferences = value;
    }

    public CBORObject ResolveSharedRefsIfNeeded(CBORObject obj) {
        if (obj == null || !this.getResolveReferences()) {
            return obj;
        }
        if (this.hasSharableObjects) {
            SharedRefs sharedRefs = new SharedRefs();
            return this.ResolveSharedRefs(obj, sharedRefs);
        }
        return obj;
    }

    private CBORObject ResolveSharedRefs(CBORObject obj, SharedRefs sharedRefs) {
        block6: {
            int type;
            block5: {
                if (obj == null) {
                    return obj;
                }
                type = obj.getItemType();
                boolean hasTag = obj.getMostOuterTag().equals((Object)EInteger.FromInt64((long)29L));
                if (hasTag) {
                    return sharedRefs.GetObject(obj.AsEInteger());
                }
                hasTag = obj.getMostOuterTag().equals((Object)EInteger.FromInt64((long)28L));
                if (hasTag) {
                    obj = obj.Untag();
                    sharedRefs.AddObject(obj);
                }
                if (type != 5) break block5;
                for (CBORObject key : obj.getKeys()) {
                    CBORObject newvalue;
                    CBORObject value = obj.get(key);
                    if (value == (newvalue = this.ResolveSharedRefs(value, sharedRefs))) continue;
                    obj.set(key, newvalue);
                }
                break block6;
            }
            if (type != 4) break block6;
            for (int i = 0; i < obj.size(); ++i) {
                obj.set(i, this.ResolveSharedRefs(obj.get(i), sharedRefs));
            }
        }
        return obj;
    }

    public CBORObject Read(CBORTypeFilter filter) throws IOException {
        if (this.depth > 500) {
            throw new CBORException("Too deeply nested");
        }
        int firstbyte = this.stream.read();
        if (firstbyte < 0) {
            throw new CBORException("Premature end of data");
        }
        return this.ReadForFirstByte(firstbyte, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CBORObject ReadForFirstByte(int firstbyte, CBORTypeFilter filter) throws IOException {
        CBORObject fixedObject;
        if (this.depth > 500) {
            throw new CBORException("Too deeply nested");
        }
        if (firstbyte < 0) {
            throw new CBORException("Premature end of data");
        }
        if (firstbyte == 255) {
            throw new CBORException("Unexpected break code encountered");
        }
        int type = firstbyte >> 5 & 7;
        int additional = firstbyte & 0x1F;
        int expectedLength = CBORObject.GetExpectedLength(firstbyte);
        if (expectedLength == -1) {
            throw new CBORException("Unexpected data encountered");
        }
        if (filter != null) {
            if (!filter.MajorTypeMatches(type)) {
                throw new CBORException("Unexpected data type encountered");
            }
            if (firstbyte >= 224 && firstbyte <= 255 && firstbyte != 249 && firstbyte != 250 && firstbyte != 251 && !filter.NonFPSimpleValueAllowed()) {
                throw new CBORException("Unexpected data type encountered");
            }
        }
        if ((fixedObject = CBORObject.GetFixedObject(firstbyte)) != null) {
            return fixedObject;
        }
        byte[] data = null;
        if (expectedLength != 0) {
            data = new byte[expectedLength];
            data[0] = (byte)firstbyte;
            if (expectedLength > 1 && this.stream.read(data, 1, expectedLength - 1) != expectedLength - 1) {
                throw new CBORException("Premature end of data");
            }
            CBORObject cbor = CBORObject.GetFixedLengthObject(firstbyte, data);
            if (this.stringRefs != null && (type == 2 || type == 3)) {
                this.stringRefs.AddStringIfNeeded(cbor, expectedLength - 1);
            }
            return cbor;
        }
        long uadditional = additional;
        EInteger bigintAdditional = EInteger.FromInt32((int)0);
        boolean hasBigAdditional = false;
        data = new byte[8];
        int lowAdditional = 0;
        switch (firstbyte & 0x1F) {
            case 24: {
                int tmp = this.stream.read();
                if (tmp < 0) {
                    throw new CBORException("Premature end of data");
                }
                lowAdditional = tmp;
                uadditional = lowAdditional;
                break;
            }
            case 25: {
                if (this.stream.read(data, 0, 2) != 2) {
                    throw new CBORException("Premature end of data");
                }
                lowAdditional = (data[0] & 0xFF) << 8;
                uadditional = lowAdditional |= data[1] & 0xFF;
                break;
            }
            case 26: {
                if (this.stream.read(data, 0, 4) != 4) {
                    throw new CBORException("Premature end of data");
                }
                uadditional = ((long)data[0] & 0xFFL) << 24;
                uadditional |= ((long)data[1] & 0xFFL) << 16;
                uadditional |= ((long)data[2] & 0xFFL) << 8;
                uadditional |= (long)data[3] & 0xFFL;
                break;
            }
            case 27: {
                if (this.stream.read(data, 0, 8) != 8) {
                    throw new CBORException("Premature end of data");
                }
                if ((data[0] & 0x80) != 0) {
                    byte[] uabytes = new byte[]{data[7], data[6], data[5], data[4], data[3], data[2], data[1], data[0], 0};
                    hasBigAdditional = true;
                    bigintAdditional = EInteger.FromBytes((byte[])uabytes, (boolean)true);
                    break;
                }
                uadditional = ((long)data[0] & 0xFFL) << 56;
                uadditional |= ((long)data[1] & 0xFFL) << 48;
                uadditional |= ((long)data[2] & 0xFFL) << 40;
                uadditional |= ((long)data[3] & 0xFFL) << 32;
                uadditional |= ((long)data[4] & 0xFFL) << 24;
                uadditional |= ((long)data[5] & 0xFFL) << 16;
                uadditional |= ((long)data[6] & 0xFFL) << 8;
                uadditional |= (long)data[7] & 0xFFL;
            }
        }
        if (type == 2) {
            if (additional == 31) {
                ByteArrayOutputStream ms = null;
                try {
                    int nextByte22;
                    ms = new ByteArrayOutputStream();
                    while ((nextByte22 = this.stream.read()) != 255) {
                        long len = CBORReader.ReadDataLength(this.stream, nextByte22, 2);
                        if (len >> 63 != 0L || len > Integer.MAX_VALUE) {
                            throw new CBORException("Length" + CBORReader.ToUnsignedBigInteger(len) + " is bigger than supported ");
                        }
                        if (nextByte22 == 64) continue;
                        CBORReader.ReadByteData(this.stream, len, ms);
                    }
                    if (ms.size() > Integer.MAX_VALUE) {
                        throw new CBORException("Length of bytes to be streamed is bigger than supported ");
                    }
                    data = ms.toByteArray();
                    CBORObject nextByte22 = new CBORObject(2, data);
                    return nextByte22;
                }
                finally {
                    try {
                        if (ms != null) {
                            ms.close();
                        }
                    }
                    catch (IOException len) {}
                }
            }
            if (hasBigAdditional) {
                throw new CBORException("Length of " + bigintAdditional.toString() + " is bigger than supported");
            }
            if (uadditional > Integer.MAX_VALUE) {
                throw new CBORException("Length of " + CBORUtilities.LongToString(uadditional) + " is bigger than supported");
            }
            data = CBORReader.ReadByteData(this.stream, uadditional, null);
            CBORObject cbor = new CBORObject(2, data);
            if (this.stringRefs != null) {
                int hint = uadditional > Integer.MAX_VALUE || hasBigAdditional ? Integer.MAX_VALUE : (int)uadditional;
                this.stringRefs.AddStringIfNeeded(cbor, hint);
            }
            return cbor;
        }
        if (type == 3) {
            if (additional == 31) {
                int nextByte;
                StringBuilder builder = new StringBuilder();
                while ((nextByte = this.stream.read()) != 255) {
                    long len = CBORReader.ReadDataLength(this.stream, nextByte, 3);
                    if (len >> 63 != 0L || len > Integer.MAX_VALUE) {
                        throw new CBORException("Length" + CBORReader.ToUnsignedBigInteger(len) + " is bigger than supported");
                    }
                    if (nextByte == 96) continue;
                    if (PropertyMap.ExceedsKnownLength(this.stream, len)) {
                        throw new CBORException("Premature end of data");
                    }
                    switch (DataUtilities.ReadUtf8(this.stream, (int)len, builder, false)) {
                        case -1: {
                            throw new CBORException("Invalid UTF-8");
                        }
                        case -2: {
                            throw new CBORException("Premature end of data");
                        }
                    }
                }
                return new CBORObject(3, builder.toString());
            }
            if (hasBigAdditional) {
                throw new CBORException("Length of " + bigintAdditional.toString() + " is bigger than supported");
            }
            if (uadditional > Integer.MAX_VALUE) {
                throw new CBORException("Length of " + CBORUtilities.LongToString(uadditional) + " is bigger than supported");
            }
            if (PropertyMap.ExceedsKnownLength(this.stream, uadditional)) {
                throw new CBORException("Premature end of data");
            }
            StringBuilder builder = new StringBuilder();
            switch (DataUtilities.ReadUtf8(this.stream, (int)uadditional, builder, false)) {
                case -1: {
                    throw new CBORException("Invalid UTF-8");
                }
                case -2: {
                    throw new CBORException("Premature end of data");
                }
            }
            CBORObject cbor = new CBORObject(3, builder.toString());
            if (this.stringRefs != null) {
                int hint = uadditional > Integer.MAX_VALUE || hasBigAdditional ? Integer.MAX_VALUE : (int)uadditional;
                this.stringRefs.AddStringIfNeeded(cbor, hint);
            }
            return cbor;
        }
        if (type == 4) {
            CBORObject cbor = CBORObject.NewArray();
            if (additional == 31) {
                int vtindex = 0;
                while (true) {
                    int headByte;
                    if ((headByte = this.stream.read()) < 0) {
                        throw new CBORException("Premature end of data");
                    }
                    if (headByte == 255) break;
                    if (filter != null && !filter.ArrayIndexAllowed(vtindex)) {
                        throw new CBORException("Array is too long");
                    }
                    ++this.depth;
                    CBORObject o = this.ReadForFirstByte(headByte, filter == null ? null : filter.GetSubFilter(vtindex));
                    --this.depth;
                    cbor.Add(o);
                    ++vtindex;
                }
                return cbor;
            }
            if (hasBigAdditional) {
                throw new CBORException("Length of " + bigintAdditional.toString() + " is bigger than supported");
            }
            if (uadditional > Integer.MAX_VALUE) {
                throw new CBORException("Length of " + CBORUtilities.LongToString(uadditional) + " is bigger than supported");
            }
            if (filter != null && !filter.ArrayLengthMatches(uadditional)) {
                throw new CBORException("Array is too long");
            }
            if (PropertyMap.ExceedsKnownLength(this.stream, uadditional)) {
                throw new CBORException("Remaining data too small for array length");
            }
            ++this.depth;
            for (long i = 0L; i < uadditional; ++i) {
                cbor.Add(this.Read(filter == null ? null : filter.GetSubFilter(i)));
            }
            --this.depth;
            return cbor;
        }
        if (type == 5) {
            CBORObject cbor = CBORObject.NewMap();
            if (additional == 31) {
                while (true) {
                    int headByte;
                    if ((headByte = this.stream.read()) < 0) {
                        throw new CBORException("Premature end of data");
                    }
                    if (headByte == 255) break;
                    ++this.depth;
                    CBORObject key = this.ReadForFirstByte(headByte, null);
                    CBORObject value = this.Read(null);
                    --this.depth;
                    if (this.policy == CBORDuplicatePolicy.Disallow && cbor.ContainsKey(key)) {
                        throw new CBORException("Duplicate key already exists: " + key);
                    }
                    cbor.set(key, value);
                }
                return cbor;
            }
            if (hasBigAdditional) {
                throw new CBORException("Length of " + bigintAdditional.toString() + " is bigger than supported");
            }
            if (uadditional > Integer.MAX_VALUE) {
                throw new CBORException("Length of " + CBORUtilities.LongToString(uadditional) + " is bigger than supported");
            }
            if (PropertyMap.ExceedsKnownLength(this.stream, uadditional)) {
                throw new CBORException("Remaining data too small for map length");
            }
            for (long i = 0L; i < uadditional; ++i) {
                ++this.depth;
                CBORObject key = this.Read(null);
                CBORObject value = this.Read(null);
                --this.depth;
                if (this.policy == CBORDuplicatePolicy.Disallow && cbor.ContainsKey(key)) {
                    throw new CBORException("Duplicate key already exists: " + key);
                }
                cbor.set(key, value);
            }
            return cbor;
        }
        if (type == 6) {
            ICBORTag taginfo = null;
            boolean haveFirstByte = false;
            int newFirstByte = -1;
            if (!hasBigAdditional) {
                int uad;
                if (filter != null && !filter.TagAllowed(uadditional)) {
                    throw new CBORException("Unexpected tag encountered: " + uadditional);
                }
                int n = uadditional >= 257L ? 257 : (uad = uadditional < 0L ? 0 : (int)uadditional);
                if (this.getResolveReferences()) {
                    switch (uad) {
                        case 256: {
                            this.stringRefs = this.stringRefs == null ? new StringRefs() : this.stringRefs;
                            this.stringRefs.Push();
                            break;
                        }
                        case 25: {
                            if (this.stringRefs != null) break;
                            throw new CBORException("No stringref namespace");
                        }
                        case 28: 
                        case 29: {
                            this.hasSharableObjects = true;
                        }
                    }
                }
                taginfo = CBORObject.FindTagConverterLong(uadditional);
            } else {
                if (filter != null && !filter.TagAllowed(bigintAdditional)) {
                    throw new CBORException("Unexpected tag encountered: " + uadditional);
                }
                taginfo = CBORObject.FindTagConverter(bigintAdditional);
            }
            ++this.depth;
            CBORObject o = haveFirstByte ? this.ReadForFirstByte(newFirstByte, taginfo == null ? null : taginfo.GetTypeFilter()) : this.Read(taginfo == null ? null : taginfo.GetTypeFilter());
            --this.depth;
            if (hasBigAdditional) {
                return CBORObject.FromObjectAndTag((Object)o, bigintAdditional);
            }
            if (uadditional < 65536L) {
                int uaddl;
                int n = uadditional >= 257L ? 257 : (uaddl = uadditional < 0L ? 0 : (int)uadditional);
                if (this.getResolveReferences()) {
                    switch (uaddl) {
                        case 256: {
                            this.stringRefs.Pop();
                            break;
                        }
                        case 25: {
                            return this.stringRefs.GetString(o.AsEInteger());
                        }
                    }
                }
                return CBORObject.FromObjectAndTag((Object)o, (int)uadditional);
            }
            return CBORObject.FromObjectAndTag((Object)o, EInteger.FromInt64((long)uadditional));
        }
        throw new CBORException("Unexpected data encountered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] ReadByteData(InputStream stream, long uadditional, OutputStream outputStream) throws IOException {
        int total;
        if (uadditional >> 63 != 0L || uadditional > Integer.MAX_VALUE) {
            throw new CBORException("Length" + CBORReader.ToUnsignedBigInteger(uadditional) + " is bigger than supported ");
        }
        if (PropertyMap.ExceedsKnownLength(stream, uadditional)) {
            throw new CBORException("Premature end of stream");
        }
        if (uadditional <= 65536L) {
            byte[] data = new byte[(int)uadditional];
            if (stream.read(data, 0, data.length) != data.length) {
                throw new CBORException("Premature end of stream");
            }
            if (outputStream != null) {
                outputStream.write(data, 0, data.length);
                return null;
            }
            return data;
        }
        byte[] tmpdata = new byte[65536];
        if (outputStream != null) {
            int bufsize;
            for (total = (int)uadditional; total > 0; total -= bufsize) {
                bufsize = Math.min(tmpdata.length, total);
                if (stream.read(tmpdata, 0, bufsize) != bufsize) {
                    throw new CBORException("Premature end of stream");
                }
                outputStream.write(tmpdata, 0, bufsize);
            }
            return null;
        }
        ByteArrayOutputStream ms = null;
        try {
            ms = new ByteArrayOutputStream(65536);
            while (total > 0) {
                int bufsize = Math.min(tmpdata.length, total);
                if (stream.read(tmpdata, 0, bufsize) != bufsize) {
                    throw new CBORException("Premature end of stream");
                }
                ms.write(tmpdata, 0, bufsize);
                total -= bufsize;
            }
            byte[] byArray = ms.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (ms != null) {
                    ms.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static long ReadDataLength(InputStream stream, int headByte, int expectedType) throws IOException {
        if (headByte < 0) {
            throw new CBORException("Unexpected data encountered");
        }
        if ((headByte >> 5 & 7) != expectedType) {
            throw new CBORException("Unexpected data encountered");
        }
        if ((headByte &= 0x1F) < 24) {
            return headByte;
        }
        byte[] data = new byte[8];
        switch (headByte & 0x1F) {
            case 24: {
                int tmp = stream.read();
                if (tmp < 0) {
                    throw new CBORException("Premature end of data");
                }
                return tmp;
            }
            case 25: {
                if (stream.read(data, 0, 2) != 2) {
                    throw new CBORException("Premature end of data");
                }
                int lowAdditional = (data[0] & 0xFF) << 8;
                return lowAdditional |= data[1] & 0xFF;
            }
            case 26: {
                if (stream.read(data, 0, 4) != 4) {
                    throw new CBORException("Premature end of data");
                }
                long uadditional = ((long)data[0] & 0xFFL) << 24;
                uadditional |= ((long)data[1] & 0xFFL) << 16;
                uadditional |= ((long)data[2] & 0xFFL) << 8;
                return uadditional |= (long)data[3] & 0xFFL;
            }
            case 27: {
                if (stream.read(data, 0, 8) != 8) {
                    throw new CBORException("Premature end of data");
                }
                long uadditional = ((long)data[0] & 0xFFL) << 56;
                uadditional |= ((long)data[1] & 0xFFL) << 48;
                uadditional |= ((long)data[2] & 0xFFL) << 40;
                uadditional |= ((long)data[3] & 0xFFL) << 32;
                uadditional |= ((long)data[4] & 0xFFL) << 24;
                uadditional |= ((long)data[5] & 0xFFL) << 16;
                uadditional |= ((long)data[6] & 0xFFL) << 8;
                return uadditional |= (long)data[7] & 0xFFL;
            }
            case 28: 
            case 29: 
            case 30: {
                throw new CBORException("Unexpected data encountered");
            }
            case 31: {
                throw new CBORException("Indefinite-length data not allowed here");
            }
        }
        return headByte;
    }

    private static EInteger ToUnsignedBigInteger(long val) {
        EInteger lval = EInteger.FromInt64((long)(val & Long.MAX_VALUE));
        if (val >> 63 != 0L) {
            EInteger bigintAdd = EInteger.FromInt32((int)1).ShiftLeft(63);
            lval = lval.Add(bigintAdd);
        }
        return lval;
    }

    static enum CBORDuplicatePolicy {
        Overwrite,
        Disallow;

    }
}

