/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORTag0;
import com.upokecenter.cbor.CBORTag37;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.PODOptions;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;
import com.upokecenter.util.BigInteger;
import com.upokecenter.util.ExtendedDecimal;
import com.upokecenter.util.ExtendedFloat;
import com.upokecenter.util.ExtendedRational;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class PropertyMap {
    static final boolean DateTimeCompatHack = false;
    private static Map<Class<?>, List<MethodData>> propertyLists = new HashMap();
    private static Map<Class<?>, List<MethodData>> setterPropertyList = new HashMap();
    private static Object methodSync = new Object();
    private static Method[] legacyMethods = new Method[8];
    private static boolean haveMethods = false;

    PropertyMap() {
    }

    private static List<MethodData> GetPropertyList(Class<?> t) {
        return PropertyMap.GetPropertyList(t, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MethodData> GetPropertyList(Class<?> t, boolean setters) {
        Map<Class<?>, List<MethodData>> map = setters ? setterPropertyList : propertyLists;
        synchronized (map) {
            List<MethodData> ret = (setters ? setterPropertyList : propertyLists).get(t);
            if (ret != null) {
                return ret;
            }
            ret = new ArrayList<MethodData>();
            for (Method pi : t.getMethods()) {
                if (pi.getParameterTypes().length != (setters ? 1 : 0)) continue;
                String methodName = pi.getName();
                boolean includeMethod = false;
                if (setters) {
                    includeMethod = MethodData.IsSetMethod(methodName);
                } else {
                    boolean bl = includeMethod = MethodData.IsGetMethod(methodName) || MethodData.IsIsMethod(methodName);
                }
                if (!includeMethod) continue;
                MethodData md = new MethodData();
                md.name = methodName;
                md.method = pi;
                ret.add(md);
            }
            (setters ? setterPropertyList : propertyLists).put(t, ret);
            return ret;
        }
    }

    public static CBORObject FromArray(Object arr, PODOptions options) {
        int length = Array.getLength(arr);
        CBORObject obj = CBORObject.NewArray();
        for (int i = 0; i < length; ++i) {
            obj.Add(CBORObject.FromObject(Array.get(arr, i), options));
        }
        return obj;
    }

    public static Object EnumToObject(Enum<?> value) {
        return value.name();
    }

    public static Iterable<Map.Entry<String, Object>> GetProperties(Object o) {
        return PropertyMap.GetProperties(o, true, true);
    }

    public static Object ObjectWithProperties(Class<?> t, Iterable<Map.Entry<String, CBORObject>> keysValues, boolean removeIsPrefix, boolean useCamelCase) {
        try {
            String name;
            Object o = null;
            Constructor<?>[] constructorArray = t.getConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            if (n2 < n) {
                Constructor<?> ci = constructorArray[n2];
                int nump = ci.getParameterCount();
                o = ci.newInstance(new Object[nump]);
            }
            if (o == null) {
                return t.newInstance();
            }
            HashMap<String, CBORObject> dict = new HashMap<String, CBORObject>();
            for (Map.Entry<String, CBORObject> kv : keysValues) {
                name = kv.getKey();
                dict.put(name, kv.getValue());
            }
            for (MethodData key : PropertyMap.GetPropertyList(o.getClass(), true)) {
                name = key.GetAdjustedName(removeIsPrefix, useCamelCase);
                if (!dict.containsKey(name)) continue;
                CBORObject dget = (CBORObject)dict.get(name);
                Object dobj = dget.ToObject(key.method.getGenericParameterTypes()[0]);
                key.method.invoke(o, dobj);
            }
            return o;
        }
        catch (InvocationTargetException ex) {
            throw (RuntimeException)new RuntimeException("").initCause(ex);
        }
        catch (InstantiationException ex) {
            throw (RuntimeException)new RuntimeException("").initCause(ex);
        }
        catch (IllegalAccessException ex) {
            throw (RuntimeException)new RuntimeException("").initCause(ex);
        }
    }

    public static Iterable<Map.Entry<String, Object>> GetProperties(Object o, boolean removeIsPrefix, boolean useCamelCase) {
        ArrayList<Map.Entry<String, Object>> ret = new ArrayList<Map.Entry<String, Object>>();
        try {
            for (MethodData key : PropertyMap.GetPropertyList(o.getClass())) {
                ret.add(new AbstractMap.SimpleEntry<String, Object>(key.GetAdjustedName(removeIsPrefix, useCamelCase), key.method.invoke(o, new Object[0])));
            }
            return ret;
        }
        catch (InvocationTargetException ex) {
            throw (RuntimeException)new RuntimeException("").initCause(ex);
        }
        catch (IllegalAccessException ex) {
            throw (RuntimeException)new RuntimeException("").initCause(ex);
        }
    }

    public static Object FindOneArgumentMethod(Object obj, String name, Type argtype) {
        if (!(argtype instanceof Class)) {
            return null;
        }
        try {
            return obj.getClass().getMethod(name, (Class)argtype);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method getLegacyMethod(int method) {
        Object object = methodSync;
        synchronized (object) {
            if (!haveMethods) {
                try {
                    PropertyMap.legacyMethods[0] = BigInteger.class.getDeclaredMethod("ToLegacy", EInteger.class);
                    PropertyMap.legacyMethods[1] = BigInteger.class.getDeclaredMethod("FromLegacy", BigInteger.class);
                    PropertyMap.legacyMethods[2] = ExtendedDecimal.class.getDeclaredMethod("ToLegacy", EDecimal.class);
                    PropertyMap.legacyMethods[3] = ExtendedDecimal.class.getDeclaredMethod("FromLegacy", ExtendedDecimal.class);
                    PropertyMap.legacyMethods[4] = ExtendedFloat.class.getDeclaredMethod("ToLegacy", EFloat.class);
                    PropertyMap.legacyMethods[5] = ExtendedFloat.class.getDeclaredMethod("FromLegacy", ExtendedFloat.class);
                    PropertyMap.legacyMethods[6] = ExtendedRational.class.getDeclaredMethod("ToLegacy", ERational.class);
                    PropertyMap.legacyMethods[7] = ExtendedRational.class.getDeclaredMethod("FromLegacy", ExtendedRational.class);
                    for (int i = 0; i < legacyMethods.length; ++i) {
                        legacyMethods[i].setAccessible(true);
                    }
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                haveMethods = true;
            }
            return legacyMethods[method];
        }
    }

    public static boolean ExceedsKnownLength(InputStream inStream, long size) {
        return false;
    }

    public static void SkipStreamToEnd(InputStream inStream) {
    }

    public static BigInteger ToLegacy(EInteger ei) {
        return (BigInteger)PropertyMap.InvokeOneArgumentMethod(PropertyMap.getLegacyMethod(0), null, ei);
    }

    public static ExtendedDecimal ToLegacy(EDecimal ed) {
        return (ExtendedDecimal)PropertyMap.InvokeOneArgumentMethod(PropertyMap.getLegacyMethod(2), null, ed);
    }

    public static ExtendedFloat ToLegacy(EFloat ef) {
        return (ExtendedFloat)PropertyMap.InvokeOneArgumentMethod(PropertyMap.getLegacyMethod(4), null, ef);
    }

    public static ExtendedRational ToLegacy(ERational er) {
        return (ExtendedRational)PropertyMap.InvokeOneArgumentMethod(PropertyMap.getLegacyMethod(6), null, er);
    }

    public static EInteger FromLegacy(BigInteger ei) {
        return (EInteger)PropertyMap.InvokeOneArgumentMethod(PropertyMap.getLegacyMethod(1), null, ei);
    }

    public static EDecimal FromLegacy(ExtendedDecimal ed) {
        return (EDecimal)PropertyMap.InvokeOneArgumentMethod(PropertyMap.getLegacyMethod(3), null, ed);
    }

    public static EFloat FromLegacy(ExtendedFloat ef) {
        return (EFloat)PropertyMap.InvokeOneArgumentMethod(PropertyMap.getLegacyMethod(5), null, ef);
    }

    public static ERational FromLegacy(ExtendedRational er) {
        return (ERational)PropertyMap.InvokeOneArgumentMethod(PropertyMap.getLegacyMethod(7), null, er);
    }

    public static Object InvokeOneArgumentMethod(Object method, Object obj, Object argument) {
        if (method == null) {
            throw new NullPointerException("method");
        }
        Method m = (Method)method;
        try {
            return m.invoke(obj, argument);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] UUIDToBytes(UUID obj) {
        byte[] bytes2 = new byte[16];
        long lsb = obj.getLeastSignificantBits();
        long msb = obj.getMostSignificantBits();
        bytes2[0] = (byte)(msb >> 56 & 0xFFL);
        bytes2[1] = (byte)(msb >> 48 & 0xFFL);
        bytes2[2] = (byte)(msb >> 40 & 0xFFL);
        bytes2[3] = (byte)(msb >> 32 & 0xFFL);
        bytes2[4] = (byte)(msb >> 24 & 0xFFL);
        bytes2[5] = (byte)(msb >> 16 & 0xFFL);
        bytes2[6] = (byte)(msb >> 8 & 0xFFL);
        bytes2[7] = (byte)(msb & 0xFFL);
        bytes2[8] = (byte)(lsb >> 56 & 0xFFL);
        bytes2[9] = (byte)(lsb >> 48 & 0xFFL);
        bytes2[10] = (byte)(lsb >> 40 & 0xFFL);
        bytes2[11] = (byte)(lsb >> 32 & 0xFFL);
        bytes2[12] = (byte)(lsb >> 24 & 0xFFL);
        bytes2[13] = (byte)(lsb >> 16 & 0xFFL);
        bytes2[14] = (byte)(lsb >> 8 & 0xFFL);
        bytes2[15] = (byte)(lsb & 0xFFL);
        return bytes2;
    }

    public static Object TypeToObject(CBORObject objThis, Type t) {
        Type[] typeArguments;
        if (t.equals(Date.class)) {
            return new CBORTag0().FromCBORObject(objThis);
        }
        if (t.equals(UUID.class)) {
            return new CBORTag37().FromCBORObject(objThis);
        }
        if (t.equals(Integer.class) || t.equals(Integer.TYPE)) {
            return objThis.AsInt32();
        }
        if (t.equals(Long.class) || t.equals(Long.TYPE)) {
            return objThis.AsInt64();
        }
        if (t.equals(Double.class) || t.equals(Double.TYPE)) {
            return objThis.AsDouble();
        }
        if (t.equals(Boolean.class) || t.equals(Boolean.TYPE)) {
            return objThis.isTrue();
        }
        if (objThis.getType() == CBORType.ByteString && t.equals(byte[].class)) {
            byte[] bytes = objThis.GetByteString();
            byte[] byteret = new byte[bytes.length];
            System.arraycopy(bytes, 0, byteret, 0, byteret.length);
            return byteret;
        }
        ParameterizedType pt = t instanceof ParameterizedType ? (ParameterizedType)t : null;
        Type rawType = pt == null ? t : pt.getRawType();
        Type[] typeArray = typeArguments = pt == null ? null : pt.getActualTypeArguments();
        if (objThis.getType() == CBORType.Array && (rawType != null && rawType.equals(List.class) || rawType.equals(Iterable.class) || rawType.equals(Collection.class) || rawType.equals(ArrayList.class))) {
            if (typeArguments == null || typeArguments.length == 0) {
                ArrayList alist = new ArrayList();
                for (CBORObject cbor : objThis.getValues()) {
                    alist.add(cbor.ToObject((Type)((Object)Object.class)));
                }
                return alist;
            }
            ArrayList alist = new ArrayList();
            for (CBORObject cbor : objThis.getValues()) {
                alist.add(cbor.ToObject(typeArguments[0]));
            }
            return alist;
        }
        if (objThis.getType() == CBORType.Map) {
            if (rawType != null && rawType.equals(HashMap.class) || rawType.equals(Map.class)) {
                if (typeArguments == null || typeArguments.length < 2) {
                    HashMap alist = new HashMap();
                    for (CBORObject cbor : objThis.getKeys()) {
                        CBORObject cborValue = objThis.get(cbor);
                        alist.put(cbor.ToObject((Type)((Object)Object.class)), cborValue.ToObject((Type)((Object)Object.class)));
                    }
                    return alist;
                }
                HashMap alist = new HashMap();
                for (CBORObject cbor : objThis.getKeys()) {
                    CBORObject cborValue = objThis.get(cbor);
                    alist.put(cbor.ToObject(typeArguments[0]), cborValue.ToObject(typeArguments[1]));
                }
                return alist;
            }
            if (rawType == null || !(rawType instanceof Class)) {
                throw new UnsupportedOperationException();
            }
            ArrayList<Map.Entry<String, CBORObject>> values = new ArrayList<Map.Entry<String, CBORObject>>();
            for (MethodData method : PropertyMap.GetPropertyList((Class)rawType, true)) {
                String key = method.GetAdjustedName(true, true);
                if (!objThis.ContainsKey(key)) continue;
                CBORObject cborValue = objThis.get(key);
                AbstractMap.SimpleEntry<String, CBORObject> dict = new AbstractMap.SimpleEntry<String, CBORObject>(key, cborValue);
                values.add(dict);
            }
            return PropertyMap.ObjectWithProperties((Class)rawType, values, true, true);
        }
        throw new UnsupportedOperationException();
    }

    public static void BreakDownDateTime(Date bi, EInteger[] year, int[] lf) {
        long time = bi.getTime();
        EDecimal edec = EDecimal.FromInt64((long)time).Divide(EDecimal.FromInt32((int)1000));
        CBORUtilities.BreakDownSecondsSinceEpoch(edec, year, lf);
    }

    public static Date BuildUpDateTime(EInteger year, int[] dt) {
        EInteger dateMS = CBORUtilities.GetNumberOfDaysProlepticGregorian(year, dt[0], dt[1]);
        dateMS = dateMS.Multiply(EInteger.FromInt32((int)86400000));
        dateMS = dateMS.Add(EInteger.FromInt32((int)(dt[2] * 3600000 + dt[3] * 60000 + dt[4])));
        dateMS = dateMS.Add(EInteger.FromInt32((int)(dt[5] / 1000000)));
        dateMS = dateMS.Add(EInteger.FromInt32((int)(dt[6] * 60000)));
        return new Date(dateMS.ToInt64Checked());
    }

    private static class MethodData {
        public String name;
        public Method method;

        private MethodData() {
        }

        public static boolean IsGetMethod(String methodName) {
            return methodName.startsWith("get") && methodName.length() > 3 && methodName.charAt(3) >= 'A' && methodName.charAt(3) <= 'Z' && !methodName.equals("getClass");
        }

        public static boolean IsSetMethod(String methodName) {
            return methodName.startsWith("set") && methodName.length() > 3 && methodName.charAt(3) >= 'A' && methodName.charAt(3) <= 'Z';
        }

        public static boolean IsIsMethod(String methodName) {
            return methodName.startsWith("is") && methodName.length() > 2 && methodName.charAt(2) >= 'A' && methodName.charAt(2) <= 'Z';
        }

        public String GetAdjustedName(boolean removeIsPrefix, boolean useCamelCase) {
            String methodName = this.name;
            if (MethodData.IsGetMethod(methodName) || MethodData.IsSetMethod(methodName)) {
                methodName = methodName.substring(3);
            } else if (removeIsPrefix && MethodData.IsIsMethod(methodName)) {
                methodName = methodName.substring(2);
            }
            if (useCamelCase && methodName.charAt(0) >= 'A' && methodName.charAt(0) <= 'Z') {
                StringBuilder sb = new StringBuilder();
                sb.append((char)(methodName.charAt(0) + 32));
                sb.append(methodName.substring(1));
                methodName = sb.toString();
            }
            return methodName;
        }
    }
}

