/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.CBORTypeFilter;
import com.upokecenter.cbor.ICBORConverter;
import com.upokecenter.cbor.ICBORTag;
import com.upokecenter.cbor.URIUtility;
import java.net.URI;

class CBORTag32
implements ICBORTag,
ICBORConverter<URI> {
    CBORTag32() {
    }

    @Override
    public CBORTypeFilter GetTypeFilter() {
        return CBORTypeFilter.TextString;
    }

    @Override
    public CBORObject ValidateObject(CBORObject obj) {
        if (obj.getType() != CBORType.TextString) {
            throw new CBORException("URI must be a text String");
        }
        if (!URIUtility.isValidIRI(obj.AsString())) {
            throw new CBORException("String is not a valid URI/IRI");
        }
        return obj;
    }

    static void AddConverter() {
        CBORObject.AddConverter(URI.class, new CBORTag32());
    }

    @Override
    public CBORObject ToCBORObject(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        String uriString = uri.toString();
        return CBORObject.FromObjectAndTag((Object)uriString, 32);
    }
}

