/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBOREncodeOptions;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

final class CBORCanonical {
    private CBORCanonical() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] CtapCanonicalEncode(CBORObject a) {
        CBORType valueAType;
        CBORObject cbor;
        block24: {
            cbor = a.Untag();
            valueAType = cbor.getType();
            try {
                if (valueAType == CBORType.Array) {
                    ByteArrayOutputStream ms = null;
                    try {
                        ms = new ByteArrayOutputStream();
                        CBORObject.WriteValue((OutputStream)ms, 4, cbor.size());
                        for (int i = 0; i < cbor.size(); ++i) {
                            byte[] bytes = CBORCanonical.CtapCanonicalEncode(cbor.get(i));
                            ms.write(bytes, 0, bytes.length);
                        }
                        byte[] i = ms.toByteArray();
                        return i;
                    }
                    finally {
                        try {
                            if (ms != null) {
                                ms.close();
                            }
                        }
                        catch (IOException bytes) {}
                    }
                }
                if (valueAType != CBORType.Map) break block24;
                ArrayList<CBORObject> sortedKeys = new ArrayList<CBORObject>();
                for (CBORObject key : cbor.getKeys()) {
                    sortedKeys.add(key);
                }
                Collections.sort(sortedKeys, new CtapComparer());
                ByteArrayOutputStream ms = null;
                try {
                    ms = new ByteArrayOutputStream();
                    CBORObject.WriteValue((OutputStream)ms, 5, cbor.size());
                    for (CBORObject key : sortedKeys) {
                        byte[] bytes = CBORCanonical.CtapCanonicalEncode(key);
                        ms.write(bytes, 0, bytes.length);
                        bytes = CBORCanonical.CtapCanonicalEncode(cbor.get(key));
                        ms.write(bytes, 0, bytes.length);
                    }
                    Object object = ms.toByteArray();
                    return object;
                }
                finally {
                    try {
                        if (ms != null) {
                            ms.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex.toString(), ex);
            }
        }
        if (valueAType == CBORType.SimpleValue) return cbor.EncodeToBytes(CBOREncodeOptions.Default);
        if (valueAType == CBORType.Boolean) return cbor.EncodeToBytes(CBOREncodeOptions.Default);
        if (valueAType == CBORType.ByteString) return cbor.EncodeToBytes(CBOREncodeOptions.Default);
        if (valueAType == CBORType.TextString) {
            return cbor.EncodeToBytes(CBOREncodeOptions.Default);
        }
        if (valueAType != CBORType.Number) throw new IllegalArgumentException("Invalid CBOR type.");
        if (cbor.CanFitInInt64()) {
            return cbor.EncodeToBytes(CBOREncodeOptions.Default);
        }
        cbor = CBORObject.FromObject(cbor.AsDouble());
        return cbor.EncodeToBytes(CBOREncodeOptions.Default);
    }

    private static final class CtapComparer
    implements Comparator<CBORObject> {
        private CtapComparer() {
        }

        @Override
        public int compare(CBORObject a, CBORObject b) {
            byte[] bbs;
            byte[] abs;
            boolean bothBytes = false;
            if (a.getType() == CBORType.ByteString && b.getType() == CBORType.ByteString) {
                abs = a.GetByteString();
                bbs = b.GetByteString();
                bothBytes = true;
            } else {
                abs = CBORCanonical.CtapCanonicalEncode(a);
                bbs = CBORCanonical.CtapCanonicalEncode(b);
            }
            if (!bothBytes && (abs[0] & 0xE0) != (bbs[0] & 0xE0)) {
                return (abs[0] & 0xE0) < (bbs[0] & 0xE0) ? -1 : 1;
            }
            if (abs.length != bbs.length) {
                return abs.length < bbs.length ? -1 : 1;
            }
            for (int i = 0; i < abs.length; ++i) {
                if (abs[i] == bbs[i]) continue;
                int ai = abs[i] & 0xFF;
                int bi = bbs[i] & 0xFF;
                return ai < bi ? -1 : 1;
            }
            return 0;
        }
    }
}

