/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.ICBORConverter;
import com.upokecenter.cbor.PropertyMap;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CBORTypeMapper {
    private final List<String> typePrefixes = new ArrayList<String>();
    private final List<String> typeNames = new ArrayList<String>();
    private final Map<Object, ConverterInfo> converters = new HashMap<Object, ConverterInfo>();

    public <T> CBORTypeMapper AddConverter(Type type, ICBORConverter<T> converter) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (converter == null) {
            throw new NullPointerException("converter");
        }
        ConverterInfo ci = new ConverterInfo();
        ci.setConverter(converter);
        ci.setToObject(PropertyMap.FindOneArgumentMethod(converter, "ToCBORObject", type));
        if (ci.getToObject() == null) {
            throw new IllegalArgumentException("Converter doesn't contain a proper ToCBORObject method");
        }
        ci.setFromObject(PropertyMap.FindOneArgumentMethod(converter, "FromCBORObject", CBORObject.class));
        this.converters.put(type, ci);
        return this;
    }

    Object ConvertBackWithConverter(CBORObject cbor, Type type) {
        ConverterInfo convinfo = null;
        if (!this.converters.containsKey(type)) {
            return null;
        }
        convinfo = this.converters.get(type);
        if (convinfo == null) {
            return null;
        }
        if (convinfo.getFromObject() == null) {
            return null;
        }
        return PropertyMap.InvokeOneArgumentMethod(convinfo.getFromObject(), convinfo.getConverter(), cbor);
    }

    CBORObject ConvertWithConverter(Object obj) {
        Class<?> type = obj.getClass();
        ConverterInfo convinfo = null;
        if (!this.converters.containsKey(type)) {
            return null;
        }
        convinfo = this.converters.get(type);
        if (convinfo == null) {
            return null;
        }
        return (CBORObject)PropertyMap.InvokeOneArgumentMethod(convinfo.getToObject(), convinfo.getConverter(), obj);
    }

    public boolean FilterTypeName(String typeName) {
        if (typeName == null || typeName.length() == 0) {
            return false;
        }
        for (String prefix : this.typePrefixes) {
            if (typeName.length() < prefix.length() || !typeName.substring(0, prefix.length()).equals(prefix)) continue;
            return true;
        }
        for (String name : this.typeNames) {
            if (!typeName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public CBORTypeMapper AddTypePrefix(String prefix) {
        if (prefix == null) {
            throw new NullPointerException("prefix");
        }
        if (prefix.length() == 0) {
            throw new IllegalArgumentException("prefix is empty.");
        }
        this.typePrefixes.add(prefix);
        return this;
    }

    public CBORTypeMapper AddTypeName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name is empty.");
        }
        this.typeNames.add(name);
        return this;
    }

    static final class ConverterInfo {
        private Object propVartoobject;
        private Object propVarfromobject;
        private Object propVarconverter;

        ConverterInfo() {
        }

        public final Object getToObject() {
            return this.propVartoobject;
        }

        public final void setToObject(Object value) {
            this.propVartoobject = value;
        }

        public final Object getFromObject() {
            return this.propVarfromobject;
        }

        public final void setFromObject(Object value) {
            this.propVarfromobject = value;
        }

        public final Object getConverter() {
            return this.propVarconverter;
        }

        public final void setConverter(Object value) {
            this.propVarconverter = value;
        }
    }
}

