/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.util;

import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERounding;
import com.upokecenter.numbers.ETrapException;
import com.upokecenter.util.BigInteger;
import com.upokecenter.util.ExtendedFloat;
import com.upokecenter.util.PrecisionContext;
import com.upokecenter.util.Rounding;
import com.upokecenter.util.TrapException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtendedDecimal
implements Comparable<ExtendedDecimal> {
    private final EDecimal ed;
    @Deprecated
    public static final ExtendedDecimal One = ExtendedDecimal.Create(BigInteger.valueOf(1L), BigInteger.valueOf(0L));
    @Deprecated
    public static final ExtendedDecimal Zero = ExtendedDecimal.Create(BigInteger.valueOf(0L), BigInteger.valueOf(0L));
    public static final ExtendedDecimal NegativeZero = new ExtendedDecimal(EDecimal.NegativeZero);
    public static final ExtendedDecimal Ten = new ExtendedDecimal(EDecimal.Ten);
    public static final ExtendedDecimal NaN = new ExtendedDecimal(EDecimal.NaN);
    public static final ExtendedDecimal SignalingNaN = new ExtendedDecimal(EDecimal.SignalingNaN);
    public static final ExtendedDecimal PositiveInfinity = new ExtendedDecimal(EDecimal.PositiveInfinity);
    public static final ExtendedDecimal NegativeInfinity = new ExtendedDecimal(EDecimal.NegativeInfinity);

    public final BigInteger getExponent() {
        return new BigInteger(this.getEd().getExponent());
    }

    public final BigInteger getUnsignedMantissa() {
        return new BigInteger(this.getEd().getUnsignedMantissa());
    }

    public final BigInteger getMantissa() {
        return new BigInteger(this.getEd().getMantissa());
    }

    static ExtendedDecimal ToLegacy(EDecimal ei) {
        return new ExtendedDecimal(ei);
    }

    static EDecimal FromLegacy(ExtendedDecimal bei) {
        return bei.getEd();
    }

    @Deprecated
    public boolean equals(ExtendedDecimal other) {
        return other == null ? false : this.getEd().equals(other.getEd());
    }

    public boolean equals(Object obj) {
        ExtendedDecimal bi = obj instanceof ExtendedDecimal ? (ExtendedDecimal)obj : null;
        return bi == null ? false : this.getEd().equals(bi.getEd());
    }

    public int hashCode() {
        return this.getEd().hashCode();
    }

    @Deprecated
    public static ExtendedDecimal Create(int mantissaSmall, int exponentSmall) {
        return new ExtendedDecimal(EDecimal.Create((int)mantissaSmall, (int)exponentSmall));
    }

    ExtendedDecimal(EDecimal ed) {
        if (ed == null) {
            throw new NullPointerException("ed");
        }
        this.ed = ed;
    }

    public static ExtendedDecimal Create(BigInteger mantissa, BigInteger exponent) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        return new ExtendedDecimal(EDecimal.Create((EInteger)mantissa.getEi(), (EInteger)exponent.getEi()));
    }

    @Deprecated
    public static ExtendedDecimal CreateNaN(BigInteger diag) {
        if (diag == null) {
            throw new NullPointerException("diag");
        }
        return new ExtendedDecimal(EDecimal.CreateNaN((EInteger)diag.getEi()));
    }

    @Deprecated
    public static ExtendedDecimal CreateNaN(BigInteger diag, boolean signaling, boolean negative, PrecisionContext ctx) {
        if (diag == null) {
            throw new NullPointerException("diag");
        }
        return new ExtendedDecimal(EDecimal.CreateNaN((EInteger)diag.getEi(), (boolean)signaling, (boolean)negative, (EContext)(ctx == null ? null : ctx.getEc())));
    }

    public static ExtendedDecimal FromString(String str) {
        return new ExtendedDecimal(EDecimal.FromString((String)str));
    }

    @Deprecated
    public static ExtendedDecimal FromString(String str, PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(EDecimal.FromString((String)str, (EContext)(ctx == null ? null : ctx.getEc())));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public static ExtendedDecimal FromString(String str, int offset, int length) {
        return new ExtendedDecimal(EDecimal.FromString((String)str, (int)offset, (int)length));
    }

    @Deprecated
    public static ExtendedDecimal FromString(String str, int offset, int length, PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(EDecimal.FromString((String)str, (int)offset, (int)length, (EContext)(ctx == null ? null : ctx.getEc())));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public int CompareToBinary(ExtendedFloat other) {
        return other == null ? 1 : this.getEd().CompareToBinary(other.getEf());
    }

    @Deprecated
    public BigInteger ToBigInteger() {
        return new BigInteger(this.getEd().ToEInteger());
    }

    @Deprecated
    static ERounding ToERounding(Rounding r) {
        if (r == Rounding.Ceiling) {
            return ERounding.Ceiling;
        }
        if (r == Rounding.Floor) {
            return ERounding.Floor;
        }
        if (r == Rounding.HalfDown) {
            return ERounding.HalfDown;
        }
        if (r == Rounding.HalfEven) {
            return ERounding.HalfEven;
        }
        if (r == Rounding.HalfUp) {
            return ERounding.HalfUp;
        }
        if (r == Rounding.Up) {
            return ERounding.Up;
        }
        if (r == Rounding.ZeroFiveUp) {
            return ERounding.ZeroFiveUp;
        }
        if (r == Rounding.OddOrZeroFiveUp) {
            return ERounding.OddOrZeroFiveUp;
        }
        return r == Rounding.Unnecessary ? ERounding.None : (r == Rounding.Odd ? ERounding.Odd : ERounding.Down);
    }

    static Rounding ToRounding(ERounding r) {
        if (r == ERounding.Ceiling) {
            return Rounding.Ceiling;
        }
        if (r == ERounding.Floor) {
            return Rounding.Floor;
        }
        if (r == ERounding.HalfDown) {
            return Rounding.HalfDown;
        }
        if (r == ERounding.HalfEven) {
            return Rounding.HalfEven;
        }
        if (r == ERounding.HalfUp) {
            return Rounding.HalfUp;
        }
        if (r == ERounding.Up) {
            return Rounding.Up;
        }
        if (r == ERounding.ZeroFiveUp) {
            return Rounding.ZeroFiveUp;
        }
        if (r == ERounding.OddOrZeroFiveUp) {
            return Rounding.OddOrZeroFiveUp;
        }
        return r == ERounding.None ? Rounding.Unnecessary : (r == ERounding.Odd ? Rounding.Odd : Rounding.Down);
    }

    @Deprecated
    public BigInteger ToBigIntegerExact() {
        return new BigInteger(this.getEd().ToEIntegerExact());
    }

    @Deprecated
    public ExtendedFloat ToExtendedFloat() {
        return new ExtendedFloat(this.getEd().ToExtendedFloat());
    }

    public float ToSingle() {
        return this.getEd().ToSingle();
    }

    public double ToDouble() {
        return this.getEd().ToDouble();
    }

    @Deprecated
    public static ExtendedDecimal FromSingle(float flt) {
        return new ExtendedDecimal(EDecimal.FromSingle((float)flt));
    }

    @Deprecated
    public static ExtendedDecimal FromBigInteger(BigInteger bigint) {
        if (bigint == null) {
            throw new NullPointerException("bigint");
        }
        return new ExtendedDecimal(EDecimal.FromEInteger((EInteger)bigint.getEi()));
    }

    @Deprecated
    public static ExtendedDecimal FromInt64(long valueSmall) {
        return new ExtendedDecimal(EDecimal.FromInt64((long)valueSmall));
    }

    @Deprecated
    public static ExtendedDecimal FromInt32(int valueSmaller) {
        return new ExtendedDecimal(EDecimal.FromInt32((int)valueSmaller));
    }

    @Deprecated
    public static ExtendedDecimal FromDouble(double dbl) {
        return new ExtendedDecimal(EDecimal.FromDouble((double)dbl));
    }

    @Deprecated
    public static ExtendedDecimal FromExtendedFloat(ExtendedFloat bigfloat) {
        if (bigfloat == null) {
            throw new NullPointerException("bigfloat");
        }
        return new ExtendedDecimal(EDecimal.FromExtendedFloat((EFloat)bigfloat.getEf()));
    }

    public String toString() {
        return this.getEd().toString();
    }

    @Deprecated
    public String ToEngineeringString() {
        return this.getEd().ToEngineeringString();
    }

    @Deprecated
    public String ToPlainString() {
        return this.getEd().ToPlainString();
    }

    @Deprecated
    public boolean IsNegativeInfinity() {
        return this.getEd().IsNegativeInfinity();
    }

    @Deprecated
    public boolean IsPositiveInfinity() {
        return this.getEd().IsPositiveInfinity();
    }

    public boolean IsNaN() {
        return this.getEd().IsNaN();
    }

    public boolean IsInfinity() {
        return this.getEd().IsInfinity();
    }

    @Deprecated
    public final boolean isFinite() {
        return this.getEd().isFinite();
    }

    @Deprecated
    public final boolean isNegative() {
        return this.getEd().isNegative();
    }

    @Deprecated
    public boolean IsQuietNaN() {
        return this.getEd().IsQuietNaN();
    }

    @Deprecated
    public boolean IsSignalingNaN() {
        return this.getEd().IsSignalingNaN();
    }

    @Deprecated
    public final int signum() {
        return this.getEd().signum();
    }

    @Deprecated
    public final boolean isZero() {
        return this.getEd().isZero();
    }

    final EDecimal getEd() {
        return this.ed;
    }

    @Deprecated
    public ExtendedDecimal Abs() {
        return new ExtendedDecimal(this.getEd().Abs(null));
    }

    @Deprecated
    public ExtendedDecimal Negate() {
        return new ExtendedDecimal(this.getEd().Negate(null));
    }

    @Deprecated
    public ExtendedDecimal Divide(ExtendedDecimal divisor) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        return new ExtendedDecimal(this.getEd().Divide(divisor.getEd()));
    }

    @Deprecated
    public ExtendedDecimal DivideToSameExponent(ExtendedDecimal divisor, Rounding rounding) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        return new ExtendedDecimal(this.getEd().DivideToSameExponent(divisor.getEd(), ExtendedDecimal.ToERounding(rounding)));
    }

    @Deprecated
    public ExtendedDecimal DivideToIntegerNaturalScale(ExtendedDecimal divisor) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        return new ExtendedDecimal(this.getEd().DivideToIntegerNaturalScale(divisor.getEd()));
    }

    @Deprecated
    public ExtendedDecimal Reduce(PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().Reduce(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal RemainderNaturalScale(ExtendedDecimal divisor) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        return new ExtendedDecimal(this.getEd().RemainderNaturalScale(divisor.getEd()));
    }

    @Deprecated
    public ExtendedDecimal RemainderNaturalScale(ExtendedDecimal divisor, PrecisionContext ctx) {
        try {
            if (divisor == null) {
                throw new NullPointerException("divisor");
            }
            return new ExtendedDecimal(this.getEd().RemainderNaturalScale(divisor.getEd(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal DivideToExponent(ExtendedDecimal divisor, long desiredExponentSmall, PrecisionContext ctx) {
        try {
            if (divisor == null) {
                throw new NullPointerException("divisor");
            }
            return new ExtendedDecimal(this.getEd().DivideToExponent(divisor.getEd(), desiredExponentSmall, ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal Divide(ExtendedDecimal divisor, PrecisionContext ctx) {
        try {
            if (divisor == null) {
                throw new NullPointerException("divisor");
            }
            return new ExtendedDecimal(this.getEd().Divide(divisor.getEd(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal DivideToExponent(ExtendedDecimal divisor, long desiredExponentSmall, Rounding rounding) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        return new ExtendedDecimal(this.getEd().DivideToExponent(divisor.getEd(), desiredExponentSmall, ExtendedDecimal.ToERounding(rounding)));
    }

    @Deprecated
    public ExtendedDecimal DivideToExponent(ExtendedDecimal divisor, BigInteger exponent, PrecisionContext ctx) {
        try {
            if (divisor == null) {
                throw new NullPointerException("divisor");
            }
            if (exponent == null) {
                throw new NullPointerException("exponent");
            }
            return new ExtendedDecimal(this.getEd().DivideToExponent(divisor.getEd(), exponent.getEi(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal DivideToExponent(ExtendedDecimal divisor, BigInteger desiredExponent, Rounding rounding) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        if (desiredExponent == null) {
            throw new NullPointerException("desiredExponent");
        }
        return new ExtendedDecimal(this.getEd().DivideToExponent(divisor.getEd(), desiredExponent.getEi(), ExtendedDecimal.ToERounding(rounding)));
    }

    @Deprecated
    public ExtendedDecimal Abs(PrecisionContext context) {
        try {
            return new ExtendedDecimal(this.getEd().Abs(context == null ? null : context.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal Negate(PrecisionContext context) {
        try {
            if (context == null) {
                throw new NullPointerException("context");
            }
            return new ExtendedDecimal(this.getEd().Negate(context == null ? null : context.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal Add(ExtendedDecimal otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        return new ExtendedDecimal(this.getEd().Add(otherValue.getEd()));
    }

    @Deprecated
    public ExtendedDecimal Subtract(ExtendedDecimal otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        return new ExtendedDecimal(this.getEd().Subtract(otherValue.getEd()));
    }

    @Deprecated
    public ExtendedDecimal Subtract(ExtendedDecimal otherValue, PrecisionContext ctx) {
        try {
            if (otherValue == null) {
                throw new NullPointerException("otherValue");
            }
            return new ExtendedDecimal(this.getEd().Subtract(otherValue.getEd(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal Multiply(ExtendedDecimal otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        return new ExtendedDecimal(this.getEd().Multiply(otherValue.getEd()));
    }

    @Deprecated
    public ExtendedDecimal MultiplyAndAdd(ExtendedDecimal multiplicand, ExtendedDecimal augend) {
        if (multiplicand == null) {
            throw new NullPointerException("multiplicand");
        }
        if (augend == null) {
            throw new NullPointerException("augend");
        }
        return new ExtendedDecimal(this.getEd().MultiplyAndAdd(multiplicand.getEd(), augend.getEd()));
    }

    @Deprecated
    public ExtendedDecimal DivideToIntegerNaturalScale(ExtendedDecimal divisor, PrecisionContext ctx) {
        try {
            if (divisor == null) {
                throw new NullPointerException("divisor");
            }
            return new ExtendedDecimal(this.getEd().DivideToIntegerNaturalScale(divisor.getEd(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal DivideToIntegerZeroScale(ExtendedDecimal divisor, PrecisionContext ctx) {
        try {
            if (divisor == null) {
                throw new NullPointerException("divisor");
            }
            return new ExtendedDecimal(this.getEd().DivideToIntegerZeroScale(divisor.getEd(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal Remainder(ExtendedDecimal divisor, PrecisionContext ctx) {
        try {
            if (divisor == null) {
                throw new NullPointerException("divisor");
            }
            return new ExtendedDecimal(this.getEd().Remainder(divisor.getEd(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal RemainderNear(ExtendedDecimal divisor, PrecisionContext ctx) {
        try {
            if (divisor == null) {
                throw new NullPointerException("divisor");
            }
            return new ExtendedDecimal(this.getEd().RemainderNear(divisor.getEd(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal NextMinus(PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().NextMinus(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal NextPlus(PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().NextPlus(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal NextToward(ExtendedDecimal otherValue, PrecisionContext ctx) {
        try {
            if (otherValue == null) {
                throw new NullPointerException("otherValue");
            }
            return new ExtendedDecimal(this.getEd().NextToward(otherValue.getEd(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public static ExtendedDecimal Max(ExtendedDecimal first, ExtendedDecimal second, PrecisionContext ctx) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return new ExtendedDecimal(EDecimal.Max((EDecimal)first.getEd(), (EDecimal)second.getEd(), (EContext)(ctx == null ? null : ctx.getEc())));
    }

    @Deprecated
    public static ExtendedDecimal Min(ExtendedDecimal first, ExtendedDecimal second, PrecisionContext ctx) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return new ExtendedDecimal(EDecimal.Min((EDecimal)first.getEd(), (EDecimal)second.getEd(), (EContext)(ctx == null ? null : ctx.getEc())));
    }

    @Deprecated
    public static ExtendedDecimal MaxMagnitude(ExtendedDecimal first, ExtendedDecimal second, PrecisionContext ctx) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return new ExtendedDecimal(EDecimal.MaxMagnitude((EDecimal)first.getEd(), (EDecimal)second.getEd(), (EContext)(ctx == null ? null : ctx.getEc())));
    }

    @Deprecated
    public static ExtendedDecimal MinMagnitude(ExtendedDecimal first, ExtendedDecimal second, PrecisionContext ctx) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return new ExtendedDecimal(EDecimal.MinMagnitude((EDecimal)first.getEd(), (EDecimal)second.getEd(), (EContext)(ctx == null ? null : ctx.getEc())));
    }

    @Deprecated
    public static ExtendedDecimal Max(ExtendedDecimal first, ExtendedDecimal second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return new ExtendedDecimal(EDecimal.Max((EDecimal)first.getEd(), (EDecimal)second.getEd()));
    }

    @Deprecated
    public static ExtendedDecimal Min(ExtendedDecimal first, ExtendedDecimal second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return new ExtendedDecimal(EDecimal.Min((EDecimal)first.getEd(), (EDecimal)second.getEd()));
    }

    @Deprecated
    public static ExtendedDecimal MaxMagnitude(ExtendedDecimal first, ExtendedDecimal second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return new ExtendedDecimal(EDecimal.MaxMagnitude((EDecimal)first.getEd(), (EDecimal)second.getEd()));
    }

    @Deprecated
    public static ExtendedDecimal MinMagnitude(ExtendedDecimal first, ExtendedDecimal second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return new ExtendedDecimal(EDecimal.MinMagnitude((EDecimal)first.getEd(), (EDecimal)second.getEd()));
    }

    @Override
    @Deprecated
    public int compareTo(ExtendedDecimal other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.getEd().compareTo(other.getEd());
    }

    @Deprecated
    public ExtendedDecimal CompareToWithContext(ExtendedDecimal other, PrecisionContext ctx) {
        try {
            if (other == null) {
                throw new NullPointerException("other");
            }
            return new ExtendedDecimal(this.getEd().CompareToWithContext(other.getEd(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal CompareToSignal(ExtendedDecimal other, PrecisionContext ctx) {
        try {
            if (other == null) {
                throw new NullPointerException("other");
            }
            return new ExtendedDecimal(this.getEd().CompareToSignal(other.getEd(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal Add(ExtendedDecimal otherValue, PrecisionContext ctx) {
        try {
            if (otherValue == null) {
                throw new NullPointerException("otherValue");
            }
            return new ExtendedDecimal(this.getEd().Add(otherValue.getEd(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal Quantize(BigInteger desiredExponent, PrecisionContext ctx) {
        try {
            if (desiredExponent == null) {
                throw new NullPointerException("desiredExponent");
            }
            return new ExtendedDecimal(this.getEd().Quantize(desiredExponent.getEi(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal Quantize(int desiredExponentSmall, Rounding rounding) {
        return new ExtendedDecimal(this.getEd().Quantize(desiredExponentSmall, ExtendedDecimal.ToERounding(rounding)));
    }

    @Deprecated
    public ExtendedDecimal Quantize(int desiredExponentSmall, PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().Quantize(desiredExponentSmall, ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal Quantize(ExtendedDecimal otherValue, PrecisionContext ctx) {
        try {
            if (otherValue == null) {
                throw new NullPointerException("otherValue");
            }
            return new ExtendedDecimal(this.getEd().Quantize(otherValue.getEd(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal RoundToIntegralExact(PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().RoundToIntegralExact(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal RoundToIntegralNoRoundedFlag(PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().RoundToIntegralNoRoundedFlag(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal RoundToExponentExact(BigInteger exponent, PrecisionContext ctx) {
        try {
            if (exponent == null) {
                throw new NullPointerException("exponent");
            }
            return new ExtendedDecimal(this.getEd().RoundToExponentExact(exponent.getEi(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal RoundToExponent(BigInteger exponent, PrecisionContext ctx) {
        try {
            if (exponent == null) {
                throw new NullPointerException("exponent");
            }
            return new ExtendedDecimal(this.getEd().RoundToExponent(exponent.getEi(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal RoundToExponentExact(int exponentSmall, PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().RoundToExponentExact(exponentSmall, ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal RoundToExponent(int exponentSmall, PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().RoundToExponent(exponentSmall, ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal Multiply(ExtendedDecimal op, PrecisionContext ctx) {
        try {
            if (op == null) {
                throw new NullPointerException("op");
            }
            return new ExtendedDecimal(this.getEd().Multiply(op.getEd(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal MultiplyAndAdd(ExtendedDecimal op, ExtendedDecimal augend, PrecisionContext ctx) {
        try {
            if (op == null) {
                throw new NullPointerException("op");
            }
            if (augend == null) {
                throw new NullPointerException("augend");
            }
            return new ExtendedDecimal(this.getEd().MultiplyAndAdd(op.getEd(), augend.getEd(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal MultiplyAndSubtract(ExtendedDecimal op, ExtendedDecimal subtrahend, PrecisionContext ctx) {
        try {
            if (op == null) {
                throw new NullPointerException("op");
            }
            if (subtrahend == null) {
                throw new NullPointerException("subtrahend");
            }
            return new ExtendedDecimal(this.getEd().MultiplyAndSubtract(op.getEd(), subtrahend.getEd(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal RoundToPrecision(PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().RoundToPrecision(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal Plus(PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().Plus(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal RoundToBinaryPrecision(PrecisionContext ctx) {
        if (ctx == null) {
            return this;
        }
        PrecisionContext ctx2 = ctx.Copy().WithPrecisionInBits(true);
        ExtendedDecimal ret = this.RoundToPrecision(ctx2);
        if (ctx2.getHasFlags()) {
            ctx.setFlags(ctx2.getFlags());
        }
        return ret;
    }

    @Deprecated
    public ExtendedDecimal SquareRoot(PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().SquareRoot(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal Exp(PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().Exp(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal Log(PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().Log(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal Log10(PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().Log10(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal Pow(ExtendedDecimal exponent, PrecisionContext ctx) {
        try {
            if (exponent == null) {
                throw new NullPointerException("exponent");
            }
            return new ExtendedDecimal(this.getEd().Pow(exponent.getEd(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal Pow(int exponentSmall, PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().Pow(exponentSmall, ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal Pow(int exponentSmall) {
        return new ExtendedDecimal(this.getEd().Pow(exponentSmall));
    }

    @Deprecated
    public static ExtendedDecimal PI(PrecisionContext ctx) {
        return new ExtendedDecimal(EDecimal.PI((EContext)(ctx == null ? null : ctx.getEc())));
    }

    @Deprecated
    public ExtendedDecimal MovePointLeft(int places) {
        return new ExtendedDecimal(this.getEd().MovePointLeft(places));
    }

    @Deprecated
    public ExtendedDecimal MovePointLeft(int places, PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().MovePointLeft(places, ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal MovePointLeft(BigInteger bigPlaces) {
        if (bigPlaces == null) {
            throw new NullPointerException("bigPlaces");
        }
        return new ExtendedDecimal(this.getEd().MovePointLeft(bigPlaces.getEi()));
    }

    @Deprecated
    public ExtendedDecimal MovePointLeft(BigInteger bigPlaces, PrecisionContext ctx) {
        try {
            if (bigPlaces == null) {
                throw new NullPointerException("bigPlaces");
            }
            return new ExtendedDecimal(this.getEd().MovePointLeft(bigPlaces.getEi(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal MovePointRight(int places) {
        return new ExtendedDecimal(this.getEd().MovePointRight(places));
    }

    @Deprecated
    public ExtendedDecimal MovePointRight(int places, PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().MovePointRight(places, ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal MovePointRight(BigInteger bigPlaces) {
        if (bigPlaces == null) {
            throw new NullPointerException("bigPlaces");
        }
        return new ExtendedDecimal(this.getEd().MovePointRight(bigPlaces.getEi()));
    }

    @Deprecated
    public ExtendedDecimal MovePointRight(BigInteger bigPlaces, PrecisionContext ctx) {
        try {
            if (bigPlaces == null) {
                throw new NullPointerException("bigPlaces");
            }
            return new ExtendedDecimal(this.getEd().MovePointRight(bigPlaces.getEi(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal ScaleByPowerOfTen(int places) {
        return new ExtendedDecimal(this.getEd().ScaleByPowerOfTen(places));
    }

    @Deprecated
    public ExtendedDecimal ScaleByPowerOfTen(int places, PrecisionContext ctx) {
        try {
            return new ExtendedDecimal(this.getEd().ScaleByPowerOfTen(places, ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedDecimal ScaleByPowerOfTen(BigInteger bigPlaces) {
        if (bigPlaces == null) {
            throw new NullPointerException("bigPlaces");
        }
        return new ExtendedDecimal(this.getEd().ScaleByPowerOfTen(bigPlaces.getEi()));
    }

    @Deprecated
    public ExtendedDecimal ScaleByPowerOfTen(BigInteger bigPlaces, PrecisionContext ctx) {
        try {
            if (bigPlaces == null) {
                throw new NullPointerException("bigPlaces");
            }
            return new ExtendedDecimal(this.getEd().ScaleByPowerOfTen(bigPlaces.getEi(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public BigInteger Precision() {
        return new BigInteger(this.getEd().Precision());
    }

    @Deprecated
    public ExtendedDecimal Ulp() {
        return new ExtendedDecimal(this.getEd().Ulp());
    }

    @Deprecated
    public ExtendedDecimal[] DivideAndRemainderNaturalScale(ExtendedDecimal divisor) {
        EDecimal[] edec = this.getEd().DivideAndRemainderNaturalScale(divisor == null ? null : divisor.getEd());
        return new ExtendedDecimal[]{new ExtendedDecimal(edec[0]), new ExtendedDecimal(edec[1])};
    }

    @Deprecated
    public ExtendedDecimal[] DivideAndRemainderNaturalScale(ExtendedDecimal divisor, PrecisionContext ctx) {
        try {
            EDecimal[] edec = this.getEd().DivideAndRemainderNaturalScale(divisor == null ? null : divisor.getEd(), ctx == null ? null : ctx.getEc());
            return new ExtendedDecimal[]{new ExtendedDecimal(edec[0]), new ExtendedDecimal(edec[1])};
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }
}

