/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class DataUtilities {
    private static final int StreamedStringBufferLength = 4096;

    private DataUtilities() {
    }

    public static String GetUtf8String(byte[] bytes, boolean replace) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        StringBuilder b = new StringBuilder();
        if (DataUtilities.ReadUtf8FromBytes(bytes, 0, bytes.length, b, replace) != 0) {
            throw new IllegalArgumentException("Invalid UTF-8");
        }
        return b.toString();
    }

    public static String GetUtf8String(byte[] bytes, int offset, int bytesCount, boolean replace) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset (" + offset + ") is less than " + "0");
        }
        if (offset > bytes.length) {
            throw new IllegalArgumentException("offset (" + offset + ") is more than " + bytes.length);
        }
        if (bytesCount < 0) {
            throw new IllegalArgumentException("bytesCount (" + bytesCount + ") is less than 0");
        }
        if (bytesCount > bytes.length) {
            throw new IllegalArgumentException("bytesCount (" + bytesCount + ") is more than " + bytes.length);
        }
        if (bytes.length - offset < bytesCount) {
            throw new IllegalArgumentException("bytes's length minus " + offset + " (" + (bytes.length - offset) + ") is less than " + bytesCount);
        }
        StringBuilder b = new StringBuilder();
        if (DataUtilities.ReadUtf8FromBytes(bytes, offset, bytesCount, b, replace) != 0) {
            throw new IllegalArgumentException("Invalid UTF-8");
        }
        return b.toString();
    }

    public static byte[] GetUtf8Bytes(String str, boolean replace) {
        return DataUtilities.GetUtf8Bytes(str, replace, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] GetUtf8Bytes(String str, boolean replace, boolean lenientLineBreaks) {
        byte[] byArray;
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (!lenientLineBreaks && str.length() == 1) {
            int c = str.charAt(0);
            if ((c & 0xF800) == 55296) {
                if (replace) {
                    c = 65533;
                } else {
                    throw new IllegalArgumentException("Unpaired surrogate code point");
                }
            }
            if (c <= 128) {
                return new byte[]{(byte)c};
            }
            if (c <= 2047) {
                return new byte[]{(byte)(0xC0 | c >> 6 & 0x1F), (byte)(0x80 | c & 0x3F)};
            }
            return new byte[]{(byte)(0xE0 | c >> 12 & 0xF), (byte)(0x80 | c >> 6 & 0x3F), (byte)(0x80 | c & 0x3F)};
        }
        if (str.length() == 2) {
            int c = str.charAt(0);
            char c2 = str.charAt(1);
            if ((c & 0xFC00) == 55296 && (c2 & 0xFC00) == 56320) {
                c = 65536 + (c - 55296 << 10) + (c2 - 56320);
                return new byte[]{(byte)(0xF0 | c >> 18 & 7), (byte)(0x80 | c >> 12 & 0x3F), (byte)(0x80 | c >> 6 & 0x3F), (byte)(0x80 | c & 0x3F)};
            }
            if (!lenientLineBreaks && c <= 128 && c2 <= '\u0080') {
                return new byte[]{(byte)c, (byte)c2};
            }
        }
        ByteArrayOutputStream ms = null;
        try {
            ms = new ByteArrayOutputStream();
            if (DataUtilities.WriteUtf8(str, 0, str.length(), ms, replace, lenientLineBreaks) != 0) {
                throw new IllegalArgumentException("Unpaired surrogate code point");
            }
            byArray = ms.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (ms != null) {
                        ms.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("I/O error occurred", ex);
            }
        }
        try {
            if (ms != null) {
                ms.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return byArray;
    }

    public static long GetUtf8Length(String str, boolean replace) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        long size = 0L;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f') {
                ++size;
                continue;
            }
            if (c <= '\u07ff') {
                size += 2L;
                continue;
            }
            if (c <= '\ud7ff' || c >= '\ue000') {
                size += 3L;
                continue;
            }
            if (c <= '\udbff') {
                if (++i >= str.length() || str.charAt(i) < '\udc00' || str.charAt(i) > '\udfff') {
                    if (replace) {
                        size += 3L;
                        --i;
                        continue;
                    }
                    return -1L;
                }
                size += 4L;
                continue;
            }
            if (replace) {
                size += 3L;
                continue;
            }
            return -1L;
        }
        return size;
    }

    public static int CodePointBefore(String str, int index) {
        return DataUtilities.CodePointBefore(str, index, 0);
    }

    public static int CodePointBefore(String str, int index, int surrogateBehavior) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (index <= 0) {
            return -1;
        }
        if (index > str.length()) {
            return -1;
        }
        char c = str.charAt(index - 1);
        if ((c & 0xFC00) == 56320 && index - 2 >= 0 && str.charAt(index - 2) >= '\ud800' && str.charAt(index - 2) <= '\udbff') {
            return 65536 + (str.charAt(index - 2) - 55296 << 10) + (c - 56320);
        }
        if ((c & 0xF800) == 55296) {
            return surrogateBehavior == 0 ? 65533 : (surrogateBehavior == 1 ? (int)c : -1);
        }
        return c;
    }

    public static int CodePointAt(String str, int index) {
        return DataUtilities.CodePointAt(str, index, 0);
    }

    public static int CodePointAt(String str, int index, int surrogateBehavior) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (index >= str.length()) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        int c = str.charAt(index);
        if ((c & 0xFC00) == 55296 && index + 1 < str.length() && str.charAt(index + 1) >= '\udc00' && str.charAt(index + 1) <= '\udfff') {
            c = 65536 + (c - 55296 << 10) + (str.charAt(index + 1) - 56320);
            ++index;
        } else if ((c & 0xF800) == 55296) {
            return surrogateBehavior == 0 ? 65533 : (surrogateBehavior == 1 ? (int)c : -1);
        }
        return c;
    }

    public static String ToLowerCaseAscii(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        char c = '\u0000';
        boolean hasUpperCase = false;
        for (int i = 0; i < len; ++i) {
            c = str.charAt(i);
            if (c < 'A' || c > 'Z') continue;
            hasUpperCase = true;
            break;
        }
        if (!hasUpperCase) {
            return str;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            c = str.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                builder.append((char)(c + 32));
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static int CodePointCompare(String strA, String strB) {
        if (strA == null) {
            return strB == null ? 0 : -1;
        }
        if (strB == null) {
            return 1;
        }
        int len = Math.min(strA.length(), strB.length());
        for (int i = 0; i < len; ++i) {
            int cb;
            int ca = strA.charAt(i);
            if (ca == (cb = strB.charAt(i))) {
                if ((ca & 0xF800) != 55296) continue;
                boolean incindex = false;
                if (i + 1 < strA.length() && strA.charAt(i + 1) >= '\udc00' && strA.charAt(i + 1) <= '\udfff') {
                    ca = 65536 + (ca - 55296 << 10) + (strA.charAt(i + 1) - 56320);
                    incindex = true;
                }
                if (i + 1 < strB.length() && strB.charAt(i + 1) >= '\udc00' && strB.charAt(i + 1) <= '\udfff') {
                    cb = 65536 + (cb - 55296 << 10) + (strB.charAt(i + 1) - 56320);
                    incindex = true;
                }
                if (ca != cb) {
                    return ca - cb;
                }
                if (!incindex) continue;
                ++i;
                continue;
            }
            if ((ca & 0xF800) != 55296 && (cb & 0xF800) != 55296) {
                return ca - cb;
            }
            if ((ca & 0xFC00) == 55296 && i + 1 < strA.length() && strA.charAt(i + 1) >= '\udc00' && strA.charAt(i + 1) <= '\udfff') {
                ca = 65536 + (ca - 55296 << 10) + (strA.charAt(i + 1) - 56320);
            }
            if ((cb & 0xFC00) == 55296 && i + 1 < strB.length() && strB.charAt(i + 1) >= '\udc00' && strB.charAt(i + 1) <= '\udfff') {
                cb = 65536 + (cb - 55296 << 10) + (strB.charAt(i + 1) - 56320);
            }
            return ca - cb;
        }
        return strA.length() == strB.length() ? 0 : (strA.length() < strB.length() ? -1 : 1);
    }

    public static int WriteUtf8(String str, int offset, int length, OutputStream stream, boolean replace) throws IOException {
        return DataUtilities.WriteUtf8(str, offset, length, stream, replace, false);
    }

    public static int WriteUtf8(String str, int offset, int length, OutputStream stream, boolean replace, boolean lenientLineBreaks) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset (" + offset + ") is less than " + "0");
        }
        if (offset > str.length()) {
            throw new IllegalArgumentException("offset (" + offset + ") is more than " + str.length());
        }
        if (length < 0) {
            throw new IllegalArgumentException("length (" + length + ") is less than " + "0");
        }
        if (length > str.length()) {
            throw new IllegalArgumentException("length (" + length + ") is more than " + str.length());
        }
        if (str.length() - offset < length) {
            throw new IllegalArgumentException("str.length() minus offset (" + (str.length() - offset) + ") is less than " + length);
        }
        int retval = 0;
        byte[] bytes = new byte[4096];
        int byteIndex = 0;
        int endIndex = offset + length;
        for (int index = offset; index < endIndex; ++index) {
            int c = str.charAt(index);
            if (c <= 127) {
                if (lenientLineBreaks) {
                    if (c == 13 && (index + 1 >= endIndex || str.charAt(index + 1) != '\n')) {
                        if (byteIndex + 2 > 4096) {
                            stream.write(bytes, 0, byteIndex);
                            byteIndex = 0;
                        }
                        bytes[byteIndex++] = 13;
                        bytes[byteIndex++] = 10;
                        continue;
                    }
                    if (c == 13) {
                        if (byteIndex + 2 > 4096) {
                            stream.write(bytes, 0, byteIndex);
                            byteIndex = 0;
                        }
                        bytes[byteIndex++] = 13;
                        bytes[byteIndex++] = 10;
                        ++index;
                        continue;
                    }
                    if (c == 10) {
                        if (byteIndex + 2 > 4096) {
                            stream.write(bytes, 0, byteIndex);
                            byteIndex = 0;
                        }
                        bytes[byteIndex++] = 13;
                        bytes[byteIndex++] = 10;
                        continue;
                    }
                }
                if (byteIndex >= 4096) {
                    stream.write(bytes, 0, byteIndex);
                    byteIndex = 0;
                }
                bytes[byteIndex++] = (byte)c;
                continue;
            }
            if (c <= 2047) {
                if (byteIndex + 2 > 4096) {
                    stream.write(bytes, 0, byteIndex);
                    byteIndex = 0;
                }
                bytes[byteIndex++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if ((c & 0xFC00) == 55296 && index + 1 < endIndex && str.charAt(index + 1) >= '\udc00' && str.charAt(index + 1) <= '\udfff') {
                c = 65536 + (c - 55296 << 10) + (str.charAt(index + 1) - 56320);
                ++index;
            } else if ((c & 0xF800) == 55296) {
                if (!replace) {
                    retval = -1;
                    break;
                }
                c = 65533;
            }
            if (c <= 65535) {
                if (byteIndex + 3 > 4096) {
                    stream.write(bytes, 0, byteIndex);
                    byteIndex = 0;
                }
                bytes[byteIndex++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytes[byteIndex++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (byteIndex + 4 > 4096) {
                stream.write(bytes, 0, byteIndex);
                byteIndex = 0;
            }
            bytes[byteIndex++] = (byte)(0xF0 | c >> 18 & 7);
            bytes[byteIndex++] = (byte)(0x80 | c >> 12 & 0x3F);
            bytes[byteIndex++] = (byte)(0x80 | c >> 6 & 0x3F);
            bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
        }
        stream.write(bytes, 0, byteIndex);
        return retval;
    }

    public static int WriteUtf8(String str, OutputStream stream, boolean replace) throws IOException {
        if (str == null) {
            throw new NullPointerException("str");
        }
        return DataUtilities.WriteUtf8(str, 0, str.length(), stream, replace);
    }

    public static int ReadUtf8FromBytes(byte[] data, int offset, int bytesCount, StringBuilder builder, boolean replace) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset (" + offset + ") is less than " + "0");
        }
        if (offset > data.length) {
            throw new IllegalArgumentException("offset (" + offset + ") is more than " + data.length);
        }
        if (bytesCount < 0) {
            throw new IllegalArgumentException("bytesCount (" + bytesCount + ") is less than 0");
        }
        if (bytesCount > data.length) {
            throw new IllegalArgumentException("bytesCount (" + bytesCount + ") is more than " + data.length);
        }
        if (data.length - offset < bytesCount) {
            throw new IllegalArgumentException("data.length minus offset (" + (data.length - offset) + ") is less than " + bytesCount);
        }
        if (builder == null) {
            throw new NullPointerException("builder");
        }
        int cp = 0;
        int bytesSeen = 0;
        int bytesNeeded = 0;
        int lower = 128;
        int upper = 191;
        int pointer = offset;
        int endpointer = offset + bytesCount;
        while (pointer < endpointer) {
            int b = data[pointer] & 0xFF;
            ++pointer;
            if (bytesNeeded == 0) {
                if ((b & 0x7F) == b) {
                    builder.append((char)b);
                    continue;
                }
                if (b >= 194 && b <= 223) {
                    bytesNeeded = 1;
                    cp = b - 192 << 6;
                    continue;
                }
                if (b >= 224 && b <= 239) {
                    lower = b == 224 ? 160 : 128;
                    upper = b == 237 ? 159 : 191;
                    bytesNeeded = 2;
                    cp = b - 224 << 12;
                    continue;
                }
                if (b >= 240 && b <= 244) {
                    lower = b == 240 ? 144 : 128;
                    upper = b == 244 ? 143 : 191;
                    bytesNeeded = 3;
                    cp = b - 240 << 18;
                    continue;
                }
                if (replace) {
                    builder.append('\ufffd');
                    continue;
                }
                return -1;
            }
            if (b < lower || b > upper) {
                bytesSeen = 0;
                bytesNeeded = 0;
                cp = 0;
                lower = 128;
                upper = 191;
                if (replace) {
                    --pointer;
                    builder.append('\ufffd');
                    continue;
                }
                return -1;
            }
            lower = 128;
            upper = 191;
            cp += b - 128 << 6 * (bytesNeeded - ++bytesSeen);
            if (bytesSeen != bytesNeeded) continue;
            int ret = cp;
            cp = 0;
            bytesSeen = 0;
            bytesNeeded = 0;
            if (ret <= 65535) {
                builder.append((char)ret);
                continue;
            }
            int ch = ret - 65536;
            int lead = (ch >> 10) + 55296;
            int trail = (ch & 0x3FF) + 56320;
            builder.append((char)lead);
            builder.append((char)trail);
        }
        if (bytesNeeded != 0) {
            if (replace) {
                builder.append('\ufffd');
            } else {
                return -1;
            }
        }
        return 0;
    }

    public static String ReadUtf8ToString(InputStream stream) throws IOException {
        return DataUtilities.ReadUtf8ToString(stream, -1, true);
    }

    public static String ReadUtf8ToString(InputStream stream, int bytesCount, boolean replace) throws IOException {
        StringBuilder builder = new StringBuilder();
        if (DataUtilities.ReadUtf8(stream, bytesCount, builder, replace) == -1) {
            throw new IOException("Unpaired surrogate code point found.", new IllegalArgumentException("Unpaired surrogate code point found."));
        }
        return builder.toString();
    }

    public static int ReadUtf8(InputStream stream, int bytesCount, StringBuilder builder, boolean replace) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (builder == null) {
            throw new NullPointerException("builder");
        }
        int cp = 0;
        int bytesSeen = 0;
        int bytesNeeded = 0;
        int lower = 128;
        int upper = 191;
        int pointer = 0;
        while (pointer < bytesCount || bytesCount < 0) {
            int b = stream.read();
            if (b < 0) {
                if (bytesNeeded != 0) {
                    bytesNeeded = 0;
                    if (replace) {
                        builder.append('\ufffd');
                        if (bytesCount < 0) break;
                        return -2;
                    }
                    return -1;
                }
                if (bytesCount < 0) break;
                return -2;
            }
            if (bytesCount > 0) {
                ++pointer;
            }
            if (bytesNeeded == 0) {
                if ((b & 0x7F) == b) {
                    builder.append((char)b);
                    continue;
                }
                if (b >= 194 && b <= 223) {
                    bytesNeeded = 1;
                    cp = b - 192 << 6;
                    continue;
                }
                if (b >= 224 && b <= 239) {
                    lower = b == 224 ? 160 : 128;
                    upper = b == 237 ? 159 : 191;
                    bytesNeeded = 2;
                    cp = b - 224 << 12;
                    continue;
                }
                if (b >= 240 && b <= 244) {
                    lower = b == 240 ? 144 : 128;
                    upper = b == 244 ? 143 : 191;
                    bytesNeeded = 3;
                    cp = b - 240 << 18;
                    continue;
                }
                if (replace) {
                    builder.append('\ufffd');
                    continue;
                }
                return -1;
            }
            if (b < lower || b > upper) {
                bytesSeen = 0;
                bytesNeeded = 0;
                cp = 0;
                lower = 128;
                upper = 191;
                if (replace) {
                    builder.append('\ufffd');
                    if (b < 128) {
                        builder.append((char)b);
                        continue;
                    }
                    if (b >= 194 && b <= 223) {
                        bytesNeeded = 1;
                        cp = b - 192 << 6;
                        continue;
                    }
                    if (b >= 224 && b <= 239) {
                        lower = b == 224 ? 160 : 128;
                        upper = b == 237 ? 159 : 191;
                        bytesNeeded = 2;
                        cp = b - 224 << 12;
                        continue;
                    }
                    if (b >= 240 && b <= 244) {
                        lower = b == 240 ? 144 : 128;
                        upper = b == 244 ? 143 : 191;
                        bytesNeeded = 3;
                        cp = b - 240 << 18;
                        continue;
                    }
                    builder.append('\ufffd');
                    continue;
                }
                return -1;
            }
            lower = 128;
            upper = 191;
            cp += b - 128 << 6 * (bytesNeeded - ++bytesSeen);
            if (bytesSeen != bytesNeeded) continue;
            int ret = cp;
            cp = 0;
            bytesSeen = 0;
            bytesNeeded = 0;
            if (ret <= 65535) {
                builder.append((char)ret);
                continue;
            }
            int ch = ret - 65536;
            int lead = (ch >> 10) + 55296;
            int trail = (ch & 0x3FF) + 56320;
            builder.append((char)lead);
            builder.append((char)trail);
        }
        if (bytesNeeded != 0) {
            if (replace) {
                builder.append('\ufffd');
            } else {
                return -1;
            }
        }
        return 0;
    }
}

