/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.numbers.EInteger;
import java.util.ArrayList;
import java.util.List;

class SharedRefs {
    private final List<CBORObject> sharedObjects = new ArrayList<CBORObject>();

    public void AddObject(CBORObject obj) {
        this.sharedObjects.add(obj);
    }

    public CBORObject GetObject(long smallIndex) {
        if (smallIndex < 0L) {
            throw new CBORException("Unexpected index");
        }
        if (smallIndex > Integer.MAX_VALUE) {
            throw new CBORException("Index " + smallIndex + " is bigger than supported ");
        }
        int index = (int)smallIndex;
        if (index >= this.sharedObjects.size()) {
            throw new CBORException("Index " + index + " is not valid");
        }
        return this.sharedObjects.get(index);
    }

    public CBORObject GetObject(EInteger bigIndex) {
        if (bigIndex.signum() < 0) {
            throw new CBORException("Unexpected index");
        }
        if (!bigIndex.CanFitInInt32()) {
            throw new CBORException("Index " + bigIndex + " is bigger than supported ");
        }
        int index = bigIndex.AsInt32Checked();
        if (index >= this.sharedObjects.size()) {
            throw new CBORException("Index " + index + " is not valid");
        }
        return this.sharedObjects.get(index);
    }
}

