/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORDouble;
import com.upokecenter.cbor.CBOREInteger;
import com.upokecenter.cbor.CBOREncodeOptions;
import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORExtendedDecimal;
import com.upokecenter.cbor.CBORExtendedFloat;
import com.upokecenter.cbor.CBORExtendedRational;
import com.upokecenter.cbor.CBORInteger;
import com.upokecenter.cbor.CBORJson;
import com.upokecenter.cbor.CBORObjectMath;
import com.upokecenter.cbor.CBORReader;
import com.upokecenter.cbor.CBORSingle;
import com.upokecenter.cbor.CBORTag0;
import com.upokecenter.cbor.CBORTag2;
import com.upokecenter.cbor.CBORTag28;
import com.upokecenter.cbor.CBORTag3;
import com.upokecenter.cbor.CBORTag30;
import com.upokecenter.cbor.CBORTag32;
import com.upokecenter.cbor.CBORTag37;
import com.upokecenter.cbor.CBORTag4;
import com.upokecenter.cbor.CBORTag5;
import com.upokecenter.cbor.CBORTagAny;
import com.upokecenter.cbor.CBORTagGenericString;
import com.upokecenter.cbor.CBORTagUnsigned;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.CharacterInputWithCount;
import com.upokecenter.cbor.CharacterReader;
import com.upokecenter.cbor.ICBORConverter;
import com.upokecenter.cbor.ICBORNumber;
import com.upokecenter.cbor.ICBORTag;
import com.upokecenter.cbor.PropertyMap;
import com.upokecenter.cbor.StringOutput;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;
import com.upokecenter.util.BigInteger;
import com.upokecenter.util.DataUtilities;
import com.upokecenter.util.ExtendedDecimal;
import com.upokecenter.util.ExtendedFloat;
import com.upokecenter.util.ExtendedRational;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CBORObject
implements Comparable<CBORObject> {
    public static final CBORObject False = CBORObject.ConstructSimpleValue(20);
    public static final CBORObject NaN = CBORObject.FromObject(Double.NaN);
    public static final CBORObject NegativeInfinity = CBORObject.FromObject(Double.NEGATIVE_INFINITY);
    public static final CBORObject Null = CBORObject.ConstructSimpleValue(22);
    public static final CBORObject PositiveInfinity = CBORObject.FromObject(Double.POSITIVE_INFINITY);
    public static final CBORObject True = CBORObject.ConstructSimpleValue(21);
    public static final CBORObject Undefined = CBORObject.ConstructSimpleValue(23);
    public static final CBORObject Zero = CBORObject.ConstructIntegerValue(0);
    static final int CBORObjectTypeArray = 4;
    static final int CBORObjectTypeBigInteger = 1;
    static final int CBORObjectTypeByteString = 2;
    static final int CBORObjectTypeDouble = 8;
    static final int CBORObjectTypeExtendedDecimal = 9;
    static final int CBORObjectTypeExtendedFloat = 11;
    static final int CBORObjectTypeExtendedRational = 12;
    static final int CBORObjectTypeInteger = 0;
    static final int CBORObjectTypeMap = 5;
    static final int CBORObjectTypeSimpleValue = 6;
    static final int CBORObjectTypeSingle = 7;
    static final int CBORObjectTypeTagged = 10;
    static final int CBORObjectTypeTextString = 3;
    static final EInteger Int64MaxValue = EInteger.FromInt64((long)Long.MAX_VALUE);
    static final EInteger Int64MinValue = EInteger.FromInt64((long)Long.MIN_VALUE);
    private static final int StreamedStringBufferLength = 4096;
    private static final Map<Object, ConverterInfo> ValueConverters = new HashMap<Object, ConverterInfo>();
    private static final ICBORNumber[] NumberInterfaces = new ICBORNumber[]{new CBORInteger(), new CBOREInteger(), null, null, null, null, null, new CBORSingle(), new CBORDouble(), new CBORExtendedDecimal(), null, new CBORExtendedFloat(), new CBORExtendedRational()};
    private static final Map<EInteger, ICBORTag> ValueTagHandlers = new HashMap<EInteger, ICBORTag>();
    private static final EInteger UInt64MaxValue = EInteger.FromInt32((int)1).ShiftLeft(64).Subtract(EInteger.FromInt64((long)1L));
    private static final EInteger[] ValueEmptyTags = new EInteger[0];
    private static final int[] ValueExpectedLengths = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 5, 9, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 5, 9, -1, -1, -1, -1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 0, 0, 0, 0, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 0, 0, 0, 0, -1, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 5, 9, -1, -1, -1, -1};
    private static final byte[] ValueFalseBytes = new byte[]{102, 97, 108, 115, 101};
    private static final byte[] ValueNullBytes = new byte[]{110, 117, 108, 108};
    private static final int[] ValueNumberTypeOrder = new int[]{0, 0, 2, 3, 4, 5, 1, 0, 0, 0, 0, 0, 0};
    private static final byte[] ValueTrueBytes = new byte[]{116, 114, 117, 101};
    private static CBORObject[] valueFixedObjects = CBORObject.InitializeFixedObjects();
    private int itemtypeValue;
    private Object itemValue;
    private int tagHigh;
    private int tagLow;

    private static CBORObject ConstructSimpleValue(int v) {
        return new CBORObject(6, v);
    }

    private static CBORObject ConstructIntegerValue(int v) {
        return new CBORObject(0, v);
    }

    CBORObject(CBORObject obj, int tagLow, int tagHigh) {
        this(10, obj);
        this.tagLow = tagLow;
        this.tagHigh = tagHigh;
    }

    CBORObject(int type, Object item) {
        this.itemtypeValue = type;
        this.itemValue = item;
    }

    public final int size() {
        return this.getItemType() == 4 ? this.AsList().size() : (this.getItemType() == 5 ? this.AsMap().size() : 0);
    }

    public final BigInteger getInnermostTag() {
        if (!this.isTagged()) {
            return PropertyMap.ToLegacy(EInteger.FromInt32((int)-1));
        }
        CBORObject previtem = this;
        CBORObject curitem = (CBORObject)this.itemValue;
        while (curitem.isTagged()) {
            previtem = curitem;
            curitem = (CBORObject)curitem.itemValue;
        }
        if (previtem.tagHigh == 0 && previtem.tagLow >= 0 && previtem.tagLow < 65536) {
            return PropertyMap.ToLegacy(EInteger.FromInt64((long)previtem.tagLow));
        }
        return PropertyMap.ToLegacy(CBORObject.LowHighToEInteger(previtem.tagLow, previtem.tagHigh));
    }

    public final boolean isFalse() {
        return this.getItemType() == 6 && (Integer)this.getThisItem() == 20;
    }

    public final boolean isFinite() {
        return this.getType() == CBORType.Number && !this.IsInfinity() && !this.IsNaN();
    }

    public final boolean isIntegral() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        return cn != null && cn.IsIntegral(this.getThisItem());
    }

    public final boolean isNull() {
        return this.getItemType() == 6 && (Integer)this.getThisItem() == 22;
    }

    public final boolean isTagged() {
        return this.itemtypeValue == 10;
    }

    public final boolean isTrue() {
        return this.getItemType() == 6 && (Integer)this.getThisItem() == 21;
    }

    public final boolean isUndefined() {
        return this.getItemType() == 6 && (Integer)this.getThisItem() == 23;
    }

    public final boolean isZero() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        return cn != null && cn.IsZero(this.getThisItem());
    }

    public final Collection<CBORObject> getKeys() {
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> dict = this.AsMap();
            return dict.keySet();
        }
        throw new IllegalStateException("Not a map");
    }

    public final boolean isNegative() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        return cn != null && cn.IsNegative(this.getThisItem());
    }

    public final BigInteger getOutermostTag() {
        if (!this.isTagged()) {
            return PropertyMap.ToLegacy(EInteger.FromInt32((int)-1));
        }
        if (this.tagHigh == 0 && this.tagLow >= 0 && this.tagLow < 65536) {
            return PropertyMap.ToLegacy(EInteger.FromInt32((int)this.tagLow));
        }
        return PropertyMap.ToLegacy(CBORObject.LowHighToEInteger(this.tagLow, this.tagHigh));
    }

    public final int signum() {
        int ret = CBORObject.GetSignInternal(this.getItemType(), this.getThisItem());
        if (ret == 2) {
            throw new IllegalStateException("This Object is not a number.");
        }
        return ret;
    }

    public final int getSimpleValue() {
        return this.getItemType() == 6 ? (Integer)this.getThisItem() : -1;
    }

    public final CBORType getType() {
        switch (this.getItemType()) {
            case 0: 
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return CBORType.Number;
            }
            case 6: {
                return (Integer)this.getThisItem() == 21 || (Integer)this.getThisItem() == 20 ? CBORType.Boolean : CBORType.SimpleValue;
            }
            case 4: {
                return CBORType.Array;
            }
            case 5: {
                return CBORType.Map;
            }
            case 2: {
                return CBORType.ByteString;
            }
            case 3: {
                return CBORType.TextString;
            }
        }
        throw new IllegalStateException("Unexpected data type");
    }

    public final Collection<CBORObject> getValues() {
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> dict = this.AsMap();
            return dict.values();
        }
        if (this.getItemType() == 4) {
            List<CBORObject> list = this.AsList();
            return Collections.unmodifiableList(list);
        }
        throw new IllegalStateException("Not a map or array");
    }

    final int getItemType() {
        CBORObject curobject = this;
        while (curobject.itemtypeValue == 10) {
            curobject = (CBORObject)curobject.itemValue;
        }
        return curobject.itemtypeValue;
    }

    final Object getThisItem() {
        CBORObject curobject = this;
        while (curobject.itemtypeValue == 10) {
            curobject = (CBORObject)curobject.itemValue;
        }
        return curobject.itemValue;
    }

    public CBORObject get(int index) {
        if (this.getItemType() == 4) {
            List<CBORObject> list = this.AsList();
            if (index < 0 || index >= list.size()) {
                throw new IllegalArgumentException("index");
            }
            return list.get(index);
        }
        throw new IllegalStateException("Not an array");
    }

    public void set(int index, CBORObject value) {
        if (this.getItemType() == 4) {
            if (value == null) {
                throw new NullPointerException("value");
            }
        } else {
            throw new IllegalStateException("Not an array");
        }
        List<CBORObject> list = this.AsList();
        list.set(index, value);
    }

    public CBORObject get(CBORObject key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> map = this.AsMap();
            return !map.containsKey(key) ? null : map.get(key);
        }
        throw new IllegalStateException("Not a map");
    }

    public void set(CBORObject key, CBORObject value) {
        if (key == null) {
            throw new NullPointerException("value");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (this.getItemType() != 5) {
            throw new IllegalStateException("Not a map");
        }
        Map<CBORObject, CBORObject> map = this.AsMap();
        map.put(key, value);
    }

    public CBORObject get(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        CBORObject objkey = CBORObject.FromObject(key);
        return this.get(objkey);
    }

    public void set(String key, CBORObject value) {
        if (key == null) {
            throw new NullPointerException("value");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        CBORObject objkey = CBORObject.FromObject(key);
        if (this.getItemType() != 5) {
            throw new IllegalStateException("Not a map");
        }
        Map<CBORObject, CBORObject> map = this.AsMap();
        map.put(objkey, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void AddConverter(Class<?> type, ICBORConverter<T> converter) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (converter == null) {
            throw new NullPointerException("converter");
        }
        ConverterInfo ci = new ConverterInfo();
        ci.setConverter(converter);
        ci.setToObject(PropertyMap.FindOneArgumentMethod(converter, "ToCBORObject", type));
        if (ci.getToObject() == null) {
            throw new IllegalArgumentException("Converter doesn't contain a proper ToCBORObject method");
        }
        Map<Object, ConverterInfo> map = ValueConverters;
        synchronized (map) {
            ValueConverters.put(type, ci);
        }
    }

    public static CBORObject Addition(CBORObject first, CBORObject second) {
        return CBORObjectMath.Addition(first, second);
    }

    public static void AddTagHandler(BigInteger bigintTag, ICBORTag handler) {
        if (bigintTag == null) {
            throw new NullPointerException("bigintTag");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        CBORObject.AddTagHandler(PropertyMap.FromLegacy(bigintTag), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void AddTagHandler(EInteger bigintTag, ICBORTag handler) {
        if (bigintTag == null) {
            throw new NullPointerException("bigintTag");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (bigintTag.signum() < 0) {
            throw new IllegalArgumentException("bigintTag.signum() (" + bigintTag.signum() + ") is less than 0");
        }
        if (bigintTag.GetSignedBitLength() > 64) {
            throw new IllegalArgumentException("bigintTag.bitLength (" + (long)bigintTag.GetSignedBitLength() + ") is more than " + "64");
        }
        Map<EInteger, ICBORTag> map = ValueTagHandlers;
        synchronized (map) {
            ValueTagHandlers.put(bigintTag, handler);
        }
    }

    public static CBORObject DecodeFromBytes(byte[] data) {
        return CBORObject.DecodeFromBytes(data, CBOREncodeOptions.None);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CBORObject DecodeFromBytes(byte[] data, CBOREncodeOptions options) {
        String s;
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (data.length == 0) {
            throw new CBORException("data is empty.");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        int firstbyte = data[0] & 0xFF;
        int expectedLength = ValueExpectedLengths[firstbyte];
        if (expectedLength == -1) {
            throw new CBORException("Unexpected data encountered");
        }
        if (expectedLength != 0) {
            CBORObject.CheckCBORLength(expectedLength, data.length);
        }
        if (firstbyte == 192 && (s = CBORObject.GetOptimizedStringIfShortAscii(data, 1)) != null) {
            return new CBORObject(CBORObject.FromObject(s), 0, 0);
        }
        if (expectedLength != 0) {
            return CBORObject.GetFixedLengthObject(firstbyte, data);
        }
        ByteArrayInputStream ms = null;
        try {
            ms = new ByteArrayInputStream(data);
            int startingAvailable = ms.available();
            CBORObject o = CBORObject.Read(ms, options);
            CBORObject.CheckCBORLength((long)data.length, (long)(startingAvailable - ms.available()));
            CBORObject cBORObject = o;
            return cBORObject;
        }
        finally {
            try {
                if (ms != null) {
                    ms.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public static CBORObject Divide(CBORObject first, CBORObject second) {
        return CBORObjectMath.Divide(first, second);
    }

    public static CBORObject FromJSONString(String str) {
        return CBORObject.FromJSONString(str, CBOREncodeOptions.None);
    }

    public static CBORObject FromJSONString(String str, CBOREncodeOptions options) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (str.length() > 0 && str.charAt(0) == '\ufeff') {
            throw new CBORException("JSON Object began with a byte order mark (U+FEFF) (offset 0)");
        }
        CharacterInputWithCount reader = new CharacterInputWithCount(new CharacterReader(str, false, true));
        CBOREncodeOptions opt = options.And(CBOREncodeOptions.NoDuplicateKeys);
        int[] nextchar = new int[1];
        CBORObject obj = CBORJson.ParseJSONValue(reader, opt.getValue() != 0, false, nextchar);
        if (nextchar[0] != -1) {
            reader.RaiseError("End of String not reached");
        }
        return obj;
    }

    public static CBORObject FromObject(long value) {
        return value >= 0L && value < 24L ? valueFixedObjects[(int)value] : new CBORObject(0, value);
    }

    public static CBORObject FromObject(CBORObject value) {
        return value == null ? Null : value;
    }

    public static CBORObject FromObject(BigInteger bigintValue) {
        return bigintValue == (Object)null ? Null : CBORObject.FromObject(PropertyMap.FromLegacy(bigintValue));
    }

    static CBORObject FromObject(EInteger bigintValue) {
        if (bigintValue == (Object)null) {
            return Null;
        }
        return bigintValue.compareTo(Int64MinValue) >= 0 && bigintValue.compareTo(Int64MaxValue) <= 0 ? new CBORObject(0, bigintValue.AsInt64Checked()) : new CBORObject(1, bigintValue);
    }

    public static CBORObject FromObject(ExtendedFloat bigValue) {
        return bigValue == (Object)null ? Null : CBORObject.FromObject(PropertyMap.FromLegacy(bigValue));
    }

    static CBORObject FromObject(EFloat bigValue) {
        if (bigValue == (Object)null) {
            return Null;
        }
        if (bigValue.IsInfinity()) {
            return CBORObject.FromObject(bigValue.ToDouble());
        }
        if (bigValue.IsNaN()) {
            return new CBORObject(11, bigValue);
        }
        EInteger bigintExponent = bigValue.getExponent();
        return bigintExponent.isZero() && (!bigValue.isZero() || !bigValue.isNegative()) ? CBORObject.FromObject(bigValue.getMantissa()) : new CBORObject(11, bigValue);
    }

    public static CBORObject FromObject(ExtendedRational bigValue) {
        return bigValue == (Object)null ? Null : CBORObject.FromObject(PropertyMap.FromLegacy(bigValue));
    }

    static CBORObject FromObject(ERational bigValue) {
        if (bigValue == (Object)null) {
            return Null;
        }
        if (bigValue.IsInfinity()) {
            return CBORObject.FromObject(bigValue.ToDouble());
        }
        if (bigValue.IsNaN()) {
            return new CBORObject(12, bigValue);
        }
        return bigValue.isFinite() && bigValue.getDenominator().equals((Object)EInteger.FromInt32((int)1)) ? CBORObject.FromObject(bigValue.getNumerator()) : new CBORObject(12, bigValue);
    }

    static CBORObject FromObject(EDecimal otherValue) {
        if (otherValue == (Object)null) {
            return Null;
        }
        if (otherValue.IsInfinity()) {
            return CBORObject.FromObject(otherValue.ToDouble());
        }
        if (otherValue.IsNaN()) {
            return new CBORObject(9, otherValue);
        }
        EInteger bigintExponent = otherValue.getExponent();
        return bigintExponent.isZero() && (!otherValue.isZero() || !otherValue.isNegative()) ? CBORObject.FromObject(otherValue.getMantissa()) : new CBORObject(9, otherValue);
    }

    public static CBORObject FromObject(ExtendedDecimal otherValue) {
        return otherValue == (Object)null ? Null : CBORObject.FromObject(PropertyMap.FromLegacy(otherValue));
    }

    public static CBORObject FromObject(String strValue) {
        if (strValue == null) {
            return Null;
        }
        if (DataUtilities.GetUtf8Length(strValue, false) < 0L) {
            throw new IllegalArgumentException("String contains an unpaired surrogate code point.");
        }
        return new CBORObject(3, strValue);
    }

    public static CBORObject FromObject(int value) {
        return value >= 0 && value < 24 ? valueFixedObjects[value] : CBORObject.FromObject((long)value);
    }

    public static CBORObject FromObject(short value) {
        return value >= 0 && value < 24 ? valueFixedObjects[value] : CBORObject.FromObject((long)value);
    }

    public static CBORObject FromObject(char value) {
        char[] valueChar = new char[]{value};
        return CBORObject.FromObject(new String(valueChar));
    }

    public static CBORObject FromObject(boolean value) {
        return value ? True : False;
    }

    public static CBORObject FromObject(byte value) {
        return CBORObject.FromObject(value & 0xFF);
    }

    public static CBORObject FromObject(float value) {
        return new CBORObject(7, Float.valueOf(value));
    }

    public static CBORObject FromObject(double value) {
        return new CBORObject(8, value);
    }

    public static CBORObject FromObject(byte[] bytes) {
        if (bytes == null) {
            return Null;
        }
        byte[] newvalue = new byte[bytes.length];
        System.arraycopy(bytes, 0, newvalue, 0, bytes.length);
        return new CBORObject(2, bytes);
    }

    public static CBORObject FromObject(CBORObject[] array) {
        if (array == null) {
            return Null;
        }
        ArrayList<CBORObject> list = new ArrayList<CBORObject>();
        for (CBORObject i : array) {
            list.add(CBORObject.FromObject(i));
        }
        return new CBORObject(4, list);
    }

    public static CBORObject FromObject(int[] array) {
        if (array == null) {
            return Null;
        }
        ArrayList<CBORObject> list = new ArrayList<CBORObject>();
        for (int i : array) {
            list.add(CBORObject.FromObject(i));
        }
        return new CBORObject(4, list);
    }

    public static CBORObject FromObject(long[] array) {
        if (array == null) {
            return Null;
        }
        ArrayList<CBORObject> list = new ArrayList<CBORObject>();
        for (long i : array) {
            list.add(CBORObject.FromObject(i));
        }
        return new CBORObject(4, list);
    }

    public static <T> CBORObject FromObject(List<T> value) {
        if (value == null) {
            return Null;
        }
        if (value.size() == 0) {
            return new CBORObject(4, new ArrayList());
        }
        CBORObject retCbor = CBORObject.NewArray();
        for (T i : value) {
            retCbor.Add(CBORObject.FromObject(i));
        }
        return retCbor;
    }

    public static <T> CBORObject FromObject(Iterable<T> value) {
        if (value == null) {
            return Null;
        }
        CBORObject retCbor = CBORObject.NewArray();
        for (T i : value) {
            retCbor.Add(CBORObject.FromObject(i));
        }
        return retCbor;
    }

    public static <TKey, TValue> CBORObject FromObject(Map<TKey, TValue> dic) {
        if (dic == null) {
            return Null;
        }
        HashMap<CBORObject, CBORObject> map = new HashMap<CBORObject, CBORObject>();
        for (Map.Entry<TKey, TValue> entry : dic.entrySet()) {
            CBORObject key = CBORObject.FromObject(entry.getKey());
            CBORObject value = CBORObject.FromObject(entry.getValue());
            map.put(key, value);
        }
        return new CBORObject(5, map);
    }

    public static CBORObject FromObject(Object obj) {
        byte[] bytearr;
        ExtendedRational rf;
        ExtendedFloat bf;
        ExtendedDecimal df;
        ERational erf;
        EFloat eff;
        EDecimal edf;
        EInteger eif;
        if (obj == null) {
            return Null;
        }
        if (obj instanceof String) {
            return CBORObject.FromObject((String)obj);
        }
        if (obj instanceof Integer) {
            return CBORObject.FromObject((Integer)obj);
        }
        if (obj instanceof Long) {
            return CBORObject.FromObject((Long)obj);
        }
        if (obj instanceof CBORObject) {
            return CBORObject.FromObject((CBORObject)obj);
        }
        if (obj instanceof BigInteger) {
            return CBORObject.FromObject((BigInteger)obj);
        }
        EInteger eInteger = eif = obj instanceof EInteger ? (EInteger)obj : null;
        if (eif != null) {
            return CBORObject.FromObject(eif);
        }
        EDecimal eDecimal = edf = obj instanceof EDecimal ? (EDecimal)obj : null;
        if (edf != null) {
            return CBORObject.FromObject(edf);
        }
        EFloat eFloat = eff = obj instanceof EFloat ? (EFloat)obj : null;
        if (eff != null) {
            return CBORObject.FromObject(eff);
        }
        ERational eRational = erf = obj instanceof ERational ? (ERational)obj : null;
        if (erf != null) {
            return CBORObject.FromObject(erf);
        }
        ExtendedDecimal extendedDecimal = df = obj instanceof ExtendedDecimal ? (ExtendedDecimal)obj : null;
        if (df != null) {
            return CBORObject.FromObject(df);
        }
        ExtendedFloat extendedFloat = bf = obj instanceof ExtendedFloat ? (ExtendedFloat)obj : null;
        if (bf != null) {
            return CBORObject.FromObject(bf);
        }
        ExtendedRational extendedRational = rf = obj instanceof ExtendedRational ? (ExtendedRational)obj : null;
        if (rf != null) {
            return CBORObject.FromObject(rf);
        }
        if (obj instanceof Short) {
            return CBORObject.FromObject((Short)obj);
        }
        if (obj instanceof Character) {
            return CBORObject.FromObject(((Character)obj).charValue());
        }
        if (obj instanceof Boolean) {
            return CBORObject.FromObject((Boolean)obj);
        }
        if (obj instanceof Byte) {
            return CBORObject.FromObject((Byte)obj);
        }
        if (obj instanceof Float) {
            return CBORObject.FromObject(((Float)obj).floatValue());
        }
        if (obj instanceof Enum) {
            return CBORObject.FromObject(PropertyMap.EnumToObject((Enum)obj));
        }
        if (obj instanceof Double) {
            return CBORObject.FromObject((Double)obj);
        }
        byte[] byArray = bytearr = obj instanceof byte[] ? (byte[])obj : null;
        if (bytearr != null) {
            return CBORObject.FromObject(bytearr);
        }
        if (obj instanceof Map) {
            CBORObject objret = CBORObject.NewMap();
            Map objdic = (Map)obj;
            for (Object key : objdic.keySet()) {
                objret.set(CBORObject.FromObject(key), CBORObject.FromObject(objdic.get(key)));
            }
            return objret;
        }
        if (obj.getClass().isArray()) {
            return PropertyMap.FromArray(obj);
        }
        if (obj instanceof Iterable) {
            CBORObject objret = CBORObject.NewArray();
            for (Object element : (Iterable)obj) {
                objret.Add(CBORObject.FromObject(element));
            }
            return objret;
        }
        CBORObject objret = CBORObject.ConvertWithConverter(obj);
        if (objret != null) {
            return objret;
        }
        objret = CBORObject.NewMap();
        for (Map.Entry<String, Object> key : PropertyMap.GetProperties(obj)) {
            objret.set(key.getKey(), CBORObject.FromObject(key.getValue()));
        }
        return objret;
    }

    public static CBORObject FromObjectAndTag(Object valueOb, BigInteger bigintTag) {
        if (bigintTag == null) {
            throw new NullPointerException("bigintTag");
        }
        return CBORObject.FromObjectAndTag(valueOb, PropertyMap.FromLegacy(bigintTag));
    }

    static CBORObject FromObjectAndTag(Object valueOb, EInteger tagEInt) {
        int b;
        int i;
        if (tagEInt == null) {
            throw new NullPointerException("tagEInt");
        }
        if (tagEInt.signum() < 0) {
            throw new IllegalArgumentException("tagEInt's sign (" + tagEInt.signum() + ") is less than 0");
        }
        if (tagEInt.compareTo(UInt64MaxValue) > 0) {
            throw new IllegalArgumentException("tag more than 18446744073709551615 (" + tagEInt + ")");
        }
        CBORObject c = CBORObject.FromObject(valueOb);
        if (tagEInt.GetSignedBitLength() <= 16) {
            return CBORObject.FromObjectAndTag((Object)c, tagEInt.AsInt32Checked());
        }
        int tagLow = 0;
        int tagHigh = 0;
        byte[] bytes = tagEInt.ToBytes(true);
        for (i = 0; i < Math.min(4, bytes.length); ++i) {
            b = bytes[i] & 0xFF;
            tagLow |= b << i * 8;
        }
        for (i = 4; i < Math.min(8, bytes.length); ++i) {
            b = bytes[i] & 0xFF;
            tagHigh |= b << i * 8;
        }
        CBORObject c2 = new CBORObject(c, tagLow, tagHigh);
        ICBORTag tagconv = CBORObject.FindTagConverter(tagEInt);
        if (tagconv != null) {
            c2 = tagconv.ValidateObject(c2);
        }
        return c2;
    }

    public static CBORObject FromObjectAndTag(Object valueObValue, int smallTag) {
        if (smallTag < 0) {
            throw new IllegalArgumentException("smallTag (" + smallTag + ") is less than 0");
        }
        ICBORTag tagconv = CBORObject.FindTagConverter(smallTag);
        CBORObject c = CBORObject.FromObject(valueObValue);
        c = new CBORObject(c, smallTag, 0);
        return tagconv != null ? tagconv.ValidateObject(c) : c;
    }

    public static CBORObject FromSimpleValue(int simpleValue) {
        if (simpleValue < 0) {
            throw new IllegalArgumentException("simpleValue (" + simpleValue + ") is less than 0");
        }
        if (simpleValue > 255) {
            throw new IllegalArgumentException("simpleValue (" + simpleValue + ") is more than " + "255");
        }
        if (simpleValue >= 24 && simpleValue < 32) {
            throw new IllegalArgumentException("Simple value is from 24 to 31: " + simpleValue);
        }
        if (simpleValue < 32) {
            return valueFixedObjects[224 + simpleValue];
        }
        return new CBORObject(6, simpleValue);
    }

    public static CBORObject Multiply(CBORObject first, CBORObject second) {
        return CBORObjectMath.Multiply(first, second);
    }

    public static CBORObject NewArray() {
        return new CBORObject(4, new ArrayList());
    }

    public static CBORObject NewMap() {
        return CBORObject.FromObject(new HashMap());
    }

    public static CBORObject Read(InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        try {
            return new CBORReader(stream).Read(null);
        }
        catch (IOException ex) {
            throw new CBORException("I/O error occurred.", ex);
        }
    }

    public static CBORObject Read(InputStream stream, CBOREncodeOptions options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        try {
            CBORReader reader = new CBORReader(stream);
            CBOREncodeOptions opt = options.And(CBOREncodeOptions.NoDuplicateKeys);
            if (opt.getValue() != 0) {
                reader.setDuplicatePolicy(CBORReader.CBORDuplicatePolicy.Disallow);
            }
            return reader.Read(null);
        }
        catch (IOException ex) {
            throw new CBORException("I/O error occurred.", ex);
        }
    }

    public static CBORObject ReadJSON(InputStream stream) throws IOException {
        return CBORObject.ReadJSON(stream, CBOREncodeOptions.None);
    }

    public static CBORObject ReadJSON(InputStream stream, CBOREncodeOptions options) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        CharacterInputWithCount reader = new CharacterInputWithCount(new CharacterReader(stream, 2, true));
        try {
            CBOREncodeOptions opt = options.And(CBOREncodeOptions.NoDuplicateKeys);
            int[] nextchar = new int[1];
            CBORObject obj = CBORJson.ParseJSONValue(reader, opt.getValue() != 0, false, nextchar);
            if (nextchar[0] != -1) {
                reader.RaiseError("End of data stream not reached");
            }
            return obj;
        }
        catch (CBORException ex) {
            IOException ioex;
            IOException iOException = ioex = ex.getCause() instanceof IOException ? (IOException)ex.getCause() : null;
            if (ioex != null) {
                throw ioex;
            }
            throw ex;
        }
    }

    public static CBORObject Remainder(CBORObject first, CBORObject second) {
        return CBORObjectMath.Remainder(first, second);
    }

    public static CBORObject Subtract(CBORObject first, CBORObject second) {
        return CBORObjectMath.Subtract(first, second);
    }

    public static void Write(String str, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (str == null) {
            stream.write(246);
        } else {
            CBORObject.WriteStreamedString(str, stream);
        }
    }

    public static void Write(String str, OutputStream stream, CBOREncodeOptions options) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (str == null) {
            stream.write(246);
        } else {
            CBOREncodeOptions noIndef = options.And(CBOREncodeOptions.NoIndefLengthStrings);
            if (noIndef.getValue() != 0) {
                long codePointLength = DataUtilities.GetUtf8Length(str, true);
                CBORObject.WritePositiveInt64(3, codePointLength, stream);
                DataUtilities.WriteUtf8(str, stream, true);
            } else {
                CBORObject.WriteStreamedString(str, stream);
            }
        }
    }

    public static void Write(ExtendedFloat bignum, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (bignum == null) {
            stream.write(246);
            return;
        }
        CBORObject.Write(PropertyMap.FromLegacy(bignum), stream);
    }

    static void Write(EFloat bignum, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (bignum == null) {
            stream.write(246);
            return;
        }
        if (bignum.isZero() && bignum.isNegative() || bignum.IsInfinity() || bignum.IsNaN()) {
            CBORObject.Write(bignum.ToDouble(), stream);
            return;
        }
        EInteger exponent = bignum.getExponent();
        if (exponent.isZero()) {
            CBORObject.Write(bignum.getMantissa(), stream);
        } else {
            if (!CBORObject.BigIntFits(exponent)) {
                stream.write(217);
                stream.write(1);
                stream.write(9);
                stream.write(130);
            } else {
                stream.write(197);
                stream.write(130);
            }
            CBORObject.Write(bignum.getExponent(), stream);
            CBORObject.Write(bignum.getMantissa(), stream);
        }
    }

    public static void Write(ExtendedRational rational, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (rational == null) {
            stream.write(246);
            return;
        }
        CBORObject.Write(PropertyMap.FromLegacy(rational), stream);
    }

    static void Write(ERational rational, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (rational == null) {
            stream.write(246);
            return;
        }
        if (!rational.isFinite()) {
            CBORObject.Write(rational.ToDouble(), stream);
            return;
        }
        if (rational.getDenominator().equals((Object)EInteger.FromInt32((int)1))) {
            CBORObject.Write(rational.getNumerator(), stream);
            return;
        }
        stream.write(216);
        stream.write(30);
        stream.write(130);
        CBORObject.Write(rational.getNumerator(), stream);
        CBORObject.Write(rational.getDenominator(), stream);
    }

    public static void Write(ExtendedDecimal bignum, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (bignum == null) {
            stream.write(246);
            return;
        }
        CBORObject.Write(PropertyMap.FromLegacy(bignum), stream);
    }

    static void Write(EDecimal bignum, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (bignum == null) {
            stream.write(246);
            return;
        }
        if (bignum.isZero() && bignum.isNegative() || bignum.IsInfinity() || bignum.IsNaN()) {
            CBORObject.Write(bignum.ToDouble(), stream);
            return;
        }
        EInteger exponent = bignum.getExponent();
        if (exponent.isZero()) {
            CBORObject.Write(bignum.getMantissa(), stream);
        } else {
            if (!CBORObject.BigIntFits(exponent)) {
                stream.write(217);
                stream.write(1);
                stream.write(8);
                stream.write(130);
            } else {
                stream.write(196);
                stream.write(130);
            }
            CBORObject.Write(bignum.getExponent(), stream);
            CBORObject.Write(bignum.getMantissa(), stream);
        }
    }

    public static void Write(BigInteger bigint, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (bigint == (Object)null) {
            stream.write(246);
            return;
        }
        CBORObject.Write(PropertyMap.FromLegacy(bigint), stream);
    }

    static void Write(EInteger bigint, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (bigint == (Object)null) {
            stream.write(246);
            return;
        }
        int datatype = 0;
        if (bigint.signum() < 0) {
            datatype = 1;
            bigint = bigint.Add(EInteger.FromInt32((int)1));
            bigint = bigint.Negate();
        }
        if (bigint.compareTo(Int64MaxValue) <= 0) {
            long ui = bigint.AsInt64Checked();
            CBORObject.WritePositiveInt64(datatype, ui, stream);
        } else {
            int byteCount;
            byte[] bytes = bigint.ToBytes(true);
            for (byteCount = bytes.length; byteCount > 0 && bytes[byteCount - 1] == 0; --byteCount) {
            }
            if (byteCount != 0) {
                int half = byteCount >> 1;
                int right = byteCount - 1;
                int i = 0;
                while (i < half) {
                    byte value = bytes[i];
                    bytes[i] = bytes[right];
                    bytes[right] = value;
                    ++i;
                    --right;
                }
            }
            switch (byteCount) {
                case 0: {
                    stream.write((byte)(datatype << 5));
                    return;
                }
                case 1: {
                    CBORObject.WritePositiveInt(datatype, bytes[0] & 0xFF, stream);
                    break;
                }
                case 2: {
                    stream.write((byte)(datatype << 5 | 0x19));
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 3: {
                    stream.write((byte)(datatype << 5 | 0x1A));
                    stream.write(0);
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 4: {
                    stream.write((byte)(datatype << 5 | 0x1A));
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 5: {
                    stream.write((byte)(datatype << 5 | 0x1B));
                    stream.write(0);
                    stream.write(0);
                    stream.write(0);
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 6: {
                    stream.write((byte)(datatype << 5 | 0x1B));
                    stream.write(0);
                    stream.write(0);
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 7: {
                    stream.write((byte)(datatype << 5 | 0x1B));
                    stream.write(0);
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 8: {
                    stream.write((byte)(datatype << 5 | 0x1B));
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                default: {
                    stream.write(datatype == 0 ? -62 : -61);
                    CBORObject.WritePositiveInt(2, byteCount, stream);
                    stream.write(bytes, 0, byteCount);
                }
            }
        }
    }

    public static void Write(long value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (value >= 0L) {
            CBORObject.WritePositiveInt64(0, value, stream);
        } else {
            ++value;
            value = -value;
            CBORObject.WritePositiveInt64(1, value, stream);
        }
    }

    public static void Write(int value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        int type = 0;
        if (value < 0) {
            ++value;
            value = -value;
            type = 32;
        }
        if (value < 24) {
            stream.write((byte)(value | type));
        } else if (value <= 255) {
            byte[] bytes = new byte[]{(byte)(0x18 | type), (byte)(value & 0xFF)};
            stream.write(bytes, 0, 2);
        } else if (value <= 65535) {
            byte[] bytes = new byte[]{(byte)(0x19 | type), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
            stream.write(bytes, 0, 3);
        } else {
            byte[] bytes = new byte[]{(byte)(0x1A | type), (byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
            stream.write(bytes, 0, 5);
        }
    }

    public static void Write(short value, OutputStream stream) throws IOException {
        CBORObject.Write((long)value, stream);
    }

    public static void Write(char value, OutputStream stream) throws IOException {
        if (value >= '\ud800' && value < '\ue000') {
            throw new IllegalArgumentException("Value is a surrogate code point.");
        }
        char[] valueChar = new char[]{value};
        CBORObject.Write(new String(valueChar), stream);
    }

    public static void Write(boolean value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        stream.write(value ? -11 : -12);
    }

    public static void Write(byte value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if ((value & 0xFF) < 24) {
            stream.write(value);
        } else {
            stream.write(24);
            stream.write(value);
        }
    }

    public static void Write(float value, OutputStream s) throws IOException {
        if (s == null) {
            throw new NullPointerException("s");
        }
        int bits = Float.floatToRawIntBits(value);
        byte[] data = new byte[]{-6, (byte)(bits >> 24 & 0xFF), (byte)(bits >> 16 & 0xFF), (byte)(bits >> 8 & 0xFF), (byte)(bits & 0xFF)};
        s.write(data, 0, 5);
    }

    public static void Write(double value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        long bits = Double.doubleToRawLongBits(value);
        byte[] data = new byte[]{-5, (byte)(bits >> 56 & 0xFFL), (byte)(bits >> 48 & 0xFFL), (byte)(bits >> 40 & 0xFFL), (byte)(bits >> 32 & 0xFFL), (byte)(bits >> 24 & 0xFFL), (byte)(bits >> 16 & 0xFFL), (byte)(bits >> 8 & 0xFFL), (byte)(bits & 0xFFL)};
        stream.write(data, 0, 9);
    }

    public static void Write(CBORObject value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (value == null) {
            stream.write(246);
        } else {
            value.WriteTo(stream);
        }
    }

    public static void Write(Object objValue, OutputStream stream) throws IOException {
        CBORObject.Write(objValue, stream, CBOREncodeOptions.None);
    }

    public static void Write(Object objValue, OutputStream output, CBOREncodeOptions options) throws IOException {
        byte[] data;
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (output == null) {
            throw new NullPointerException("output");
        }
        if (objValue == null) {
            output.write(246);
            return;
        }
        byte[] byArray = data = objValue instanceof byte[] ? (byte[])objValue : null;
        if (data != null) {
            CBORObject.WritePositiveInt(3, data.length, output);
            output.write(data, 0, data.length);
            return;
        }
        if (objValue instanceof List) {
            CBORObject.WriteObjectArray((List)objValue, output, options);
            return;
        }
        if (objValue instanceof Map) {
            CBORObject.WriteObjectMap((Map)objValue, output, options);
            return;
        }
        CBORObject.FromObject(objValue).WriteTo(output);
    }

    public static void WriteJSON(Object obj, OutputStream outputStream) throws IOException {
        if (obj == null) {
            outputStream.write(ValueNullBytes, 0, ValueNullBytes.length);
            return;
        }
        if (obj instanceof Boolean) {
            if (((Boolean)obj).booleanValue()) {
                outputStream.write(ValueTrueBytes, 0, ValueTrueBytes.length);
                return;
            }
            outputStream.write(ValueFalseBytes, 0, ValueFalseBytes.length);
            return;
        }
        CBORObject.FromObject(obj).WriteJSONTo(outputStream);
    }

    public CBORObject Abs() {
        ERational rat;
        Object newItem;
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("This Object is not a number.");
        }
        Object oldItem = this.getThisItem();
        if (oldItem == (newItem = cn.Abs(oldItem))) {
            return this;
        }
        if (newItem instanceof EDecimal) {
            return CBORObject.FromObject((EDecimal)newItem);
        }
        if (newItem instanceof EInteger) {
            return CBORObject.FromObject((EInteger)newItem);
        }
        if (newItem instanceof EFloat) {
            return CBORObject.FromObject((EFloat)newItem);
        }
        ERational eRational = rat = newItem instanceof ERational ? (ERational)newItem : null;
        return rat != null ? CBORObject.FromObject(rat) : (oldItem == newItem ? this : CBORObject.FromObject(newItem));
    }

    public CBORObject Add(Object key, Object valueOb) {
        Map<CBORObject, CBORObject> map;
        CBORObject mapValue;
        CBORObject mapKey;
        if (this.getItemType() == 5) {
            if (key == null) {
                mapKey = Null;
            } else {
                mapKey = key instanceof CBORObject ? (CBORObject)key : null;
                CBORObject cBORObject = mapKey = mapKey == null ? CBORObject.FromObject(key) : mapKey;
            }
            if (valueOb == null) {
                mapValue = Null;
            } else {
                mapValue = valueOb instanceof CBORObject ? (CBORObject)valueOb : null;
                mapValue = mapValue == null ? CBORObject.FromObject(valueOb) : mapValue;
            }
            map = this.AsMap();
            if (map.containsKey(mapKey)) {
                throw new IllegalArgumentException("Key already exists");
            }
        } else {
            throw new IllegalStateException("Not a map");
        }
        map.put(mapKey, mapValue);
        return this;
    }

    public CBORObject Add(CBORObject obj) {
        if (this.getItemType() == 4) {
            List<CBORObject> list = this.AsList();
            list.add(obj);
            return this;
        }
        throw new IllegalStateException("Not an array");
    }

    public CBORObject Add(Object obj) {
        if (this.getItemType() == 4) {
            List<CBORObject> list = this.AsList();
            list.add(CBORObject.FromObject(obj));
            return this;
        }
        throw new IllegalStateException("Not an array");
    }

    public BigInteger AsBigInteger() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return BigInteger.fromBytes(cn.AsBigInteger(this.getThisItem()).ToBytes(true), true);
    }

    EInteger AsEInteger() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.AsBigInteger(this.getThisItem());
    }

    public boolean AsBoolean() {
        return !this.isFalse() && !this.isNull() && !this.isUndefined();
    }

    public byte AsByte() {
        return (byte)this.AsInt32(0, 255);
    }

    public double AsDouble() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.AsDouble(this.getThisItem());
    }

    public ExtendedDecimal AsExtendedDecimal() {
        return ExtendedDecimal.FromString(this.AsEDecimal().toString());
    }

    EDecimal AsEDecimal() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.AsExtendedDecimal(this.getThisItem());
    }

    public ExtendedFloat AsExtendedFloat() {
        return ExtendedFloat.FromString(this.AsEFloat().toString());
    }

    EFloat AsEFloat() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.AsExtendedFloat(this.getThisItem());
    }

    public ExtendedRational AsExtendedRational() {
        return PropertyMap.ToLegacy(this.AsERational());
    }

    ERational AsERational() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.AsExtendedRational(this.getThisItem());
    }

    public short AsInt16() {
        return (short)this.AsInt32(Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public int AsInt32() {
        return this.AsInt32(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public long AsInt64() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.AsInt64(this.getThisItem());
    }

    public float AsSingle() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.AsSingle(this.getThisItem());
    }

    public String AsString() {
        int type = this.getItemType();
        switch (type) {
            case 3: {
                return (String)this.getThisItem();
            }
        }
        throw new IllegalStateException("Not a String type");
    }

    public boolean CanFitInDouble() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        return cn != null && cn.CanFitInDouble(this.getThisItem());
    }

    public boolean CanFitInInt32() {
        if (!this.CanFitInInt64()) {
            return false;
        }
        long v = this.AsInt64();
        return v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE;
    }

    public boolean CanFitInInt64() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        return cn != null && cn.CanFitInInt64(this.getThisItem());
    }

    public boolean CanFitInSingle() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        return cn != null && cn.CanFitInSingle(this.getThisItem());
    }

    public boolean CanTruncatedIntFitInInt32() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        return cn != null && cn.CanTruncatedIntFitInInt32(this.getThisItem());
    }

    public boolean CanTruncatedIntFitInInt64() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        return cn != null && cn.CanTruncatedIntFitInInt64(this.getThisItem());
    }

    @Override
    public int compareTo(CBORObject other) {
        int cmp;
        block57: {
            int s2;
            Object objB;
            Object objA;
            int typeB;
            int typeA;
            block58: {
                block56: {
                    if (other == null) {
                        return 1;
                    }
                    if (this == other) {
                        return 0;
                    }
                    typeA = this.getItemType();
                    typeB = other.getItemType();
                    objA = this.getThisItem();
                    objB = other.getThisItem();
                    int simpleValueA = -1;
                    int simpleValueB = -1;
                    if (typeA == 6) {
                        if ((Integer)objA == 20) {
                            simpleValueA = 2;
                        } else if ((Integer)objA == 21) {
                            simpleValueA = 3;
                        } else if ((Integer)objA == 22) {
                            simpleValueA = 1;
                        } else if ((Integer)objA == 23) {
                            simpleValueA = 0;
                        }
                    }
                    if (typeB == 6) {
                        if ((Integer)objB == 20) {
                            simpleValueB = 2;
                        } else if ((Integer)objB == 21) {
                            simpleValueB = 3;
                        } else if ((Integer)objB == 22) {
                            simpleValueB = 1;
                        } else if ((Integer)objB == 23) {
                            simpleValueB = 0;
                        }
                    }
                    cmp = 0;
                    if (simpleValueA < 0 && simpleValueB < 0) break block56;
                    if (simpleValueB < 0) {
                        return -1;
                    }
                    if (simpleValueA < 0) {
                        return 1;
                    }
                    cmp = simpleValueA == simpleValueB ? 0 : (simpleValueA < simpleValueB ? -1 : 1);
                    break block57;
                }
                if (typeA != typeB) break block58;
                switch (typeA) {
                    case 0: {
                        long a = (Long)objA;
                        long b = (Long)objB;
                        cmp = a == b ? 0 : (a < b ? -1 : 1);
                        break block57;
                    }
                    case 7: {
                        float a = ((Float)objA).floatValue();
                        float b = ((Float)objB).floatValue();
                        cmp = Float.isNaN(a) ? (Float.isNaN(b) ? 0 : 1) : (Float.isNaN(b) ? -1 : (a == b ? 0 : (a < b ? -1 : 1)));
                        break block57;
                    }
                    case 1: {
                        EInteger bigintA = (EInteger)objA;
                        EInteger bigintB = (EInteger)objB;
                        cmp = bigintA.compareTo(bigintB);
                        break block57;
                    }
                    case 8: {
                        double a = (Double)objA;
                        double b = (Double)objB;
                        cmp = Double.isNaN(a) ? (Double.isNaN(b) ? 0 : 1) : (Double.isNaN(b) ? -1 : (a == b ? 0 : (a < b ? -1 : 1)));
                        break block57;
                    }
                    case 9: {
                        cmp = ((EDecimal)objA).compareTo((EDecimal)objB);
                        break block57;
                    }
                    case 11: {
                        cmp = ((EFloat)objA).compareTo((EFloat)objB);
                        break block57;
                    }
                    case 12: {
                        cmp = ((ERational)objA).compareTo((ERational)objB);
                        break block57;
                    }
                    case 2: {
                        cmp = CBORUtilities.ByteArrayCompare((byte[])objA, (byte[])objB);
                        break block57;
                    }
                    case 3: {
                        cmp = DataUtilities.CodePointCompare((String)objA, (String)objB);
                        break block57;
                    }
                    case 4: {
                        cmp = CBORObject.ListCompare((ArrayList)objA, (ArrayList)objB);
                        break block57;
                    }
                    case 5: {
                        cmp = CBORObject.MapCompare((Map)objA, (Map)objB);
                        break block57;
                    }
                    case 6: {
                        int valueA = (Integer)objA;
                        int valueB = (Integer)objB;
                        cmp = valueA == valueB ? 0 : (valueA < valueB ? -1 : 1);
                        break block57;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected data type");
                    }
                }
            }
            int typeOrderA = ValueNumberTypeOrder[typeA];
            int typeOrderB = ValueNumberTypeOrder[typeB];
            if (typeOrderA != typeOrderB) {
                return typeOrderA < typeOrderB ? -1 : 1;
            }
            int s1 = CBORObject.GetSignInternal(typeA, objA);
            if (s1 != (s2 = CBORObject.GetSignInternal(typeB, objB)) && s1 != 2 && s2 != 2) {
                return s1 < s2 ? -1 : 1;
            }
            if (s1 == 2 && s2 == 2) {
                cmp = 0;
            } else {
                if (s1 == 2) {
                    return 1;
                }
                if (s2 == 2) {
                    return -1;
                }
                if (typeA == 12) {
                    ERational e1 = NumberInterfaces[typeA].AsExtendedRational(objA);
                    if (typeB == 9) {
                        EDecimal e2 = NumberInterfaces[typeB].AsExtendedDecimal(objB);
                        cmp = e1.CompareToDecimal(e2);
                    } else {
                        EFloat e2 = NumberInterfaces[typeB].AsExtendedFloat(objB);
                        cmp = e1.CompareToBinary(e2);
                    }
                } else if (typeB == 12) {
                    ERational e2 = NumberInterfaces[typeB].AsExtendedRational(objB);
                    if (typeA == 9) {
                        EDecimal e1 = NumberInterfaces[typeA].AsExtendedDecimal(objA);
                        cmp = e2.CompareToDecimal(e1);
                        cmp = -cmp;
                    } else {
                        EFloat e1 = NumberInterfaces[typeA].AsExtendedFloat(objA);
                        cmp = e2.CompareToBinary(e1);
                        cmp = -cmp;
                    }
                } else if (typeA == 9 || typeB == 9) {
                    EDecimal e1 = null;
                    EDecimal e2 = null;
                    if (typeA == 11) {
                        EFloat ef1 = (EFloat)objA;
                        e2 = (EDecimal)objB;
                        cmp = e2.CompareToBinary(ef1);
                        cmp = -cmp;
                    } else if (typeB == 11) {
                        EFloat ef1 = (EFloat)objB;
                        e2 = (EDecimal)objA;
                        cmp = e2.CompareToBinary(ef1);
                    } else {
                        e1 = NumberInterfaces[typeA].AsExtendedDecimal(objA);
                        e2 = NumberInterfaces[typeB].AsExtendedDecimal(objB);
                        cmp = e1.compareTo(e2);
                    }
                } else if (typeA == 11 || typeB == 11 || typeA == 8 || typeB == 8 || typeA == 7 || typeB == 7) {
                    EFloat e1 = NumberInterfaces[typeA].AsExtendedFloat(objA);
                    EFloat e2 = NumberInterfaces[typeB].AsExtendedFloat(objB);
                    cmp = e1.compareTo(e2);
                } else {
                    EInteger b1 = NumberInterfaces[typeA].AsBigInteger(objA);
                    EInteger b2 = NumberInterfaces[typeB].AsBigInteger(objB);
                    cmp = b1.compareTo(b2);
                }
            }
        }
        return cmp == 0 ? (!this.isTagged() && !other.isTagged() ? 0 : CBORObject.TagsCompare(this.GetTagsEInteger(), other.GetTagsEInteger())) : cmp;
    }

    public int CompareToIgnoreTags(CBORObject other) {
        return other == null ? 1 : (this == other ? 0 : this.Untag().compareTo(other.Untag()));
    }

    public boolean ContainsKey(CBORObject key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> map = this.AsMap();
            return map.containsKey(key);
        }
        return false;
    }

    public boolean ContainsKey(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> map = this.AsMap();
            return map.containsKey(CBORObject.FromObject(key));
        }
        return false;
    }

    public byte[] EncodeToBytes() {
        return this.EncodeToBytes(CBOREncodeOptions.None);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] EncodeToBytes(CBOREncodeOptions options) {
        byte[] byArray;
        if (options == null) {
            throw new NullPointerException("options");
        }
        boolean hasComplexTag = false;
        byte tagbyte = 0;
        boolean tagged = this.isTagged();
        if (this.isTagged()) {
            CBORObject taggedItem = (CBORObject)this.itemValue;
            if (taggedItem.isTagged() || this.tagHigh != 0 || this.tagLow >> 16 != 0 || this.tagLow >= 24) {
                hasComplexTag = true;
            } else {
                tagbyte = (byte)(192 + this.tagLow);
            }
        }
        if (!hasComplexTag) {
            switch (this.getItemType()) {
                case 3: {
                    byte[] ret = CBORObject.GetOptimizedBytesIfShortAscii(this.AsString(), tagged ? tagbyte & 0xFF : -1);
                    if (ret == null) break;
                    return ret;
                }
                case 6: {
                    if (tagged) {
                        if (this.isFalse()) {
                            return new byte[]{tagbyte, -12};
                        }
                        if (this.isTrue()) {
                            return new byte[]{tagbyte, -11};
                        }
                        if (this.isNull()) {
                            return new byte[]{tagbyte, -10};
                        }
                        if (!this.isUndefined()) break;
                        return new byte[]{tagbyte, -9};
                    }
                    if (this.isFalse()) {
                        return new byte[]{-12};
                    }
                    if (this.isTrue()) {
                        return new byte[]{-11};
                    }
                    if (this.isNull()) {
                        return new byte[]{-10};
                    }
                    if (!this.isUndefined()) break;
                    return new byte[]{-9};
                }
                case 0: {
                    long value = (Long)this.getThisItem();
                    byte[] intBytes = null;
                    if (value >= 0L) {
                        intBytes = CBORObject.GetPositiveInt64Bytes(0, value);
                    } else {
                        ++value;
                        value = -value;
                        intBytes = CBORObject.GetPositiveInt64Bytes(1, value);
                    }
                    if (!tagged) {
                        return intBytes;
                    }
                    byte[] ret2 = new byte[intBytes.length + 1];
                    System.arraycopy(intBytes, 0, ret2, 1, intBytes.length);
                    ret2[0] = tagbyte;
                    return ret2;
                }
                case 7: {
                    byte[] byArray2;
                    float value = ((Float)this.getThisItem()).floatValue();
                    int bits = Float.floatToRawIntBits(value);
                    if (tagged) {
                        byte[] byArray3 = new byte[6];
                        byArray3[0] = tagbyte;
                        byArray3[1] = -6;
                        byArray3[2] = (byte)(bits >> 24 & 0xFF);
                        byArray3[3] = (byte)(bits >> 16 & 0xFF);
                        byArray3[4] = (byte)(bits >> 8 & 0xFF);
                        byArray2 = byArray3;
                        byArray3[5] = (byte)(bits & 0xFF);
                    } else {
                        byte[] byArray4 = new byte[5];
                        byArray4[0] = -6;
                        byArray4[1] = (byte)(bits >> 24 & 0xFF);
                        byArray4[2] = (byte)(bits >> 16 & 0xFF);
                        byArray4[3] = (byte)(bits >> 8 & 0xFF);
                        byArray2 = byArray4;
                        byArray4[4] = (byte)(bits & 0xFF);
                    }
                    return byArray2;
                }
                case 8: {
                    byte[] byArray5;
                    double value = (Double)this.getThisItem();
                    long bits = Double.doubleToRawLongBits(value);
                    if (tagged) {
                        byte[] byArray6 = new byte[10];
                        byArray6[0] = tagbyte;
                        byArray6[1] = -5;
                        byArray6[2] = (byte)(bits >> 56 & 0xFFL);
                        byArray6[3] = (byte)(bits >> 48 & 0xFFL);
                        byArray6[4] = (byte)(bits >> 40 & 0xFFL);
                        byArray6[5] = (byte)(bits >> 32 & 0xFFL);
                        byArray6[6] = (byte)(bits >> 24 & 0xFFL);
                        byArray6[7] = (byte)(bits >> 16 & 0xFFL);
                        byArray6[8] = (byte)(bits >> 8 & 0xFFL);
                        byArray5 = byArray6;
                        byArray6[9] = (byte)(bits & 0xFFL);
                    } else {
                        byte[] byArray7 = new byte[9];
                        byArray7[0] = -5;
                        byArray7[1] = (byte)(bits >> 56 & 0xFFL);
                        byArray7[2] = (byte)(bits >> 48 & 0xFFL);
                        byArray7[3] = (byte)(bits >> 40 & 0xFFL);
                        byArray7[4] = (byte)(bits >> 32 & 0xFFL);
                        byArray7[5] = (byte)(bits >> 24 & 0xFFL);
                        byArray7[6] = (byte)(bits >> 16 & 0xFFL);
                        byArray7[7] = (byte)(bits >> 8 & 0xFFL);
                        byArray5 = byArray7;
                        byArray7[8] = (byte)(bits & 0xFFL);
                    }
                    return byArray5;
                }
            }
        }
        ByteArrayOutputStream ms = null;
        try {
            ms = new ByteArrayOutputStream(16);
            this.WriteTo(ms, options);
            byArray = ms.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (ms != null) {
                        ms.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new CBORException("I/O Error occurred", ex);
            }
        }
        try {
            if (ms != null) {
                ms.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return byArray;
    }

    public boolean equals(Object obj) {
        return this.equals(obj instanceof CBORObject ? (CBORObject)obj : null);
    }

    public boolean equals(CBORObject other) {
        CBORObject otherValue;
        CBORObject cBORObject = otherValue = other instanceof CBORObject ? other : null;
        if (otherValue == null) {
            return false;
        }
        if (this == otherValue) {
            return true;
        }
        switch (this.itemtypeValue) {
            case 2: {
                if (CBORUtilities.ByteArrayEquals((byte[])this.getThisItem(), otherValue.itemValue instanceof byte[] ? (byte[])otherValue.itemValue : null)) break;
                return false;
            }
            case 5: {
                Map cbordict;
                Map map = cbordict = otherValue.itemValue instanceof Map ? (Map)otherValue.itemValue : null;
                if (CBORObject.CBORMapEquals(this.AsMap(), cbordict)) break;
                return false;
            }
            case 4: {
                if (CBORObject.CBORArrayEquals(this.AsList(), otherValue.itemValue instanceof List ? (List)otherValue.itemValue : null)) break;
                return false;
            }
            default: {
                if (this.itemValue != null ? this.itemValue.equals(otherValue.itemValue) : otherValue.itemValue == null) break;
                return false;
            }
        }
        return this.itemtypeValue == otherValue.itemtypeValue && this.tagLow == otherValue.tagLow && this.tagHigh == otherValue.tagHigh;
    }

    public byte[] GetByteString() {
        if (this.getItemType() == 2) {
            return (byte[])this.getThisItem();
        }
        throw new IllegalStateException("Not a byte String");
    }

    public int hashCode() {
        int valueHashCode = 651869431;
        if (this.itemValue != null) {
            int itemHashCode = 0;
            switch (this.itemtypeValue) {
                case 2: {
                    itemHashCode = CBORUtilities.ByteArrayHashCode((byte[])this.getThisItem());
                    break;
                }
                case 5: {
                    itemHashCode = CBORObject.CBORMapHashCode(this.AsMap());
                    break;
                }
                case 4: {
                    itemHashCode = CBORObject.CBORArrayHashCode(this.AsList());
                    break;
                }
                default: {
                    itemHashCode = this.itemValue.hashCode();
                }
            }
            valueHashCode += 651869479 * itemHashCode;
        }
        return valueHashCode += 651869483 * (this.itemtypeValue + this.tagLow + this.tagHigh);
    }

    public BigInteger[] GetTags() {
        EInteger[] etags = this.GetTagsEInteger();
        if (etags.length == 0) {
            return new BigInteger[0];
        }
        BigInteger[] bigret = new BigInteger[etags.length];
        for (int i = 0; i < bigret.length; ++i) {
            bigret[i] = PropertyMap.ToLegacy(etags[i]);
        }
        return bigret;
    }

    private EInteger[] GetTagsEInteger() {
        if (!this.isTagged()) {
            return ValueEmptyTags;
        }
        CBORObject curitem = this;
        if (curitem.isTagged()) {
            ArrayList<EInteger> list = new ArrayList<EInteger>();
            while (curitem.isTagged()) {
                list.add(CBORObject.LowHighToEInteger(curitem.tagLow, curitem.tagHigh));
                curitem = (CBORObject)curitem.itemValue;
            }
            return list.toArray(new EInteger[0]);
        }
        return new EInteger[]{CBORObject.LowHighToEInteger(this.tagLow, this.tagHigh)};
    }

    public boolean HasTag(int tagValue) {
        if (tagValue < 0) {
            throw new IllegalArgumentException("tagValue (" + tagValue + ") is less than 0");
        }
        CBORObject obj = this;
        while (obj.isTagged()) {
            if (obj.tagHigh == 0 && tagValue == obj.tagLow) {
                return true;
            }
            obj = (CBORObject)obj.itemValue;
        }
        return false;
    }

    public boolean HasTag(BigInteger bigTagValue) {
        if (bigTagValue == null) {
            throw new NullPointerException("bigTagValue");
        }
        return this.HasTag(EInteger.FromBytes((byte[])bigTagValue.toBytes(true), (boolean)true));
    }

    boolean HasTag(EInteger bigTagValue) {
        EInteger[] bigTags;
        if (bigTagValue == null) {
            throw new NullPointerException("bigTagValue");
        }
        if (bigTagValue.signum() < 0) {
            throw new IllegalArgumentException("doesn't satisfy bigTagValue.signum()>= 0");
        }
        for (EInteger bigTag : bigTags = this.GetTagsEInteger()) {
            if (!bigTagValue.equals((Object)bigTag)) continue;
            return true;
        }
        return false;
    }

    public CBORObject Insert(int index, Object valueOb) {
        CBORObject mapValue;
        List<CBORObject> list;
        if (this.getItemType() == 4) {
            list = this.AsList();
            if (index < 0 || index > list.size()) {
                throw new IllegalArgumentException("index");
            }
            if (valueOb == null) {
                mapValue = Null;
            } else {
                mapValue = valueOb instanceof CBORObject ? (CBORObject)valueOb : null;
                mapValue = mapValue == null ? CBORObject.FromObject(valueOb) : mapValue;
            }
        } else {
            throw new IllegalStateException("Not an array");
        }
        list.add(index, mapValue);
        return this;
    }

    public boolean IsInfinity() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        return cn != null && cn.IsInfinity(this.getThisItem());
    }

    public boolean IsNaN() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        return cn != null && cn.IsNaN(this.getThisItem());
    }

    public boolean IsNegativeInfinity() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        return cn != null && cn.IsNegativeInfinity(this.getThisItem());
    }

    public boolean IsPositiveInfinity() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        return cn != null && cn.IsPositiveInfinity(this.getThisItem());
    }

    public CBORObject Negate() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("This Object is not a number.");
        }
        Object newItem = cn.Negate(this.getThisItem());
        if (newItem instanceof EDecimal) {
            return CBORObject.FromObject((EDecimal)newItem);
        }
        if (newItem instanceof EInteger) {
            return CBORObject.FromObject((EInteger)newItem);
        }
        if (newItem instanceof EFloat) {
            return CBORObject.FromObject((EFloat)newItem);
        }
        ERational rat = newItem instanceof ERational ? (ERational)newItem : null;
        return rat != null ? CBORObject.FromObject(rat) : CBORObject.FromObject(newItem);
    }

    public boolean Remove(CBORObject obj) {
        if (obj == null) {
            throw new NullPointerException("obj");
        }
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> dict = this.AsMap();
            boolean hasKey = dict.containsKey(obj);
            if (hasKey) {
                dict.remove(obj);
                return true;
            }
            return false;
        }
        if (this.getItemType() == 4) {
            List<CBORObject> list = this.AsList();
            return list.remove(obj);
        }
        throw new IllegalStateException("Not a map or array");
    }

    public CBORObject Set(Object key, Object valueOb) {
        if (this.getItemType() == 5) {
            CBORObject mapValue;
            CBORObject mapKey;
            if (key == null) {
                mapKey = Null;
            } else {
                mapKey = key instanceof CBORObject ? (CBORObject)key : null;
                CBORObject cBORObject = mapKey = mapKey == null ? CBORObject.FromObject(key) : mapKey;
            }
            if (valueOb == null) {
                mapValue = Null;
            } else {
                mapValue = valueOb instanceof CBORObject ? (CBORObject)valueOb : null;
                mapValue = mapValue == null ? CBORObject.FromObject(valueOb) : mapValue;
            }
            Map<CBORObject, CBORObject> map = this.AsMap();
            if (map.containsKey(mapKey)) {
                map.put(mapKey, mapValue);
            } else {
                map.put(mapKey, mapValue);
            }
        } else {
            throw new IllegalStateException("Not a map");
        }
        return this;
    }

    public String ToJSONString() {
        int type = this.getItemType();
        switch (type) {
            case 6: {
                return this.isTrue() ? "true" : (this.isFalse() ? "false" : "null");
            }
            case 0: {
                return CBORUtilities.LongToString((Long)this.getThisItem());
            }
        }
        StringBuilder sb = new StringBuilder();
        try {
            CBORJson.WriteJSONToInternal(this, new StringOutput(sb));
        }
        catch (IOException ex) {
            throw new IllegalStateException("Internal error", ex);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = null;
        String simvalue = null;
        int type = this.getItemType();
        if (this.isTagged()) {
            if (sb == null) {
                if (type == 3) {
                    String str = this.AsString();
                    sb = new StringBuilder(Math.min(str.length(), 4096) + 16);
                } else {
                    sb = new StringBuilder();
                }
            }
            this.AppendOpeningTags(sb);
        }
        switch (type) {
            case 6: {
                if (this.isTrue()) {
                    simvalue = "true";
                    if (sb == null) {
                        return simvalue;
                    }
                    sb.append(simvalue);
                    break;
                }
                if (this.isFalse()) {
                    simvalue = "false";
                    if (sb == null) {
                        return simvalue;
                    }
                    sb.append(simvalue);
                    break;
                }
                if (this.isNull()) {
                    simvalue = "null";
                    if (sb == null) {
                        return simvalue;
                    }
                    sb.append(simvalue);
                    break;
                }
                if (this.isUndefined()) {
                    simvalue = "undefined";
                    if (sb == null) {
                        return simvalue;
                    }
                    sb.append(simvalue);
                    break;
                }
                sb = sb == null ? new StringBuilder() : sb;
                sb.append("simple(");
                int thisItemInt = (Integer)this.getThisItem();
                sb.append(CBORUtilities.LongToString(thisItemInt));
                sb.append(")");
                break;
            }
            case 7: {
                float f = ((Float)this.getThisItem()).floatValue();
                String string = f == Float.NEGATIVE_INFINITY ? "-Infinity" : (f == Float.POSITIVE_INFINITY ? "Infinity" : (simvalue = Float.isNaN(f) ? "NaN" : CBORObject.TrimDotZero(CBORUtilities.SingleToString(f))));
                if (sb == null) {
                    return simvalue;
                }
                sb.append(simvalue);
                break;
            }
            case 8: {
                double f = (Double)this.getThisItem();
                String string = f == Double.NEGATIVE_INFINITY ? "-Infinity" : (f == Double.POSITIVE_INFINITY ? "Infinity" : (simvalue = Double.isNaN(f) ? "NaN" : CBORObject.TrimDotZero(CBORUtilities.DoubleToString(f))));
                if (sb == null) {
                    return simvalue;
                }
                sb.append(simvalue);
                break;
            }
            case 11: {
                simvalue = CBORObject.ExtendedToString((EFloat)this.getThisItem());
                if (sb == null) {
                    return simvalue;
                }
                sb.append(simvalue);
                break;
            }
            case 0: {
                long v = (Long)this.getThisItem();
                simvalue = CBORUtilities.LongToString(v);
                if (sb == null) {
                    return simvalue;
                }
                sb.append(simvalue);
                break;
            }
            case 1: {
                simvalue = CBORUtilities.BigIntToString((EInteger)this.getThisItem());
                if (sb == null) {
                    return simvalue;
                }
                sb.append(simvalue);
                break;
            }
            case 2: {
                sb = sb == null ? new StringBuilder() : sb;
                sb.append("h'");
                CBORUtilities.ToBase16(sb, (byte[])this.getThisItem());
                sb.append("'");
                break;
            }
            case 3: {
                if (sb == null) {
                    return "\"" + this.AsString() + "\"";
                }
                sb.append('\"');
                sb.append(this.AsString());
                sb.append('\"');
                break;
            }
            case 4: {
                sb = sb == null ? new StringBuilder() : sb;
                boolean first = true;
                sb.append("[");
                for (CBORObject i : this.AsList()) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(i.toString());
                    first = false;
                }
                sb.append("]");
                break;
            }
            case 5: {
                sb = sb == null ? new StringBuilder() : sb;
                boolean first = true;
                sb.append("{");
                Map<CBORObject, CBORObject> map = this.AsMap();
                for (Map.Entry<CBORObject, CBORObject> entry : map.entrySet()) {
                    CBORObject key = entry.getKey();
                    CBORObject value = entry.getValue();
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(key.toString());
                    sb.append(": ");
                    sb.append(value.toString());
                    first = false;
                }
                sb.append("}");
                break;
            }
            default: {
                if (sb == null) {
                    return this.getThisItem().toString();
                }
                sb.append(this.getThisItem().toString());
            }
        }
        if (this.isTagged()) {
            this.AppendClosingTags(sb);
        }
        return sb.toString();
    }

    public CBORObject Untag() {
        CBORObject curobject = this;
        while (curobject.itemtypeValue == 10) {
            curobject = (CBORObject)curobject.itemValue;
        }
        return curobject;
    }

    public CBORObject UntagOne() {
        return this.itemtypeValue == 10 ? (CBORObject)this.itemValue : this;
    }

    public void WriteJSONTo(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        CBORJson.WriteJSONToInternal(this, new StringOutput(outputStream));
    }

    public void WriteTo(OutputStream stream) throws IOException {
        this.WriteTo(stream, CBOREncodeOptions.None);
    }

    public void WriteTo(OutputStream stream, CBOREncodeOptions options) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        this.WriteTags(stream);
        int type = this.getItemType();
        switch (type) {
            case 0: {
                CBORObject.Write((Long)this.getThisItem(), stream);
                break;
            }
            case 1: {
                CBORObject.Write((EInteger)this.getThisItem(), stream);
                break;
            }
            case 2: {
                byte[] arr = (byte[])this.getThisItem();
                CBORObject.WritePositiveInt(this.getItemType() == 2 ? 2 : 3, arr.length, stream);
                stream.write(arr, 0, arr.length);
                break;
            }
            case 3: {
                CBORObject.Write((String)this.getThisItem(), stream, options);
                break;
            }
            case 4: {
                CBORObject.WriteObjectArray(this.AsList(), stream, options);
                break;
            }
            case 9: {
                EDecimal dec = (EDecimal)this.getThisItem();
                CBORObject.Write(dec, stream);
                break;
            }
            case 11: {
                EFloat flo = (EFloat)this.getThisItem();
                CBORObject.Write(flo, stream);
                break;
            }
            case 12: {
                ERational flo = (ERational)this.getThisItem();
                CBORObject.Write(flo, stream);
                break;
            }
            case 5: {
                CBORObject.WriteObjectMap(this.AsMap(), stream, options);
                break;
            }
            case 6: {
                int value = (Integer)this.getThisItem();
                if (value < 24) {
                    stream.write((byte)(224 + value));
                    break;
                }
                stream.write(248);
                stream.write((byte)value);
                break;
            }
            case 7: {
                CBORObject.Write(((Float)this.getThisItem()).floatValue(), stream);
                break;
            }
            case 8: {
                CBORObject.Write((Double)this.getThisItem(), stream);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected data type");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ICBORTag FindTagConverter(EInteger bigintTag) {
        if (CBORObject.TagHandlersEmpty()) {
            CBORObject.AddTagHandler(EInteger.FromInt64((long)2L), (ICBORTag)new CBORTag2());
            CBORObject.AddTagHandler(EInteger.FromInt64((long)3L), (ICBORTag)new CBORTag3());
            CBORObject.AddTagHandler(EInteger.FromInt64((long)4L), (ICBORTag)new CBORTag4());
            CBORObject.AddTagHandler(EInteger.FromInt64((long)5L), (ICBORTag)new CBORTag5());
            CBORObject.AddTagHandler(EInteger.FromInt64((long)264L), (ICBORTag)new CBORTag4(true));
            CBORObject.AddTagHandler(EInteger.FromInt64((long)265L), (ICBORTag)new CBORTag5(true));
            CBORObject.AddTagHandler(EInteger.FromInt64((long)25L), (ICBORTag)new CBORTagUnsigned());
            CBORObject.AddTagHandler(EInteger.FromInt64((long)28L), (ICBORTag)new CBORTag28());
            CBORObject.AddTagHandler(EInteger.FromInt64((long)29L), (ICBORTag)new CBORTagUnsigned());
            CBORObject.AddTagHandler(EInteger.FromInt64((long)256L), (ICBORTag)new CBORTagAny());
            CBORObject.AddTagHandler(EInteger.FromInt32((int)0), (ICBORTag)new CBORTag0());
            CBORObject.AddTagHandler(EInteger.FromInt64((long)32L), (ICBORTag)new CBORTag32());
            CBORObject.AddTagHandler(EInteger.FromInt64((long)33L), (ICBORTag)new CBORTagGenericString());
            CBORObject.AddTagHandler(EInteger.FromInt64((long)34L), (ICBORTag)new CBORTagGenericString());
            CBORObject.AddTagHandler(EInteger.FromInt64((long)35L), (ICBORTag)new CBORTagGenericString());
            CBORObject.AddTagHandler(EInteger.FromInt64((long)36L), (ICBORTag)new CBORTagGenericString());
            CBORObject.AddTagHandler(EInteger.FromInt64((long)37L), (ICBORTag)new CBORTag37());
            CBORObject.AddTagHandler(EInteger.FromInt64((long)30L), (ICBORTag)new CBORTag30());
        }
        Map<EInteger, ICBORTag> map = ValueTagHandlers;
        synchronized (map) {
            if (ValueTagHandlers.containsKey(bigintTag)) {
                return ValueTagHandlers.get(bigintTag);
            }
            return null;
        }
    }

    static ICBORTag FindTagConverterLong(long tagLong) {
        return CBORObject.FindTagConverter(EInteger.FromInt64((long)tagLong));
    }

    static CBORObject FromRaw(String str) {
        return new CBORObject(3, str);
    }

    static CBORObject FromRaw(List<CBORObject> list) {
        return new CBORObject(4, list);
    }

    static CBORObject FromRaw(Map<CBORObject, CBORObject> map) {
        return new CBORObject(5, map);
    }

    static int GetExpectedLength(int value) {
        return ValueExpectedLengths[value];
    }

    static CBORObject GetFixedLengthObject(int firstbyte, byte[] data) {
        Object ret;
        String s;
        CBORObject fixedObj = valueFixedObjects[firstbyte];
        if (fixedObj != null) {
            return fixedObj;
        }
        int majortype = firstbyte >> 5;
        if (firstbyte >= 97 && firstbyte < 120 && (s = CBORObject.GetOptimizedStringIfShortAscii(data, 0)) != null) {
            return new CBORObject(3, s);
        }
        if ((firstbyte & 0x1C) == 24) {
            long uadditional = 0L;
            switch (firstbyte & 0x1F) {
                case 24: {
                    uadditional = data[1] & 0xFF;
                    break;
                }
                case 25: {
                    uadditional = ((long)data[1] & 0xFFL) << 8;
                    uadditional |= (long)data[2] & 0xFFL;
                    break;
                }
                case 26: {
                    uadditional = ((long)data[1] & 0xFFL) << 24;
                    uadditional |= ((long)data[2] & 0xFFL) << 16;
                    uadditional |= ((long)data[3] & 0xFFL) << 8;
                    uadditional |= (long)data[4] & 0xFFL;
                    break;
                }
                case 27: {
                    uadditional = ((long)data[1] & 0xFFL) << 56;
                    uadditional |= ((long)data[2] & 0xFFL) << 48;
                    uadditional |= ((long)data[3] & 0xFFL) << 40;
                    uadditional |= ((long)data[4] & 0xFFL) << 32;
                    uadditional |= ((long)data[5] & 0xFFL) << 24;
                    uadditional |= ((long)data[6] & 0xFFL) << 16;
                    uadditional |= ((long)data[7] & 0xFFL) << 8;
                    uadditional |= (long)data[8] & 0xFFL;
                    break;
                }
                default: {
                    throw new CBORException("Unexpected data encountered");
                }
            }
            switch (majortype) {
                case 0: {
                    if (uadditional >> 63 == 0L) {
                        return new CBORObject(0, uadditional);
                    }
                    int low = (int)(uadditional & 0xFFFFFFFFL);
                    int high = (int)(uadditional >> 32 & 0xFFFFFFFFL);
                    return CBORObject.FromObject(CBORObject.LowHighToEInteger(low, high));
                }
                case 1: {
                    if (uadditional >> 63 == 0L) {
                        return new CBORObject(0, -1L - uadditional);
                    }
                    int low = (int)(uadditional & 0xFFFFFFFFL);
                    int high = (int)(uadditional >> 32 & 0xFFFFFFFFL);
                    EInteger bigintAdditional = CBORObject.LowHighToEInteger(low, high);
                    EInteger minusOne = EInteger.FromInt64((long)-1L);
                    bigintAdditional = minusOne.Subtract(bigintAdditional);
                    return CBORObject.FromObject(bigintAdditional);
                }
                case 7: {
                    if (firstbyte == 249) {
                        return new CBORObject(7, Float.valueOf(CBORUtilities.HalfPrecisionToSingle((int)uadditional)));
                    }
                    if (firstbyte == 250) {
                        float flt = Float.intBitsToFloat((int)uadditional);
                        return new CBORObject(7, Float.valueOf(flt));
                    }
                    if (firstbyte == 251) {
                        double flt = Double.longBitsToDouble(uadditional);
                        return new CBORObject(8, flt);
                    }
                    if (firstbyte == 248) {
                        if ((int)uadditional < 32) {
                            throw new CBORException("Invalid overlong simple value");
                        }
                        return new CBORObject(6, (int)uadditional);
                    }
                    throw new CBORException("Unexpected data encountered");
                }
            }
            throw new CBORException("Unexpected data encountered");
        }
        if (majortype == 2) {
            ret = new byte[firstbyte - 64];
            System.arraycopy(data, 1, ret, 0, firstbyte - 64);
            return new CBORObject(2, ret);
        }
        if (majortype == 3) {
            ret = new StringBuilder(firstbyte - 96);
            DataUtilities.ReadUtf8FromBytes(data, 1, firstbyte - 96, (StringBuilder)ret, false);
            return new CBORObject(3, ((StringBuilder)ret).toString());
        }
        if (firstbyte == 128) {
            return CBORObject.FromObject(new ArrayList());
        }
        if (firstbyte == 160) {
            return CBORObject.FromObject(new HashMap());
        }
        throw new CBORException("Unexpected data encountered");
    }

    static CBORObject GetFixedObject(int value) {
        return valueFixedObjects[value];
    }

    static ICBORNumber GetNumberInterface(int type) {
        return NumberInterfaces[type];
    }

    static String TrimDotZero(String str) {
        return str.length() > 2 && str.charAt(str.length() - 1) == '0' && str.charAt(str.length() - 2) == '.' ? str.substring(0, str.length() - 2) : str;
    }

    List<CBORObject> AsList() {
        return (List)this.getThisItem();
    }

    Map<CBORObject, CBORObject> AsMap() {
        return (Map)this.getThisItem();
    }

    void Redefine(CBORObject cbor) {
        this.itemtypeValue = cbor.itemtypeValue;
        this.tagLow = cbor.tagLow;
        this.tagHigh = cbor.tagHigh;
        this.itemValue = cbor.itemValue;
    }

    private static boolean BigIntFits(EInteger bigint) {
        return bigint.GetSignedBitLength() <= 64;
    }

    private static boolean CBORArrayEquals(List<CBORObject> listA, List<CBORObject> listB) {
        int listBCount;
        if (listA == null) {
            return listB == null;
        }
        if (listB == null) {
            return false;
        }
        int listACount = listA.size();
        if (listACount != (listBCount = listB.size())) {
            return false;
        }
        for (int i = 0; i < listACount; ++i) {
            CBORObject itemA = listA.get(i);
            CBORObject itemB = listB.get(i);
            if (itemA != null ? itemA.equals(itemB) : itemB == null) continue;
            return false;
        }
        return true;
    }

    private static int CBORArrayHashCode(List<CBORObject> list) {
        if (list == null) {
            return 0;
        }
        int ret = 19;
        int count = list.size();
        ret = ret * 31 + count;
        for (int i = 0; i < count; ++i) {
            ret = ret * 31 + list.get(i).hashCode();
        }
        return ret;
    }

    private static boolean CBORMapEquals(Map<CBORObject, CBORObject> mapA, Map<CBORObject, CBORObject> mapB) {
        if (mapA == null) {
            return mapB == null;
        }
        if (mapB == null) {
            return false;
        }
        if (mapA.size() != mapB.size()) {
            return false;
        }
        for (Map.Entry<CBORObject, CBORObject> kvp : mapA.entrySet()) {
            boolean hasKey;
            CBORObject valueB = null;
            valueB = mapB.get(kvp.getKey());
            boolean bl = hasKey = valueB == null ? mapB.containsKey(kvp.getKey()) : true;
            if (hasKey) {
                CBORObject valueA = kvp.getValue();
                if (valueA != null ? valueA.equals(valueB) : valueB == null) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static int CBORMapHashCode(Map<CBORObject, CBORObject> a) {
        return a.size() * 19;
    }

    private static void CheckCBORLength(long expectedLength, long actualLength) {
        if (actualLength < expectedLength) {
            throw new CBORException("Premature end of data");
        }
        if (actualLength > expectedLength) {
            throw new CBORException("Too many bytes");
        }
    }

    private static void CheckCBORLength(int expectedLength, int actualLength) {
        if (actualLength < expectedLength) {
            throw new CBORException("Premature end of data");
        }
        if (actualLength > expectedLength) {
            throw new CBORException("Too many bytes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CBORObject ConvertWithConverter(Object obj) {
        Class<?> type = obj.getClass();
        ConverterInfo convinfo = null;
        Map<Object, ConverterInfo> map = ValueConverters;
        synchronized (map) {
            if (ValueConverters.size() == 0) {
                CBORTag0.AddConverter();
                CBORTag37.AddConverter();
                CBORTag32.AddConverter();
            }
            if (!ValueConverters.containsKey(type)) {
                return null;
            }
            convinfo = ValueConverters.get(type);
        }
        if (convinfo == null) {
            return null;
        }
        return (CBORObject)PropertyMap.InvokeOneArgumentMethod(convinfo.getToObject(), convinfo.getConverter(), obj);
    }

    private static String ExtendedToString(EFloat ef) {
        if (ef.isFinite() && (ef.getExponent().compareTo(EInteger.FromInt64((long)2500L)) > 0 || ef.getExponent().compareTo(EInteger.FromInt64((long)-2500L)) < 0)) {
            return ef.getMantissa() + "p" + ef.getExponent();
        }
        return ef.toString();
    }

    private static ICBORTag FindTagConverter(int tag) {
        return CBORObject.FindTagConverter(EInteger.FromInt32((int)tag));
    }

    private static byte[] GetOptimizedBytesIfShortAscii(String str, int tagbyteInt) {
        if (str.length() <= 255) {
            int extra;
            int offset = 0;
            int length = str.length();
            int n = extra = length < 24 ? 1 : 2;
            if (tagbyteInt >= 0) {
                ++extra;
            }
            byte[] bytes = new byte[length + extra];
            if (tagbyteInt >= 0) {
                bytes[offset] = (byte)tagbyteInt;
                ++offset;
            }
            if (length < 24) {
                bytes[offset] = (byte)(96 + str.length());
                ++offset;
            } else {
                bytes[offset] = 120;
                bytes[offset + 1] = (byte)str.length();
                offset += 2;
            }
            boolean issimple = true;
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c >= '\u0080') {
                    issimple = false;
                    break;
                }
                bytes[i + offset] = (byte)c;
            }
            if (issimple) {
                return bytes;
            }
        }
        return null;
    }

    private static String GetOptimizedStringIfShortAscii(byte[] data, int offset) {
        int nextbyte;
        int length = data.length;
        if (length > offset && (nextbyte = data[offset] & 0xFF) >= 96 && nextbyte < 120) {
            int offsetp1 = 1 + offset;
            int rightLength = offsetp1 + (nextbyte - 96);
            CBORObject.CheckCBORLength(rightLength, length);
            for (int i = offsetp1; i < length; ++i) {
                if ((data[i] & 0xFFFFFF80) == 0) continue;
                return null;
            }
            char[] c = new char[length - offsetp1];
            for (int i = offsetp1; i < length; ++i) {
                c[i - offsetp1] = (char)(data[i] & 0xFF);
            }
            return new String(c);
        }
        return null;
    }

    private static byte[] GetPositiveInt64Bytes(int type, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value (" + value + ") is less than " + "0");
        }
        if (value < 24L) {
            return new byte[]{(byte)((byte)value | (byte)(type << 5))};
        }
        if (value <= 255L) {
            return new byte[]{(byte)(0x18 | type << 5), (byte)(value & 0xFFL)};
        }
        if (value <= 65535L) {
            return new byte[]{(byte)(0x19 | type << 5), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
        }
        if (value <= 0xFFFFFFFFL) {
            return new byte[]{(byte)(0x1A | type << 5), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
        }
        return new byte[]{(byte)(0x1B | type << 5), (byte)(value >> 56 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
    }

    private static byte[] GetPositiveIntBytes(int type, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value (" + value + ") is less than " + "0");
        }
        if (value < 24) {
            return new byte[]{(byte)((byte)value | (byte)(type << 5))};
        }
        if (value <= 255) {
            return new byte[]{(byte)(0x18 | type << 5), (byte)(value & 0xFF)};
        }
        if (value <= 65535) {
            return new byte[]{(byte)(0x19 | type << 5), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        }
        return new byte[]{(byte)(0x1A | type << 5), (byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    private static int GetSignInternal(int type, Object obj) {
        ICBORNumber cn = NumberInterfaces[type];
        return cn == null ? 2 : cn.Sign(obj);
    }

    private static CBORObject[] InitializeFixedObjects() {
        int i;
        valueFixedObjects = new CBORObject[256];
        for (i = 0; i < 24; ++i) {
            CBORObject.valueFixedObjects[i] = new CBORObject(0, i);
        }
        for (i = 32; i < 56; ++i) {
            CBORObject.valueFixedObjects[i] = new CBORObject(0, -1 - (i - 32));
        }
        CBORObject.valueFixedObjects[96] = new CBORObject(3, "");
        for (i = 224; i < 248; ++i) {
            CBORObject.valueFixedObjects[i] = new CBORObject(6, i - 224);
        }
        return valueFixedObjects;
    }

    private static int ListCompare(List<CBORObject> listA, List<CBORObject> listB) {
        if (listA == null) {
            return listB == null ? 0 : -1;
        }
        if (listB == null) {
            return 1;
        }
        int listACount = listA.size();
        int listBCount = listB.size();
        int c = Math.min(listACount, listBCount);
        for (int i = 0; i < c; ++i) {
            int cmp = listA.get(i).compareTo(listB.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return listACount != listBCount ? (listACount < listBCount ? -1 : 1) : 0;
    }

    private static EInteger LowHighToEInteger(int tagLow, int tagHigh) {
        byte[] uabytes = null;
        if (tagHigh != 0) {
            uabytes = new byte[9];
            uabytes[7] = (byte)(tagHigh >> 24 & 0xFF);
            uabytes[6] = (byte)(tagHigh >> 16 & 0xFF);
            uabytes[5] = (byte)(tagHigh >> 8 & 0xFF);
            uabytes[4] = (byte)(tagHigh & 0xFF);
            uabytes[3] = (byte)(tagLow >> 24 & 0xFF);
            uabytes[2] = (byte)(tagLow >> 16 & 0xFF);
            uabytes[1] = (byte)(tagLow >> 8 & 0xFF);
            uabytes[0] = (byte)(tagLow & 0xFF);
            uabytes[8] = 0;
            return EInteger.FromBytes((byte[])uabytes, (boolean)true);
        }
        if (tagLow != 0) {
            uabytes = new byte[5];
            uabytes[3] = (byte)(tagLow >> 24 & 0xFF);
            uabytes[2] = (byte)(tagLow >> 16 & 0xFF);
            uabytes[1] = (byte)(tagLow >> 8 & 0xFF);
            uabytes[0] = (byte)(tagLow & 0xFF);
            uabytes[4] = 0;
            return EInteger.FromBytes((byte[])uabytes, (boolean)true);
        }
        return EInteger.FromInt32((int)0);
    }

    private static int MapCompare(Map<CBORObject, CBORObject> mapA, Map<CBORObject, CBORObject> mapB) {
        int cmp;
        int i;
        if (mapA == null) {
            return mapB == null ? 0 : -1;
        }
        if (mapB == null) {
            return 1;
        }
        if (mapA == mapB) {
            return 0;
        }
        int listACount = mapA.size();
        int listBCount = mapB.size();
        if (listACount == 0 && listBCount == 0) {
            return 0;
        }
        if (listACount == 0) {
            return -1;
        }
        if (listBCount == 0) {
            return 1;
        }
        ArrayList<CBORObject> sortedASet = new ArrayList<CBORObject>(mapA.keySet());
        ArrayList<CBORObject> sortedBSet = new ArrayList<CBORObject>(mapB.keySet());
        Collections.sort(sortedASet);
        Collections.sort(sortedBSet);
        listACount = sortedASet.size();
        listBCount = sortedBSet.size();
        int minCount = Math.min(listACount, listBCount);
        for (i = 0; i < minCount; ++i) {
            CBORObject itemA = sortedASet.get(i);
            CBORObject itemB = sortedBSet.get(i);
            if (itemA == null) {
                return -1;
            }
            cmp = itemA.compareTo(itemB);
            if (cmp == 0) continue;
            return cmp;
        }
        if (listACount == listBCount) {
            for (i = 0; i < minCount; ++i) {
                CBORObject keyA = sortedASet.get(i);
                CBORObject keyB = sortedBSet.get(i);
                cmp = mapA.get(keyA).compareTo(mapB.get(keyB));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
        return listACount > listBCount ? 1 : -1;
    }

    private static List<Object> PushObject(List<Object> stack, Object parent, Object child) {
        if (stack == null) {
            stack = new ArrayList<Object>();
            stack.add(parent);
        }
        for (Object o : stack) {
            if (o != child) continue;
            throw new IllegalArgumentException("Circular reference in data structure");
        }
        stack.add(child);
        return stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean TagHandlersEmpty() {
        Map<EInteger, ICBORTag> map = ValueTagHandlers;
        synchronized (map) {
            return ValueTagHandlers.size() == 0;
        }
    }

    private static int TagsCompare(EInteger[] tagsA, EInteger[] tagsB) {
        if (tagsA == null) {
            return tagsB == null ? 0 : -1;
        }
        if (tagsB == null) {
            return 1;
        }
        int listACount = tagsA.length;
        int listBCount = tagsB.length;
        int c = Math.min(listACount, listBCount);
        for (int i = 0; i < c; ++i) {
            int cmp = tagsA[i].compareTo(tagsB[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return listACount != listBCount ? (listACount < listBCount ? -1 : 1) : 0;
    }

    private static List<Object> WriteChildObject(Object parentThisItem, CBORObject child, OutputStream outputStream, List<Object> stack, CBOREncodeOptions options) throws IOException {
        if (child == null) {
            outputStream.write(246);
        } else {
            int type = child.getItemType();
            if (type == 4) {
                stack = CBORObject.PushObject(stack, parentThisItem, child.getThisItem());
                child.WriteTags(outputStream);
                CBORObject.WriteObjectArray(child.AsList(), outputStream, stack, options);
                stack.remove(stack.size() - 1);
            } else if (type == 5) {
                stack = CBORObject.PushObject(stack, parentThisItem, child.getThisItem());
                child.WriteTags(outputStream);
                CBORObject.WriteObjectMap(child.AsMap(), outputStream, stack, options);
                stack.remove(stack.size() - 1);
            } else {
                child.WriteTo(outputStream);
            }
        }
        return stack;
    }

    private static void WriteObjectArray(List<CBORObject> list, OutputStream outputStream, CBOREncodeOptions options) throws IOException {
        CBORObject.WriteObjectArray(list, outputStream, null, options);
    }

    private static void WriteObjectArray(List<CBORObject> list, OutputStream outputStream, List<Object> stack, CBOREncodeOptions options) throws IOException {
        List<CBORObject> thisObj = list;
        CBORObject.WritePositiveInt(4, list.size(), outputStream);
        for (CBORObject i : list) {
            stack = CBORObject.WriteChildObject(thisObj, i, outputStream, stack, options);
        }
    }

    private static void WriteObjectMap(Map<CBORObject, CBORObject> map, OutputStream outputStream, CBOREncodeOptions options) throws IOException {
        CBORObject.WriteObjectMap(map, outputStream, null, options);
    }

    private static void WriteObjectMap(Map<CBORObject, CBORObject> map, OutputStream outputStream, List<Object> stack, CBOREncodeOptions options) throws IOException {
        Map<CBORObject, CBORObject> thisObj = map;
        CBORObject.WritePositiveInt(5, map.size(), outputStream);
        for (Map.Entry<CBORObject, CBORObject> entry : map.entrySet()) {
            CBORObject key = entry.getKey();
            CBORObject value = entry.getValue();
            stack = CBORObject.WriteChildObject(thisObj, key, outputStream, stack, options);
            stack = CBORObject.WriteChildObject(thisObj, value, outputStream, stack, options);
        }
    }

    private static void WritePositiveInt(int type, int value, OutputStream s) throws IOException {
        byte[] bytes = CBORObject.GetPositiveIntBytes(type, value);
        s.write(bytes, 0, bytes.length);
    }

    private static void WritePositiveInt64(int type, long value, OutputStream s) throws IOException {
        byte[] bytes = CBORObject.GetPositiveInt64Bytes(type, value);
        s.write(bytes, 0, bytes.length);
    }

    private static void WriteStreamedString(String str, OutputStream stream) throws IOException {
        byte[] bytes = CBORObject.GetOptimizedBytesIfShortAscii(str, -1);
        if (bytes != null) {
            stream.write(bytes, 0, bytes.length);
            return;
        }
        bytes = new byte[4096];
        int byteIndex = 0;
        boolean streaming = false;
        for (int index = 0; index < str.length(); ++index) {
            int c = str.charAt(index);
            if (c <= 127) {
                if (byteIndex >= 4096) {
                    if (!streaming) {
                        stream.write(127);
                    }
                    CBORObject.WritePositiveInt(3, byteIndex, stream);
                    stream.write(bytes, 0, byteIndex);
                    byteIndex = 0;
                    streaming = true;
                }
                bytes[byteIndex++] = (byte)c;
                continue;
            }
            if (c <= 2047) {
                if (byteIndex + 2 > 4096) {
                    if (!streaming) {
                        stream.write(127);
                    }
                    CBORObject.WritePositiveInt(3, byteIndex, stream);
                    stream.write(bytes, 0, byteIndex);
                    byteIndex = 0;
                    streaming = true;
                }
                bytes[byteIndex++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if ((c & 0xFC00) == 55296 && index + 1 < str.length() && str.charAt(index + 1) >= '\udc00' && str.charAt(index + 1) <= '\udfff') {
                c = 65536 + (c - 55296 << 10) + (str.charAt(index + 1) - 56320);
                ++index;
            } else if ((c & 0xF800) == 55296) {
                c = 65533;
            }
            if (c <= 65535) {
                if (byteIndex + 3 > 4096) {
                    if (!streaming) {
                        stream.write(127);
                    }
                    CBORObject.WritePositiveInt(3, byteIndex, stream);
                    stream.write(bytes, 0, byteIndex);
                    byteIndex = 0;
                    streaming = true;
                }
                bytes[byteIndex++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytes[byteIndex++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (byteIndex + 4 > 4096) {
                if (!streaming) {
                    stream.write(127);
                }
                CBORObject.WritePositiveInt(3, byteIndex, stream);
                stream.write(bytes, 0, byteIndex);
                byteIndex = 0;
                streaming = true;
            }
            bytes[byteIndex++] = (byte)(0xF0 | c >> 18 & 7);
            bytes[byteIndex++] = (byte)(0x80 | c >> 12 & 0x3F);
            bytes[byteIndex++] = (byte)(0x80 | c >> 6 & 0x3F);
            bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
        }
        CBORObject.WritePositiveInt(3, byteIndex, stream);
        stream.write(bytes, 0, byteIndex);
        if (streaming) {
            stream.write(-1);
        }
    }

    private void AppendClosingTags(StringBuilder sb) {
        CBORObject curobject = this;
        while (curobject.isTagged()) {
            sb.append(')');
            curobject = (CBORObject)curobject.itemValue;
        }
    }

    private void AppendOpeningTags(StringBuilder sb) {
        CBORObject curobject = this;
        while (curobject.isTagged()) {
            int low = curobject.tagLow;
            int high = curobject.tagHigh;
            if (high == 0 && low >> 16 == 0) {
                sb.append(CBORUtilities.LongToString(low));
            } else {
                EInteger bi = CBORObject.LowHighToEInteger(low, high);
                sb.append(CBORUtilities.BigIntToString(bi));
            }
            sb.append('(');
            curobject = (CBORObject)curobject.itemValue;
        }
    }

    private int AsInt32(int minValue, int maxValue) {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("not a number type");
        }
        return cn.AsInt32(this.getThisItem(), minValue, maxValue);
    }

    private void WriteTags(OutputStream s) throws IOException {
        CBORObject curobject = this;
        while (curobject.isTagged()) {
            int low = curobject.tagLow;
            int high = curobject.tagHigh;
            if (high == 0 && low >> 16 == 0) {
                CBORObject.WritePositiveInt(6, low, s);
            } else if (high == 0) {
                long value = (long)low & 0xFFFFFFFFL;
                CBORObject.WritePositiveInt64(6, value, s);
            } else if (high >> 16 == 0) {
                long value = (long)low & 0xFFFFFFFFL;
                long highValue = (long)high & 0xFFFFFFFFL;
                CBORObject.WritePositiveInt64(6, value |= highValue << 32, s);
            } else {
                byte[] arrayToWrite = new byte[]{-37, (byte)(high >> 24 & 0xFF), (byte)(high >> 16 & 0xFF), (byte)(high >> 8 & 0xFF), (byte)(high & 0xFF), (byte)(low >> 24 & 0xFF), (byte)(low >> 16 & 0xFF), (byte)(low >> 8 & 0xFF), (byte)(low & 0xFF)};
                s.write(arrayToWrite, 0, 9);
            }
            curobject = (CBORObject)curobject.itemValue;
        }
    }

    private static final class ConverterInfo {
        private Object toObject;
        private Object converter;

        private ConverterInfo() {
        }

        public final Object getToObject() {
            return this.toObject;
        }

        public final void setToObject(Object value) {
            this.toObject = value;
        }

        public final Object getConverter() {
            return this.converter;
        }

        public final void setConverter(Object value) {
            this.converter = value;
        }
    }
}

