/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.util;

import com.upokecenter.util.BigInteger;
import com.upokecenter.util.BitShiftAccumulator;
import com.upokecenter.util.DecimalUtility;
import com.upokecenter.util.ExtendedDecimal;
import com.upokecenter.util.ExtendedOrSimpleRadixMath;
import com.upokecenter.util.Extras;
import com.upokecenter.util.FastInteger;
import com.upokecenter.util.IRadixMath;
import com.upokecenter.util.IRadixMathHelper;
import com.upokecenter.util.IShiftAccumulator;
import com.upokecenter.util.PrecisionContext;
import com.upokecenter.util.Rounding;
import com.upokecenter.util.TrappableRadixMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtendedFloat
implements Comparable<ExtendedFloat> {
    private final BigInteger exponent;
    private final BigInteger unsignedMantissa;
    private final int flags;
    private static final BigInteger valueOneShift23 = BigInteger.ONE.shiftLeft(23);
    private static final BigInteger valueOneShift52 = BigInteger.ONE.shiftLeft(52);
    public static final ExtendedFloat One = ExtendedFloat.Create(BigInteger.ONE, BigInteger.ZERO);
    public static final ExtendedFloat Zero = ExtendedFloat.Create(BigInteger.ZERO, BigInteger.ZERO);
    public static final ExtendedFloat NegativeZero = ExtendedFloat.CreateWithFlags(BigInteger.ZERO, BigInteger.ZERO, 1);
    public static final ExtendedFloat Ten = ExtendedFloat.Create(BigInteger.TEN, BigInteger.ZERO);
    public static final ExtendedFloat NaN = ExtendedFloat.CreateWithFlags(BigInteger.ZERO, BigInteger.ZERO, 4);
    public static final ExtendedFloat SignalingNaN = ExtendedFloat.CreateWithFlags(BigInteger.ZERO, BigInteger.ZERO, 8);
    public static final ExtendedFloat PositiveInfinity = ExtendedFloat.CreateWithFlags(BigInteger.ZERO, BigInteger.ZERO, 2);
    public static final ExtendedFloat NegativeInfinity = ExtendedFloat.CreateWithFlags(BigInteger.ZERO, BigInteger.ZERO, 3);
    private static final IRadixMath<ExtendedFloat> MathValue = new TrappableRadixMath<ExtendedFloat>(new ExtendedOrSimpleRadixMath<ExtendedFloat>(new BinaryMathHelper()));

    public final BigInteger getExponent() {
        return this.exponent;
    }

    public final BigInteger getUnsignedMantissa() {
        return this.unsignedMantissa;
    }

    public final BigInteger getMantissa() {
        return this.isNegative() ? this.unsignedMantissa.negate() : this.unsignedMantissa;
    }

    public boolean EqualsInternal(ExtendedFloat otherValue) {
        if (otherValue == null) {
            return false;
        }
        return this.exponent.equals(otherValue.exponent) && this.unsignedMantissa.equals(otherValue.unsignedMantissa) && this.flags == otherValue.flags;
    }

    public boolean equals(ExtendedFloat other) {
        return this.EqualsInternal(other);
    }

    public boolean equals(Object obj) {
        return this.EqualsInternal(obj instanceof ExtendedFloat ? (ExtendedFloat)obj : null);
    }

    public int hashCode() {
        int valueHashCode = 403796923;
        valueHashCode += 403797019 * this.exponent.hashCode();
        valueHashCode += 403797059 * this.unsignedMantissa.hashCode();
        return valueHashCode += 403797127 * this.flags;
    }

    public static ExtendedFloat CreateNaN(BigInteger diag) {
        return ExtendedFloat.CreateNaN(diag, false, false, null);
    }

    public static ExtendedFloat CreateNaN(BigInteger diag, boolean signaling, boolean negative, PrecisionContext ctx) {
        if (diag == null) {
            throw new NullPointerException("diag");
        }
        if (diag.signum() < 0) {
            throw new IllegalArgumentException("Diagnostic information must be 0 or greater, was: " + diag);
        }
        if (diag.signum() == 0 && !negative) {
            return signaling ? SignalingNaN : NaN;
        }
        int flags = 0;
        if (negative) {
            flags |= 1;
        }
        if (ctx != null && ctx.getHasMaxPrecision()) {
            ExtendedFloat ef = ExtendedFloat.CreateWithFlags(diag, BigInteger.ZERO, flags |= 4).RoundToPrecision(ctx);
            int newFlags = ef.flags;
            newFlags &= 0xFFFFFFFB;
            return new ExtendedFloat(ef.unsignedMantissa, ef.exponent, newFlags |= signaling ? 8 : 4);
        }
        return ExtendedFloat.CreateWithFlags(diag, BigInteger.ZERO, flags |= signaling ? 8 : 4);
    }

    public static ExtendedFloat Create(int mantissaSmall, int exponentSmall) {
        return ExtendedFloat.Create(BigInteger.valueOf(mantissaSmall), BigInteger.valueOf(exponentSmall));
    }

    public static ExtendedFloat Create(BigInteger mantissa, BigInteger exponent) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        int sign = mantissa.signum();
        return new ExtendedFloat(sign < 0 ? mantissa.negate() : mantissa, exponent, sign < 0 ? 1 : 0);
    }

    private ExtendedFloat(BigInteger unsignedMantissa, BigInteger exponent, int flags) {
        this.unsignedMantissa = unsignedMantissa;
        this.exponent = exponent;
        this.flags = flags;
    }

    static ExtendedFloat CreateWithFlags(BigInteger mantissa, BigInteger exponent, int flags) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        int sign = mantissa == null ? 0 : mantissa.signum();
        return new ExtendedFloat(sign < 0 ? mantissa.negate() : mantissa, exponent, flags);
    }

    public static ExtendedFloat FromString(String str, int offset, int length, PrecisionContext ctx) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        return ExtendedDecimal.FromString(str, offset, length, ctx).ToExtendedFloat();
    }

    public static ExtendedFloat FromString(String str) {
        return ExtendedFloat.FromString(str, 0, str == null ? 0 : str.length(), null);
    }

    public static ExtendedFloat FromString(String str, PrecisionContext ctx) {
        return ExtendedFloat.FromString(str, 0, str == null ? 0 : str.length(), ctx);
    }

    public static ExtendedFloat FromString(String str, int offset, int length) {
        return ExtendedFloat.FromString(str, offset, length, null);
    }

    public BigInteger ToBigInteger() {
        return this.ToBigIntegerInternal(false);
    }

    public BigInteger ToBigIntegerExact() {
        return this.ToBigIntegerInternal(true);
    }

    private BigInteger ToBigIntegerInternal(boolean exact) {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        if (this.signum() == 0) {
            return BigInteger.ZERO;
        }
        int expsign = this.getExponent().signum();
        if (expsign == 0) {
            return this.getMantissa();
        }
        if (expsign > 0) {
            boolean neg;
            BigInteger curexp = this.getExponent();
            BigInteger bigmantissa = this.getMantissa();
            if (bigmantissa.signum() == 0) {
                return bigmantissa;
            }
            boolean bl = neg = bigmantissa.signum() < 0;
            if (neg) {
                bigmantissa = bigmantissa.negate();
            }
            bigmantissa = DecimalUtility.ShiftLeft(bigmantissa, curexp);
            if (neg) {
                bigmantissa = bigmantissa.negate();
            }
            return bigmantissa;
        }
        BigInteger bigmantissa = this.getMantissa();
        FastInteger bigexponent = FastInteger.FromBig(this.getExponent()).Negate();
        bigmantissa = bigmantissa.abs();
        BitShiftAccumulator acc = new BitShiftAccumulator(bigmantissa, 0, 0);
        acc.ShiftRight(bigexponent);
        if (exact && (acc.getLastDiscardedDigit() != 0 || acc.getOlderDiscardedDigits() != 0)) {
            throw new ArithmeticException("Not an exact integer");
        }
        bigmantissa = acc.getShiftedInt();
        if (this.isNegative()) {
            bigmantissa = bigmantissa.negate();
        }
        return bigmantissa;
    }

    public float ToSingle() {
        FastInteger fastSmallMant;
        if (this.IsPositiveInfinity()) {
            return Float.POSITIVE_INFINITY;
        }
        if (this.IsNegativeInfinity()) {
            return Float.NEGATIVE_INFINITY;
        }
        if (this.IsNaN()) {
            int nan = 2139095040;
            if (this.isNegative()) {
                nan |= Integer.MIN_VALUE;
            }
            nan |= this.IsQuietNaN() ? 0x400000 : 0x200000;
            if (this.getUnsignedMantissa().signum() != 0) {
                BigInteger bigdata = this.getUnsignedMantissa().remainder(BigInteger.valueOf(0x200000L));
                nan |= bigdata.intValueChecked();
            }
            return Float.intBitsToFloat(nan);
        }
        if (this.isNegative() && this.signum() == 0) {
            return Float.intBitsToFloat(Integer.MIN_VALUE);
        }
        BigInteger bigmant = this.unsignedMantissa.abs();
        FastInteger bigexponent = FastInteger.FromBig(this.exponent);
        int bitLeftmost = 0;
        int bitsAfterLeftmost = 0;
        if (this.unsignedMantissa.signum() == 0) {
            return 0.0f;
        }
        int smallmant = 0;
        if (bigmant.compareTo(valueOneShift23) < 0) {
            smallmant = bigmant.intValueChecked();
            int exponentchange = 0;
            while (smallmant < 0x800000) {
                smallmant <<= 1;
                ++exponentchange;
            }
            bigexponent.SubtractInt(exponentchange);
            fastSmallMant = new FastInteger(smallmant);
        } else {
            BitShiftAccumulator accum = new BitShiftAccumulator(bigmant, 0, 0);
            accum.ShiftToDigitsInt(24);
            bitsAfterLeftmost = accum.getOlderDiscardedDigits();
            bitLeftmost = accum.getLastDiscardedDigit();
            bigexponent.Add(accum.getDiscardedDigitCount());
            fastSmallMant = accum.getShiftedIntFast();
        }
        if (!(bitLeftmost <= 0 || bitsAfterLeftmost <= 0 && fastSmallMant.isEvenNumber())) {
            fastSmallMant.Increment();
            if (fastSmallMant.CompareToInt(0x1000000) == 0) {
                fastSmallMant = new FastInteger(0x800000);
                bigexponent.Increment();
            }
        }
        boolean subnormal = false;
        if (bigexponent.CompareToInt(104) > 0) {
            return this.isNegative() ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        if (bigexponent.CompareToInt(-149) < 0) {
            subnormal = true;
            BitShiftAccumulator accum = BitShiftAccumulator.FromInt32(fastSmallMant.AsInt32());
            FastInteger fi = FastInteger.Copy(bigexponent).SubtractInt(-149).Abs();
            accum.ShiftRight(fi);
            bitsAfterLeftmost = accum.getOlderDiscardedDigits();
            bitLeftmost = accum.getLastDiscardedDigit();
            bigexponent.Add(accum.getDiscardedDigitCount());
            fastSmallMant = accum.getShiftedIntFast();
            if (!(bitLeftmost <= 0 || bitsAfterLeftmost <= 0 && fastSmallMant.isEvenNumber())) {
                fastSmallMant.Increment();
                if (fastSmallMant.CompareToInt(0x1000000) == 0) {
                    fastSmallMant = new FastInteger(0x800000);
                    bigexponent.Increment();
                }
            }
        }
        if (bigexponent.CompareToInt(-149) < 0) {
            return this.isNegative() ? Float.intBitsToFloat(Integer.MIN_VALUE) : Float.intBitsToFloat(0);
        }
        int smallexponent = bigexponent.AsInt32();
        smallexponent += 150;
        int smallmantissa = fastSmallMant.AsInt32() & 0x7FFFFF;
        if (!subnormal) {
            smallmantissa |= smallexponent << 23;
        }
        if (this.isNegative()) {
            smallmantissa |= Integer.MIN_VALUE;
        }
        return Float.intBitsToFloat(smallmantissa);
    }

    public double ToDouble() {
        int[] mantissaBits;
        if (this.IsPositiveInfinity()) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.IsNegativeInfinity()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.IsNaN()) {
            int[] nan = new int[]{0, 0x7FF00000};
            if (this.isNegative()) {
                nan[1] = nan[1] | Integer.MIN_VALUE;
            }
            nan[1] = this.IsQuietNaN() ? nan[1] | 0x80000 : nan[1] | 0x40000;
            if (this.getUnsignedMantissa().signum() != 0) {
                int[] words = FastInteger.GetLastWords(this.getUnsignedMantissa(), 2);
                nan[0] = words[0];
                nan[1] = words[1] & 0x3FFFF;
            }
            return Extras.IntegersToDouble(nan);
        }
        if (this.isNegative() && this.signum() == 0) {
            return Extras.IntegersToDouble(new int[]{Integer.MIN_VALUE, 0});
        }
        BigInteger bigmant = this.unsignedMantissa.abs();
        FastInteger bigexponent = FastInteger.FromBig(this.exponent);
        int bitLeftmost = 0;
        int bitsAfterLeftmost = 0;
        if (this.unsignedMantissa.signum() == 0) {
            return 0.0;
        }
        if (bigmant.compareTo(valueOneShift52) < 0) {
            mantissaBits = FastInteger.GetLastWords(bigmant, 2);
            while (!DecimalUtility.HasBitSet(mantissaBits, 52)) {
                DecimalUtility.ShiftLeftOne(mantissaBits);
                bigexponent.Decrement();
            }
        } else {
            BitShiftAccumulator accum = new BitShiftAccumulator(bigmant, 0, 0);
            accum.ShiftToDigitsInt(53);
            bitsAfterLeftmost = accum.getOlderDiscardedDigits();
            bitLeftmost = accum.getLastDiscardedDigit();
            bigexponent.Add(accum.getDiscardedDigitCount());
            mantissaBits = FastInteger.GetLastWords(accum.getShiftedInt(), 2);
        }
        if (bitLeftmost > 0 && (bitsAfterLeftmost > 0 || DecimalUtility.HasBitSet(mantissaBits, 0))) {
            mantissaBits[0] = mantissaBits[0] + 1;
            if (mantissaBits[0] == 0) {
                mantissaBits[1] = mantissaBits[1] + 1;
            }
            if (mantissaBits[0] == 0 && mantissaBits[1] == 0x200000) {
                mantissaBits[1] = mantissaBits[1] >> 1;
                bigexponent.Increment();
            }
        }
        boolean subnormal = false;
        if (bigexponent.CompareToInt(971) > 0) {
            return this.isNegative() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        if (bigexponent.CompareToInt(-1074) < 0) {
            subnormal = true;
            BitShiftAccumulator accum = new BitShiftAccumulator(FastInteger.WordsToBigInteger(mantissaBits), 0, 0);
            FastInteger fi = FastInteger.Copy(bigexponent).SubtractInt(-1074).Abs();
            accum.ShiftRight(fi);
            bitsAfterLeftmost = accum.getOlderDiscardedDigits();
            bitLeftmost = accum.getLastDiscardedDigit();
            bigexponent.Add(accum.getDiscardedDigitCount());
            mantissaBits = FastInteger.GetLastWords(accum.getShiftedInt(), 2);
            if (bitLeftmost > 0 && (bitsAfterLeftmost > 0 || DecimalUtility.HasBitSet(mantissaBits, 0))) {
                mantissaBits[0] = mantissaBits[0] + 1;
                if (mantissaBits[0] == 0) {
                    mantissaBits[1] = mantissaBits[1] + 1;
                }
                if (mantissaBits[0] == 0 && mantissaBits[1] == 0x200000) {
                    mantissaBits[1] = mantissaBits[1] >> 1;
                    bigexponent.Increment();
                }
            }
        }
        if (bigexponent.CompareToInt(-1074) < 0) {
            return this.isNegative() ? Extras.IntegersToDouble(new int[]{0, Integer.MIN_VALUE}) : 0.0;
        }
        bigexponent.AddInt(1075);
        mantissaBits[1] = mantissaBits[1] & 0xFFFFF;
        if (!subnormal) {
            int smallexponent = bigexponent.AsInt32() << 20;
            mantissaBits[1] = mantissaBits[1] | smallexponent;
        }
        if (this.isNegative()) {
            mantissaBits[1] = mantissaBits[1] | Integer.MIN_VALUE;
        }
        return Extras.IntegersToDouble(mantissaBits);
    }

    public static ExtendedFloat FromSingle(float flt) {
        int value = Float.floatToRawIntBits(flt);
        boolean neg = value >> 31 != 0;
        int floatExponent = value >> 23 & 0xFF;
        int valueFpMantissa = value & 0x7FFFFF;
        if (floatExponent == 255) {
            if (valueFpMantissa == 0) {
                return neg ? NegativeInfinity : PositiveInfinity;
            }
            boolean quiet = (valueFpMantissa & 0x400000) != 0;
            BigInteger bigmant = BigInteger.valueOf(valueFpMantissa &= 0x1FFFFF);
            value = (neg ? 1 : 0) | (quiet ? 4 : 8);
            if (bigmant.signum() == 0) {
                return quiet ? NaN : SignalingNaN;
            }
            return ExtendedFloat.CreateWithFlags(bigmant, BigInteger.ZERO, value);
        }
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            valueFpMantissa |= 0x800000;
        }
        if (valueFpMantissa == 0) {
            return neg ? NegativeZero : Zero;
        }
        while ((valueFpMantissa & 1) == 0) {
            ++floatExponent;
            valueFpMantissa >>= 1;
        }
        if (neg) {
            valueFpMantissa = -valueFpMantissa;
        }
        BigInteger bigmant = BigInteger.valueOf(valueFpMantissa);
        return ExtendedFloat.Create(bigmant, BigInteger.valueOf(floatExponent - 150));
    }

    public static ExtendedFloat FromBigInteger(BigInteger bigint) {
        return ExtendedFloat.Create(bigint, BigInteger.ZERO);
    }

    public static ExtendedFloat FromInt64(long valueSmall) {
        BigInteger bigint = BigInteger.valueOf(valueSmall);
        return ExtendedFloat.Create(bigint, BigInteger.ZERO);
    }

    public static ExtendedFloat FromInt32(int valueSmaller) {
        BigInteger bigint = BigInteger.valueOf(valueSmaller);
        return ExtendedFloat.Create(bigint, BigInteger.ZERO);
    }

    public static ExtendedFloat FromDouble(double dbl) {
        boolean neg;
        int[] value = Extras.DoubleToIntegers(dbl);
        int floatExponent = value[1] >> 20 & 0x7FF;
        boolean bl = neg = value[1] >> 31 != 0;
        if (floatExponent == 2047) {
            if ((value[1] & 0xFFFFF) == 0 && value[0] == 0) {
                return neg ? NegativeInfinity : PositiveInfinity;
            }
            boolean quiet = (value[1] & 0x80000) != 0;
            value[1] = value[1] & 0x3FFFF;
            BigInteger info = FastInteger.WordsToBigInteger(value);
            if (info.signum() == 0) {
                return quiet ? NaN : SignalingNaN;
            }
            value[0] = (neg ? 1 : 0) | (quiet ? 4 : 8);
            return ExtendedFloat.CreateWithFlags(info, BigInteger.ZERO, value[0]);
        }
        value[1] = value[1] & 0xFFFFF;
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            value[1] = value[1] | 0x100000;
        }
        if ((value[1] | value[0]) == 0) {
            return neg ? NegativeZero : Zero;
        }
        return ExtendedFloat.CreateWithFlags(FastInteger.WordsToBigInteger(value), BigInteger.valueOf((floatExponent += DecimalUtility.ShiftAwayTrailingZerosTwoElements(value)) - 1075), neg ? 1 : 0);
    }

    public ExtendedDecimal ToExtendedDecimal() {
        return ExtendedDecimal.FromExtendedFloat(this);
    }

    public String toString() {
        return ExtendedDecimal.FromExtendedFloat(this).toString();
    }

    public String ToEngineeringString() {
        return this.ToExtendedDecimal().ToEngineeringString();
    }

    public String ToPlainString() {
        return this.ToExtendedDecimal().ToPlainString();
    }

    public boolean IsNegativeInfinity() {
        return (this.flags & 3) == 3;
    }

    public boolean IsPositiveInfinity() {
        return (this.flags & 3) == 2;
    }

    public boolean IsNaN() {
        return (this.flags & 0xC) != 0;
    }

    public boolean IsInfinity() {
        return (this.flags & 2) != 0;
    }

    public final boolean isFinite() {
        return (this.flags & 0xE) == 0;
    }

    public final boolean isNegative() {
        return (this.flags & 1) != 0;
    }

    public boolean IsQuietNaN() {
        return (this.flags & 4) != 0;
    }

    public boolean IsSignalingNaN() {
        return (this.flags & 8) != 0;
    }

    public final int signum() {
        return (this.flags & 0xE) == 0 && this.unsignedMantissa.signum() == 0 ? 0 : ((this.flags & 1) != 0 ? -1 : 1);
    }

    public final boolean isZero() {
        return (this.flags & 0xE) == 0 && this.unsignedMantissa.signum() == 0;
    }

    public ExtendedFloat Abs() {
        return this.Abs(null);
    }

    public ExtendedFloat Negate() {
        return this.Negate(null);
    }

    public ExtendedFloat Divide(ExtendedFloat divisor) {
        return this.Divide(divisor, PrecisionContext.ForRounding(Rounding.Unnecessary));
    }

    public ExtendedFloat DivideToSameExponent(ExtendedFloat divisor, Rounding rounding) {
        return this.DivideToExponent(divisor, this.exponent, PrecisionContext.ForRounding(rounding));
    }

    public ExtendedFloat DivideToIntegerNaturalScale(ExtendedFloat divisor) {
        return this.DivideToIntegerNaturalScale(divisor, PrecisionContext.ForRounding(Rounding.Down));
    }

    public ExtendedFloat Reduce(PrecisionContext ctx) {
        return MathValue.Reduce(this, ctx);
    }

    public ExtendedFloat RemainderNaturalScale(ExtendedFloat divisor) {
        return this.RemainderNaturalScale(divisor, null);
    }

    public ExtendedFloat RemainderNaturalScale(ExtendedFloat divisor, PrecisionContext ctx) {
        return this.Subtract(this.DivideToIntegerNaturalScale(divisor, ctx).Multiply(divisor, null), null);
    }

    public ExtendedFloat DivideToExponent(ExtendedFloat divisor, long desiredExponentSmall, PrecisionContext ctx) {
        return this.DivideToExponent(divisor, BigInteger.valueOf(desiredExponentSmall), ctx);
    }

    public ExtendedFloat Divide(ExtendedFloat divisor, PrecisionContext ctx) {
        return MathValue.Divide(this, divisor, ctx);
    }

    public ExtendedFloat DivideToExponent(ExtendedFloat divisor, long desiredExponentSmall, Rounding rounding) {
        return this.DivideToExponent(divisor, BigInteger.valueOf(desiredExponentSmall), PrecisionContext.ForRounding(rounding));
    }

    public ExtendedFloat DivideToExponent(ExtendedFloat divisor, BigInteger exponent, PrecisionContext ctx) {
        return MathValue.DivideToExponent(this, divisor, exponent, ctx);
    }

    public ExtendedFloat DivideToExponent(ExtendedFloat divisor, BigInteger desiredExponent, Rounding rounding) {
        return this.DivideToExponent(divisor, desiredExponent, PrecisionContext.ForRounding(rounding));
    }

    public ExtendedFloat Abs(PrecisionContext context) {
        return MathValue.Abs(this, context);
    }

    public ExtendedFloat Negate(PrecisionContext context) {
        return MathValue.Negate(this, context);
    }

    public ExtendedFloat Add(ExtendedFloat otherValue) {
        return this.Add(otherValue, PrecisionContext.Unlimited);
    }

    public ExtendedFloat Subtract(ExtendedFloat otherValue) {
        return this.Subtract(otherValue, null);
    }

    public ExtendedFloat Subtract(ExtendedFloat otherValue, PrecisionContext ctx) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        ExtendedFloat negated = otherValue;
        if ((otherValue.flags & 0xC) == 0) {
            int newflags = otherValue.flags ^ 1;
            negated = ExtendedFloat.CreateWithFlags(otherValue.unsignedMantissa, otherValue.exponent, newflags);
        }
        return this.Add(negated, ctx);
    }

    public ExtendedFloat Multiply(ExtendedFloat otherValue) {
        return this.Multiply(otherValue, PrecisionContext.Unlimited);
    }

    public ExtendedFloat MultiplyAndAdd(ExtendedFloat multiplicand, ExtendedFloat augend) {
        return this.MultiplyAndAdd(multiplicand, augend, null);
    }

    public ExtendedFloat DivideToIntegerNaturalScale(ExtendedFloat divisor, PrecisionContext ctx) {
        return MathValue.DivideToIntegerNaturalScale(this, divisor, ctx);
    }

    public ExtendedFloat DivideToIntegerZeroScale(ExtendedFloat divisor, PrecisionContext ctx) {
        return MathValue.DivideToIntegerZeroScale(this, divisor, ctx);
    }

    public ExtendedFloat Remainder(ExtendedFloat divisor, PrecisionContext ctx) {
        return MathValue.Remainder(this, divisor, ctx);
    }

    public ExtendedFloat RemainderNear(ExtendedFloat divisor, PrecisionContext ctx) {
        return MathValue.RemainderNear(this, divisor, ctx);
    }

    public ExtendedFloat NextMinus(PrecisionContext ctx) {
        return MathValue.NextMinus(this, ctx);
    }

    public ExtendedFloat NextPlus(PrecisionContext ctx) {
        return MathValue.NextPlus(this, ctx);
    }

    public ExtendedFloat NextToward(ExtendedFloat otherValue, PrecisionContext ctx) {
        return MathValue.NextToward(this, otherValue, ctx);
    }

    public static ExtendedFloat Max(ExtendedFloat first, ExtendedFloat second, PrecisionContext ctx) {
        return MathValue.Max(first, second, ctx);
    }

    public static ExtendedFloat Min(ExtendedFloat first, ExtendedFloat second, PrecisionContext ctx) {
        return MathValue.Min(first, second, ctx);
    }

    public static ExtendedFloat MaxMagnitude(ExtendedFloat first, ExtendedFloat second, PrecisionContext ctx) {
        return MathValue.MaxMagnitude(first, second, ctx);
    }

    public static ExtendedFloat MinMagnitude(ExtendedFloat first, ExtendedFloat second, PrecisionContext ctx) {
        return MathValue.MinMagnitude(first, second, ctx);
    }

    public static ExtendedFloat Max(ExtendedFloat first, ExtendedFloat second) {
        return ExtendedFloat.Max(first, second, null);
    }

    public static ExtendedFloat Min(ExtendedFloat first, ExtendedFloat second) {
        return ExtendedFloat.Min(first, second, null);
    }

    public static ExtendedFloat MaxMagnitude(ExtendedFloat first, ExtendedFloat second) {
        return ExtendedFloat.MaxMagnitude(first, second, null);
    }

    public static ExtendedFloat MinMagnitude(ExtendedFloat first, ExtendedFloat second) {
        return ExtendedFloat.MinMagnitude(first, second, null);
    }

    @Override
    public int compareTo(ExtendedFloat other) {
        return MathValue.compareTo(this, other);
    }

    public ExtendedFloat CompareToWithContext(ExtendedFloat other, PrecisionContext ctx) {
        return MathValue.CompareToWithContext(this, other, false, ctx);
    }

    public ExtendedFloat CompareToSignal(ExtendedFloat other, PrecisionContext ctx) {
        return MathValue.CompareToWithContext(this, other, true, ctx);
    }

    public ExtendedFloat Add(ExtendedFloat otherValue, PrecisionContext ctx) {
        return MathValue.Add(this, otherValue, ctx);
    }

    public ExtendedFloat Quantize(BigInteger desiredExponent, PrecisionContext ctx) {
        return this.Quantize(ExtendedFloat.Create(BigInteger.ONE, desiredExponent), ctx);
    }

    public ExtendedFloat Quantize(int desiredExponentSmall, PrecisionContext ctx) {
        return this.Quantize(ExtendedFloat.Create(BigInteger.ONE, BigInteger.valueOf(desiredExponentSmall)), ctx);
    }

    public ExtendedFloat Quantize(ExtendedFloat otherValue, PrecisionContext ctx) {
        return MathValue.Quantize(this, otherValue, ctx);
    }

    public ExtendedFloat RoundToIntegralExact(PrecisionContext ctx) {
        return MathValue.RoundToExponentExact(this, BigInteger.ZERO, ctx);
    }

    public ExtendedFloat RoundToIntegralNoRoundedFlag(PrecisionContext ctx) {
        return MathValue.RoundToExponentNoRoundedFlag(this, BigInteger.ZERO, ctx);
    }

    public ExtendedFloat RoundToExponentExact(BigInteger exponent, PrecisionContext ctx) {
        return MathValue.RoundToExponentExact(this, exponent, ctx);
    }

    public ExtendedFloat RoundToExponent(BigInteger exponent, PrecisionContext ctx) {
        return MathValue.RoundToExponentSimple(this, exponent, ctx);
    }

    public ExtendedFloat RoundToExponentExact(int exponentSmall, PrecisionContext ctx) {
        return this.RoundToExponentExact(BigInteger.valueOf(exponentSmall), ctx);
    }

    public ExtendedFloat RoundToExponent(int exponentSmall, PrecisionContext ctx) {
        return this.RoundToExponent(BigInteger.valueOf(exponentSmall), ctx);
    }

    public ExtendedFloat Multiply(ExtendedFloat op, PrecisionContext ctx) {
        return MathValue.Multiply(this, op, ctx);
    }

    public ExtendedFloat MultiplyAndAdd(ExtendedFloat op, ExtendedFloat augend, PrecisionContext ctx) {
        return MathValue.MultiplyAndAdd(this, op, augend, ctx);
    }

    public ExtendedFloat MultiplyAndSubtract(ExtendedFloat op, ExtendedFloat subtrahend, PrecisionContext ctx) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (subtrahend == null) {
            throw new NullPointerException("subtrahend");
        }
        ExtendedFloat negated = subtrahend;
        if ((subtrahend.flags & 0xC) == 0) {
            int newflags = subtrahend.flags ^ 1;
            negated = ExtendedFloat.CreateWithFlags(subtrahend.unsignedMantissa, subtrahend.exponent, newflags);
        }
        return MathValue.MultiplyAndAdd(this, op, negated, ctx);
    }

    public ExtendedFloat RoundToPrecision(PrecisionContext ctx) {
        return MathValue.RoundToPrecision(this, ctx);
    }

    public ExtendedFloat Plus(PrecisionContext ctx) {
        return MathValue.Plus(this, ctx);
    }

    @Deprecated
    public ExtendedFloat RoundToBinaryPrecision(PrecisionContext ctx) {
        if (ctx == null) {
            return this;
        }
        PrecisionContext ctx2 = ctx.Copy().WithPrecisionInBits(true);
        ExtendedFloat ret = MathValue.RoundToPrecision(this, ctx2);
        if (ctx2.getHasFlags()) {
            ctx.setFlags(ctx2.getFlags());
        }
        return ret;
    }

    public ExtendedFloat SquareRoot(PrecisionContext ctx) {
        return MathValue.SquareRoot(this, ctx);
    }

    public ExtendedFloat Exp(PrecisionContext ctx) {
        return MathValue.Exp(this, ctx);
    }

    public ExtendedFloat Log(PrecisionContext ctx) {
        return MathValue.Ln(this, ctx);
    }

    public ExtendedFloat Log10(PrecisionContext ctx) {
        return MathValue.Log10(this, ctx);
    }

    public ExtendedFloat Pow(ExtendedFloat exponent, PrecisionContext ctx) {
        return MathValue.Power(this, exponent, ctx);
    }

    public ExtendedFloat Pow(int exponentSmall, PrecisionContext ctx) {
        return this.Pow(ExtendedFloat.FromInt64(exponentSmall), ctx);
    }

    public ExtendedFloat Pow(int exponentSmall) {
        return this.Pow(ExtendedFloat.FromInt64(exponentSmall), null);
    }

    public static ExtendedFloat PI(PrecisionContext ctx) {
        return MathValue.Pi(ctx);
    }

    public ExtendedFloat MovePointLeft(int places) {
        return this.MovePointLeft(BigInteger.valueOf(places), null);
    }

    public ExtendedFloat MovePointLeft(int places, PrecisionContext ctx) {
        return this.MovePointLeft(BigInteger.valueOf(places), ctx);
    }

    public ExtendedFloat MovePointLeft(BigInteger bigPlaces) {
        return this.MovePointLeft(bigPlaces, null);
    }

    public ExtendedFloat MovePointLeft(BigInteger bigPlaces, PrecisionContext ctx) {
        if (bigPlaces.signum() == 0) {
            return this.RoundToPrecision(ctx);
        }
        return !this.isFinite() ? this.RoundToPrecision(ctx) : this.MovePointRight(bigPlaces.negate(), ctx);
    }

    public ExtendedFloat MovePointRight(int places) {
        return this.MovePointRight(BigInteger.valueOf(places), null);
    }

    public ExtendedFloat MovePointRight(int places, PrecisionContext ctx) {
        return this.MovePointRight(BigInteger.valueOf(places), ctx);
    }

    public ExtendedFloat MovePointRight(BigInteger bigPlaces) {
        return this.MovePointRight(bigPlaces, null);
    }

    public ExtendedFloat MovePointRight(BigInteger bigPlaces, PrecisionContext ctx) {
        if (bigPlaces.signum() == 0) {
            return this.RoundToPrecision(ctx);
        }
        if (!this.isFinite()) {
            return this.RoundToPrecision(ctx);
        }
        BigInteger bigExp = this.getExponent();
        if ((bigExp = bigExp.add(bigPlaces)).signum() > 0) {
            BigInteger mant = DecimalUtility.ShiftLeft(this.unsignedMantissa, bigExp);
            return ExtendedFloat.CreateWithFlags(mant, BigInteger.ZERO, this.flags).RoundToPrecision(ctx);
        }
        return ExtendedFloat.CreateWithFlags(this.unsignedMantissa, bigExp, this.flags).RoundToPrecision(ctx);
    }

    public ExtendedFloat ScaleByPowerOfTwo(int places) {
        return this.ScaleByPowerOfTwo(BigInteger.valueOf(places), null);
    }

    public ExtendedFloat ScaleByPowerOfTwo(int places, PrecisionContext ctx) {
        return this.ScaleByPowerOfTwo(BigInteger.valueOf(places), ctx);
    }

    public ExtendedFloat ScaleByPowerOfTwo(BigInteger bigPlaces) {
        return this.ScaleByPowerOfTwo(bigPlaces, null);
    }

    public ExtendedFloat ScaleByPowerOfTwo(BigInteger bigPlaces, PrecisionContext ctx) {
        if (bigPlaces.signum() == 0) {
            return this.RoundToPrecision(ctx);
        }
        if (!this.isFinite()) {
            return this.RoundToPrecision(ctx);
        }
        BigInteger bigExp = this.getExponent();
        bigExp = bigExp.add(bigPlaces);
        return ExtendedFloat.CreateWithFlags(this.unsignedMantissa, bigExp, this.flags).RoundToPrecision(ctx);
    }

    public BigInteger Precision() {
        if (!this.isFinite()) {
            return BigInteger.ZERO;
        }
        if (this.signum() == 0) {
            return BigInteger.ONE;
        }
        int bitlen = this.unsignedMantissa.bitLength();
        return BigInteger.valueOf(bitlen);
    }

    public ExtendedFloat Ulp() {
        return !this.isFinite() ? One : ExtendedFloat.Create(BigInteger.ONE, this.exponent);
    }

    public ExtendedFloat[] DivideAndRemainderNaturalScale(ExtendedFloat divisor) {
        return this.DivideAndRemainderNaturalScale(divisor, null);
    }

    public ExtendedFloat[] DivideAndRemainderNaturalScale(ExtendedFloat divisor, PrecisionContext ctx) {
        ExtendedFloat[] result;
        result = new ExtendedFloat[]{this.DivideToIntegerNaturalScale(divisor, ctx), this.Subtract(result[0].Multiply(divisor, null), null)};
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BinaryMathHelper
    implements IRadixMathHelper<ExtendedFloat> {
        private BinaryMathHelper() {
        }

        @Override
        public int GetRadix() {
            return 2;
        }

        @Override
        public int GetSign(ExtendedFloat value) {
            return value.signum();
        }

        @Override
        public BigInteger GetMantissa(ExtendedFloat value) {
            return value.getMantissa();
        }

        @Override
        public BigInteger GetExponent(ExtendedFloat value) {
            return value.exponent;
        }

        @Override
        public IShiftAccumulator CreateShiftAccumulatorWithDigits(BigInteger bigint, int lastDigit, int olderDigits) {
            return new BitShiftAccumulator(bigint, lastDigit, olderDigits);
        }

        @Override
        public IShiftAccumulator CreateShiftAccumulator(BigInteger bigint) {
            return new BitShiftAccumulator(bigint, 0, 0);
        }

        @Override
        public boolean HasTerminatingRadixExpansion(BigInteger num, BigInteger den) {
            BigInteger gcd = num.gcd(den);
            if (gcd.signum() == 0) {
                return false;
            }
            den = den.divide(gcd);
            while (!den.testBit(0)) {
                den = den.shiftRight(1);
            }
            return den.equals(BigInteger.ONE);
        }

        @Override
        public BigInteger MultiplyByRadixPower(BigInteger bigint, FastInteger power) {
            BigInteger tmpbigint = bigint;
            if (power.signum() <= 0) {
                return tmpbigint;
            }
            if (tmpbigint.signum() < 0) {
                tmpbigint = tmpbigint.negate();
                if (power.CanFitInInt32()) {
                    tmpbigint = DecimalUtility.ShiftLeftInt(tmpbigint, power.AsInt32());
                    tmpbigint = tmpbigint.negate();
                } else {
                    tmpbigint = DecimalUtility.ShiftLeft(tmpbigint, power.AsBigInteger());
                    tmpbigint = tmpbigint.negate();
                }
                return tmpbigint;
            }
            return power.CanFitInInt32() ? DecimalUtility.ShiftLeftInt(tmpbigint, power.AsInt32()) : DecimalUtility.ShiftLeft(tmpbigint, power.AsBigInteger());
        }

        @Override
        public int GetFlags(ExtendedFloat value) {
            return value.flags;
        }

        @Override
        public ExtendedFloat CreateNewWithFlags(BigInteger mantissa, BigInteger exponent, int flags) {
            return ExtendedFloat.CreateWithFlags(mantissa, exponent, flags);
        }

        @Override
        public int GetArithmeticSupport() {
            return 1;
        }

        @Override
        public ExtendedFloat ValueOf(int val) {
            return ExtendedFloat.FromInt64(val);
        }
    }
}

