/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.CBORTypeFilter;
import com.upokecenter.cbor.ICBORTag;
import com.upokecenter.util.BigInteger;
import com.upokecenter.util.ExtendedDecimal;
import com.upokecenter.util.ExtendedFloat;

class CBORTag5
implements ICBORTag {
    static final CBORTypeFilter Filter = new CBORTypeFilter().WithArrayExactLength(2, CBORTypeFilter.UnsignedInteger.WithNegativeInteger(), CBORTypeFilter.UnsignedInteger.WithNegativeInteger().WithTags(2, 3));
    static final CBORTypeFilter ExtendedFilter = new CBORTypeFilter().WithArrayExactLength(2, CBORTypeFilter.UnsignedInteger.WithNegativeInteger().WithTags(2, 3), CBORTypeFilter.UnsignedInteger.WithNegativeInteger().WithTags(2, 3));
    private final boolean extended;

    public CBORTag5() {
        this(false);
    }

    public CBORTag5(boolean extended) {
        this.extended = extended;
    }

    public CBORTypeFilter GetTypeFilter() {
        return this.extended ? ExtendedFilter : Filter;
    }

    static CBORObject ConvertToDecimalFrac(CBORObject o, boolean isDecimal, boolean extended) {
        if (o.getType() != CBORType.Array) {
            throw new CBORException("Big fraction must be an array");
        }
        if (o.size() != 2) {
            throw new CBORException("Big fraction requires exactly 2 items");
        }
        if (!o.get(0).isIntegral()) {
            throw new CBORException("Exponent is not an integer");
        }
        if (!o.get(1).isIntegral()) {
            throw new CBORException("Mantissa is not an integer");
        }
        BigInteger exponent = o.get(0).AsBigInteger();
        BigInteger mantissa = o.get(1).AsBigInteger();
        if (exponent.bitLength() > 64 && !extended) {
            throw new CBORException("Exponent is too big");
        }
        if (exponent.signum() == 0) {
            return CBORObject.FromObject(mantissa);
        }
        return isDecimal ? CBORObject.FromObject(ExtendedDecimal.Create(mantissa, exponent)) : CBORObject.FromObject(ExtendedFloat.Create(mantissa, exponent));
    }

    public CBORObject ValidateObject(CBORObject obj) {
        return CBORTag5.ConvertToDecimalFrac(obj, false, this.extended);
    }
}

