/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.util;

import com.upokecenter.util.BigInteger;
import com.upokecenter.util.DecimalUtility;
import com.upokecenter.util.FastInteger;
import com.upokecenter.util.IRadixMath;
import com.upokecenter.util.IRadixMathHelper;
import com.upokecenter.util.IShiftAccumulator;
import com.upokecenter.util.PrecisionContext;
import com.upokecenter.util.Rounding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RadixMath<T>
implements IRadixMath<T> {
    private static final int IntegerModeFixedScale = 1;
    private static final int IntegerModeRegular = 0;
    private IRadixMathHelper<T> helper;
    private int thisRadix;
    private int support;

    public RadixMath(IRadixMathHelper<T> helper) {
        this.helper = helper;
        this.support = helper.GetArithmeticSupport();
        this.thisRadix = helper.GetRadix();
    }

    private T ReturnQuietNaN(T thisValue, PrecisionContext ctx) {
        BigInteger mant = this.helper.GetMantissa(thisValue).abs();
        boolean mantChanged = false;
        if (mant.signum() != 0 && ctx != null && ctx.getHasMaxPrecision()) {
            FastInteger compPrecision = FastInteger.FromBig(ctx.getPrecision());
            if (this.helper.CreateShiftAccumulator(mant).GetDigitLength().compareTo(compPrecision) >= 0) {
                BigInteger limit = this.TryMultiplyByRadixPower(BigInteger.ONE, compPrecision);
                if (limit == null) {
                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                }
                if (mant.compareTo(limit) >= 0) {
                    mant = mant.remainder(limit);
                    mantChanged = true;
                }
            }
        }
        int flags = this.helper.GetFlags(thisValue);
        if (!mantChanged && (flags & 4) != 0) {
            return thisValue;
        }
        flags &= 1;
        return this.helper.CreateNewWithFlags(mant, BigInteger.ZERO, flags |= 4);
    }

    private T SquareRootHandleSpecial(T thisValue, PrecisionContext ctx) {
        int sign;
        int thisFlags = this.helper.GetFlags(thisValue);
        if ((thisFlags & 0xE) != 0) {
            if ((thisFlags & 8) != 0) {
                return this.SignalingNaNInvalid(thisValue, ctx);
            }
            if ((thisFlags & 4) != 0) {
                return this.ReturnQuietNaN(thisValue, ctx);
            }
            if ((thisFlags & 2) != 0) {
                return (thisFlags & 1) != 0 ? this.SignalInvalid(ctx) : thisValue;
            }
        }
        return (sign = this.helper.GetSign(thisValue)) < 0 ? (T)this.SignalInvalid(ctx) : null;
    }

    private T DivisionHandleSpecial(T thisValue, T other, PrecisionContext ctx) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(other))) & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, other, ctx);
            if (result != (Object)null) {
                return result;
            }
            if ((thisFlags & 2) != 0 && (otherFlags & 2) != 0) {
                return this.SignalInvalid(ctx);
            }
            if ((thisFlags & 2) != 0) {
                return this.EnsureSign(thisValue, ((thisFlags ^ otherFlags) & 1) != 0);
            }
            if ((otherFlags & 2) != 0) {
                if (ctx != null && ctx.getHasExponentRange() && ctx.getPrecision().signum() > 0) {
                    if (ctx.getHasFlags()) {
                        ctx.setFlags(ctx.getFlags() | 0x20);
                    }
                    BigInteger bigexp = ctx.getEMin();
                    BigInteger bigprec = ctx.getPrecision();
                    bigexp = bigexp.subtract(bigprec);
                    bigexp = bigexp.add(BigInteger.ONE);
                    thisFlags = (thisFlags ^ otherFlags) & 1;
                    return this.helper.CreateNewWithFlags(BigInteger.ZERO, bigexp, thisFlags);
                }
                thisFlags = (thisFlags ^ otherFlags) & 1;
                return this.RoundToPrecision(this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, thisFlags), ctx);
            }
        }
        return null;
    }

    private T RemainderHandleSpecial(T thisValue, T other, PrecisionContext ctx) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(other))) & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, other, ctx);
            if (result != (Object)null) {
                return result;
            }
            if ((thisFlags & 2) != 0) {
                return this.SignalInvalid(ctx);
            }
            if ((otherFlags & 2) != 0) {
                return this.RoundToPrecision(thisValue, ctx);
            }
        }
        return this.helper.GetMantissa(other).signum() == 0 ? (T)this.SignalInvalid(ctx) : null;
    }

    private T MinMaxHandleSpecial(T thisValue, T otherValue, PrecisionContext ctx, boolean isMinOp, boolean compareAbs) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(otherValue))) & 0xE) != 0) {
            if ((thisFlags & 8) != 0) {
                return this.SignalingNaNInvalid(thisValue, ctx);
            }
            if ((otherFlags & 8) != 0) {
                return this.SignalingNaNInvalid(otherValue, ctx);
            }
            if ((thisFlags & 4) != 0) {
                if ((otherFlags & 4) != 0) {
                    return this.ReturnQuietNaN(thisValue, ctx);
                }
                return this.RoundToPrecision(otherValue, ctx);
            }
            if ((otherFlags & 4) != 0) {
                return this.RoundToPrecision(thisValue, ctx);
            }
            if ((thisFlags & 2) != 0) {
                if (compareAbs && (otherFlags & 2) == 0) {
                    return isMinOp ? this.RoundToPrecision(otherValue, ctx) : thisValue;
                }
                if (isMinOp) {
                    return (thisFlags & 1) != 0 ? thisValue : this.RoundToPrecision(otherValue, ctx);
                }
                return (thisFlags & 1) == 0 ? thisValue : this.RoundToPrecision(otherValue, ctx);
            }
            if ((otherFlags & 2) != 0) {
                if (compareAbs) {
                    return isMinOp ? this.RoundToPrecision(thisValue, ctx) : otherValue;
                }
                return isMinOp ? ((otherFlags & 1) == 0 ? this.RoundToPrecision(thisValue, ctx) : otherValue) : ((otherFlags & 1) != 0 ? this.RoundToPrecision(thisValue, ctx) : otherValue);
            }
        }
        return null;
    }

    private T HandleNotANumber(T thisValue, T other, PrecisionContext ctx) {
        int thisFlags = this.helper.GetFlags(thisValue);
        int otherFlags = this.helper.GetFlags(other);
        if ((thisFlags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((otherFlags & 8) != 0) {
            return this.SignalingNaNInvalid(other, ctx);
        }
        return (T)((thisFlags & 4) != 0 ? this.ReturnQuietNaN(thisValue, ctx) : ((otherFlags & 4) != 0 ? this.ReturnQuietNaN(other, ctx) : null));
    }

    private T MultiplyAddHandleSpecial(T op1, T op2, T op3, PrecisionContext ctx) {
        int op1Flags = this.helper.GetFlags(op1);
        if ((op1Flags & 8) != 0) {
            return this.SignalingNaNInvalid(op1, ctx);
        }
        int op2Flags = this.helper.GetFlags(op2);
        if ((op2Flags & 8) != 0) {
            return this.SignalingNaNInvalid(op2, ctx);
        }
        int op3Flags = this.helper.GetFlags(op3);
        if ((op3Flags & 8) != 0) {
            return this.SignalingNaNInvalid(op3, ctx);
        }
        if ((op1Flags & 4) != 0) {
            return this.ReturnQuietNaN(op1, ctx);
        }
        if ((op2Flags & 4) != 0) {
            return this.ReturnQuietNaN(op2, ctx);
        }
        if ((op1Flags & 2) != 0 && (op2Flags & 0xE) == 0 && this.helper.GetMantissa(op2).signum() == 0) {
            return this.SignalInvalid(ctx);
        }
        if ((op2Flags & 2) != 0 && (op1Flags & 0xE) == 0 && this.helper.GetMantissa(op1).signum() == 0) {
            return this.SignalInvalid(ctx);
        }
        return (op3Flags & 4) != 0 ? (T)this.ReturnQuietNaN(op3, ctx) : null;
    }

    private T ValueOf(int value, PrecisionContext ctx) {
        return ctx == null || !ctx.getHasExponentRange() || ctx.ExponentWithinRange(BigInteger.ZERO) ? this.helper.ValueOf(value) : this.RoundToPrecision(this.helper.ValueOf(value), ctx);
    }

    private int CompareToHandleSpecialReturnInt(T thisValue, T other) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(other))) & 0xE) != 0) {
            if ((thisFlags & 2) != 0) {
                return (thisFlags & 3) == (otherFlags & 3) ? 0 : ((thisFlags & 1) == 0 ? 1 : -1);
            }
            if ((otherFlags & 2) != 0) {
                return (thisFlags & 3) == (otherFlags & 3) ? 0 : ((otherFlags & 1) == 0 ? -1 : 1);
            }
        }
        return 2;
    }

    private T CompareToHandleSpecial(T thisValue, T other, boolean treatQuietNansAsSignaling, PrecisionContext ctx) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(other))) & 0xE) != 0) {
            if ((thisFlags & 8) != 0) {
                return this.SignalingNaNInvalid(thisValue, ctx);
            }
            if ((otherFlags & 8) != 0) {
                return this.SignalingNaNInvalid(other, ctx);
            }
            if (treatQuietNansAsSignaling) {
                if ((thisFlags & 4) != 0) {
                    return this.SignalingNaNInvalid(thisValue, ctx);
                }
                if ((otherFlags & 4) != 0) {
                    return this.SignalingNaNInvalid(other, ctx);
                }
            } else {
                if ((thisFlags & 4) != 0) {
                    return this.ReturnQuietNaN(thisValue, ctx);
                }
                if ((otherFlags & 4) != 0) {
                    return this.ReturnQuietNaN(other, ctx);
                }
            }
            if ((thisFlags & 2) != 0) {
                return (thisFlags & 3) == (otherFlags & 3) ? this.ValueOf(0, null) : ((thisFlags & 1) == 0 ? this.ValueOf(1, null) : this.ValueOf(-1, null));
            }
            if ((otherFlags & 2) != 0) {
                return (thisFlags & 3) == (otherFlags & 3) ? this.ValueOf(0, null) : ((otherFlags & 1) == 0 ? this.ValueOf(-1, null) : this.ValueOf(1, null));
            }
        }
        return null;
    }

    private T SignalingNaNInvalid(T value, PrecisionContext ctx) {
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 0x40);
        }
        return this.ReturnQuietNaN(value, ctx);
    }

    private T SignalInvalid(PrecisionContext ctx) {
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 0x40);
        }
        if (this.support == 0) {
            throw new ArithmeticException("Invalid operation");
        }
        return this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, 4);
    }

    private T SignalInvalidWithMessage(PrecisionContext ctx, String str) {
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 0x40);
        }
        if (this.support == 0) {
            throw new ArithmeticException(str);
        }
        return this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, 4);
    }

    private T SignalOverflow(boolean neg) {
        return this.support == 0 ? null : (T)this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, (neg ? 1 : 0) | 2);
    }

    private T SignalOverflow2(PrecisionContext ctx, boolean neg) {
        if (ctx != null) {
            Rounding roundingOnOverflow = ctx.getRounding();
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | 0x13);
            }
            if (ctx.getHasMaxPrecision() && ctx.getHasExponentRange() && (roundingOnOverflow == Rounding.Down || roundingOnOverflow == Rounding.ZeroFiveUp || roundingOnOverflow == Rounding.Ceiling && neg || roundingOnOverflow == Rounding.Floor && !neg)) {
                BigInteger overflowMant = BigInteger.ZERO;
                FastInteger fastPrecision = FastInteger.FromBig(ctx.getPrecision());
                overflowMant = this.TryMultiplyByRadixPower(BigInteger.ONE, fastPrecision);
                if (overflowMant == null) {
                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                }
                overflowMant = overflowMant.subtract(BigInteger.ONE);
                FastInteger clamp = FastInteger.FromBig(ctx.getEMax());
                if (ctx.getAdjustExponent()) {
                    clamp.Increment().Subtract(fastPrecision);
                }
                return this.helper.CreateNewWithFlags(overflowMant, clamp.AsBigInteger(), neg ? 1 : 0);
            }
        }
        return this.SignalOverflow(neg);
    }

    private T SignalDivideByZero(PrecisionContext ctx, boolean neg) {
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 0x80);
        }
        if (this.support == 0) {
            throw new ArithmeticException("Division by zero");
        }
        return this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, 2 | (neg ? 1 : 0));
    }

    private boolean Round(IShiftAccumulator accum, Rounding rounding, boolean neg, FastInteger fastint) {
        boolean incremented = false;
        if (rounding == Rounding.HalfEven) {
            int radix = this.thisRadix;
            if (accum.getLastDiscardedDigit() >= radix / 2) {
                incremented = accum.getLastDiscardedDigit() > radix / 2 || accum.getOlderDiscardedDigits() != 0 ? true : (incremented |= !fastint.isEvenNumber());
            }
        } else if (rounding == Rounding.ZeroFiveUp) {
            int radix = this.thisRadix;
            if ((accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0) {
                if (radix == 2) {
                    incremented = true;
                } else {
                    int lastDigit = FastInteger.Copy(fastint).Remainder(radix).AsInt32();
                    if (lastDigit == 0 || lastDigit == radix / 2) {
                        incremented = true;
                    }
                }
            }
        } else if (rounding != Rounding.Down) {
            incremented = this.RoundGivenDigits(accum.getLastDiscardedDigit(), accum.getOlderDiscardedDigits(), rounding, neg, BigInteger.ZERO);
        }
        return incremented;
    }

    private boolean RoundGivenDigits(int lastDiscarded, int olderDiscarded, Rounding rounding, boolean neg, BigInteger bigval) {
        boolean incremented = false;
        int radix = this.thisRadix;
        if (rounding == Rounding.HalfUp) {
            incremented |= lastDiscarded >= radix / 2;
        } else if (rounding == Rounding.HalfEven) {
            if (lastDiscarded >= radix / 2) {
                incremented = lastDiscarded > radix / 2 || olderDiscarded != 0 ? true : (incremented |= bigval.testBit(0));
            }
        } else if (rounding == Rounding.Ceiling) {
            incremented |= !neg && (lastDiscarded | olderDiscarded) != 0;
        } else if (rounding == Rounding.Floor) {
            incremented |= neg && (lastDiscarded | olderDiscarded) != 0;
        } else if (rounding == Rounding.HalfDown) {
            incremented |= lastDiscarded > radix / 2 || lastDiscarded == radix / 2 && olderDiscarded != 0;
        } else if (rounding == Rounding.Up) {
            incremented |= (lastDiscarded | olderDiscarded) != 0;
        } else if (rounding == Rounding.ZeroFiveUp && (lastDiscarded | olderDiscarded) != 0) {
            if (radix == 2) {
                incremented = true;
            } else {
                BigInteger bigdigit = bigval.remainder(BigInteger.valueOf(radix));
                int lastDigit = bigdigit.intValue();
                if (lastDigit == 0 || lastDigit == radix / 2) {
                    incremented = true;
                }
            }
        }
        return incremented;
    }

    private boolean RoundGivenBigInt(IShiftAccumulator accum, Rounding rounding, boolean neg, BigInteger bigval) {
        return this.RoundGivenDigits(accum.getLastDiscardedDigit(), accum.getOlderDiscardedDigits(), rounding, neg, bigval);
    }

    private BigInteger RescaleByExponentDiff(BigInteger mantissa, BigInteger e1, BigInteger e2) {
        if (mantissa.signum() == 0) {
            return BigInteger.ZERO;
        }
        FastInteger diff = FastInteger.FromBig(e1).SubtractBig(e2).Abs();
        return this.TryMultiplyByRadixPower(mantissa, diff);
    }

    private T EnsureSign(T val, boolean negative) {
        if (val == null) {
            return val;
        }
        int flags = this.helper.GetFlags(val);
        if (negative && (flags & 1) == 0 || !negative && (flags & 1) != 0) {
            flags &= 0xFFFFFFFE;
            return this.helper.CreateNewWithFlags(this.helper.GetMantissa(val), this.helper.GetExponent(val), flags |= negative ? 1 : 0);
        }
        return val;
    }

    @Override
    public T DivideToIntegerNaturalScale(T thisValue, T divisor, PrecisionContext ctx) {
        FastInteger desiredScale = FastInteger.FromBig(this.helper.GetExponent(thisValue)).SubtractBig(this.helper.GetExponent(divisor));
        PrecisionContext ctx2 = PrecisionContext.ForRounding(Rounding.Down).WithBigPrecision(ctx == null ? BigInteger.ZERO : ctx.getPrecision()).WithBlankFlags();
        T ret = this.DivideInternal(thisValue, divisor, ctx2, 1, BigInteger.ZERO);
        if ((ctx2.getFlags() & 0xC0) != 0) {
            if (ctx != null && ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | 0xC0);
            }
            return ret;
        }
        boolean neg = this.helper.GetSign(thisValue) < 0 ^ this.helper.GetSign(divisor) < 0;
        if (this.helper.GetMantissa(ret).signum() == 0) {
            BigInteger dividendExp = this.helper.GetExponent(thisValue);
            BigInteger divisorExp = this.helper.GetExponent(divisor);
            ret = this.helper.CreateNewWithFlags(BigInteger.ZERO, dividendExp.subtract(divisorExp), this.helper.GetFlags(ret));
        } else if (desiredScale.signum() < 0) {
            desiredScale.Negate();
            BigInteger bigmantissa = this.helper.GetMantissa(ret).abs();
            bigmantissa = this.TryMultiplyByRadixPower(bigmantissa, desiredScale);
            if (bigmantissa == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            BigInteger exponentDivisor = this.helper.GetExponent(divisor);
            ret = this.helper.CreateNewWithFlags(bigmantissa, this.helper.GetExponent(thisValue).subtract(exponentDivisor), this.helper.GetFlags(ret));
        } else if (desiredScale.signum() > 0) {
            BigInteger bigmantissa = this.helper.GetMantissa(ret).abs();
            FastInteger fastexponent = FastInteger.FromBig(this.helper.GetExponent(ret));
            BigInteger bigradix = BigInteger.valueOf(this.thisRadix);
            while (desiredScale.compareTo(fastexponent) != 0) {
                BigInteger[] divrem = bigmantissa.divideAndRemainder(bigradix);
                BigInteger bigquo = divrem[0];
                BigInteger bigrem = divrem[1];
                if (bigrem.signum() != 0) break;
                bigmantissa = bigquo;
                fastexponent.Increment();
            }
            ret = this.helper.CreateNewWithFlags(bigmantissa, fastexponent.AsBigInteger(), this.helper.GetFlags(ret));
        }
        if (ctx != null) {
            ret = this.RoundToPrecision(ret, ctx);
        }
        ret = this.EnsureSign(ret, neg);
        return ret;
    }

    @Override
    public T DivideToIntegerZeroScale(T thisValue, T divisor, PrecisionContext ctx) {
        PrecisionContext ctx2 = PrecisionContext.ForRounding(Rounding.Down).WithBigPrecision(ctx == null ? BigInteger.ZERO : ctx.getPrecision()).WithBlankFlags();
        T ret = this.DivideInternal(thisValue, divisor, ctx2, 1, BigInteger.ZERO);
        if ((ctx2.getFlags() & 0xC0) != 0) {
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | ctx2.getFlags() & 0xC0);
            }
            return ret;
        }
        if (ctx != null) {
            ctx2 = ctx.WithBlankFlags().WithUnlimitedExponents();
            ret = this.RoundToPrecision(ret, ctx2);
            if ((ctx2.getFlags() & 2) != 0) {
                return this.SignalInvalid(ctx);
            }
        }
        return ret;
    }

    @Override
    public T Abs(T value, PrecisionContext ctx) {
        int flags = this.helper.GetFlags(value);
        return (flags & 8) != 0 ? this.SignalingNaNInvalid(value, ctx) : ((flags & 4) != 0 ? this.ReturnQuietNaN(value, ctx) : ((flags & 1) != 0 ? this.RoundToPrecision(this.helper.CreateNewWithFlags(this.helper.GetMantissa(value), this.helper.GetExponent(value), flags & 0xFFFFFFFE), ctx) : this.RoundToPrecision(value, ctx)));
    }

    @Override
    public T Negate(T value, PrecisionContext ctx) {
        int flags = this.helper.GetFlags(value);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(value, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(value, ctx);
        }
        BigInteger mant = this.helper.GetMantissa(value);
        if ((flags & 2) == 0 && mant.signum() == 0) {
            if ((flags & 1) == 0) {
                return this.RoundToPrecision(this.helper.CreateNewWithFlags(mant, this.helper.GetExponent(value), flags & 0xFFFFFFFE), ctx);
            }
            if (ctx != null && ctx.getRounding() == Rounding.Floor) {
                return this.RoundToPrecision(this.helper.CreateNewWithFlags(mant, this.helper.GetExponent(value), flags | 1), ctx);
            }
            return this.RoundToPrecision(this.helper.CreateNewWithFlags(mant, this.helper.GetExponent(value), flags & 0xFFFFFFFE), ctx);
        }
        return this.RoundToPrecision(this.helper.CreateNewWithFlags(mant, this.helper.GetExponent(value), flags ^= 1), ctx);
    }

    private T AbsRaw(T value) {
        return this.EnsureSign(value, false);
    }

    private boolean IsFinite(T val) {
        return (this.helper.GetFlags(val) & 0xE) == 0;
    }

    private boolean IsNegative(T val) {
        return (this.helper.GetFlags(val) & 1) != 0;
    }

    private T NegateRaw(T val) {
        if (val == null) {
            return val;
        }
        int sign = this.helper.GetFlags(val) & 1;
        return this.helper.CreateNewWithFlags(this.helper.GetMantissa(val), this.helper.GetExponent(val), sign == 0 ? 1 : 0);
    }

    private static void TransferFlags(PrecisionContext ctxDst, PrecisionContext ctxSrc) {
        if (ctxDst != null && ctxDst.getHasFlags()) {
            if ((ctxSrc.getFlags() & 0xC0) != 0) {
                ctxDst.setFlags(ctxDst.getFlags() | ctxSrc.getFlags() & 0xC0);
            } else {
                ctxDst.setFlags(ctxDst.getFlags() | ctxSrc.getFlags());
            }
        }
    }

    @Override
    public T Remainder(T thisValue, T divisor, PrecisionContext ctx) {
        PrecisionContext ctx2 = ctx == null ? null : ctx.WithBlankFlags();
        T ret = this.RemainderHandleSpecial(thisValue, divisor, ctx2);
        if (ret != (Object)null) {
            RadixMath.TransferFlags(ctx, ctx2);
            return ret;
        }
        ret = this.DivideToIntegerZeroScale(thisValue, divisor, ctx2);
        if ((ctx2.getFlags() & 0x40) != 0) {
            return this.SignalInvalid(ctx);
        }
        ret = this.Add(thisValue, this.NegateRaw(this.Multiply(ret, divisor, null)), ctx2);
        ret = this.EnsureSign(ret, (this.helper.GetFlags(thisValue) & 1) != 0);
        RadixMath.TransferFlags(ctx, ctx2);
        return ret;
    }

    @Override
    public T RemainderNear(T thisValue, T divisor, PrecisionContext ctx) {
        PrecisionContext ctx2 = ctx == null ? PrecisionContext.ForRounding(Rounding.HalfEven).WithBlankFlags() : ctx.WithRounding(Rounding.HalfEven).WithBlankFlags();
        T ret = this.RemainderHandleSpecial(thisValue, divisor, ctx2);
        if (ret != (Object)null) {
            RadixMath.TransferFlags(ctx, ctx2);
            return ret;
        }
        ret = this.DivideInternal(thisValue, divisor, ctx2, 1, BigInteger.ZERO);
        if ((ctx2.getFlags() & 0x40) != 0) {
            return this.SignalInvalid(ctx);
        }
        ctx2 = ctx2.WithBlankFlags();
        ret = this.RoundToPrecision(ret, ctx2);
        if ((ctx2.getFlags() & 0x42) != 0) {
            return this.SignalInvalid(ctx);
        }
        ctx2 = ctx == null ? PrecisionContext.Unlimited.WithBlankFlags() : ctx.WithBlankFlags();
        T ret2 = this.Add(thisValue, this.NegateRaw(this.Multiply(ret, divisor, null)), ctx2);
        if ((ctx2.getFlags() & 0x40) != 0) {
            return this.SignalInvalid(ctx);
        }
        if (this.helper.GetFlags(ret2) == 0 && this.helper.GetMantissa(ret2).signum() == 0) {
            ret2 = this.EnsureSign(ret2, (this.helper.GetFlags(thisValue) & 1) != 0);
        }
        RadixMath.TransferFlags(ctx, ctx2);
        return ret2;
    }

    @Override
    public T Pi(PrecisionContext ctx) {
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        T a = this.helper.ValueOf(1);
        PrecisionContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().add(BigInteger.TEN)).WithRounding(this.thisRadix == 2 ? Rounding.HalfEven : Rounding.ZeroFiveUp);
        T two = this.helper.ValueOf(2);
        T b = this.Divide(a, this.SquareRoot(two, ctxdiv), ctxdiv);
        T four = this.helper.ValueOf(4);
        T half = (this.thisRadix & 1) == 0 ? (T)this.helper.CreateNewWithFlags(BigInteger.valueOf(this.thisRadix / 2), BigInteger.ZERO.subtract(BigInteger.ONE), 0) : null;
        T t = this.Divide(a, four, ctxdiv);
        boolean more = true;
        int lastCompare = 0;
        int vacillations = 0;
        T lastGuess = null;
        T guess = null;
        BigInteger powerTwo = BigInteger.ONE;
        while (more) {
            lastGuess = guess;
            T aplusB = this.Add(a, b, null);
            T newA = half == null ? this.Divide(aplusB, two, ctxdiv) : this.Multiply(aplusB, half, null);
            T valueAMinusNewA = this.Add(a, this.NegateRaw(newA), null);
            if (!a.equals(b)) {
                T atimesB = this.Multiply(a, b, ctxdiv);
                b = this.SquareRoot(atimesB, ctxdiv);
            }
            a = newA;
            guess = this.Multiply(aplusB, aplusB, null);
            T newGuess = guess = this.Divide(guess, this.Multiply(t, four, null), ctxdiv);
            if (lastGuess != (Object)null) {
                int guessCmp = this.compareTo(lastGuess, newGuess);
                if (guessCmp == 0) {
                    more = false;
                } else if (guessCmp > 0 && lastCompare < 0 || lastCompare > 0 && guessCmp < 0) {
                    more &= ++vacillations <= 3 || guessCmp <= 0;
                }
                lastCompare = guessCmp;
            }
            if (more) {
                T tmpT = this.Multiply(valueAMinusNewA, valueAMinusNewA, null);
                tmpT = this.Multiply(tmpT, this.helper.CreateNewWithFlags(powerTwo, BigInteger.ZERO, 0), null);
                t = this.Add(t, this.NegateRaw(tmpT), ctxdiv);
                powerTwo = powerTwo.shiftLeft(1);
            }
            guess = newGuess;
        }
        return this.RoundToPrecision(guess, ctx);
    }

    private T LnInternal(T thisValue, BigInteger workingPrecision, PrecisionContext ctx) {
        boolean more = true;
        int lastCompare = 0;
        int vacillations = 0;
        PrecisionContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, workingPrecision.add(BigInteger.valueOf(6L))).WithRounding(this.thisRadix == 2 ? Rounding.HalfEven : Rounding.ZeroFiveUp);
        T z = this.Add(this.NegateRaw(thisValue), this.helper.ValueOf(1), null);
        T zpow = this.Multiply(z, z, ctxdiv);
        T guess = this.NegateRaw(z);
        T lastGuess = null;
        BigInteger denom = BigInteger.valueOf(2L);
        while (more) {
            lastGuess = guess;
            T tmp = this.Divide(zpow, this.helper.CreateNewWithFlags(denom, BigInteger.ZERO, 0), ctxdiv);
            T newGuess = this.Add(guess, this.NegateRaw(tmp), ctxdiv);
            int guessCmp = this.compareTo(lastGuess, newGuess);
            if (guessCmp == 0) {
                more = false;
            } else if (guessCmp > 0 && lastCompare < 0 || lastCompare > 0 && guessCmp < 0) {
                more &= ++vacillations <= 3 || guessCmp <= 0;
            }
            lastCompare = guessCmp;
            guess = newGuess;
            if (!more) continue;
            zpow = this.Multiply(zpow, z, ctxdiv);
            denom = denom.add(BigInteger.ONE);
        }
        return this.RoundToPrecision(guess, ctx);
    }

    private T ExpInternal(T thisValue, BigInteger workingPrecision, PrecisionContext ctx) {
        T guess;
        T one = this.helper.ValueOf(1);
        PrecisionContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, workingPrecision.add(BigInteger.valueOf(6L))).WithRounding(this.thisRadix == 2 ? Rounding.Down : Rounding.ZeroFiveUp);
        BigInteger bigintN = BigInteger.valueOf(2L);
        BigInteger facto = BigInteger.ONE;
        T lastGuess = guess = this.Add(one, thisValue, null);
        T pow = thisValue;
        boolean more = true;
        int lastCompare = 0;
        int vacillations = 0;
        while (more) {
            lastGuess = guess;
            T tmp = this.Divide(pow = this.Multiply(pow, thisValue, ctxdiv), this.helper.CreateNewWithFlags(facto = facto.multiply(bigintN), BigInteger.ZERO, 0), ctxdiv);
            T newGuess = this.Add(guess, tmp, ctxdiv);
            int guessCmp = this.compareTo(lastGuess, newGuess);
            if (guessCmp == 0) {
                more = false;
            } else if (guessCmp > 0 && lastCompare < 0 || lastCompare > 0 && guessCmp < 0) {
                more &= ++vacillations <= 3 || guessCmp <= 0;
            }
            lastCompare = guessCmp;
            guess = newGuess;
            if (!more) continue;
            bigintN = bigintN.add(BigInteger.ONE);
        }
        return this.RoundToPrecision(guess, ctx);
    }

    private static PrecisionContext SetPrecisionIfLimited(PrecisionContext ctx, BigInteger bigPrecision) {
        return ctx == null || !ctx.getHasMaxPrecision() ? ctx : ctx.WithBigPrecision(bigPrecision);
    }

    private T PowerIntegral(T thisValue, BigInteger powIntBig, PrecisionContext ctx) {
        int sign = powIntBig.signum();
        T one = this.helper.ValueOf(1);
        if (sign == 0) {
            return this.RoundToPrecision(one, ctx);
        }
        if (powIntBig.equals(BigInteger.ONE)) {
            return this.RoundToPrecision(thisValue, ctx);
        }
        if (powIntBig.equals(BigInteger.valueOf(2L))) {
            return this.Multiply(thisValue, thisValue, ctx);
        }
        if (powIntBig.equals(BigInteger.valueOf(3L))) {
            return this.Multiply(thisValue, this.Multiply(thisValue, thisValue, null), ctx);
        }
        boolean retvalNeg = this.IsNegative(thisValue) && powIntBig.testBit(0);
        FastInteger error = this.helper.CreateShiftAccumulator(powIntBig.abs()).GetDigitLength();
        error.AddInt(6);
        BigInteger bigError = error.AsBigInteger();
        PrecisionContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().add(bigError)).WithRounding(this.thisRadix == 2 ? Rounding.HalfEven : Rounding.ZeroFiveUp).WithBlankFlags();
        if (sign < 0) {
            thisValue = this.Divide(one, thisValue, ctxdiv);
            if ((ctxdiv.getFlags() & 0x10) != 0) {
                return this.SignalOverflow2(ctx, retvalNeg);
            }
            powIntBig = powIntBig.negate();
        }
        T r = one;
        while (powIntBig.signum() != 0) {
            if (powIntBig.testBit(0)) {
                r = this.Multiply(r, thisValue, ctxdiv);
                if ((ctxdiv.getFlags() & 0x10) != 0) {
                    return this.SignalOverflow2(ctx, retvalNeg);
                }
            }
            if ((powIntBig = powIntBig.shiftRight(1)).signum() == 0) continue;
            ctxdiv.setFlags(0);
            T tmp = this.Multiply(thisValue, thisValue, ctxdiv);
            if ((ctxdiv.getFlags() & 0x10) != 0) {
                return this.SignalOverflow2(ctx, retvalNeg);
            }
            thisValue = tmp;
        }
        return this.RoundToPrecision(r, ctx);
    }

    private T ExtendPrecision(T thisValue, PrecisionContext ctx) {
        if (ctx == null || !ctx.getHasMaxPrecision()) {
            return this.RoundToPrecision(thisValue, ctx);
        }
        BigInteger mant = this.helper.GetMantissa(thisValue).abs();
        FastInteger digits = this.helper.CreateShiftAccumulator(mant).GetDigitLength();
        FastInteger fastPrecision = FastInteger.FromBig(ctx.getPrecision());
        BigInteger exponent = this.helper.GetExponent(thisValue);
        if (digits.compareTo(fastPrecision) < 0) {
            fastPrecision.Subtract(digits);
            mant = this.TryMultiplyByRadixPower(mant, fastPrecision);
            if (mant == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            BigInteger bigPrec = fastPrecision.AsBigInteger();
            exponent = exponent.subtract(bigPrec);
        }
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 2);
            ctx.setFlags(ctx.getFlags() | 1);
        }
        return this.RoundToPrecision(this.helper.CreateNewWithFlags(mant, exponent, 0), ctx);
    }

    private boolean IsWithinExponentRangeForPow(T thisValue, PrecisionContext ctx) {
        if (ctx == null || !ctx.getHasExponentRange()) {
            return true;
        }
        FastInteger digits = this.helper.CreateShiftAccumulator(this.helper.GetMantissa(thisValue).abs()).GetDigitLength();
        BigInteger exp = this.helper.GetExponent(thisValue);
        FastInteger fi = FastInteger.FromBig(exp);
        if (ctx.getAdjustExponent()) {
            fi.Add(digits);
            fi.Decrement();
        }
        if (fi.signum() < 0) {
            fi.Negate().Divide(2).Negate();
        }
        return (exp = fi.AsBigInteger()).compareTo(ctx.getEMin()) >= 0 && exp.compareTo(ctx.getEMax()) <= 0;
    }

    @Override
    public T Power(T thisValue, T pow, PrecisionContext ctx) {
        boolean isResultNegative;
        T ret = this.HandleNotANumber(thisValue, pow, ctx);
        if (ret != (Object)null) {
            return ret;
        }
        int thisSign = this.helper.GetSign(thisValue);
        int powSign = this.helper.GetSign(pow);
        int thisFlags = this.helper.GetFlags(thisValue);
        int powFlags = this.helper.GetFlags(pow);
        if (thisSign == 0 && powSign == 0) {
            return this.SignalInvalid(ctx);
        }
        if (thisSign < 0 && (powFlags & 2) != 0) {
            return this.SignalInvalid(ctx);
        }
        if (thisSign > 0 && (thisFlags & 2) == 0 && (powFlags & 2) != 0) {
            int cmp = this.compareTo(thisValue, this.helper.ValueOf(1));
            if (cmp < 0) {
                if (powSign < 0) {
                    return this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, 2);
                }
                return this.RoundToPrecision(this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, 0), ctx);
            }
            if (cmp == 0) {
                return this.ExtendPrecision(this.helper.ValueOf(1), ctx);
            }
            if (powSign > 0) {
                return pow;
            }
            return this.RoundToPrecision(this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, 0), ctx);
        }
        BigInteger powExponent = this.helper.GetExponent(pow);
        boolean isPowIntegral = powExponent.signum() > 0;
        boolean isPowOdd = false;
        Object powInt = null;
        if (!isPowIntegral) {
            powInt = this.Quantize(pow, this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, 0), PrecisionContext.ForRounding(Rounding.Down));
            isPowIntegral = this.compareTo(powInt, pow) == 0;
            isPowOdd = !(!this.helper.GetMantissa(powInt).testBit(0));
        } else {
            isPowOdd = powExponent.equals(BigInteger.ZERO) ? !(!this.helper.GetMantissa(powInt).testBit(0)) : (this.thisRadix % 2 == 0 ? false : !(!this.helper.GetMantissa(powInt = (Object)this.Quantize(pow, this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, 0), PrecisionContext.ForRounding(Rounding.Down))).testBit(0)));
        }
        boolean bl = isResultNegative = (thisFlags & 1) != 0 && (powFlags & 2) == 0 && isPowIntegral && isPowOdd;
        if (thisSign == 0 && powSign != 0) {
            int infinityFlags;
            int n = infinityFlags = powSign < 0 ? 2 : 0;
            if (isResultNegative) {
                infinityFlags |= 1;
            }
            thisValue = this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, infinityFlags);
            if ((infinityFlags & 2) == 0) {
                thisValue = this.RoundToPrecision(thisValue, ctx);
            }
            return thisValue;
        }
        if (!(isPowIntegral && powSign >= 0 || ctx != null && ctx.getHasMaxPrecision())) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null or has unlimited precision, and pow's exponent is not an integer or is negative");
        }
        if (thisSign < 0 && !isPowIntegral) {
            return this.SignalInvalid(ctx);
        }
        if ((thisFlags & 2) != 0) {
            return powSign > 0 ? this.RoundToPrecision(this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, (isResultNegative ? 1 : 0) | 2), ctx) : (powSign < 0 ? this.RoundToPrecision(this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, isResultNegative ? 1 : 0), ctx) : this.RoundToPrecision(this.helper.CreateNewWithFlags(BigInteger.ONE, BigInteger.ZERO, 0), ctx));
        }
        if (powSign == 0) {
            return this.RoundToPrecision(this.helper.CreateNewWithFlags(BigInteger.ONE, BigInteger.ZERO, 0), ctx);
        }
        if (isPowIntegral) {
            if (this.compareTo(thisValue, this.helper.ValueOf(1)) == 0) {
                return !this.IsWithinExponentRangeForPow(pow, ctx) ? this.SignalInvalid(ctx) : this.helper.ValueOf(1);
            }
            if (powInt == (Object)null) {
                powInt = this.Quantize(pow, this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, 0), PrecisionContext.ForRounding(Rounding.Down));
            }
            BigInteger signedMant = this.helper.GetMantissa(powInt).abs();
            if (powSign < 0) {
                signedMant = signedMant.negate();
            }
            return this.PowerIntegral(thisValue, signedMant, ctx);
        }
        if (this.compareTo(thisValue, this.helper.ValueOf(1)) == 0 && powSign > 0) {
            return !this.IsWithinExponentRangeForPow(pow, ctx) ? this.SignalInvalid(ctx) : this.ExtendPrecision(this.helper.ValueOf(1), ctx);
        }
        if (this.thisRadix == 10 || this.thisRadix == 2) {
            T half;
            T t = half = this.thisRadix == 10 ? this.helper.CreateNewWithFlags(BigInteger.valueOf(5L), BigInteger.ZERO.subtract(BigInteger.ONE), 0) : this.helper.CreateNewWithFlags(BigInteger.ONE, BigInteger.ZERO.subtract(BigInteger.ONE), 0);
            if (this.compareTo(pow, half) == 0 && this.IsWithinExponentRangeForPow(pow, ctx) && this.IsWithinExponentRangeForPow(thisValue, ctx)) {
                PrecisionContext ctxCopy = ctx.WithBlankFlags();
                thisValue = this.SquareRoot(thisValue, ctxCopy);
                ctxCopy.setFlags(ctxCopy.getFlags() | 1);
                ctxCopy.setFlags(ctxCopy.getFlags() | 2);
                if ((ctxCopy.getFlags() & 4) != 0) {
                    ctxCopy.setFlags(ctxCopy.getFlags() | 8);
                }
                thisValue = this.ExtendPrecision(thisValue, ctxCopy);
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | ctxCopy.getFlags());
                }
                return thisValue;
            }
        }
        int guardDigitCount = this.thisRadix == 2 ? 32 : 10;
        BigInteger guardDigits = BigInteger.valueOf(guardDigitCount);
        PrecisionContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().add(guardDigits));
        ctxdiv = ctxdiv.WithRounding(this.thisRadix == 2 ? Rounding.HalfEven : Rounding.ZeroFiveUp).WithBlankFlags();
        T lnresult = this.Ln(thisValue, ctxdiv);
        lnresult = this.Multiply(lnresult, pow, ctxdiv);
        ctxdiv = ctx.WithBlankFlags();
        lnresult = this.Exp(lnresult, ctxdiv);
        if ((ctxdiv.getFlags() & 0x30) != 0) {
            if (!this.IsWithinExponentRangeForPow(thisValue, ctx)) {
                return this.SignalInvalid(ctx);
            }
            if (!this.IsWithinExponentRangeForPow(pow, ctx)) {
                return this.SignalInvalid(ctx);
            }
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctxdiv.getFlags());
        }
        return lnresult;
    }

    @Override
    public T Log10(T thisValue, PrecisionContext ctx) {
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        int flags = this.helper.GetFlags(thisValue);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(thisValue, ctx);
        }
        int sign = this.helper.GetSign(thisValue);
        if (sign < 0) {
            return this.SignalInvalid(ctx);
        }
        if ((flags & 2) != 0) {
            return thisValue;
        }
        PrecisionContext ctxCopy = ctx.WithBlankFlags();
        T one = this.helper.ValueOf(1);
        if (sign == 0) {
            thisValue = this.RoundToPrecision(this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, 3), ctxCopy);
        } else if (this.compareTo(thisValue, one) == 0) {
            thisValue = this.RoundToPrecision(this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, 0), ctxCopy);
        } else {
            BigInteger exp = this.helper.GetExponent(thisValue);
            BigInteger mant = this.helper.GetMantissa(thisValue).abs();
            if (mant.equals(BigInteger.ONE) && this.thisRadix == 10) {
                thisValue = this.RoundToPrecision(this.helper.CreateNewWithFlags(exp, BigInteger.ZERO, exp.signum() < 0 ? 1 : 0), ctxCopy);
            } else {
                BigInteger mantissa = this.helper.GetMantissa(thisValue);
                FastInteger expTmp = FastInteger.FromBig(exp);
                BigInteger tenBig = BigInteger.TEN;
                while (true) {
                    BigInteger[] divrem = mantissa.divideAndRemainder(tenBig);
                    BigInteger bigquo = divrem[0];
                    BigInteger bigrem = divrem[1];
                    if (bigrem.signum() != 0) break;
                    mantissa = bigquo;
                    expTmp.Increment();
                }
                if (mantissa.compareTo(BigInteger.ONE) == 0 && (this.thisRadix == 10 || expTmp.signum() == 0 || exp.signum() == 0)) {
                    thisValue = this.RoundToPrecision(this.helper.CreateNewWithFlags(expTmp.AsBigInteger(), BigInteger.ZERO, expTmp.signum() < 0 ? 1 : 0), ctxCopy);
                } else {
                    PrecisionContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().add(BigInteger.TEN)).WithRounding(this.thisRadix == 2 ? Rounding.HalfEven : Rounding.ZeroFiveUp).WithBlankFlags();
                    T logNatural = this.Ln(thisValue, ctxdiv);
                    T logTen = this.LnTenConstant(ctxdiv);
                    thisValue = this.Divide(logNatural, logTen, ctx);
                    if (ctx.getHasFlags()) {
                        ctx.setFlags(ctx.getFlags() | 3);
                    }
                }
            }
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctxCopy.getFlags());
        }
        return thisValue;
    }

    private static BigInteger PowerOfTwo(FastInteger fi) {
        if (fi.signum() <= 0) {
            return BigInteger.ONE;
        }
        if (fi.CanFitInInt32()) {
            int val = fi.AsInt32();
            if (val <= 30) {
                val = 1 << val;
                return BigInteger.valueOf(val);
            }
            return BigInteger.ONE.shiftLeft(val);
        }
        BigInteger bi = BigInteger.ONE;
        FastInteger fi2 = FastInteger.Copy(fi);
        while (fi2.signum() > 0) {
            int count = 1000000;
            if (fi2.CompareToInt(1000000) < 0) {
                count = bi.intValue();
            }
            bi = bi.shiftLeft(count);
            fi2.SubtractInt(count);
        }
        return bi;
    }

    private T LnTenConstant(PrecisionContext ctx) {
        T thisValue = this.helper.ValueOf(10);
        FastInteger error = new FastInteger(10);
        BigInteger bigError = error.AsBigInteger();
        PrecisionContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().add(bigError)).WithRounding(this.thisRadix == 2 ? Rounding.HalfEven : Rounding.ZeroFiveUp).WithBlankFlags();
        for (int i = 0; i < 9; ++i) {
            thisValue = this.SquareRoot(thisValue, ctxdiv.WithUnlimitedExponents());
        }
        thisValue = this.Divide(this.helper.ValueOf(1), thisValue, ctxdiv);
        thisValue = this.LnInternal(thisValue, ctxdiv.getPrecision(), ctxdiv);
        thisValue = this.NegateRaw(thisValue);
        thisValue = this.Multiply(thisValue, this.helper.ValueOf(512), ctx);
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 1);
            ctx.setFlags(ctx.getFlags() | 2);
        }
        return thisValue;
    }

    @Override
    public T Ln(T thisValue, PrecisionContext ctx) {
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        int flags = this.helper.GetFlags(thisValue);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(thisValue, ctx);
        }
        int sign = this.helper.GetSign(thisValue);
        if (sign < 0) {
            return this.SignalInvalid(ctx);
        }
        if ((flags & 2) != 0) {
            return thisValue;
        }
        PrecisionContext ctxCopy = ctx.WithBlankFlags();
        T one = this.helper.ValueOf(1);
        if (sign == 0) {
            return this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, 3);
        }
        int cmpOne = this.compareTo(thisValue, one);
        PrecisionContext ctxdiv = null;
        if (cmpOne == 0) {
            thisValue = this.RoundToPrecision(this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, 0), ctxCopy);
        } else if (cmpOne < 0) {
            FastInteger error = new FastInteger(10);
            BigInteger bigError = error.AsBigInteger();
            ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().add(bigError)).WithRounding(this.thisRadix == 2 ? Rounding.HalfEven : Rounding.ZeroFiveUp).WithBlankFlags();
            T quarter = this.Divide(one, this.helper.ValueOf(4), ctxCopy);
            if (this.compareTo(thisValue, quarter) <= 0) {
                T half = this.Multiply(quarter, this.helper.ValueOf(2), null);
                FastInteger roots = new FastInteger(0);
                while (this.compareTo(thisValue, half) < 0) {
                    thisValue = this.SquareRoot(thisValue, ctxdiv.WithUnlimitedExponents());
                    roots.Increment();
                }
                thisValue = this.LnInternal(thisValue, ctxdiv.getPrecision(), ctxdiv);
                BigInteger bigintRoots = RadixMath.PowerOfTwo(roots);
                thisValue = this.Multiply(thisValue, this.helper.CreateNewWithFlags(bigintRoots, BigInteger.ZERO, 0), ctxCopy);
            } else {
                T smallfrac = this.Divide(one, this.helper.ValueOf(16), ctxdiv);
                T closeToOne = this.Add(one, this.NegateRaw(smallfrac), null);
                if (this.compareTo(thisValue, closeToOne) >= 0) {
                    error = this.helper.CreateShiftAccumulator(this.helper.GetMantissa(thisValue).abs()).GetDigitLength();
                    error.AddInt(6);
                    error.AddBig(ctx.getPrecision());
                    bigError = error.AsBigInteger();
                    thisValue = this.LnInternal(thisValue, error.AsBigInteger(), ctxCopy);
                } else {
                    thisValue = this.LnInternal(thisValue, ctxdiv.getPrecision(), ctxCopy);
                }
            }
            if (ctx.getHasFlags()) {
                ctxCopy.setFlags(ctxCopy.getFlags() | 1);
                ctxCopy.setFlags(ctxCopy.getFlags() | 2);
            }
        } else {
            T two = this.helper.ValueOf(2);
            if (this.compareTo(thisValue, two) >= 0) {
                FastInteger roots = new FastInteger(0);
                FastInteger error = new FastInteger(10);
                BigInteger bigError = error.AsBigInteger();
                ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().add(bigError)).WithRounding(this.thisRadix == 2 ? Rounding.HalfEven : Rounding.ZeroFiveUp).WithBlankFlags();
                T smallfrac = this.Divide(one, this.helper.ValueOf(10), ctxdiv);
                T closeToOne = this.Add(one, smallfrac, null);
                while (this.compareTo(thisValue, closeToOne) >= 0) {
                    thisValue = this.SquareRoot(thisValue, ctxdiv.WithUnlimitedExponents());
                    roots.Increment();
                }
                thisValue = this.Divide(one, thisValue, ctxdiv);
                thisValue = this.LnInternal(thisValue, ctxdiv.getPrecision(), ctxdiv);
                thisValue = this.NegateRaw(thisValue);
                BigInteger bigintRoots = RadixMath.PowerOfTwo(roots);
                thisValue = this.Multiply(thisValue, this.helper.CreateNewWithFlags(bigintRoots, BigInteger.ZERO, 0), ctxCopy);
            } else {
                FastInteger error = new FastInteger(10);
                BigInteger bigError = error.AsBigInteger();
                ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().add(bigError)).WithRounding(this.thisRadix == 2 ? Rounding.HalfEven : Rounding.ZeroFiveUp).WithBlankFlags();
                T smallfrac = this.Divide(one, this.helper.ValueOf(16), ctxdiv);
                T closeToOne = this.Add(one, smallfrac, null);
                if (this.compareTo(thisValue, closeToOne) >= 0) {
                    thisValue = this.Divide(one, thisValue, ctxdiv);
                    thisValue = this.LnInternal(thisValue, ctxdiv.getPrecision(), ctxCopy);
                    thisValue = this.NegateRaw(thisValue);
                } else {
                    error = this.helper.CreateShiftAccumulator(this.helper.GetMantissa(thisValue).abs()).GetDigitLength();
                    error.AddInt(6);
                    error.AddBig(ctx.getPrecision());
                    bigError = error.AsBigInteger();
                    thisValue = this.LnInternal(thisValue, error.AsBigInteger(), ctxCopy);
                }
            }
            if (ctx.getHasFlags()) {
                ctxCopy.setFlags(ctxCopy.getFlags() | 1);
                ctxCopy.setFlags(ctxCopy.getFlags() | 2);
            }
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctxCopy.getFlags());
        }
        return thisValue;
    }

    @Override
    public T Exp(T thisValue, PrecisionContext ctx) {
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        int flags = this.helper.GetFlags(thisValue);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(thisValue, ctx);
        }
        PrecisionContext ctxCopy = ctx.WithBlankFlags();
        if ((flags & 2) != 0) {
            if ((flags & 1) != 0) {
                T retval = this.RoundToPrecision(this.helper.CreateNewWithFlags(BigInteger.ZERO, BigInteger.ZERO, 0), ctxCopy);
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | ctxCopy.getFlags());
                }
                return retval;
            }
            return thisValue;
        }
        int sign = this.helper.GetSign(thisValue);
        T one = this.helper.ValueOf(1);
        BigInteger guardDigits = this.thisRadix == 2 ? ctx.getPrecision().add(BigInteger.TEN) : BigInteger.TEN;
        PrecisionContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().add(guardDigits)).WithRounding(this.thisRadix == 2 ? Rounding.HalfEven : Rounding.ZeroFiveUp).WithBlankFlags();
        if (sign == 0) {
            thisValue = this.RoundToPrecision(one, ctxCopy);
        } else if (sign > 0 && this.compareTo(thisValue, one) < 0) {
            thisValue = this.ExpInternal(thisValue, ctxdiv.getPrecision(), ctxCopy);
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | 3);
            }
        } else if (sign < 0) {
            T val = this.Exp(this.NegateRaw(thisValue), ctxdiv);
            if ((ctxdiv.getFlags() & 0x10) != 0 || !this.IsFinite(val)) {
                ctxdiv.setFlags(0);
                BigInteger newMax = ctx.getEMax();
                BigInteger expdiff = ctx.getEMin();
                expdiff = newMax.subtract(expdiff);
                newMax = newMax.add(expdiff);
                ctxdiv = ctxdiv.WithBigExponentRange(ctxdiv.getEMin(), newMax);
                thisValue = this.Exp(this.NegateRaw(thisValue), ctxdiv);
                if ((ctxdiv.getFlags() & 0x10) != 0) {
                    if (ctx.getHasFlags()) {
                        ctx.setFlags(ctx.getFlags() | 0xF);
                    }
                    BigInteger ctxdivPrec = ctxdiv.getPrecision();
                    newMax = ctx.getEMin();
                    newMax = newMax.subtract(ctxdivPrec);
                    newMax = newMax.add(BigInteger.ONE);
                    thisValue = this.helper.CreateNewWithFlags(BigInteger.ZERO, newMax, 0);
                    return this.RoundToPrecisionInternal(thisValue, 0, 1, null, false, ctx);
                }
            } else {
                thisValue = val;
            }
            thisValue = this.Divide(one, thisValue, ctxCopy);
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | 3);
            }
        } else {
            T intpart = this.Quantize(thisValue, one, PrecisionContext.ForRounding(Rounding.Down));
            if (this.compareTo(thisValue, this.helper.ValueOf(50000)) > 0 && ctx.getHasExponentRange()) {
                this.PowerIntegral(this.helper.ValueOf(2), BigInteger.valueOf(50000L), ctxCopy);
                if ((ctxCopy.getFlags() & 0x10) != 0) {
                    return this.SignalOverflow2(ctx, false);
                }
                ctxCopy.setFlags(0);
                this.PowerIntegral(this.helper.ValueOf(2), this.helper.GetMantissa(intpart), ctxCopy);
                if ((ctxCopy.getFlags() & 0x10) != 0) {
                    return this.SignalOverflow2(ctx, false);
                }
                ctxCopy.setFlags(0);
            }
            T fracpart = this.Add(thisValue, this.NegateRaw(intpart), null);
            fracpart = this.Add(one, this.Divide(fracpart, intpart, ctxdiv), null);
            ctxdiv.setFlags(0);
            thisValue = this.ExpInternal(fracpart, ctxdiv.getPrecision(), ctxdiv);
            if ((ctxdiv.getFlags() & 8) != 0 && ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | ctxdiv.getFlags());
            }
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | 3);
            }
            thisValue = this.PowerIntegral(thisValue, this.helper.GetMantissa(intpart), ctxCopy);
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctxCopy.getFlags());
        }
        return thisValue;
    }

    @Override
    public T SquareRoot(T thisValue, PrecisionContext ctx) {
        int expcmp;
        BigInteger currentExp;
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        T ret = this.SquareRootHandleSpecial(thisValue, ctx);
        if (ret != (Object)null) {
            return ret;
        }
        PrecisionContext ctxtmp = ctx.WithBlankFlags();
        BigInteger origExp = currentExp = this.helper.GetExponent(thisValue);
        BigInteger idealExp = currentExp;
        idealExp = idealExp.divide(BigInteger.valueOf(2L));
        if (currentExp.signum() < 0 && currentExp.testBit(0)) {
            idealExp = idealExp.subtract(BigInteger.ONE);
        }
        if (this.helper.GetSign(thisValue) == 0) {
            ret = this.RoundToPrecision(this.helper.CreateNewWithFlags(BigInteger.ZERO, idealExp, this.helper.GetFlags(thisValue)), ctxtmp);
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | ctxtmp.getFlags());
            }
            return ret;
        }
        BigInteger mantissa = this.helper.GetMantissa(thisValue).abs();
        IShiftAccumulator accum = this.helper.CreateShiftAccumulator(mantissa);
        FastInteger digitCount = accum.GetDigitLength();
        FastInteger targetPrecision = FastInteger.FromBig(ctx.getPrecision());
        FastInteger precision = FastInteger.Copy(targetPrecision).Multiply(2).AddInt(2);
        boolean rounded = false;
        boolean inexact = false;
        if (digitCount.compareTo(precision) < 0) {
            FastInteger diff = FastInteger.Copy(precision).Subtract(digitCount);
            if (!diff.isEvenNumber() ^ origExp.testBit(0)) {
                diff.Increment();
            }
            BigInteger bigdiff = diff.AsBigInteger();
            currentExp = currentExp.subtract(bigdiff);
            if ((mantissa = this.TryMultiplyByRadixPower(mantissa, diff)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
        }
        BigInteger[] sr = mantissa.sqrtWithRemainder();
        digitCount = this.helper.CreateShiftAccumulator(sr[0]).GetDigitLength();
        BigInteger squareRootRemainder = sr[1];
        mantissa = sr[0];
        if (squareRootRemainder.signum() != 0) {
            rounded = true;
            inexact = true;
        }
        BigInteger oldexp = currentExp;
        currentExp = currentExp.divide(BigInteger.valueOf(2L));
        if (oldexp.signum() < 0 && oldexp.testBit(0)) {
            currentExp = currentExp.subtract(BigInteger.ONE);
        }
        T retval = this.helper.CreateNewWithFlags(mantissa, currentExp, 0);
        retval = this.RoundToPrecisionInternal(retval, 0, inexact ? 1 : 0, null, false, ctxtmp);
        currentExp = this.helper.GetExponent(retval);
        if (!((ctxtmp.getFlags() & 8) != 0 || (expcmp = currentExp.compareTo(idealExp)) > 0 && this.IsFinite(retval))) {
            retval = this.ReduceToPrecisionAndIdealExponent(retval, ctx.getHasExponentRange() ? ctxtmp : null, inexact ? targetPrecision : null, FastInteger.FromBig(idealExp));
        }
        if (ctx.getHasFlags() && ctx.getClampNormalExponents() && !this.helper.GetExponent(retval).equals(idealExp) && (ctxtmp.getFlags() & 1) == 0) {
            ctx.setFlags(ctx.getFlags() | 0x20);
        }
        boolean bl = (ctxtmp.getFlags() & 0x10) != 0;
        currentExp = this.helper.GetExponent(retval);
        if (rounded |= bl) {
            ctxtmp.setFlags(ctxtmp.getFlags() | 2);
        } else if (currentExp.compareTo(idealExp) > 0) {
            ctxtmp.setFlags(ctxtmp.getFlags() | 2);
        } else {
            ctxtmp.setFlags(ctxtmp.getFlags() & 0xFFFFFFFD);
        }
        if (inexact) {
            ctxtmp.setFlags(ctxtmp.getFlags() | 2);
            ctxtmp.setFlags(ctxtmp.getFlags() | 1);
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctxtmp.getFlags());
        }
        return retval;
    }

    @Override
    public T NextMinus(T thisValue, PrecisionContext ctx) {
        FastInteger bigexp;
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        if (!ctx.getHasExponentRange()) {
            return this.SignalInvalidWithMessage(ctx, "doesn't satisfy ctx.getHasExponentRange()");
        }
        int flags = this.helper.GetFlags(thisValue);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(thisValue, ctx);
        }
        if ((flags & 2) != 0) {
            if ((flags & 1) != 0) {
                return thisValue;
            }
            BigInteger bigexp2 = ctx.getEMax();
            BigInteger bigprec = ctx.getPrecision();
            bigexp2 = bigexp2.add(BigInteger.ONE);
            bigexp2 = bigexp2.subtract(bigprec);
            BigInteger overflowMant = this.TryMultiplyByRadixPower(BigInteger.ONE, FastInteger.FromBig(ctx.getPrecision()));
            if (overflowMant == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            overflowMant = overflowMant.subtract(BigInteger.ONE);
            return this.helper.CreateNewWithFlags(overflowMant, bigexp2, 0);
        }
        FastInteger minexp = FastInteger.FromBig(ctx.getEMin());
        if (ctx.getAdjustExponent()) {
            minexp.SubtractBig(ctx.getPrecision()).Increment();
        }
        if ((bigexp = FastInteger.FromBig(this.helper.GetExponent(thisValue))).compareTo(minexp) <= 0) {
            minexp = FastInteger.Copy(bigexp).SubtractInt(2);
        }
        T quantum = this.helper.CreateNewWithFlags(BigInteger.ONE, minexp.AsBigInteger(), 1);
        PrecisionContext ctx2 = ctx.WithRounding(Rounding.Floor);
        return this.Add(thisValue, quantum, ctx2);
    }

    @Override
    public T NextToward(T thisValue, T otherValue, PrecisionContext ctx) {
        FastInteger bigexp;
        T result;
        int otherFlags;
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        if (!ctx.getHasExponentRange()) {
            return this.SignalInvalidWithMessage(ctx, "doesn't satisfy ctx.getHasExponentRange()");
        }
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(otherValue))) & 0xE) != 0 && (result = this.HandleNotANumber(thisValue, otherValue, ctx)) != (Object)null) {
            return result;
        }
        int cmp = this.compareTo(thisValue, otherValue);
        if (cmp == 0) {
            return this.RoundToPrecision(this.EnsureSign(thisValue, (otherFlags & 1) != 0), ctx.WithNoFlags());
        }
        if ((thisFlags & 2) != 0) {
            if ((thisFlags & 3) == (otherFlags & 3)) {
                return thisValue;
            }
            BigInteger bigexp2 = ctx.getEMax();
            BigInteger bigprec = ctx.getPrecision();
            bigexp2 = bigexp2.add(BigInteger.ONE);
            bigexp2 = bigexp2.subtract(bigprec);
            BigInteger overflowMant = this.TryMultiplyByRadixPower(BigInteger.ONE, FastInteger.FromBig(ctx.getPrecision()));
            if (overflowMant == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            overflowMant = overflowMant.subtract(BigInteger.ONE);
            return this.helper.CreateNewWithFlags(overflowMant, bigexp2, thisFlags & 1);
        }
        FastInteger minexp = FastInteger.FromBig(ctx.getEMin());
        if (ctx.getAdjustExponent()) {
            minexp.SubtractBig(ctx.getPrecision()).Increment();
        }
        if ((bigexp = FastInteger.FromBig(this.helper.GetExponent(thisValue))).compareTo(minexp) < 0) {
            minexp = FastInteger.Copy(bigexp).SubtractInt(2);
        } else {
            minexp.SubtractInt(2);
        }
        T quantum = this.helper.CreateNewWithFlags(BigInteger.ONE, minexp.AsBigInteger(), cmp > 0 ? 1 : 0);
        T val = thisValue;
        PrecisionContext ctx2 = ctx.WithRounding(cmp > 0 ? Rounding.Floor : Rounding.Ceiling).WithBlankFlags();
        val = this.Add(val, quantum, ctx2);
        if ((ctx2.getFlags() & 0x18) == 0) {
            ctx2.setFlags(0);
        }
        if ((ctx2.getFlags() & 8) != 0) {
            BigInteger bigmant = this.helper.GetMantissa(val).abs();
            BigInteger maxmant = this.TryMultiplyByRadixPower(BigInteger.ONE, FastInteger.FromBig(ctx.getPrecision()).Decrement());
            if (maxmant == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            if (bigmant.compareTo(maxmant) >= 0 || ctx.getPrecision().compareTo(BigInteger.ONE) == 0) {
                ctx2.setFlags(0);
            }
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctx2.getFlags());
        }
        return val;
    }

    @Override
    public T NextPlus(T thisValue, PrecisionContext ctx) {
        FastInteger bigexp;
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        if (!ctx.getHasExponentRange()) {
            return this.SignalInvalidWithMessage(ctx, "doesn't satisfy ctx.getHasExponentRange()");
        }
        int flags = this.helper.GetFlags(thisValue);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(thisValue, ctx);
        }
        if ((flags & 2) != 0) {
            if ((flags & 1) != 0) {
                BigInteger bigexp2 = ctx.getEMax();
                BigInteger bigprec = ctx.getPrecision();
                bigexp2 = bigexp2.add(BigInteger.ONE);
                bigexp2 = bigexp2.subtract(bigprec);
                BigInteger overflowMant = this.TryMultiplyByRadixPower(BigInteger.ONE, FastInteger.FromBig(ctx.getPrecision()));
                if (overflowMant == null) {
                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                }
                overflowMant = overflowMant.subtract(BigInteger.ONE);
                return this.helper.CreateNewWithFlags(overflowMant, bigexp2, 1);
            }
            return thisValue;
        }
        FastInteger minexp = FastInteger.FromBig(ctx.getEMin());
        if (ctx.getAdjustExponent()) {
            minexp.SubtractBig(ctx.getPrecision()).Increment();
        }
        if ((bigexp = FastInteger.FromBig(this.helper.GetExponent(thisValue))).compareTo(minexp) <= 0) {
            minexp = FastInteger.Copy(bigexp).SubtractInt(2);
        }
        T quantum = this.helper.CreateNewWithFlags(BigInteger.ONE, minexp.AsBigInteger(), 0);
        T val = thisValue;
        PrecisionContext ctx2 = ctx.WithRounding(Rounding.Ceiling);
        return this.Add(val, quantum, ctx2);
    }

    @Override
    public T DivideToExponent(T thisValue, T divisor, BigInteger desiredExponent, PrecisionContext ctx) {
        if (ctx != null && !ctx.ExponentWithinRange(desiredExponent)) {
            return this.SignalInvalidWithMessage(ctx, "Exponent not within exponent range: " + desiredExponent);
        }
        PrecisionContext ctx2 = ctx == null ? PrecisionContext.ForRounding(Rounding.HalfDown) : ctx.WithUnlimitedExponents().WithPrecision(0);
        T ret = this.DivideInternal(thisValue, divisor, ctx2, 1, desiredExponent);
        if (!ctx2.getHasMaxPrecision() && this.IsFinite(ret)) {
            ret = this.Quantize(ret, ret, ctx2);
            if ((ctx2.getFlags() & 0x40) != 0) {
                ctx2.setFlags(64);
            }
        }
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctx2.getFlags());
        }
        return ret;
    }

    @Override
    public T Divide(T thisValue, T divisor, PrecisionContext ctx) {
        return this.DivideInternal(thisValue, divisor, ctx, 0, BigInteger.ZERO);
    }

    private int[] RoundToScaleStatus(BigInteger remainder, BigInteger divisor, PrecisionContext ctx) {
        Rounding rounding = ctx == null ? Rounding.HalfEven : ctx.getRounding();
        int lastDiscarded = 0;
        int olderDiscarded = 0;
        if (remainder.signum() != 0) {
            if (rounding == Rounding.HalfDown || rounding == Rounding.HalfUp || rounding == Rounding.HalfEven) {
                BigInteger halfDivisor = divisor.shiftRight(1);
                int cmpHalf = remainder.compareTo(halfDivisor);
                if (cmpHalf == 0 && !divisor.testBit(0)) {
                    lastDiscarded = this.thisRadix / 2;
                    olderDiscarded = 0;
                } else if (cmpHalf > 0) {
                    lastDiscarded = this.thisRadix / 2;
                    olderDiscarded = 1;
                } else {
                    lastDiscarded = 0;
                    olderDiscarded = 1;
                }
            } else {
                if (rounding == Rounding.Unnecessary) {
                    return null;
                }
                lastDiscarded = 1;
                olderDiscarded = 1;
            }
        }
        return new int[]{lastDiscarded, olderDiscarded};
    }

    private BigInteger TryMultiplyByRadixPower(BigInteger bi, FastInteger radixPower) {
        if (bi.signum() == 0) {
            return bi;
        }
        if (!radixPower.CanFitInInt32()) {
            return null;
        }
        FastInteger tmp = FastInteger.Copy(radixPower);
        if (this.thisRadix == 10 && tmp.Multiply(3).Divide(8).CompareToInt(Integer.MAX_VALUE) > 0) {
            return null;
        }
        return this.helper.MultiplyByRadixPower(bi, radixPower);
    }

    private T RoundToScale(BigInteger mantissa, BigInteger remainder, BigInteger divisor, BigInteger desiredExponent, FastInteger shift, boolean neg, PrecisionContext ctx) {
        Rounding rounding = ctx == null ? Rounding.HalfEven : ctx.getRounding();
        int lastDiscarded = 0;
        int olderDiscarded = 0;
        if (remainder.signum() != 0) {
            if (rounding == Rounding.HalfDown || rounding == Rounding.HalfUp || rounding == Rounding.HalfEven) {
                BigInteger halfDivisor = divisor.shiftRight(1);
                int cmpHalf = remainder.compareTo(halfDivisor);
                if (cmpHalf == 0 && !divisor.testBit(0)) {
                    lastDiscarded = this.thisRadix / 2;
                    olderDiscarded = 0;
                } else if (cmpHalf > 0) {
                    lastDiscarded = this.thisRadix / 2;
                    olderDiscarded = 1;
                } else {
                    lastDiscarded = 0;
                    olderDiscarded = 1;
                }
            } else {
                if (rounding == Rounding.Unnecessary) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
                lastDiscarded = 1;
                olderDiscarded = 1;
            }
        }
        int flags = 0;
        BigInteger newmantissa = mantissa;
        if (shift.isValueZero()) {
            if (lastDiscarded | olderDiscarded) {
                flags |= 3;
                if (rounding == Rounding.Unnecessary) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
                if (this.RoundGivenDigits(lastDiscarded, olderDiscarded, rounding, neg, newmantissa)) {
                    newmantissa = newmantissa.add(BigInteger.ONE);
                }
            }
        } else {
            IShiftAccumulator accum = this.helper.CreateShiftAccumulatorWithDigits(mantissa, lastDiscarded, olderDiscarded);
            accum.ShiftRight(shift);
            newmantissa = accum.getShiftedInt();
            if (accum.getDiscardedDigitCount().signum() != 0 || (accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0) {
                if (mantissa.signum() != 0) {
                    flags |= 2;
                }
                if ((accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0) {
                    flags |= 3;
                    if (rounding == Rounding.Unnecessary) {
                        return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                    }
                }
                if (this.RoundGivenBigInt(accum, rounding, neg, newmantissa)) {
                    newmantissa = newmantissa.add(BigInteger.ONE);
                }
            }
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | flags);
        }
        return this.helper.CreateNewWithFlags(newmantissa, desiredExponent, neg ? 1 : 0);
    }

    private T DivideInternal(T thisValue, T divisor, PrecisionContext ctx, int integerMode, BigInteger desiredExponent) {
        int mantcmp;
        T ret = this.DivisionHandleSpecial(thisValue, divisor, ctx);
        if (ret != (Object)null) {
            return ret;
        }
        int signA = this.helper.GetSign(thisValue);
        int signB = this.helper.GetSign(divisor);
        if (signB == 0) {
            if (signA == 0) {
                return this.SignalInvalid(ctx);
            }
            boolean flagsNeg = (this.helper.GetFlags(thisValue) & 1) != 0 ^ (this.helper.GetFlags(divisor) & 1) != 0;
            return this.SignalDivideByZero(ctx, flagsNeg);
        }
        int radix = this.thisRadix;
        if (signA == 0) {
            T retval = null;
            if (integerMode == 1) {
                int newflags = this.helper.GetFlags(thisValue) & 1 ^ this.helper.GetFlags(divisor) & 1;
                retval = this.helper.CreateNewWithFlags(BigInteger.ZERO, desiredExponent, newflags);
            } else {
                BigInteger dividendExp = this.helper.GetExponent(thisValue);
                BigInteger divisorExp = this.helper.GetExponent(divisor);
                int newflags = this.helper.GetFlags(thisValue) & 1 ^ this.helper.GetFlags(divisor) & 1;
                retval = this.RoundToPrecision(this.helper.CreateNewWithFlags(BigInteger.ZERO, dividendExp.subtract(divisorExp), newflags), ctx);
            }
            return retval;
        }
        BigInteger mantissaDividend = this.helper.GetMantissa(thisValue).abs();
        BigInteger mantissaDivisor = this.helper.GetMantissa(divisor).abs();
        FastInteger expDividend = FastInteger.FromBig(this.helper.GetExponent(thisValue));
        FastInteger expDivisor = FastInteger.FromBig(this.helper.GetExponent(divisor));
        FastInteger expdiff = FastInteger.Copy(expDividend).Subtract(expDivisor);
        FastInteger adjust = new FastInteger(0);
        FastInteger result = new FastInteger(0);
        FastInteger naturalExponent = FastInteger.Copy(expdiff);
        boolean hasPrecision = ctx != null && ctx.getPrecision().signum() != 0;
        boolean resultNeg = (this.helper.GetFlags(thisValue) & 1) != (this.helper.GetFlags(divisor) & 1);
        FastInteger fastPrecision = !hasPrecision ? new FastInteger(0) : FastInteger.FromBig(ctx.getPrecision());
        FastInteger dividendPrecision = null;
        FastInteger divisorPrecision = null;
        if (integerMode == 1) {
            FastInteger fastDesiredExponent = FastInteger.FromBig(desiredExponent);
            if (ctx != null && ctx.getHasFlags() && fastDesiredExponent.compareTo(naturalExponent) > 0) {
                ctx.setFlags(ctx.getFlags() | 2);
            }
            if (expdiff.compareTo(fastDesiredExponent) <= 0) {
                FastInteger shift = FastInteger.Copy(fastDesiredExponent).Subtract(expdiff);
                BigInteger[] divrem = mantissaDividend.divideAndRemainder(mantissaDivisor);
                BigInteger quo = divrem[0];
                BigInteger rem = divrem[1];
                return this.RoundToScale(quo, rem, mantissaDivisor, desiredExponent, shift, resultNeg, ctx);
            }
            if (ctx != null && ctx.getPrecision().signum() != 0 && FastInteger.Copy(expdiff).SubtractInt(8).compareTo(fastPrecision) > 0) {
                return this.SignalInvalidWithMessage(ctx, "Result can't fit the precision");
            }
            FastInteger shift = FastInteger.Copy(expdiff).Subtract(fastDesiredExponent);
            if ((mantissaDividend = this.TryMultiplyByRadixPower(mantissaDividend, shift)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            BigInteger[] divrem = mantissaDividend.divideAndRemainder(mantissaDivisor);
            BigInteger quo = divrem[0];
            BigInteger rem = divrem[1];
            return this.RoundToScale(quo, rem, mantissaDivisor, desiredExponent, new FastInteger(0), resultNeg, ctx);
        }
        if (integerMode == 0) {
            BigInteger rem = null;
            BigInteger quo = null;
            BigInteger[] divrem = mantissaDividend.divideAndRemainder(mantissaDivisor);
            quo = divrem[0];
            rem = divrem[1];
            if (rem.signum() == 0) {
                if (resultNeg) {
                    quo = quo.negate();
                }
                return this.RoundToPrecision(this.helper.CreateNewWithFlags(quo, naturalExponent.AsBigInteger(), resultNeg ? 1 : 0), ctx);
            }
            rem = null;
            quo = null;
            if (hasPrecision) {
                int[] digitStatus;
                BigInteger divid = mantissaDividend;
                FastInteger shift = FastInteger.FromBig(ctx.getPrecision());
                dividendPrecision = this.helper.CreateShiftAccumulator(mantissaDividend).GetDigitLength();
                if (dividendPrecision.compareTo(divisorPrecision = this.helper.CreateShiftAccumulator(mantissaDivisor).GetDigitLength()) <= 0) {
                    divisorPrecision.Subtract(dividendPrecision);
                    divisorPrecision.Increment();
                    shift.Add(divisorPrecision);
                    divid = this.TryMultiplyByRadixPower(divid, shift);
                    if (divid == null) {
                        return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                    }
                } else {
                    dividendPrecision.Subtract(divisorPrecision);
                    if (dividendPrecision.compareTo(shift) <= 0) {
                        shift.Subtract(dividendPrecision);
                        shift.Increment();
                        divid = this.TryMultiplyByRadixPower(divid, shift);
                        if (divid == null) {
                            return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                        }
                    } else {
                        shift.SetInt(0);
                    }
                }
                dividendPrecision = this.helper.CreateShiftAccumulator(divid).GetDigitLength();
                divisorPrecision = this.helper.CreateShiftAccumulator(mantissaDivisor).GetDigitLength();
                if (shift.signum() != 0 || quo == null) {
                    BigInteger[] divrem2 = divid.divideAndRemainder(mantissaDivisor);
                    quo = divrem2[0];
                    rem = divrem2[1];
                }
                if ((digitStatus = this.RoundToScaleStatus(rem, mantissaDivisor, ctx)) == null) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
                FastInteger natexp = FastInteger.Copy(naturalExponent).Subtract(shift);
                PrecisionContext ctxcopy = ctx.WithBlankFlags();
                T retval2 = this.helper.CreateNewWithFlags(quo, natexp.AsBigInteger(), resultNeg ? 1 : 0);
                retval2 = this.RoundToPrecisionWithShift(retval2, ctxcopy, digitStatus[0], digitStatus[1], null, false);
                if ((ctxcopy.getFlags() & 1) != 0) {
                    if (ctx.getHasFlags()) {
                        ctx.setFlags(ctx.getFlags() | ctxcopy.getFlags());
                    }
                    return retval2;
                }
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | ctxcopy.getFlags());
                    ctx.setFlags(ctx.getFlags() & 0xFFFFFFFD);
                }
                return this.ReduceToPrecisionAndIdealExponent(retval2, ctx, rem.signum() == 0 ? null : fastPrecision, expdiff);
            }
        }
        if ((mantcmp = mantissaDividend.compareTo(mantissaDivisor)) < 0) {
            dividendPrecision = this.helper.CreateShiftAccumulator(mantissaDividend).GetDigitLength();
            divisorPrecision = this.helper.CreateShiftAccumulator(mantissaDivisor).GetDigitLength();
            divisorPrecision.Subtract(dividendPrecision);
            if (divisorPrecision.isValueZero()) {
                divisorPrecision.Increment();
            }
            if ((mantissaDividend = this.TryMultiplyByRadixPower(mantissaDividend, divisorPrecision)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            adjust.Add(divisorPrecision);
            if (mantissaDividend.compareTo(mantissaDivisor) < 0) {
                mantissaDividend = radix == 2 ? mantissaDividend.shiftLeft(1) : mantissaDividend.multiply(BigInteger.valueOf(radix));
                adjust.Increment();
            }
        } else if (mantcmp > 0) {
            dividendPrecision = this.helper.CreateShiftAccumulator(mantissaDividend).GetDigitLength();
            divisorPrecision = this.helper.CreateShiftAccumulator(mantissaDivisor).GetDigitLength();
            dividendPrecision.Subtract(divisorPrecision);
            BigInteger oldMantissaB = mantissaDivisor;
            mantissaDivisor = this.TryMultiplyByRadixPower(mantissaDivisor, dividendPrecision);
            if (mantissaDivisor == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            adjust.Subtract(dividendPrecision);
            if (mantissaDividend.compareTo(mantissaDivisor) < 0) {
                if (dividendPrecision.CompareToInt(1) == 0) {
                    mantissaDivisor = oldMantissaB;
                } else {
                    BigInteger bigpow = BigInteger.valueOf(radix);
                    mantissaDivisor = mantissaDivisor.divide(bigpow);
                }
                adjust.Increment();
            }
        }
        if (mantcmp == 0) {
            result = new FastInteger(1);
            mantissaDividend = BigInteger.ZERO;
        } else {
            if (!this.helper.HasTerminatingRadixExpansion(mantissaDividend, mantissaDivisor)) {
                return this.SignalInvalidWithMessage(ctx, "Result would have a nonterminating expansion");
            }
            FastInteger divs = FastInteger.FromBig(mantissaDivisor);
            FastInteger divd = FastInteger.FromBig(mantissaDividend);
            boolean divisorFits = divs.CanFitInInt32();
            int smallDivisor = divisorFits ? divs.AsInt32() : 0;
            int halfRadix = radix / 2;
            FastInteger divsHalfRadix = null;
            if (radix != 2) {
                divsHalfRadix = FastInteger.FromBig(mantissaDivisor).Multiply(halfRadix);
            }
            while (true) {
                boolean remainderZero = false;
                int count = 0;
                if (divd.CanFitInInt32()) {
                    if (divisorFits) {
                        int smallDividend = divd.AsInt32();
                        count = smallDividend / smallDivisor;
                        divd.SetInt(smallDividend % smallDivisor);
                    } else {
                        count = 0;
                    }
                } else {
                    if (divsHalfRadix != null) {
                        count += halfRadix * divd.RepeatedSubtract(divsHalfRadix);
                    }
                    count += divd.RepeatedSubtract(divs);
                }
                result.AddInt(count);
                remainderZero = divd.isValueZero();
                if (remainderZero && adjust.signum() >= 0) {
                    mantissaDividend = divd.AsBigInteger();
                    break;
                }
                adjust.Increment();
                result.Multiply(radix);
                divd.Multiply(radix);
            }
        }
        FastInteger exp = FastInteger.Copy(expdiff).Subtract(adjust);
        Rounding rounding = ctx == null ? Rounding.HalfEven : ctx.getRounding();
        int lastDiscarded = 0;
        int olderDiscarded = 0;
        if (mantissaDividend.signum() != 0) {
            if (rounding == Rounding.HalfDown || rounding == Rounding.HalfEven || rounding == Rounding.HalfUp) {
                BigInteger halfDivisor = mantissaDivisor.shiftRight(1);
                int cmpHalf = mantissaDividend.compareTo(halfDivisor);
                if (cmpHalf == 0 && !mantissaDivisor.testBit(0)) {
                    lastDiscarded = radix / 2;
                    olderDiscarded = 0;
                } else if (cmpHalf > 0) {
                    lastDiscarded = radix / 2;
                    olderDiscarded = 1;
                } else {
                    lastDiscarded = 0;
                    olderDiscarded = 1;
                }
            } else {
                if (rounding == Rounding.Unnecessary) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
                lastDiscarded = 1;
                olderDiscarded = 1;
            }
        }
        BigInteger bigResult = result.AsBigInteger();
        if (ctx != null && ctx.getHasFlags() && exp.compareTo(expdiff) > 0) {
            ctx.setFlags(ctx.getFlags() | 2);
        }
        BigInteger bigexp = exp.AsBigInteger();
        T retval = this.helper.CreateNewWithFlags(bigResult, bigexp, resultNeg ? 1 : 0);
        return this.RoundToPrecisionWithShift(retval, ctx, lastDiscarded, olderDiscarded, null, false);
    }

    @Override
    public T MinMagnitude(T a, T b, PrecisionContext ctx) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        T result = this.MinMaxHandleSpecial(a, b, ctx, true, true);
        if (result != (Object)null) {
            return result;
        }
        int cmp = this.compareTo(this.AbsRaw(a), this.AbsRaw(b));
        return cmp == 0 ? this.Min(a, b, ctx) : (cmp < 0 ? this.RoundToPrecision(a, ctx) : this.RoundToPrecision(b, ctx));
    }

    @Override
    public T MaxMagnitude(T a, T b, PrecisionContext ctx) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        T result = this.MinMaxHandleSpecial(a, b, ctx, false, true);
        if (result != (Object)null) {
            return result;
        }
        int cmp = this.compareTo(this.AbsRaw(a), this.AbsRaw(b));
        return cmp == 0 ? this.Max(a, b, ctx) : (cmp > 0 ? this.RoundToPrecision(a, ctx) : this.RoundToPrecision(b, ctx));
    }

    @Override
    public T Max(T a, T b, PrecisionContext ctx) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        T result = this.MinMaxHandleSpecial(a, b, ctx, false, false);
        if (result != (Object)null) {
            return result;
        }
        int cmp = this.compareTo(a, b);
        if (cmp != 0) {
            return cmp < 0 ? this.RoundToPrecision(b, ctx) : this.RoundToPrecision(a, ctx);
        }
        int flagNegA = this.helper.GetFlags(a) & 1;
        return flagNegA != (this.helper.GetFlags(b) & 1) ? (flagNegA != 0 ? this.RoundToPrecision(b, ctx) : this.RoundToPrecision(a, ctx)) : (flagNegA == 0 ? (this.helper.GetExponent(a).compareTo(this.helper.GetExponent(b)) > 0 ? this.RoundToPrecision(a, ctx) : this.RoundToPrecision(b, ctx)) : (this.helper.GetExponent(a).compareTo(this.helper.GetExponent(b)) > 0 ? this.RoundToPrecision(b, ctx) : this.RoundToPrecision(a, ctx)));
    }

    @Override
    public T Min(T a, T b, PrecisionContext ctx) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        T result = this.MinMaxHandleSpecial(a, b, ctx, true, false);
        if (result != (Object)null) {
            return result;
        }
        int cmp = this.compareTo(a, b);
        if (cmp != 0) {
            return cmp > 0 ? this.RoundToPrecision(b, ctx) : this.RoundToPrecision(a, ctx);
        }
        int signANeg = this.helper.GetFlags(a) & 1;
        return signANeg != (this.helper.GetFlags(b) & 1) ? (signANeg != 0 ? this.RoundToPrecision(a, ctx) : this.RoundToPrecision(b, ctx)) : (signANeg == 0 ? (this.helper.GetExponent(a).compareTo(this.helper.GetExponent(b)) > 0 ? this.RoundToPrecision(b, ctx) : this.RoundToPrecision(a, ctx)) : (this.helper.GetExponent(a).compareTo(this.helper.GetExponent(b)) > 0 ? this.RoundToPrecision(a, ctx) : this.RoundToPrecision(b, ctx)));
    }

    @Override
    public T Multiply(T thisValue, T other, PrecisionContext ctx) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(other))) & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, other, ctx);
            if (result != (Object)null) {
                return result;
            }
            if ((thisFlags & 2) != 0) {
                return (otherFlags & 0xE) == 0 && this.helper.GetMantissa(other).signum() == 0 ? this.SignalInvalid(ctx) : this.EnsureSign(thisValue, (thisFlags & 1 ^ otherFlags & 1) != 0);
            }
            if ((otherFlags & 2) != 0) {
                return (thisFlags & 0xE) == 0 && this.helper.GetMantissa(thisValue).signum() == 0 ? this.SignalInvalid(ctx) : this.EnsureSign(other, (thisFlags & 1 ^ otherFlags & 1) != 0);
            }
        }
        BigInteger bigintOp2 = this.helper.GetExponent(other);
        BigInteger newexp = this.helper.GetExponent(thisValue).add(bigintOp2);
        BigInteger mantissaOp2 = this.helper.GetMantissa(other);
        thisFlags = thisFlags & 1 ^ otherFlags & 1;
        T ret = this.helper.CreateNewWithFlags(this.helper.GetMantissa(thisValue).multiply(mantissaOp2), newexp, thisFlags);
        if (ctx != null) {
            ret = this.RoundToPrecision(ret, ctx);
        }
        return ret;
    }

    @Override
    public T MultiplyAndAdd(T thisValue, T multiplicand, T augend, PrecisionContext ctx) {
        PrecisionContext ctx2 = PrecisionContext.Unlimited.WithBlankFlags();
        T ret = this.MultiplyAddHandleSpecial(thisValue, multiplicand, augend, ctx);
        if (ret != (Object)null) {
            return ret;
        }
        ret = this.Add(this.Multiply(thisValue, multiplicand, ctx2), augend, ctx);
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctx2.getFlags());
        }
        return ret;
    }

    @Override
    public T Plus(T thisValue, PrecisionContext context) {
        return this.RoundToPrecisionInternal(thisValue, 0, 0, null, true, context);
    }

    @Override
    public T RoundToPrecision(T thisValue, PrecisionContext context) {
        return this.RoundToPrecisionInternal(thisValue, 0, 0, null, false, context);
    }

    private T RoundToPrecisionWithShift(T thisValue, PrecisionContext context, int lastDiscarded, int olderDiscarded, FastInteger shift, boolean adjustNegativeZero) {
        return this.RoundToPrecisionInternal(thisValue, lastDiscarded, olderDiscarded, shift, adjustNegativeZero, context);
    }

    @Override
    public T Quantize(T thisValue, T otherValue, PrecisionContext ctx) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(otherValue))) & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, otherValue, ctx);
            if (result != (Object)null) {
                return result;
            }
            if ((thisFlags & otherFlags & 2) != 0) {
                return this.RoundToPrecision(thisValue, ctx);
            }
            return this.SignalInvalid(ctx);
        }
        BigInteger expOther = this.helper.GetExponent(otherValue);
        if (ctx != null && !ctx.ExponentWithinRange(expOther)) {
            return this.SignalInvalidWithMessage(ctx, "Exponent not within exponent range: " + expOther);
        }
        PrecisionContext tmpctx = (ctx == null ? PrecisionContext.ForRounding(Rounding.HalfEven) : ctx.Copy()).WithBlankFlags();
        BigInteger mantThis = this.helper.GetMantissa(thisValue).abs();
        BigInteger expThis = this.helper.GetExponent(thisValue);
        int expcmp = expThis.compareTo(expOther);
        int negativeFlag = this.helper.GetFlags(thisValue) & 1;
        Object ret = null;
        if (expcmp == 0) {
            ret = this.RoundToPrecision(thisValue, tmpctx);
        } else if (mantThis.signum() == 0) {
            ret = this.helper.CreateNewWithFlags(BigInteger.ZERO, expOther, negativeFlag);
            ret = this.RoundToPrecision(ret, tmpctx);
        } else if (expcmp > 0) {
            FastInteger radixPower = FastInteger.FromBig(expThis).SubtractBig(expOther);
            if (tmpctx.getPrecision().signum() > 0 && radixPower.compareTo(FastInteger.FromBig(tmpctx.getPrecision()).AddInt(10)) > 0) {
                return this.SignalInvalidWithMessage(ctx, "Result too high for current precision");
            }
            if ((mantThis = this.TryMultiplyByRadixPower(mantThis, radixPower)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            ret = this.helper.CreateNewWithFlags(mantThis, expOther, negativeFlag);
            ret = this.RoundToPrecision(ret, tmpctx);
        } else {
            FastInteger shift = FastInteger.FromBig(expOther).SubtractBig(expThis);
            ret = this.RoundToPrecisionWithShift(thisValue, tmpctx, 0, 0, shift, false);
        }
        if ((tmpctx.getFlags() & 0x10) != 0) {
            return this.SignalInvalid(ctx);
        }
        if (ret == null || !this.helper.GetExponent(ret).equals(expOther)) {
            return this.SignalInvalid(ctx);
        }
        ret = this.EnsureSign(ret, negativeFlag != 0);
        if (ctx != null && ctx.getHasFlags()) {
            int flags = tmpctx.getFlags();
            ctx.setFlags(ctx.getFlags() | (flags &= 0xFFFFFFF7));
        }
        return ret;
    }

    @Override
    public T RoundToExponentExact(T thisValue, BigInteger expOther, PrecisionContext ctx) {
        if (this.helper.GetExponent(thisValue).compareTo(expOther) >= 0) {
            return this.RoundToPrecision(thisValue, ctx);
        }
        PrecisionContext pctx = ctx == null ? null : ctx.WithPrecision(0).WithBlankFlags();
        T ret = this.Quantize(thisValue, this.helper.CreateNewWithFlags(BigInteger.ONE, expOther, 0), pctx);
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | pctx.getFlags());
        }
        return ret;
    }

    @Override
    public T RoundToExponentSimple(T thisValue, BigInteger expOther, PrecisionContext ctx) {
        int thisFlags = this.helper.GetFlags(thisValue);
        if ((thisFlags & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, thisValue, ctx);
            if (result != (Object)null) {
                return result;
            }
            if ((thisFlags & 2) != 0) {
                return thisValue;
            }
        }
        if (this.helper.GetExponent(thisValue).compareTo(expOther) >= 0) {
            return this.RoundToPrecision(thisValue, ctx);
        }
        if (ctx != null && !ctx.ExponentWithinRange(expOther)) {
            return this.SignalInvalidWithMessage(ctx, "Exponent not within exponent range: " + expOther);
        }
        BigInteger bigmantissa = this.helper.GetMantissa(thisValue).abs();
        FastInteger shift = FastInteger.FromBig(expOther).SubtractBig(this.helper.GetExponent(thisValue));
        IShiftAccumulator accum = this.helper.CreateShiftAccumulator(bigmantissa);
        accum.ShiftRight(shift);
        bigmantissa = accum.getShiftedInt();
        thisValue = this.helper.CreateNewWithFlags(bigmantissa, expOther, thisFlags);
        return this.RoundToPrecisionWithShift(thisValue, ctx, accum.getLastDiscardedDigit(), accum.getOlderDiscardedDigits(), null, false);
    }

    @Override
    public T RoundToExponentNoRoundedFlag(T thisValue, BigInteger exponent, PrecisionContext ctx) {
        PrecisionContext pctx = ctx == null ? null : ctx.WithBlankFlags();
        T ret = this.RoundToExponentExact(thisValue, exponent, pctx);
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | pctx.getFlags() & 0xFFFFFFFC);
        }
        return ret;
    }

    private T ReduceToPrecisionAndIdealExponent(T thisValue, PrecisionContext ctx, FastInteger precision, FastInteger idealExp) {
        T ret = this.RoundToPrecision(thisValue, ctx);
        if (ret != null && (this.helper.GetFlags(ret) & 0xE) == 0) {
            BigInteger bigmant = this.helper.GetMantissa(ret).abs();
            FastInteger exp = FastInteger.FromBig(this.helper.GetExponent(ret));
            int radix = this.thisRadix;
            if (bigmant.signum() == 0) {
                exp = new FastInteger(0);
            } else {
                FastInteger digits = precision == null ? null : this.helper.CreateShiftAccumulator(bigmant).GetDigitLength();
                bigmant = DecimalUtility.ReduceTrailingZeros(bigmant, exp, radix, digits, precision, idealExp);
            }
            int flags = this.helper.GetFlags(thisValue);
            ret = this.helper.CreateNewWithFlags(bigmant, exp.AsBigInteger(), flags);
            if (ctx != null && ctx.getClampNormalExponents()) {
                PrecisionContext ctxtmp = ctx.WithBlankFlags();
                ret = this.RoundToPrecision(ret, ctxtmp);
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | ctxtmp.getFlags() & 0xFFFFFFDF);
                }
            }
            ret = this.EnsureSign(ret, (flags & 1) != 0);
        }
        return ret;
    }

    @Override
    public T Reduce(T thisValue, PrecisionContext ctx) {
        return this.ReduceToPrecisionAndIdealExponent(thisValue, ctx, null, null);
    }

    private T RoundToPrecisionInternal(T thisValue, int lastDiscarded, int olderDiscarded, FastInteger shift, boolean adjustNegativeZero, PrecisionContext ctx) {
        BigInteger bigmantissa;
        PrecisionContext precisionContext = ctx = ctx == null ? PrecisionContext.Unlimited.WithRounding(Rounding.HalfEven) : ctx;
        if (!(ctx.getHasMaxPrecision() || ctx.getHasExponentRange() || (lastDiscarded | olderDiscarded) != 0 || shift != null && !shift.isValueZero())) {
            return thisValue;
        }
        boolean binaryPrec = ctx.isPrecisionInBits();
        int thisFlags = this.helper.GetFlags(thisValue);
        if ((thisFlags & 0xE) != 0) {
            if ((thisFlags & 8) != 0) {
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | 0x40);
                }
                return this.ReturnQuietNaN(thisValue, ctx);
            }
            if ((thisFlags & 4) != 0) {
                return this.ReturnQuietNaN(thisValue, ctx);
            }
            if ((thisFlags & 2) != 0) {
                return thisValue;
            }
        }
        FastInteger fastPrecision = ctx.getPrecision().canFitInInt() ? new FastInteger(ctx.getPrecision().intValue()) : FastInteger.FromBig(ctx.getPrecision());
        binaryPrec &= this.thisRadix != 2 && !fastPrecision.isValueZero();
        IShiftAccumulator accum = null;
        FastInteger fastEMin = null;
        FastInteger fastEMax = null;
        if (ctx != null && ctx.getHasExponentRange()) {
            fastEMax = ctx.getEMax().canFitInInt() ? new FastInteger(ctx.getEMax().intValue()) : FastInteger.FromBig(ctx.getEMax());
            fastEMin = ctx.getEMin().canFitInInt() ? new FastInteger(ctx.getEMin().intValue()) : FastInteger.FromBig(ctx.getEMin());
        }
        Rounding rounding = ctx == null ? Rounding.HalfEven : ctx.getRounding();
        boolean unlimitedPrec = fastPrecision.isValueZero();
        if (!binaryPrec && fastPrecision.signum() > 0 && (shift == null || shift.isValueZero()) && (thisFlags & 0xE) == 0) {
            FastInteger digitCount;
            BigInteger mantabs = this.helper.GetMantissa(thisValue).abs();
            if (adjustNegativeZero && (thisFlags & 1) != 0 && mantabs.signum() == 0 && ctx.getRounding() != Rounding.Floor) {
                thisValue = this.EnsureSign(thisValue, false);
                thisFlags = 0;
            }
            if ((digitCount = (accum = this.helper.CreateShiftAccumulatorWithDigits(mantabs, lastDiscarded, olderDiscarded)).GetDigitLength()).compareTo(fastPrecision) <= 0) {
                if (!this.RoundGivenDigits(lastDiscarded, olderDiscarded, ctx.getRounding(), (thisFlags & 1) != 0, mantabs)) {
                    if (ctx.getHasFlags() && (lastDiscarded | olderDiscarded) != 0) {
                        ctx.setFlags(ctx.getFlags() | 3);
                    }
                    if (!ctx.getHasExponentRange()) {
                        return thisValue;
                    }
                    BigInteger bigexp = this.helper.GetExponent(thisValue);
                    FastInteger fastExp = bigexp.canFitInInt() ? new FastInteger(bigexp.intValue()) : FastInteger.FromBig(bigexp);
                    FastInteger fastAdjustedExp = FastInteger.Copy(fastExp);
                    FastInteger fastNormalMin = FastInteger.Copy(fastEMin);
                    if (ctx == null || ctx.getAdjustExponent()) {
                        fastAdjustedExp.Add(fastPrecision).Decrement();
                        fastNormalMin.Add(fastPrecision).Decrement();
                    }
                    if (fastAdjustedExp.compareTo(fastEMax) <= 0 && fastAdjustedExp.compareTo(fastNormalMin) >= 0) {
                        return thisValue;
                    }
                } else {
                    if (ctx.getHasFlags() && (lastDiscarded | olderDiscarded) != 0) {
                        ctx.setFlags(ctx.getFlags() | 3);
                    }
                    boolean stillWithinPrecision = false;
                    mantabs = mantabs.add(BigInteger.ONE);
                    if (digitCount.compareTo(fastPrecision) < 0) {
                        stillWithinPrecision = true;
                    } else {
                        BigInteger radixPower = this.TryMultiplyByRadixPower(BigInteger.ONE, fastPrecision);
                        if (radixPower == null) {
                            return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                        }
                        boolean bl = stillWithinPrecision = mantabs.compareTo(radixPower) < 0;
                    }
                    if (stillWithinPrecision) {
                        BigInteger bigexp = this.helper.GetExponent(thisValue);
                        if (!ctx.getHasExponentRange()) {
                            return this.helper.CreateNewWithFlags(mantabs, bigexp, thisFlags);
                        }
                        FastInteger fastExp = bigexp.canFitInInt() ? new FastInteger(bigexp.intValue()) : FastInteger.FromBig(bigexp);
                        FastInteger fastAdjustedExp = FastInteger.Copy(fastExp);
                        FastInteger fastNormalMin = FastInteger.Copy(fastEMin);
                        if (ctx == null || ctx.getAdjustExponent()) {
                            fastAdjustedExp.Add(fastPrecision).Decrement();
                            fastNormalMin.Add(fastPrecision).Decrement();
                        }
                        if (fastAdjustedExp.compareTo(fastEMax) <= 0 && fastAdjustedExp.compareTo(fastNormalMin) >= 0) {
                            return this.helper.CreateNewWithFlags(mantabs, bigexp, thisFlags);
                        }
                    }
                }
            }
        }
        if (adjustNegativeZero && (thisFlags & 1) != 0 && this.helper.GetMantissa(thisValue).signum() == 0 && rounding != Rounding.Floor) {
            thisValue = this.EnsureSign(thisValue, false);
            thisFlags = 0;
        }
        boolean neg = (thisFlags & 1) != 0;
        BigInteger oldmantissa = bigmantissa = this.helper.GetMantissa(thisValue).abs();
        boolean mantissaWasZero = oldmantissa.signum() == 0 && (lastDiscarded | olderDiscarded) == 0;
        BigInteger maxMantissa = BigInteger.ONE;
        FastInteger exp = FastInteger.FromBig(this.helper.GetExponent(thisValue));
        int flags = 0;
        IShiftAccumulator iShiftAccumulator = accum = accum == null ? this.helper.CreateShiftAccumulatorWithDigits(bigmantissa, lastDiscarded, olderDiscarded) : accum;
        if (binaryPrec) {
            FastInteger prec = FastInteger.Copy(fastPrecision);
            while (prec.signum() > 0) {
                int bitShift = prec.CompareToInt(1000000) >= 0 ? 1000000 : prec.AsInt32();
                maxMantissa = maxMantissa.shiftLeft(bitShift);
                prec.SubtractInt(bitShift);
            }
            maxMantissa = maxMantissa.subtract(BigInteger.ONE);
            IShiftAccumulator accumMaxMant = this.helper.CreateShiftAccumulator(maxMantissa);
            fastPrecision = accumMaxMant.GetDigitLength();
        }
        if (shift != null && shift.signum() != 0) {
            accum.ShiftRight(shift);
        }
        if (!unlimitedPrec) {
            accum.ShiftToDigits(fastPrecision);
        } else {
            fastPrecision = accum.GetDigitLength();
        }
        if (binaryPrec) {
            while (accum.getShiftedInt().compareTo(maxMantissa) > 0) {
                accum.ShiftRightInt(1);
            }
        }
        FastInteger discardedBits = FastInteger.Copy(accum.getDiscardedDigitCount());
        exp.Add(discardedBits);
        FastInteger adjExponent = FastInteger.Copy(exp);
        if (ctx.getAdjustExponent()) {
            adjExponent = adjExponent.Add(accum.GetDigitLength()).Decrement();
        }
        FastInteger newAdjExponent = adjExponent;
        FastInteger clamp = null;
        BigInteger earlyRounded = BigInteger.ZERO;
        if (binaryPrec && fastEMax != null && adjExponent.compareTo(fastEMax) == 0) {
            FastInteger expdiff = FastInteger.Copy(fastPrecision).Subtract(accum.GetDigitLength());
            BigInteger currMantissa = accum.getShiftedInt();
            if ((currMantissa = this.TryMultiplyByRadixPower(currMantissa, expdiff)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            if (currMantissa.compareTo(maxMantissa) > 0) {
                adjExponent.Increment();
            }
        }
        if (ctx.getHasFlags() && fastEMin != null && adjExponent.compareTo(fastEMin) < 0 && this.RoundGivenBigInt(accum, rounding, neg, earlyRounded = accum.getShiftedInt())) {
            earlyRounded = earlyRounded.add(BigInteger.ONE);
            if (!(unlimitedPrec || earlyRounded.testBit(0) && (this.thisRadix & 1) == 0)) {
                IShiftAccumulator accum2 = this.helper.CreateShiftAccumulator(earlyRounded);
                FastInteger newDigitLength = accum2.GetDigitLength();
                if (binaryPrec || newDigitLength.compareTo(fastPrecision) > 0) {
                    newDigitLength = FastInteger.Copy(fastPrecision);
                }
                newAdjExponent = FastInteger.Copy(exp);
                if (ctx.getAdjustExponent()) {
                    newAdjExponent = newAdjExponent.Add(newDigitLength).Decrement();
                }
            }
        }
        if (fastEMax != null && adjExponent.compareTo(fastEMax) > 0) {
            if (mantissaWasZero) {
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | (flags | 0x20));
                }
                if (ctx.getClampNormalExponents()) {
                    if (binaryPrec && this.thisRadix != 2) {
                        fastPrecision = this.helper.CreateShiftAccumulator(maxMantissa).GetDigitLength();
                    }
                    FastInteger clampExp = FastInteger.Copy(fastEMax);
                    if (ctx.getAdjustExponent()) {
                        clampExp.Increment().Subtract(fastPrecision);
                    }
                    if (fastEMax.compareTo(clampExp) > 0) {
                        if (ctx.getHasFlags()) {
                            ctx.setFlags(ctx.getFlags() | 0x20);
                        }
                        fastEMax = clampExp;
                    }
                }
                return this.helper.CreateNewWithFlags(oldmantissa, fastEMax.AsBigInteger(), thisFlags);
            }
            flags |= 0x13;
            if (rounding == Rounding.Unnecessary) {
                return this.SignalInvalidWithMessage(ctx, "Rounding was required");
            }
            if (!unlimitedPrec && (rounding == Rounding.Down || rounding == Rounding.ZeroFiveUp || rounding == Rounding.Ceiling && neg || rounding == Rounding.Floor && !neg)) {
                BigInteger overflowMant = BigInteger.ZERO;
                if (binaryPrec) {
                    overflowMant = maxMantissa;
                } else {
                    overflowMant = this.TryMultiplyByRadixPower(BigInteger.ONE, fastPrecision);
                    if (overflowMant == null) {
                        return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                    }
                    overflowMant = overflowMant.subtract(BigInteger.ONE);
                }
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | flags);
                }
                clamp = FastInteger.Copy(fastEMax);
                if (ctx.getAdjustExponent()) {
                    clamp.Increment().Subtract(fastPrecision);
                }
                return this.helper.CreateNewWithFlags(overflowMant, clamp.AsBigInteger(), neg ? 1 : 0);
            }
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | flags);
            }
            return this.SignalOverflow(neg);
        }
        if (fastEMin != null && adjExponent.compareTo(fastEMin) < 0) {
            FastInteger subExp;
            FastInteger fastETiny = FastInteger.Copy(fastEMin);
            if (ctx.getAdjustExponent()) {
                fastETiny = fastETiny.Subtract(fastPrecision).Increment();
            }
            if (ctx.getHasFlags() && earlyRounded.signum() != 0 && newAdjExponent.compareTo(fastEMin) < 0) {
                flags |= 4;
            }
            if ((subExp = FastInteger.Copy(exp)).compareTo(fastETiny) < 0) {
                FastInteger expdiff = FastInteger.Copy(fastETiny).Subtract(exp);
                expdiff.Add(discardedBits);
                accum = this.helper.CreateShiftAccumulatorWithDigits(oldmantissa, lastDiscarded, olderDiscarded);
                accum.ShiftRight(expdiff);
                FastInteger newmantissa = accum.getShiftedIntFast();
                if ((accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0 && rounding == Rounding.Unnecessary) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
                if (accum.getDiscardedDigitCount().signum() != 0 || (accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0) {
                    if (ctx.getHasFlags()) {
                        if (!mantissaWasZero) {
                            flags |= 2;
                        }
                        if ((accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0) {
                            flags |= 3;
                        }
                    }
                    if (this.Round(accum, rounding, neg, newmantissa)) {
                        newmantissa.Increment();
                    }
                }
                if (ctx.getHasFlags()) {
                    if (newmantissa.isValueZero()) {
                        flags |= 0x20;
                    }
                    if ((flags & 5) == 5) {
                        flags |= 0xA;
                    }
                    ctx.setFlags(ctx.getFlags() | flags);
                }
                bigmantissa = newmantissa.AsBigInteger();
                if (ctx.getClampNormalExponents()) {
                    if (binaryPrec && this.thisRadix != 2) {
                        fastPrecision = this.helper.CreateShiftAccumulator(maxMantissa).GetDigitLength();
                    }
                    FastInteger clampExp = FastInteger.Copy(fastEMax);
                    if (ctx.getAdjustExponent()) {
                        clampExp.Increment().Subtract(fastPrecision);
                    }
                    if (fastETiny.compareTo(clampExp) > 0) {
                        if (bigmantissa.signum() != 0 && (bigmantissa = this.TryMultiplyByRadixPower(bigmantissa, expdiff = FastInteger.Copy(fastETiny).Subtract(clampExp))) == null) {
                            return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                        }
                        if (ctx.getHasFlags()) {
                            ctx.setFlags(ctx.getFlags() | 0x20);
                        }
                        fastETiny = clampExp;
                    }
                }
                return this.helper.CreateNewWithFlags(bigmantissa, fastETiny.AsBigInteger(), neg ? 1 : 0);
            }
        }
        boolean recheckOverflow = false;
        if (accum.getDiscardedDigitCount().signum() != 0 || (accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0) {
            if (bigmantissa.signum() != 0) {
                flags |= 2;
            }
            bigmantissa = accum.getShiftedInt();
            if ((accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0) {
                flags |= 3;
                if (rounding == Rounding.Unnecessary) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
            }
            if (this.RoundGivenBigInt(accum, rounding, neg, bigmantissa)) {
                FastInteger oldDigitLength = accum.GetDigitLength();
                bigmantissa = bigmantissa.add(BigInteger.ONE);
                recheckOverflow |= binaryPrec;
                if (!(unlimitedPrec || bigmantissa.testBit(0) && (this.thisRadix & 1) == 0 || !binaryPrec && oldDigitLength.compareTo(fastPrecision) < 0)) {
                    accum = this.helper.CreateShiftAccumulator(bigmantissa);
                    FastInteger newDigitLength = accum.GetDigitLength();
                    if (binaryPrec || newDigitLength.compareTo(fastPrecision) > 0) {
                        FastInteger neededShift = FastInteger.Copy(newDigitLength).Subtract(fastPrecision);
                        accum.ShiftRight(neededShift);
                        if (binaryPrec) {
                            while (accum.getShiftedInt().compareTo(maxMantissa) > 0) {
                                accum.ShiftRightInt(1);
                            }
                        }
                        if (accum.getDiscardedDigitCount().signum() != 0) {
                            exp.Add(accum.getDiscardedDigitCount());
                            discardedBits.Add(accum.getDiscardedDigitCount());
                            bigmantissa = accum.getShiftedInt();
                            recheckOverflow |= !binaryPrec;
                        }
                    }
                }
            }
        }
        if (recheckOverflow && fastEMax != null) {
            adjExponent = FastInteger.Copy(exp);
            if (ctx.getAdjustExponent()) {
                adjExponent.Add(accum.GetDigitLength()).Decrement();
            }
            if (binaryPrec && fastEMax != null && adjExponent.compareTo(fastEMax) == 0) {
                FastInteger expdiff = FastInteger.Copy(fastPrecision).Subtract(accum.GetDigitLength());
                BigInteger currMantissa = accum.getShiftedInt();
                if ((currMantissa = this.TryMultiplyByRadixPower(currMantissa, expdiff)) == null) {
                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                }
                if (currMantissa.compareTo(maxMantissa) > 0) {
                    adjExponent.Increment();
                }
            }
            if (adjExponent.compareTo(fastEMax) > 0) {
                flags |= 0x13;
                if (!unlimitedPrec && (rounding == Rounding.Down || rounding == Rounding.ZeroFiveUp || rounding == Rounding.Ceiling && neg || rounding == Rounding.Floor && !neg)) {
                    BigInteger overflowMant = BigInteger.ZERO;
                    if (binaryPrec) {
                        overflowMant = maxMantissa;
                    } else {
                        overflowMant = this.TryMultiplyByRadixPower(BigInteger.ONE, fastPrecision);
                        if (overflowMant == null) {
                            return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                        }
                        overflowMant = overflowMant.subtract(BigInteger.ONE);
                    }
                    if (ctx.getHasFlags()) {
                        ctx.setFlags(ctx.getFlags() | flags);
                    }
                    clamp = FastInteger.Copy(fastEMax);
                    if (ctx.getAdjustExponent()) {
                        clamp.Increment().Subtract(fastPrecision);
                    }
                    return this.helper.CreateNewWithFlags(overflowMant, clamp.AsBigInteger(), neg ? 1 : 0);
                }
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | flags);
                }
                return this.SignalOverflow(neg);
            }
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | flags);
        }
        if (ctx.getClampNormalExponents()) {
            if (binaryPrec && this.thisRadix != 2) {
                fastPrecision = this.helper.CreateShiftAccumulator(maxMantissa).GetDigitLength();
            }
            FastInteger clampExp = FastInteger.Copy(fastEMax);
            if (ctx.getAdjustExponent()) {
                clampExp.Increment().Subtract(fastPrecision);
            }
            if (exp.compareTo(clampExp) > 0) {
                FastInteger expdiff;
                if (bigmantissa.signum() != 0 && (bigmantissa = this.TryMultiplyByRadixPower(bigmantissa, expdiff = FastInteger.Copy(exp).Subtract(clampExp))) == null) {
                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                }
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | 0x20);
                }
                exp = clampExp;
            }
        }
        return this.helper.CreateNewWithFlags(bigmantissa, exp.AsBigInteger(), neg ? 1 : 0);
    }

    private T AddCore(BigInteger mant1, BigInteger mant2, BigInteger exponent, int flags1, int flags2, PrecisionContext ctx) {
        boolean neg1 = (flags1 & 1) != 0;
        boolean neg2 = (flags2 & 1) != 0;
        boolean negResult = false;
        if (neg1 != neg2) {
            int mant1Sign = (mant1 = mant1.subtract(mant2)).signum();
            negResult = neg1 ^ (mant1Sign == 0 ? neg2 : mant1Sign < 0);
        } else {
            mant1 = mant1.add(mant2);
            negResult = neg1;
        }
        if (mant1.signum() == 0 && negResult) {
            negResult &= neg1 && neg2 || neg1 ^ neg2 && ctx != null && ctx.getRounding() == Rounding.Floor;
        }
        return this.helper.CreateNewWithFlags(mant1, exponent, negResult ? 1 : 0);
    }

    @Override
    public T Add(T thisValue, T other, PrecisionContext ctx) {
        if (thisValue == null) {
            throw new NullPointerException("thisValue");
        }
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.AddEx(thisValue, other, ctx, false);
    }

    @Override
    public T AddEx(T thisValue, T other, PrecisionContext ctx, boolean roundToOperandPrecision) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(other))) & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, other, ctx);
            if (result != (Object)null) {
                return result;
            }
            if ((thisFlags & 2) != 0) {
                if ((otherFlags & 2) != 0 && (thisFlags & 1) != (otherFlags & 1)) {
                    return this.SignalInvalid(ctx);
                }
                return thisValue;
            }
            if ((otherFlags & 2) != 0) {
                return other;
            }
        }
        int expcmp = this.helper.GetExponent(thisValue).compareTo(this.helper.GetExponent(other));
        Object retval = null;
        BigInteger op1MantAbs = this.helper.GetMantissa(thisValue).abs();
        BigInteger op2MantAbs = this.helper.GetMantissa(other).abs();
        if (expcmp == 0) {
            retval = this.AddCore(op1MantAbs, op2MantAbs, this.helper.GetExponent(thisValue), thisFlags, otherFlags, ctx);
            if (ctx != null) {
                retval = this.RoundToPrecision(retval, ctx);
            }
        } else {
            T op1 = thisValue;
            T op2 = other;
            BigInteger op1Exponent = this.helper.GetExponent(op1);
            BigInteger op2Exponent = this.helper.GetExponent(op2);
            BigInteger resultExponent = expcmp < 0 ? op1Exponent : op2Exponent;
            FastInteger fastOp1Exp = FastInteger.FromBig(op1Exponent);
            FastInteger fastOp2Exp = FastInteger.FromBig(op2Exponent);
            FastInteger expdiff = FastInteger.Copy(fastOp1Exp).Subtract(fastOp2Exp).Abs();
            if (ctx != null && ctx.getPrecision().signum() > 0) {
                FastInteger fastPrecision = FastInteger.FromBig(ctx.getPrecision());
                if (FastInteger.Copy(expdiff).compareTo(fastPrecision) > 0) {
                    int expcmp2 = fastOp1Exp.compareTo(fastOp2Exp);
                    if (expcmp2 < 0) {
                        if (op2MantAbs.signum() != 0) {
                            FastInteger tmp;
                            FastInteger newDiff;
                            FastInteger digitLength1 = this.helper.CreateShiftAccumulator(op1MantAbs).GetDigitLength();
                            if (FastInteger.Copy(fastOp1Exp).Add(digitLength1).AddInt(2).compareTo(fastOp2Exp) < 0 && (newDiff = FastInteger.Copy(tmp = FastInteger.Copy(fastOp2Exp).SubtractInt(4).Subtract(digitLength1).SubtractBig(ctx.getPrecision())).Subtract(fastOp2Exp).Abs()).compareTo(expdiff) < 0) {
                                boolean sameSign = this.helper.GetSign(thisValue) == this.helper.GetSign(other);
                                boolean oneOpIsZero = op1MantAbs.signum() == 0;
                                FastInteger digitLength2 = this.helper.CreateShiftAccumulator(op2MantAbs).GetDigitLength();
                                if (digitLength2.compareTo(fastPrecision) < 0) {
                                    FastInteger precisionDiff = FastInteger.Copy(fastPrecision).Subtract(digitLength2);
                                    if (!oneOpIsZero && !sameSign) {
                                        precisionDiff.AddInt(2);
                                    }
                                    if ((op2MantAbs = this.TryMultiplyByRadixPower(op2MantAbs, precisionDiff)) == null) {
                                        return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                                    }
                                    BigInteger bigintTemp = precisionDiff.AsBigInteger();
                                    op2Exponent = op2Exponent.subtract(bigintTemp);
                                    if (!oneOpIsZero && !sameSign) {
                                        op2MantAbs = op2MantAbs.subtract(BigInteger.ONE);
                                    }
                                    other = this.helper.CreateNewWithFlags(op2MantAbs, op2Exponent, this.helper.GetFlags(other));
                                    FastInteger shift = FastInteger.Copy(digitLength2).Subtract(fastPrecision);
                                    if (oneOpIsZero && ctx != null && ctx.getHasFlags()) {
                                        ctx.setFlags(ctx.getFlags() | 2);
                                    }
                                    return this.RoundToPrecisionWithShift(other, ctx, oneOpIsZero || sameSign ? 0 : 1, oneOpIsZero && !sameSign ? 0 : 1, shift, false);
                                }
                                if (!oneOpIsZero && !sameSign) {
                                    if ((op2MantAbs = this.TryMultiplyByRadixPower(op2MantAbs, new FastInteger(2))) == null) {
                                        return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                                    }
                                    op2Exponent = op2Exponent.subtract(BigInteger.valueOf(2L));
                                    op2MantAbs = op2MantAbs.subtract(BigInteger.ONE);
                                    other = this.helper.CreateNewWithFlags(op2MantAbs, op2Exponent, this.helper.GetFlags(other));
                                    FastInteger shift = FastInteger.Copy(digitLength2).Subtract(fastPrecision);
                                    return this.RoundToPrecisionWithShift(other, ctx, 0, 0, shift, false);
                                }
                                FastInteger shift2 = FastInteger.Copy(digitLength2).Subtract(fastPrecision);
                                if (!sameSign && ctx != null && ctx.getHasFlags()) {
                                    ctx.setFlags(ctx.getFlags() | 2);
                                }
                                return this.RoundToPrecisionWithShift(other, ctx, 0, sameSign ? 1 : 0, shift2, false);
                            }
                        }
                    } else if (expcmp2 > 0 && op1MantAbs.signum() != 0) {
                        FastInteger tmp;
                        FastInteger newDiff;
                        FastInteger digitLength2 = this.helper.CreateShiftAccumulator(op2MantAbs).GetDigitLength();
                        if (FastInteger.Copy(fastOp2Exp).Add(digitLength2).AddInt(2).compareTo(fastOp1Exp) < 0 && (newDiff = FastInteger.Copy(tmp = FastInteger.Copy(fastOp1Exp).SubtractInt(4).Subtract(digitLength2).SubtractBig(ctx.getPrecision())).Subtract(fastOp1Exp).Abs()).compareTo(expdiff) < 0) {
                            boolean sameSign = this.helper.GetSign(thisValue) == this.helper.GetSign(other);
                            boolean oneOpIsZero = op2MantAbs.signum() == 0;
                            digitLength2 = this.helper.CreateShiftAccumulator(op1MantAbs).GetDigitLength();
                            if (digitLength2.compareTo(fastPrecision) < 0) {
                                FastInteger precisionDiff = FastInteger.Copy(fastPrecision).Subtract(digitLength2);
                                if (!oneOpIsZero && !sameSign) {
                                    precisionDiff.AddInt(2);
                                }
                                if ((op1MantAbs = this.TryMultiplyByRadixPower(op1MantAbs, precisionDiff)) == null) {
                                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                                }
                                BigInteger bigintTemp = precisionDiff.AsBigInteger();
                                op1Exponent = op1Exponent.subtract(bigintTemp);
                                if (!oneOpIsZero && !sameSign) {
                                    op1MantAbs = op1MantAbs.subtract(BigInteger.ONE);
                                }
                                thisValue = this.helper.CreateNewWithFlags(op1MantAbs, op1Exponent, this.helper.GetFlags(thisValue));
                                FastInteger shift = FastInteger.Copy(digitLength2).Subtract(fastPrecision);
                                if (oneOpIsZero && ctx != null && ctx.getHasFlags()) {
                                    ctx.setFlags(ctx.getFlags() | 2);
                                }
                                return this.RoundToPrecisionWithShift(thisValue, ctx, oneOpIsZero || sameSign ? 0 : 1, oneOpIsZero && !sameSign ? 0 : 1, shift, false);
                            }
                            if (!oneOpIsZero && !sameSign) {
                                if ((op1MantAbs = this.TryMultiplyByRadixPower(op1MantAbs, new FastInteger(2))) == null) {
                                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                                }
                                op1Exponent = op1Exponent.subtract(BigInteger.valueOf(2L));
                                op1MantAbs = op1MantAbs.subtract(BigInteger.ONE);
                                thisValue = this.helper.CreateNewWithFlags(op1MantAbs, op1Exponent, this.helper.GetFlags(thisValue));
                                FastInteger shift = FastInteger.Copy(digitLength2).Subtract(fastPrecision);
                                return this.RoundToPrecisionWithShift(thisValue, ctx, 0, 0, shift, false);
                            }
                            FastInteger shift2 = FastInteger.Copy(digitLength2).Subtract(fastPrecision);
                            if (!sameSign && ctx != null && ctx.getHasFlags()) {
                                ctx.setFlags(ctx.getFlags() | 2);
                            }
                            return this.RoundToPrecisionWithShift(thisValue, ctx, 0, sameSign ? 1 : 0, shift2, false);
                        }
                    }
                    BigInteger bigInteger = resultExponent = (expcmp = op1Exponent.compareTo(op2Exponent)) < 0 ? op1Exponent : op2Exponent;
                }
            }
            if (expcmp > 0) {
                if ((op1MantAbs = this.RescaleByExponentDiff(op1MantAbs, op1Exponent, op2Exponent)) == null) {
                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                }
                retval = this.AddCore(op1MantAbs, op2MantAbs, resultExponent, thisFlags, otherFlags, ctx);
            } else {
                if ((op2MantAbs = this.RescaleByExponentDiff(op2MantAbs, op1Exponent, op2Exponent)) == null) {
                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                }
                retval = this.AddCore(op1MantAbs, op2MantAbs, resultExponent, thisFlags, otherFlags, ctx);
            }
            if (roundToOperandPrecision && ctx != null && ctx.getHasMaxPrecision()) {
                FastInteger digitLength2;
                FastInteger digitLength1 = this.helper.CreateShiftAccumulator(op1MantAbs.abs()).GetDigitLength();
                FastInteger maxDigitLength = digitLength1.compareTo(digitLength2 = this.helper.CreateShiftAccumulator(op2MantAbs.abs()).GetDigitLength()) > 0 ? digitLength1 : digitLength2;
                maxDigitLength.SubtractBig(ctx.getPrecision());
                retval = maxDigitLength.signum() > 0 ? this.RoundToPrecisionWithShift(retval, ctx, 0, 0, maxDigitLength, false) : this.RoundToPrecision(retval, ctx);
            } else {
                retval = this.RoundToPrecision(retval, ctx);
            }
        }
        return retval;
    }

    @Override
    public T CompareToWithContext(T thisValue, T otherValue, boolean treatQuietNansAsSignaling, PrecisionContext ctx) {
        if (otherValue == null) {
            return this.SignalInvalid(ctx);
        }
        T result = this.CompareToHandleSpecial(thisValue, otherValue, treatQuietNansAsSignaling, ctx);
        if (result != (Object)null) {
            return result;
        }
        int cmp = this.CompareToInternal(thisValue, otherValue, false);
        return cmp == -2 ? this.SignalInvalidWithMessage(ctx, "Out of memory") : this.ValueOf(this.compareTo(thisValue, otherValue), null);
    }

    @Override
    public int compareTo(T thisValue, T otherValue) {
        return this.CompareToInternal(thisValue, otherValue, true);
    }

    private int CompareToInternal(T thisValue, T otherValue, boolean reportOOM) {
        BigInteger othermant;
        BigInteger newmant;
        int signB;
        if (otherValue == null) {
            return 1;
        }
        int flagsThis = this.helper.GetFlags(thisValue);
        int flagsOther = this.helper.GetFlags(otherValue);
        if ((flagsThis & 0xC) != 0) {
            if ((flagsOther & 0xC) != 0) {
                return 0;
            }
            return 1;
        }
        if ((flagsOther & 0xC) != 0) {
            return -1;
        }
        int signA = this.CompareToHandleSpecialReturnInt(thisValue, otherValue);
        if (signA <= 1) {
            return signA;
        }
        signA = this.helper.GetSign(thisValue);
        if (signA != (signB = this.helper.GetSign(otherValue))) {
            return signA < signB ? -1 : 1;
        }
        if (signB == 0 || signA == 0) {
            return 0;
        }
        int expcmp = this.helper.GetExponent(thisValue).compareTo(this.helper.GetExponent(otherValue));
        int mantcmp = this.helper.GetMantissa(thisValue).abs().compareTo(this.helper.GetMantissa(otherValue).abs());
        if (signA < 0) {
            mantcmp = -mantcmp;
        }
        if (mantcmp == 0) {
            return signA < 0 ? -expcmp : expcmp;
        }
        if (expcmp == 0) {
            return mantcmp;
        }
        BigInteger op1Exponent = this.helper.GetExponent(thisValue);
        BigInteger op2Exponent = this.helper.GetExponent(otherValue);
        FastInteger fastOp1Exp = FastInteger.FromBig(op1Exponent);
        FastInteger fastOp2Exp = FastInteger.FromBig(op2Exponent);
        FastInteger expdiff = FastInteger.Copy(fastOp1Exp).Subtract(fastOp2Exp).Abs();
        if (expdiff.CompareToInt(100) >= 0) {
            BigInteger op1MantAbs = this.helper.GetMantissa(thisValue).abs();
            BigInteger op2MantAbs = this.helper.GetMantissa(otherValue).abs();
            FastInteger precision1 = this.helper.CreateShiftAccumulator(op1MantAbs).GetDigitLength();
            FastInteger precision2 = this.helper.CreateShiftAccumulator(op2MantAbs).GetDigitLength();
            FastInteger maxPrecision = null;
            FastInteger fastInteger = maxPrecision = precision1.compareTo(precision2) > 0 ? precision1 : precision2;
            if (FastInteger.Copy(expdiff).compareTo(maxPrecision) > 0) {
                int expcmp2 = fastOp1Exp.compareTo(fastOp2Exp);
                if (expcmp2 < 0) {
                    if (op2MantAbs.signum() != 0) {
                        FastInteger tmp;
                        FastInteger newDiff;
                        FastInteger digitLength1 = this.helper.CreateShiftAccumulator(op1MantAbs).GetDigitLength();
                        if (FastInteger.Copy(fastOp1Exp).Add(digitLength1).AddInt(2).compareTo(fastOp2Exp) < 0 && (newDiff = FastInteger.Copy(tmp = FastInteger.Copy(fastOp2Exp).SubtractInt(8).Subtract(digitLength1).Subtract(maxPrecision)).Subtract(fastOp2Exp).Abs()).compareTo(expdiff) < 0) {
                            return signA < 0 ? 1 : -1;
                        }
                    }
                } else if (expcmp2 > 0 && op1MantAbs.signum() != 0) {
                    FastInteger tmp;
                    FastInteger newDiff;
                    FastInteger digitLength2 = this.helper.CreateShiftAccumulator(op2MantAbs).GetDigitLength();
                    if (FastInteger.Copy(fastOp2Exp).Add(digitLength2).AddInt(2).compareTo(fastOp1Exp) < 0 && (newDiff = FastInteger.Copy(tmp = FastInteger.Copy(fastOp1Exp).SubtractInt(8).Subtract(digitLength2).Subtract(maxPrecision)).Subtract(fastOp1Exp).Abs()).compareTo(expdiff) < 0) {
                        return signA < 0 ? -1 : 1;
                    }
                }
                expcmp = op1Exponent.compareTo(op2Exponent);
            }
        }
        if (expcmp > 0) {
            newmant = this.RescaleByExponentDiff(this.helper.GetMantissa(thisValue), op1Exponent, op2Exponent);
            if (newmant == null) {
                if (reportOOM) {
                    throw new OutOfMemoryError("Result requires too much memory");
                }
                return -2;
            }
            othermant = this.helper.GetMantissa(otherValue).abs();
            newmant = newmant.abs();
            mantcmp = newmant.compareTo(othermant);
            return signA < 0 ? -mantcmp : mantcmp;
        }
        newmant = this.RescaleByExponentDiff(this.helper.GetMantissa(otherValue), op1Exponent, op2Exponent);
        if (newmant == null) {
            if (reportOOM) {
                throw new OutOfMemoryError("Result requires too much memory");
            }
            return -2;
        }
        othermant = this.helper.GetMantissa(thisValue).abs();
        newmant = newmant.abs();
        mantcmp = othermant.compareTo(newmant);
        return signA < 0 ? -mantcmp : mantcmp;
    }

    @Override
    public IRadixMathHelper<T> GetHelper() {
        return this.helper;
    }

    @Override
    public T RoundAfterConversion(T thisValue, PrecisionContext ctx) {
        return this.RoundToPrecision(thisValue, ctx);
    }
}

