/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

final class URIUtility {
    private static final String HexChars = "0123456789ABCDEF";

    private URIUtility() {
    }

    private static void appendAuthority(StringBuilder builder, String refValue, int[] segments) {
        if (segments[2] >= 0) {
            builder.append("//");
            builder.append(refValue.substring(segments[2], segments[2] + (segments[3] - segments[2])));
        }
    }

    private static void appendFragment(StringBuilder builder, String refValue, int[] segments) {
        if (segments[8] >= 0) {
            builder.append('#');
            builder.append(refValue.substring(segments[8], segments[8] + (segments[9] - segments[8])));
        }
    }

    private static void appendNormalizedPath(StringBuilder builder, String refValue, int[] segments) {
        builder.append(URIUtility.normalizePath(refValue.substring(segments[4], segments[4] + (segments[5] - segments[4]))));
    }

    private static void appendPath(StringBuilder builder, String refValue, int[] segments) {
        builder.append(refValue.substring(segments[4], segments[4] + (segments[5] - segments[4])));
    }

    private static void appendQuery(StringBuilder builder, String refValue, int[] segments) {
        if (segments[6] >= 0) {
            builder.append('?');
            builder.append(refValue.substring(segments[6], segments[6] + (segments[7] - segments[6])));
        }
    }

    private static void appendScheme(StringBuilder builder, String refValue, int[] segments) {
        if (segments[0] >= 0) {
            builder.append(refValue.substring(segments[0], segments[0] + (segments[1] - segments[0])));
            builder.append(':');
        }
    }

    public static String escapeURI(String s, int mode) {
        if (s == null) {
            return null;
        }
        int[] components = null;
        if (mode == 1) {
            int[] nArray = components = s == null ? null : URIUtility.splitIRI(s, 0, s.length(), ParseMode.IRIStrict);
            if (components == null) {
                return null;
            }
        } else {
            components = s == null ? null : URIUtility.splitIRI(s, 0, s.length(), ParseMode.IRISurrogateLenient);
        }
        int index = 0;
        int valueSLength = s.length();
        StringBuilder builder = new StringBuilder();
        while (index < valueSLength) {
            int c = s.charAt(index);
            if ((c & 0xFC00) == 55296 && index + 1 < valueSLength && s.charAt(index + 1) >= '\udc00' && s.charAt(index + 1) <= '\udfff') {
                c = 65536 + (c - 55296 << 10) + (s.charAt(index + 1) - 56320);
                ++index;
            } else if ((c & 0xF800) == 55296) {
                c = 65533;
            }
            if (mode == 0 || mode == 3) {
                if (c == 37 && mode == 3) {
                    if (index + 2 >= valueSLength || !URIUtility.isHexChar(s.charAt(index + 1)) || !URIUtility.isHexChar(s.charAt(index + 2))) {
                        URIUtility.percentEncodeUtf8(builder, c);
                    } else if (c <= 65535) {
                        builder.append((char)c);
                    } else if (c <= 0x10FFFF) {
                        builder.append((char)((c - 65536 >> 10 & 0x3FF) + 55296));
                        builder.append((char)((c - 65536 & 0x3FF) + 56320));
                    }
                    ++index;
                    continue;
                }
                if (c >= 127 || c <= 32 || (c & 0x7F) == c && "{}|^\\`<>\"".indexOf((char)c) >= 0) {
                    URIUtility.percentEncodeUtf8(builder, c);
                } else if (c == 91 || c == 93) {
                    if (components != null && index >= components[2] && index < components[3]) {
                        if (c <= 65535) {
                            builder.append((char)c);
                        } else if (c <= 0x10FFFF) {
                            builder.append((char)((c - 65536 >> 10 & 0x3FF) + 55296));
                            builder.append((char)((c - 65536 & 0x3FF) + 56320));
                        }
                    } else {
                        URIUtility.percentEncodeUtf8(builder, c);
                    }
                } else if (c <= 65535) {
                    builder.append((char)c);
                } else if (c <= 0x10FFFF) {
                    builder.append((char)((c - 65536 >> 10 & 0x3FF) + 55296));
                    builder.append((char)((c - 65536 & 0x3FF) + 56320));
                }
            } else if (mode == 1 || mode == 2) {
                if (c >= 128) {
                    URIUtility.percentEncodeUtf8(builder, c);
                } else if (c == 91 || c == 93) {
                    if (components != null && index >= components[2] && index < components[3]) {
                        if (c <= 65535) {
                            builder.append((char)c);
                        } else if (c <= 0x10FFFF) {
                            builder.append((char)((c - 65536 >> 10 & 0x3FF) + 55296));
                            builder.append((char)((c - 65536 & 0x3FF) + 56320));
                        }
                    } else {
                        URIUtility.percentEncodeUtf8(builder, c);
                    }
                } else if (c <= 65535) {
                    builder.append((char)c);
                } else if (c <= 0x10FFFF) {
                    builder.append((char)((c - 65536 >> 10 & 0x3FF) + 55296));
                    builder.append((char)((c - 65536 & 0x3FF) + 56320));
                }
            }
            ++index;
        }
        return builder.toString();
    }

    public static boolean hasScheme(String refValue) {
        int[] segments = refValue == null ? null : URIUtility.splitIRI(refValue, 0, refValue.length(), ParseMode.IRIStrict);
        return segments != null && segments[0] >= 0;
    }

    public static boolean hasSchemeForURI(String refValue) {
        int[] segments = refValue == null ? null : URIUtility.splitIRI(refValue, 0, refValue.length(), ParseMode.URIStrict);
        return segments != null && segments[0] >= 0;
    }

    private static boolean isHexChar(char c) {
        return c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
    }

    private static boolean isIfragmentChar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || (c & 0x7F) == c && "/?-._~:@!$&'()*+,;=".indexOf((char)c) >= 0 || c >= 160 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65519 || c >= 65536 && c <= 983037 && (c & 0xFFFE) != 65534;
    }

    private static boolean isIpchar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || (c & 0x7F) == c && "/-._~:@!$&'()*+,;=".indexOf((char)c) >= 0 || c >= 160 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65519 || c >= 65536 && c <= 983037 && (c & 0xFFFE) != 65534;
    }

    private static boolean isIqueryChar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || (c & 0x7F) == c && "/?-._~:@!$&'()*+,;=".indexOf((char)c) >= 0 || c >= 160 && c <= 55295 || c >= 57344 && c <= 64975 || c >= 65008 && c <= 65519 || c >= 65536 && c <= 1114109 && (c & 0xFFFE) != 65534;
    }

    private static boolean isIRegNameChar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || (c & 0x7F) == c && "-._~!$&'()*+,;=".indexOf((char)c) >= 0 || c >= 160 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65519 || c >= 65536 && c <= 983037 && (c & 0xFFFE) != 65534;
    }

    private static boolean isIUserInfoChar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || (c & 0x7F) == c && "-._~:!$&'()*+,;=".indexOf((char)c) >= 0 || c >= 160 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65519 || c >= 65536 && c <= 983037 && (c & 0xFFFE) != 65534;
    }

    public static boolean isValidCurieReference(String s, int offset, int length) {
        if (s == null) {
            return false;
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset (" + Integer.toString((int)((long)offset)) + ") is less than " + "0");
        }
        if (offset > s.length()) {
            throw new IllegalArgumentException("offset (" + Integer.toString((int)((long)offset)) + ") is more than " + Integer.toString((int)((long)s.length())));
        }
        if (length < 0) {
            throw new IllegalArgumentException("length (" + Integer.toString((int)((long)length)) + ") is less than " + "0");
        }
        if (length > s.length()) {
            throw new IllegalArgumentException("length (" + Integer.toString((int)((long)length)) + ") is more than " + Integer.toString((int)((long)s.length())));
        }
        if (s.length() - offset < length) {
            throw new IllegalArgumentException("s's length minus " + offset + " (" + Integer.toString((int)((long)(s.length() - offset))) + ") is less than " + Integer.toString((int)((long)length)));
        }
        if (length == 0) {
            return true;
        }
        int index = offset;
        int valueSLength = offset + length;
        int state = 0;
        if (index + 2 <= valueSLength && s.charAt(index) == '/' && s.charAt(index + 1) == '/') {
            return false;
        }
        state = 0;
        while (index < valueSLength) {
            int c = s.charAt(index);
            if ((c & 0xFC00) == 55296 && index + 1 < valueSLength && s.charAt(index + 1) >= '\udc00' && s.charAt(index + 1) <= '\udfff') {
                c = 65536 + (c - 55296 << 10) + (s.charAt(index + 1) - 56320);
                ++index;
            } else if ((c & 0xF800) == 55296) {
                return false;
            }
            if (c == 37) {
                if (index + 2 < valueSLength && URIUtility.isHexChar(s.charAt(index + 1)) && URIUtility.isHexChar(s.charAt(index + 2))) {
                    index += 3;
                    continue;
                }
                return false;
            }
            if (state == 0) {
                if (c == 63) {
                    state = 1;
                } else if (c == 35) {
                    state = 2;
                } else if (!URIUtility.isIpchar(c)) {
                    return false;
                }
                ++index;
                continue;
            }
            if (state == 1) {
                if (c == 35) {
                    state = 2;
                } else if (!URIUtility.isIqueryChar(c)) {
                    return false;
                }
                ++index;
                continue;
            }
            if (state != 2) continue;
            if (!URIUtility.isIfragmentChar(c)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static boolean isValidIRI(String s) {
        return (s == null ? null : URIUtility.splitIRI(s, 0, s.length(), ParseMode.IRIStrict)) != null;
    }

    private static String normalizePath(String path) {
        int len = path.length();
        if (len == 0 || path.equals("..") || path.equals(".")) {
            return "";
        }
        if (path.indexOf("/.") < 0 && path.indexOf("./") < 0) {
            return path;
        }
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (index < len) {
            int index2;
            char c = path.charAt(index);
            if (index + 3 <= len && c == '/' && path.charAt(index + 1) == '.' && path.charAt(index + 2) == '/' || index + 2 == len && c == '.' && path.charAt(index + 1) == '.') {
                index += 2;
                continue;
            }
            if (index + 3 <= len && c == '.' && path.charAt(index + 1) == '.' && path.charAt(index + 2) == '/') {
                index += 3;
                continue;
            }
            if (index + 2 <= len && c == '.' && path.charAt(index + 1) == '/' || index + 1 == len && c == '.') {
                ++index;
                continue;
            }
            if (index + 2 == len && c == '/' && path.charAt(index + 1) == '.') {
                builder.append('/');
                break;
            }
            if (index + 3 == len && c == '/' && path.charAt(index + 1) == '.' && path.charAt(index + 2) == '.') {
                for (index2 = builder.length() - 1; index2 >= 0 && builder.charAt(index2) != '/'; --index2) {
                }
                if (index2 < 0) {
                    index2 = 0;
                }
                builder.setLength(index2);
                builder.append('/');
                break;
            }
            if (index + 4 <= len && c == '/' && path.charAt(index + 1) == '.' && path.charAt(index + 2) == '.' && path.charAt(index + 3) == '/') {
                for (index2 = builder.length() - 1; index2 >= 0 && builder.charAt(index2) != '/'; --index2) {
                }
                if (index2 < 0) {
                    index2 = 0;
                }
                builder.setLength(index2);
                index += 3;
                continue;
            }
            builder.append(c);
            ++index;
            while (index < len && (c = path.charAt(index)) != '/') {
                builder.append(c);
                ++index;
            }
        }
        return builder.toString();
    }

    private static int parseDecOctet(String s, int index, int endOffset, int c, int delim) {
        if (c >= 49 && c <= 57 && index + 2 < endOffset && s.charAt(index + 1) >= '0' && s.charAt(index + 1) <= '9' && s.charAt(index + 2) == delim) {
            return (c - 48) * 10 + (s.charAt(index + 1) - 48);
        }
        if (c == 50 && index + 3 < endOffset && s.charAt(index + 1) == '5' && s.charAt(index + 2) >= '0' && s.charAt(index + 2) <= '5' && s.charAt(index + 3) == delim) {
            return 250 + (s.charAt(index + 2) - 48);
        }
        if (c == 50 && index + 3 < endOffset && s.charAt(index + 1) >= '0' && s.charAt(index + 1) <= '4' && s.charAt(index + 2) >= '0' && s.charAt(index + 2) <= '9' && s.charAt(index + 3) == delim) {
            return 200 + (s.charAt(index + 1) - 48) * 10 + (s.charAt(index + 2) - 48);
        }
        if (c == 49 && index + 3 < endOffset && s.charAt(index + 1) >= '0' && s.charAt(index + 1) <= '9' && s.charAt(index + 2) >= '0' && s.charAt(index + 2) <= '9' && s.charAt(index + 3) == delim) {
            return 100 + (s.charAt(index + 1) - 48) * 10 + (s.charAt(index + 2) - 48);
        }
        return c >= 48 && c <= 57 && index + 1 < endOffset && s.charAt(index + 1) == delim ? c - 48 : -1;
    }

    private static int parseIPLiteral(String s, int offset, int endOffset) {
        int index = offset;
        if (offset == endOffset) {
            return -1;
        }
        if (s.charAt(index) == 'v') {
            char c;
            ++index;
            boolean hex = false;
            while (index < endOffset && URIUtility.isHexChar(c = s.charAt(index))) {
                hex = true;
                ++index;
            }
            if (!hex) {
                return -1;
            }
            if (index >= endOffset || s.charAt(index) != '.') {
                return -1;
            }
            ++index;
            hex = false;
            while (index < endOffset && ((c = s.charAt(index)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || (c & 0x7F) == c && ":-._~!$&'()*+,;=".indexOf(c) >= 0)) {
                hex = true;
                ++index;
            }
            if (!hex) {
                return -1;
            }
            if (index >= endOffset || s.charAt(index) != ']') {
                return -1;
            }
            return ++index;
        }
        if (s.charAt(index) == ':' || URIUtility.isHexChar(s.charAt(index))) {
            int phase1 = 0;
            int phase2 = 0;
            boolean phased = false;
            boolean expectHex = false;
            boolean expectColon = false;
            while (index < endOffset) {
                int decOctet;
                char c = s.charAt(index);
                if (c == ':' && !expectHex) {
                    if (phase1 + (phased ? 1 : 0) + phase2 >= 8) {
                        return -1;
                    }
                    if (++index < endOffset && s.charAt(index) == ':') {
                        if (phased) {
                            return -1;
                        }
                        phased = true;
                        ++index;
                    }
                    expectHex = true;
                    expectColon = false;
                    continue;
                }
                if (c >= '0' && c <= '9' && !expectColon && (phased || phase1 + (phased ? 1 : 0) + phase2 == 6) && (decOctet = URIUtility.parseDecOctet(s, index, endOffset, c, 46)) >= 0) {
                    if (phase1 + (phased ? 1 : 0) + phase2 > 6) {
                        return -1;
                    }
                    phase2 += 2;
                    index = decOctet >= 100 ? (index += 4) : (decOctet >= 10 ? (index += 3) : (index += 2));
                    char tmpc = index < endOffset ? s.charAt(index) : (char)'\u0000';
                    decOctet = URIUtility.parseDecOctet(s, index, endOffset, tmpc, 46);
                    if (decOctet >= 100) {
                        index += 4;
                    } else if (decOctet >= 10) {
                        index += 3;
                    } else if (decOctet >= 0) {
                        index += 2;
                    } else {
                        return -1;
                    }
                    tmpc = index < endOffset ? s.charAt(index) : (char)'\u0000';
                    decOctet = URIUtility.parseDecOctet(s, index, endOffset, tmpc, 46);
                    if (decOctet >= 100) {
                        index += 4;
                    } else if (decOctet >= 10) {
                        index += 3;
                    } else if (decOctet >= 0) {
                        index += 2;
                    } else {
                        return -1;
                    }
                    tmpc = index < endOffset ? s.charAt(index) : (char)'\u0000';
                    decOctet = URIUtility.parseDecOctet(s, index, endOffset, tmpc, 93);
                    if (decOctet < 0) {
                        tmpc = index < endOffset ? s.charAt(index) : (char)'\u0000';
                        decOctet = URIUtility.parseDecOctet(s, index, endOffset, tmpc, 37);
                    }
                    if (decOctet >= 100) {
                        index += 3;
                        break;
                    }
                    if (decOctet >= 10) {
                        index += 2;
                        break;
                    }
                    if (decOctet >= 0) {
                        ++index;
                        break;
                    }
                    return -1;
                }
                if (!URIUtility.isHexChar(c) || expectColon) break;
                if (phased) {
                    ++phase2;
                } else {
                    ++phase1;
                }
                ++index;
                for (int i = 0; i < 3 && index < endOffset && URIUtility.isHexChar(s.charAt(index)); ++index, ++i) {
                }
                expectHex = false;
                expectColon = true;
            }
            if (phase1 + phase2 != 8 && !phased) {
                return -1;
            }
            if (phase1 + 1 + phase2 > 8 && phased) {
                return -1;
            }
            if (index >= endOffset) {
                return -1;
            }
            if (s.charAt(index) != ']' && s.charAt(index) != '%') {
                return -1;
            }
            if (s.charAt(index) == '%') {
                if (index + 2 < endOffset && s.charAt(index + 1) == '2' && s.charAt(index + 2) == '5') {
                    index += 3;
                    boolean haveChar = false;
                    while (index < endOffset) {
                        char c = s.charAt(index);
                        if (c == ']') {
                            return haveChar ? index + 1 : -1;
                        }
                        if (c == '%') {
                            if (index + 2 < endOffset && URIUtility.isHexChar(s.charAt(index + 1)) && URIUtility.isHexChar(s.charAt(index + 2))) {
                                index += 3;
                                haveChar = true;
                                continue;
                            }
                            return -1;
                        }
                        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-' || c == '~') {
                            ++index;
                            haveChar = true;
                            continue;
                        }
                        return -1;
                    }
                    return -1;
                }
                return -1;
            }
            return ++index;
        }
        return -1;
    }

    private static String pathParent(String refValue, int startIndex, int endIndex) {
        if (startIndex > endIndex) {
            return "";
        }
        --endIndex;
        while (endIndex >= startIndex) {
            if (refValue.charAt(endIndex) == '/') {
                return refValue.substring(startIndex, startIndex + (endIndex + 1 - startIndex));
            }
            --endIndex;
        }
        return "";
    }

    private static void percentEncode(StringBuilder buffer, int b) {
        buffer.append('%');
        buffer.append(HexChars.charAt(b >> 4 & 0xF));
        buffer.append(HexChars.charAt(b & 0xF));
    }

    private static void percentEncodeUtf8(StringBuilder buffer, int cp) {
        if (cp <= 127) {
            buffer.append('%');
            buffer.append(HexChars.charAt(cp >> 4 & 0xF));
            buffer.append(HexChars.charAt(cp & 0xF));
        } else if (cp <= 2047) {
            URIUtility.percentEncode(buffer, 0xC0 | cp >> 6 & 0x1F);
            URIUtility.percentEncode(buffer, 0x80 | cp & 0x3F);
        } else if (cp <= 65535) {
            URIUtility.percentEncode(buffer, 0xE0 | cp >> 12 & 0xF);
            URIUtility.percentEncode(buffer, 0x80 | cp >> 6 & 0x3F);
            URIUtility.percentEncode(buffer, 0x80 | cp & 0x3F);
        } else {
            URIUtility.percentEncode(buffer, 0xF0 | cp >> 18 & 7);
            URIUtility.percentEncode(buffer, 0x80 | cp >> 12 & 0x3F);
            URIUtility.percentEncode(buffer, 0x80 | cp >> 6 & 0x3F);
            URIUtility.percentEncode(buffer, 0x80 | cp & 0x3F);
        }
    }

    public static String relativeResolve(String refValue, String baseURI) {
        return URIUtility.relativeResolve(refValue, baseURI, ParseMode.IRIStrict);
    }

    public static String relativeResolve(String refValue, String baseURI, ParseMode parseMode) {
        int[] segmentsBase;
        int[] segments;
        int[] nArray = segments = refValue == null ? null : URIUtility.splitIRI(refValue, 0, refValue.length(), parseMode);
        if (segments == null) {
            return null;
        }
        int[] nArray2 = segmentsBase = baseURI == null ? null : URIUtility.splitIRI(baseURI, 0, baseURI.length(), parseMode);
        if (segmentsBase == null) {
            return refValue;
        }
        StringBuilder builder = new StringBuilder();
        if (segments[0] >= 0) {
            URIUtility.appendScheme(builder, refValue, segments);
            URIUtility.appendAuthority(builder, refValue, segments);
            URIUtility.appendNormalizedPath(builder, refValue, segments);
            URIUtility.appendQuery(builder, refValue, segments);
            URIUtility.appendFragment(builder, refValue, segments);
        } else if (segments[2] >= 0) {
            URIUtility.appendScheme(builder, baseURI, segmentsBase);
            URIUtility.appendAuthority(builder, refValue, segments);
            URIUtility.appendNormalizedPath(builder, refValue, segments);
            URIUtility.appendQuery(builder, refValue, segments);
            URIUtility.appendFragment(builder, refValue, segments);
        } else if (segments[4] == segments[5]) {
            URIUtility.appendScheme(builder, baseURI, segmentsBase);
            URIUtility.appendAuthority(builder, baseURI, segmentsBase);
            URIUtility.appendPath(builder, baseURI, segmentsBase);
            if (segments[6] >= 0) {
                URIUtility.appendQuery(builder, refValue, segments);
            } else {
                URIUtility.appendQuery(builder, baseURI, segmentsBase);
            }
            URIUtility.appendFragment(builder, refValue, segments);
        } else {
            URIUtility.appendScheme(builder, baseURI, segmentsBase);
            URIUtility.appendAuthority(builder, baseURI, segmentsBase);
            if (segments[4] < segments[5] && refValue.charAt(segments[4]) == '/') {
                URIUtility.appendNormalizedPath(builder, refValue, segments);
            } else {
                StringBuilder merged = new StringBuilder();
                if (segmentsBase[2] >= 0 && segmentsBase[4] == segmentsBase[5]) {
                    merged.append('/');
                    URIUtility.appendPath(merged, refValue, segments);
                    builder.append(URIUtility.normalizePath(merged.toString()));
                } else {
                    merged.append(URIUtility.pathParent(baseURI, segmentsBase[4], segmentsBase[5]));
                    URIUtility.appendPath(merged, refValue, segments);
                    builder.append(URIUtility.normalizePath(merged.toString()));
                }
            }
            URIUtility.appendQuery(builder, refValue, segments);
            URIUtility.appendFragment(builder, refValue, segments);
        }
        return builder.toString();
    }

    public static int[] splitIRI(String s) {
        return s == null ? null : URIUtility.splitIRI(s, 0, s.length(), ParseMode.IRIStrict);
    }

    public static int[] splitIRI(String s, int offset, int length, ParseMode parseMode) {
        int index;
        if (s == null) {
            return null;
        }
        if (offset < 0 || length < 0 || offset + length > s.length()) {
            throw new IllegalArgumentException();
        }
        int[] retval = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        if (length == 0) {
            retval[4] = 0;
            retval[5] = 0;
            return retval;
        }
        boolean asciiOnly = parseMode == ParseMode.URILenient || parseMode == ParseMode.URIStrict;
        boolean strict = parseMode == ParseMode.URIStrict || parseMode == ParseMode.IRIStrict;
        int valueSLength = offset + length;
        boolean scheme = false;
        for (index = offset; index < valueSLength; ++index) {
            char c = s.charAt(index);
            if (index > offset && c == ':') {
                scheme = true;
                retval[0] = offset;
                retval[1] = index++;
                break;
            }
            if (!((!strict || index != offset || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (!strict || index <= offset || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '+' || c == '-' || c == '.') && (strict || c != '#' && c != ':' && c != '?' && c != '/'))) break;
        }
        if (!scheme) {
            index = offset;
        }
        int state = 0;
        if (index + 2 <= valueSLength && s.charAt(index) == '/' && s.charAt(index + 1) == '/') {
            int authorityStart;
            retval[2] = authorityStart = (index += 2);
            retval[3] = valueSLength;
            state = 0;
            while (index < valueSLength) {
                int c = s.charAt(index);
                if (asciiOnly && c >= 128) {
                    return null;
                }
                if ((c & 0xFC00) == 55296 && index + 1 < valueSLength && s.charAt(index + 1) >= '\udc00' && s.charAt(index + 1) <= '\udfff') {
                    c = 65536 + (c - 55296 << 10) + (s.charAt(index + 1) - 56320);
                    ++index;
                } else if ((c & 0xF800) == 55296) {
                    if (parseMode == ParseMode.IRISurrogateLenient) {
                        c = 65533;
                    } else {
                        return null;
                    }
                }
                if (c == 37 && (state == 0 || state == 1) && strict) {
                    if (index + 2 < valueSLength && URIUtility.isHexChar(s.charAt(index + 1)) && URIUtility.isHexChar(s.charAt(index + 2))) {
                        index += 3;
                        continue;
                    }
                    return null;
                }
                if (state == 0) {
                    if (c == 47 || c == 63 || c == 35) {
                        state = 1;
                        index = authorityStart;
                        continue;
                    }
                    if (strict && c == 64) {
                        ++index;
                        state = 1;
                        continue;
                    }
                    if (strict && URIUtility.isIUserInfoChar(c)) {
                        if (++index != valueSLength) continue;
                        state = 1;
                        index = authorityStart;
                        continue;
                    }
                    state = 1;
                    index = authorityStart;
                    continue;
                }
                if (state == 1) {
                    if (c == 47 || c == 63 || c == 35) {
                        retval[3] = index;
                        break;
                    }
                    if (!strict) {
                        ++index;
                        continue;
                    }
                    if (c == 91) {
                        ++index;
                        if ((index = URIUtility.parseIPLiteral(s, index, valueSLength)) >= 0) continue;
                        return null;
                    }
                    if (c == 58) {
                        state = 2;
                        ++index;
                        continue;
                    }
                    if (URIUtility.isIRegNameChar(c)) {
                        ++index;
                        continue;
                    }
                    return null;
                }
                if (state != 2) continue;
                if (c == 47 || c == 63 || c == 35) {
                    retval[3] = index;
                    break;
                }
                if (c >= 48 && c <= 57) {
                    ++index;
                    continue;
                }
                return null;
            }
        }
        boolean colon = false;
        boolean segment = false;
        boolean fullyRelative = index == offset;
        retval[4] = index;
        retval[5] = valueSLength;
        state = 0;
        while (index < valueSLength) {
            int c = s.charAt(index);
            if (asciiOnly && c >= 128) {
                return null;
            }
            if ((c & 0xFC00) == 55296 && index + 1 < valueSLength && s.charAt(index + 1) >= '\udc00' && s.charAt(index + 1) <= '\udfff') {
                c = 65536 + (c - 55296 << 10) + (s.charAt(index + 1) - 56320);
                ++index;
            } else if ((c & 0xF800) == 55296) {
                return null;
            }
            if (c == 37 && strict) {
                if (index + 2 < valueSLength && URIUtility.isHexChar(s.charAt(index + 1)) && URIUtility.isHexChar(s.charAt(index + 2))) {
                    index += 3;
                    continue;
                }
                return null;
            }
            if (state == 0) {
                if (c == 58 && fullyRelative) {
                    colon = true;
                } else if (c == 47 && fullyRelative && !segment) {
                    if (strict && colon) {
                        return null;
                    }
                    segment = true;
                }
                if (c == 63) {
                    retval[5] = index;
                    retval[6] = index + 1;
                    retval[7] = valueSLength;
                    state = 1;
                } else if (c == 35) {
                    retval[5] = index;
                    retval[8] = index + 1;
                    retval[9] = valueSLength;
                    state = 2;
                } else if (strict && !URIUtility.isIpchar(c)) {
                    return null;
                }
                ++index;
                continue;
            }
            if (state == 1) {
                if (c == 35) {
                    retval[7] = index;
                    retval[8] = index + 1;
                    retval[9] = valueSLength;
                    state = 2;
                } else if (strict && !URIUtility.isIqueryChar(c)) {
                    return null;
                }
                ++index;
                continue;
            }
            if (state != 2) continue;
            if (strict && !URIUtility.isIfragmentChar(c)) {
                return null;
            }
            ++index;
        }
        if (strict && fullyRelative && colon && !segment) {
            return null;
        }
        return retval;
    }

    public static int[] splitIRI(String s, ParseMode parseMode) {
        return s == null ? null : URIUtility.splitIRI(s, 0, s.length(), parseMode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ParseMode {
        IRIStrict,
        URIStrict,
        IRILenient,
        URILenient,
        IRISurrogateLenient;

    }
}

