/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import java.io.IOException;
import java.io.InputStream;

class CharacterReader {
    private String str;
    private InputStream stream;
    private int offset;

    public CharacterReader(String str) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        this.str = str;
    }

    public CharacterReader(InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        this.stream = stream;
    }

    public CBORException NewError(String str) {
        return new CBORException(str + " (offset " + this.offset + ")");
    }

    public int NextChar() {
        int c;
        if (this.stream != null) {
            int cp = 0;
            int bytesSeen = 0;
            int bytesNeeded = 0;
            int lower = 0;
            int upper = 0;
            try {
                while (true) {
                    int b;
                    if ((b = this.stream.read()) < 0) {
                        if (bytesNeeded != 0) {
                            bytesNeeded = 0;
                            throw this.NewError("Invalid UTF-8");
                        }
                        return -1;
                    }
                    if (bytesNeeded == 0) {
                        if ((b & 0x7F) == b) {
                            ++this.offset;
                            return b;
                        }
                        if (b >= 194 && b <= 223) {
                            bytesNeeded = 1;
                            lower = 128;
                            upper = 191;
                            cp = b - 192 << 6;
                            continue;
                        }
                        if (b >= 224 && b <= 239) {
                            lower = b == 224 ? 160 : 128;
                            upper = b == 237 ? 159 : 191;
                            bytesNeeded = 2;
                            cp = b - 224 << 12;
                            continue;
                        }
                        if (b >= 240 && b <= 244) {
                            lower = b == 240 ? 144 : 128;
                            upper = b == 244 ? 143 : 191;
                            bytesNeeded = 3;
                            cp = b - 240 << 18;
                            continue;
                        }
                        throw this.NewError("Invalid UTF-8");
                    }
                    if (b < lower || b > upper) {
                        bytesSeen = 0;
                        bytesNeeded = 0;
                        cp = 0;
                        throw this.NewError("Invalid UTF-8");
                    }
                    lower = 128;
                    upper = 191;
                    cp += b - 128 << 6 * (bytesNeeded - ++bytesSeen);
                    if (bytesSeen == bytesNeeded) break;
                }
                int ret = cp;
                cp = 0;
                bytesSeen = 0;
                bytesNeeded = 0;
                ++this.offset;
                return ret;
            }
            catch (IOException ex) {
                throw new CBORException("I/O error occurred (offset " + this.offset + ")", ex);
            }
        }
        int n = c = this.offset < this.str.length() ? (int)this.str.charAt(this.offset) : -1;
        if ((c & 0xFC00) == 55296 && this.offset + 1 < this.str.length() && this.str.charAt(this.offset + 1) >= '\udc00' && this.str.charAt(this.offset + 1) <= '\udfff') {
            c = 65536 + (c - 55296 << 10) + (this.str.charAt(this.offset + 1) - 56320);
            ++this.offset;
        } else if ((c & 0xF800) == 55296) {
            throw this.NewError("Unpaired surrogate code point");
        }
        ++this.offset;
        return c;
    }
}

