/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.activity;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.MenuItem;
import android.webkit.CookieManager;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.uploadcare.android.widget.R;
import com.uploadcare.android.widget.controller.UploadcareWidget;
import fr.castorflex.android.circularprogressbar.CircularProgressBar;

public class UploadcareAuthActivity
extends AppCompatActivity {
    public static final int RESULT_ERROR = 10;
    private WebView mWebView;
    private CircularProgressBar mCircularProgressBar;
    private String loginUrl;

    protected void onCreate(Bundle savedInstanceState) {
        if (UploadcareWidget.getInstance().getStyle() != -1) {
            this.getTheme().applyStyle(UploadcareWidget.getInstance().getStyle(), true);
        } else {
            this.getTheme().applyStyle(R.style.UploadcareStyle, true);
        }
        super.onCreate(savedInstanceState);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        }
        if (!UploadcareWidget.getInstance().isInited()) {
            this.finish();
        }
        this.setContentView(R.layout.ucw_activity_auth);
        this.mWebView = (WebView)this.findViewById(R.id.ucw_webview);
        this.mCircularProgressBar = (CircularProgressBar)this.findViewById(R.id.ucw_progress);
        if (savedInstanceState != null) {
            this.loginUrl = savedInstanceState.getString("loginUrl");
        } else {
            Bundle extras = this.getIntent().getExtras();
            this.loginUrl = extras.getString("loginUrl");
        }
        this.setResult(0);
        WebSettings webSettings = this.mWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        this.mWebView.setWebViewClient((WebViewClient)new UploadcareWebViewClient());
        this.mWebView.loadUrl(this.loginUrl);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.loginUrl != null) {
            outState.putString("loginUrl", this.loginUrl);
        }
    }

    private class UploadcareWebViewClient
    extends WebViewClient {
        private UploadcareWebViewClient() {
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            UploadcareAuthActivity.this.mCircularProgressBar.setVisibility(8);
            if (url.startsWith("https://social.uploadcare.com")) {
                String cookies = CookieManager.getInstance().getCookie(url);
                if (cookies != null && cookies.length() > 0) {
                    Intent resultIntent = new Intent();
                    resultIntent.putExtra("cookie", cookies);
                    UploadcareAuthActivity.this.setResult(-1, resultIntent);
                } else {
                    UploadcareAuthActivity.this.setResult(10);
                }
                UploadcareAuthActivity.this.finish();
            }
        }

        public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
            return super.shouldInterceptRequest(view, request);
        }

        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            super.onReceivedError(view, request, error);
            UploadcareAuthActivity.this.mCircularProgressBar.setVisibility(8);
            UploadcareAuthActivity.this.setResult(10);
            UploadcareAuthActivity.this.finish();
        }

        public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
            super.onReceivedHttpError(view, request, errorResponse);
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return false;
        }
    }
}

