/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.activity;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.widget.ListAdapter;
import com.uploadcare.android.library.api.UploadcareFile;
import com.uploadcare.android.library.callbacks.UploadcareFileCallback;
import com.uploadcare.android.library.exceptions.UploadcareApiException;
import com.uploadcare.android.library.upload.FileUploader;
import com.uploadcare.android.widget.R;
import com.uploadcare.android.widget.activity.UploadcareFilesActivity;
import com.uploadcare.android.widget.adapter.SocialNetworksAdapter;
import com.uploadcare.android.widget.controller.UploadcareWidget;
import com.uploadcare.android.widget.data.SocialSource;
import com.uploadcare.android.widget.data.SocialSourcesResponse;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import retrofit.Callback;
import retrofit.RetrofitError;
import retrofit.client.Response;

public class UploadcareActivity
extends AppCompatActivity {
    private static final int CAPTURE_IMAGE_ACTIVITY_REQUEST_CODE = 100;
    private static final int CAPTURE_VIDEO_ACTIVITY_REQUEST_CODE = 200;
    private static final int CHOOSE_FILE_ACTIVITY_REQUEST_CODE = 300;
    public static final int MEDIA_TYPE_IMAGE = 1;
    public static final int MEDIA_TYPE_VIDEO = 2;
    private SocialSourcesResponse mSocialSources;
    private String network = null;
    private Uri tempFileUri = null;

    protected void onCreate(Bundle savedInstanceState) {
        if (UploadcareWidget.getInstance().getStyle() != -1) {
            this.getTheme().applyStyle(UploadcareWidget.getInstance().getStyle(), true);
        } else {
            this.getTheme().applyStyle(R.style.UploadcareStyle, true);
        }
        super.onCreate(savedInstanceState);
        if (!UploadcareWidget.getInstance().isInited()) {
            this.finish();
        }
        this.setContentView(R.layout.ucw_activity_uploadcare);
        if (savedInstanceState != null) {
            this.mSocialSources = (SocialSourcesResponse)savedInstanceState.getParcelable("socialsources");
            this.network = savedInstanceState.getString("network", null);
        } else {
            Bundle extras = this.getIntent().getExtras();
            if (extras != null) {
                this.network = extras.getString("network", null);
                this.tempFileUri = (Uri)extras.getParcelable("tempfile");
            }
        }
        if (this.mSocialSources != null) {
            this.showNetworks();
        } else {
            this.getAvailableNetworks();
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mSocialSources != null) {
            outState.putParcelable("socialsource", (Parcelable)this.mSocialSources);
        }
        if (this.network != null) {
            outState.putString("network", this.network);
        }
        if (this.tempFileUri != null) {
            outState.putParcelable("tempfile", (Parcelable)this.tempFileUri);
        }
    }

    private void getAvailableNetworks() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this, R.style.UploadcareWidget_AlertDialogStyle);
        builder.setView(R.layout.ucw_progress_bar);
        builder.setTitle(R.string.ucw_action_loading_networks);
        builder.setCancelable(false);
        final AlertDialog dialog = builder.create();
        dialog.show();
        UploadcareWidget.getInstance().getSocialApi().getSources(new Callback<SocialSourcesResponse>(){

            public void success(SocialSourcesResponse socialSourcesResponse, Response response) {
                UploadcareActivity.this.mSocialSources = socialSourcesResponse;
                dialog.dismiss();
                UploadcareActivity.this.showNetworks();
            }

            public void failure(RetrofitError error) {
                dialog.dismiss();
                UploadcareActivity.this.finish();
                UploadcareWidget.getInstance().getCallback().onFailure(new UploadcareApiException(error.getLocalizedMessage()));
            }
        });
    }

    private void showNetworks() {
        if (this.network == null) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this, R.style.UploadcareWidget_AlertDialogStyle);
            builder.setTitle(R.string.ucw_action_select_network);
            builder.setCancelable(true);
            final SocialNetworksAdapter adapter = new SocialNetworksAdapter((Context)this, this.mSocialSources.sources);
            builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    dialog.dismiss();
                    UploadcareActivity.this.finish();
                }
            });
            builder.setNegativeButton(R.string.ucw_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    UploadcareActivity.this.finish();
                }
            });
            builder.setAdapter((ListAdapter)adapter, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    SocialSource socialSource = adapter.getItem(which);
                    UploadcareActivity.this.launchNetwork(socialSource);
                }
            });
            AlertDialog dialog = builder.create();
            dialog.show();
        } else {
            SocialSource socialSource = null;
            for (SocialSource source : this.mSocialSources.sources) {
                if (!source.name.equalsIgnoreCase(this.network)) continue;
                socialSource = source;
                break;
            }
            Intent intent = new Intent((Context)this, UploadcareFilesActivity.class);
            intent.putExtra("socialsource", socialSource);
            this.startActivity(intent);
            this.finish();
        }
    }

    private void launchNetwork(SocialSource socialSource) {
        switch (socialSource.name) {
            case "image": {
                this.tempFileUri = null;
                Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
                this.tempFileUri = this.getOutputMediaFileUri(1);
                cameraIntent.putExtra("output", (Parcelable)this.tempFileUri);
                this.startActivityForResult(cameraIntent, 100);
                break;
            }
            case "video": {
                this.tempFileUri = null;
                Intent videoIntent = new Intent("android.media.action.VIDEO_CAPTURE");
                this.tempFileUri = this.getOutputMediaFileUri(2);
                videoIntent.putExtra("output", (Parcelable)this.tempFileUri);
                videoIntent.putExtra("android.intent.extra.videoQuality", 1);
                this.startActivityForResult(videoIntent, 200);
                break;
            }
            case "file": {
                Intent chooseFile = new Intent("android.intent.action.GET_CONTENT");
                chooseFile.setType(this.getTypeForFileChooser());
                chooseFile.putExtra("android.intent.extra.LOCAL_ONLY", true);
                Intent intentFile = Intent.createChooser((Intent)chooseFile, (CharSequence)this.getResources().getString(R.string.ucw_choose_file));
                this.startActivityForResult(intentFile, 300);
                break;
            }
            default: {
                Intent intent = new Intent((Context)this, UploadcareFilesActivity.class);
                intent.putExtra("socialsource", (Parcelable)socialSource);
                this.startActivity(intent);
                this.finish();
            }
        }
    }

    private Uri getOutputMediaFileUri(int type) {
        return Uri.fromFile((File)this.getOutputMediaFile(type));
    }

    private File getOutputMediaFile(int type) {
        File mediaFile;
        File mediaStorageDir = new File(this.getExternalFilesDir(Environment.DIRECTORY_PICTURES), "Cache");
        if (!mediaStorageDir.exists() && !mediaStorageDir.mkdirs()) {
            return null;
        }
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        if (type == 1) {
            mediaFile = new File(mediaStorageDir.getPath() + File.separator + "IMG_" + timeStamp + ".jpg");
        } else if (type == 2) {
            mediaFile = new File(mediaStorageDir.getPath() + File.separator + "VID_" + timeStamp + ".mp4");
        } else {
            return null;
        }
        return mediaFile;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (!UploadcareWidget.getInstance().isInited()) {
            this.finish();
        }
        if (requestCode == 100) {
            if (resultCode == -1) {
                this.uploadFile(this.tempFileUri);
            } else {
                this.finish();
            }
        } else if (requestCode == 200) {
            if (resultCode == -1) {
                this.uploadFile(this.tempFileUri);
            } else {
                this.finish();
            }
        } else if (requestCode == 300) {
            if (resultCode == -1) {
                Uri fileUri = data.getData();
                this.uploadFile(fileUri);
            } else {
                this.finish();
            }
        }
    }

    private void uploadFile(Uri fileUri) {
        if (fileUri == null) {
            this.finish();
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this, R.style.UploadcareWidget_AlertDialogStyle);
        builder.setView(R.layout.ucw_progress_bar);
        builder.setTitle(R.string.ucw_action_loading_image);
        builder.setCancelable(false);
        final AlertDialog dialog = builder.create();
        dialog.show();
        FileUploader uploader = new FileUploader(UploadcareWidget.getInstance().getUploadcareClient(), fileUri, (Context)this).store(UploadcareWidget.getInstance().storeUponUpload());
        uploader.uploadAsync(new UploadcareFileCallback(){

            public void onFailure(UploadcareApiException e) {
                dialog.dismiss();
                UploadcareActivity.this.finish();
                UploadcareWidget.getInstance().getCallback().onFailure(e);
            }

            public void onSuccess(UploadcareFile file) {
                dialog.dismiss();
                UploadcareActivity.this.finish();
                UploadcareWidget.getInstance().getCallback().onSuccess(file);
            }
        });
    }

    private String getTypeForFileChooser() {
        String fileType;
        switch (fileType = UploadcareWidget.getInstance().getFileType()) {
            case "image": {
                return "image/*";
            }
            case "video": {
                return "video/*";
            }
        }
        return "*/*";
    }
}

