/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.fragment;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.SearchView;
import com.uploadcare.android.widget.R;
import com.uploadcare.android.widget.adapter.FilesAdapter;
import com.uploadcare.android.widget.adapter.FilesGridAdapter;
import com.uploadcare.android.widget.adapter.FilesLinearAdapter;
import com.uploadcare.android.widget.controller.UploadcareWidget;
import com.uploadcare.android.widget.data.Chunk;
import com.uploadcare.android.widget.data.ChunkResponse;
import com.uploadcare.android.widget.data.SocialSource;
import com.uploadcare.android.widget.data.Thing;
import com.uploadcare.android.widget.interfaces.ItemTapListener;
import com.uploadcare.android.widget.utils.RecyclerViewOnScrollListener;
import fr.castorflex.android.circularprogressbar.CircularProgressBar;
import java.util.ArrayList;
import java.util.List;
import jp.wasabeef.recyclerview.adapters.AlphaInAnimationAdapter;
import jp.wasabeef.recyclerview.adapters.ScaleInAnimationAdapter;
import retrofit.Callback;
import retrofit.RetrofitError;
import retrofit.client.Response;

public class UploadcareFilesFragment
extends Fragment
implements ItemTapListener,
SearchView.OnQueryTextListener,
View.OnClickListener {
    private SocialSource mSocialSource;
    private List<Chunk> mChunks;
    private CircularProgressBar mCircularProgressBar;
    private RecyclerView mRecyclerView;
    private View mLoadingMoreView;
    private View mEmptyView;
    private SearchView mSearchView;
    private FilesAdapter mFilesAdapter;
    private RecyclerViewOnScrollListener mRecyclerViewOnScrollListener;
    private OnFileActionsListener mOnFileActionsListener;
    private boolean scroll = false;
    private int currentChunk = 0;
    private String title;
    private boolean rootFragment = false;
    private boolean searchFragment = false;

    public static UploadcareFilesFragment newInstance(SocialSource socialSource, List<Chunk> chunkList, String title, boolean root) {
        UploadcareFilesFragment f = new UploadcareFilesFragment();
        Bundle args = new Bundle();
        args.putParcelable("socialsource", (Parcelable)socialSource);
        args.putString("title", title);
        args.putBoolean("root", root);
        args.putParcelableArrayList("chunks", (ArrayList)chunkList);
        f.setArguments(args);
        return f;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.ucw_fragment_files, container, false);
        if (savedInstanceState != null) {
            this.mSocialSource = (SocialSource)savedInstanceState.getParcelable("socialsource");
            this.mChunks = savedInstanceState.getParcelableArrayList("chunks");
            this.currentChunk = savedInstanceState.getInt("currentChunk");
            this.title = savedInstanceState.getString("title");
            this.rootFragment = savedInstanceState.getBoolean("root");
            this.searchFragment = savedInstanceState.getBoolean("search");
        } else {
            Bundle arguments = this.getArguments();
            this.mSocialSource = (SocialSource)arguments.getParcelable("socialsource");
            this.mChunks = arguments.getParcelableArrayList("chunks");
            this.title = arguments.getString("title");
            this.rootFragment = arguments.getBoolean("root");
            this.searchFragment = arguments.getBoolean("search", false);
        }
        this.mRecyclerView = (RecyclerView)rootView.findViewById(R.id.ucw_recycler_view);
        this.mLoadingMoreView = rootView.findViewById(R.id.ucw_additional_loading);
        this.mEmptyView = rootView.findViewById(R.id.ucw_empty_view);
        this.mSearchView = (SearchView)rootView.findViewById(R.id.ucw_search_view);
        this.mSearchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        this.mCircularProgressBar = (CircularProgressBar)rootView.findViewById(R.id.ucw_progress);
        LinearLayoutManager layoutManager = null;
        if (this.mSocialSource.name.equalsIgnoreCase("box") || this.mSocialSource.name.equalsIgnoreCase("dropbox") || this.mSocialSource.name.equalsIgnoreCase("evernote") || this.mSocialSource.name.equalsIgnoreCase("skydrive") || this.mSocialSource.name.equalsIgnoreCase("gdrive")) {
            layoutManager = new LinearLayoutManager((Context)this.getActivity(), 1, false);
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            this.mFilesAdapter = new FilesLinearAdapter((Context)this.getActivity(), this, UploadcareWidget.getInstance().getFileType());
            AlphaInAnimationAdapter alphaAdapter = new AlphaInAnimationAdapter((RecyclerView.Adapter)this.mFilesAdapter);
            alphaAdapter.setDuration(this.getResources().getInteger(0x10E0000));
            alphaAdapter.setInterpolator((Interpolator)new DecelerateInterpolator());
            int pad = (int)UploadcareFilesFragment.convertDpToPixel(8.0f, (Context)this.getActivity());
            this.mRecyclerView.setPadding(0, pad, 0, pad);
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)alphaAdapter);
        } else {
            layoutManager = new GridLayoutManager((Context)this.getActivity(), this.getResources().getInteger(R.integer.columns));
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            this.mFilesAdapter = new FilesGridAdapter((Context)this.getActivity(), this, UploadcareWidget.getInstance().getFileType());
            AlphaInAnimationAdapter alphaAdapter = new AlphaInAnimationAdapter((RecyclerView.Adapter)new ScaleInAnimationAdapter((RecyclerView.Adapter)this.mFilesAdapter));
            alphaAdapter.setDuration(this.getResources().getInteger(0x10E0000));
            alphaAdapter.setInterpolator((Interpolator)new DecelerateInterpolator());
            int pad = (int)UploadcareFilesFragment.convertDpToPixel(2.0f, (Context)this.getActivity());
            this.mRecyclerView.setPadding(pad, pad, pad, pad);
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)alphaAdapter);
        }
        this.mRecyclerViewOnScrollListener = new RecyclerViewOnScrollListener((RecyclerView.LayoutManager)layoutManager){

            @Override
            public void onLoadMore() {
                if (UploadcareFilesFragment.this.scroll) {
                    UploadcareFilesFragment.this.scroll = false;
                    UploadcareFilesFragment.this.getChunkData(true, null);
                }
            }
        };
        this.getChunkData(false, null);
        return rootView;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mSocialSource != null) {
            outState.putParcelable("socialsource", (Parcelable)this.mSocialSource);
        }
        if (this.mChunks != null) {
            outState.putParcelableArrayList("chunks", (ArrayList)this.mChunks);
        }
        outState.putInt("currentChunk", this.currentChunk);
        outState.putString("title", this.title);
        outState.putBoolean("root", this.rootFragment);
        outState.putBoolean("search", this.searchFragment);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.mOnFileActionsListener = (OnFileActionsListener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context.toString() + " must implement OnFileActionsListener");
        }
    }

    @Override
    public void itemTap(Thing thing) {
        switch (thing.objectType) {
            case "album": {
                if (thing.action.path == null || thing.action.path.chunks == null) break;
                this.mOnFileActionsListener.onChunkSelected(thing.action.path.chunks, thing.title);
                break;
            }
            case "photo": {
                if (!thing.action.action.equalsIgnoreCase("select_file")) break;
                this.mOnFileActionsListener.onFileSelected(thing.action.url);
                break;
            }
            case "folder": {
                if (thing.action.path == null || thing.action.path.chunks == null) break;
                this.mOnFileActionsListener.onChunkSelected(thing.action.path.chunks, thing.title);
                break;
            }
            case "file": {
                if (!thing.action.action.equalsIgnoreCase("select_file")) break;
                this.mOnFileActionsListener.onFileSelected(thing.action.url);
                break;
            }
            case "frined": {
                if (thing.action.path == null || thing.action.path.chunks == null) break;
                this.mOnFileActionsListener.onChunkSelected(thing.action.path.chunks, thing.title);
                break;
            }
            default: {
                Log.d((String)"UploadcareFilesActivity", (String)("itemTap: Unknown thing type:" + thing.objectType));
            }
        }
    }

    private void getChunkData(final boolean loadMore, String query) {
        this.mRecyclerView.clearOnScrollListeners();
        this.mEmptyView.setVisibility(8);
        if (!loadMore) {
            this.mFilesAdapter.clear();
            this.mCircularProgressBar.setVisibility(0);
        } else {
            this.mLoadingMoreView.setVisibility(0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (query != null) {
            stringBuilder.append(this.mSocialSource.rootChunks.get((int)this.mOnFileActionsListener.currentRootChunk()).pathChunk).append("/");
            stringBuilder.append("-").append("/").append(query);
        } else if (this.searchFragment && loadMore) {
            stringBuilder.append(this.mChunks.get((int)this.currentChunk).pathChunk);
        } else if (this.rootFragment) {
            stringBuilder.append(this.mChunks.get((int)this.currentChunk).pathChunk);
        } else {
            stringBuilder.append(this.mSocialSource.rootChunks.get((int)this.mOnFileActionsListener.currentRootChunk()).pathChunk).append("/");
            for (int i = 0; i < this.mChunks.size(); ++i) {
                if (i != this.mChunks.size() - 1) {
                    stringBuilder.append(this.mChunks.get((int)i).pathChunk).append("/");
                    continue;
                }
                stringBuilder.append(this.mChunks.get((int)i).pathChunk);
            }
        }
        UploadcareWidget.getInstance().getSocialApi().getSourceChunk(this.mSocialSource.getCookie((Context)this.getActivity()), this.mSocialSource.urls.sourceBase, stringBuilder.toString(), loadMore ? this.mFilesAdapter.getNext() : "", new Callback<ChunkResponse>(){

            public void success(ChunkResponse chunkResponse, Response response) {
                Log.d((String)"Files", (String)chunkResponse.toString());
                UploadcareFilesFragment.this.mLoadingMoreView.setVisibility(8);
                if (chunkResponse.error != null) {
                    UploadcareFilesFragment.this.mOnFileActionsListener.onAuthorizationNeeded(chunkResponse);
                } else {
                    if (!loadMore) {
                        UploadcareFilesFragment.this.mCircularProgressBar.setVisibility(8);
                        UploadcareFilesFragment.this.mFilesAdapter.updateImages(chunkResponse.things, chunkResponse.nextPage);
                    } else {
                        UploadcareFilesFragment.this.mFilesAdapter.addImages(chunkResponse.things, chunkResponse.nextPage);
                    }
                    UploadcareFilesFragment.this.scroll = chunkResponse.nextPage != null;
                    UploadcareFilesFragment.this.mRecyclerViewOnScrollListener.clear();
                    if (UploadcareFilesFragment.this.scroll) {
                        UploadcareFilesFragment.this.mRecyclerView.addOnScrollListener((RecyclerView.OnScrollListener)UploadcareFilesFragment.this.mRecyclerViewOnScrollListener);
                    }
                }
                if (chunkResponse.searchPath != null) {
                    UploadcareFilesFragment.this.mSearchView.setVisibility(0);
                    UploadcareFilesFragment.this.mSearchView.requestFocus();
                    UploadcareFilesFragment.this.searchFragment = true;
                } else if (UploadcareFilesFragment.this.mFilesAdapter.isEmpty()) {
                    UploadcareFilesFragment.this.mSearchView.setVisibility(8);
                    UploadcareFilesFragment.this.mEmptyView.setVisibility(0);
                } else {
                    UploadcareFilesFragment.this.mSearchView.setVisibility(8);
                }
            }

            public void failure(RetrofitError error) {
                UploadcareFilesFragment.this.mLoadingMoreView.setVisibility(8);
                UploadcareFilesFragment.this.mCircularProgressBar.setVisibility(8);
                UploadcareFilesFragment.this.mOnFileActionsListener.onError(error.getLocalizedMessage());
                if (UploadcareFilesFragment.this.mFilesAdapter.isEmpty()) {
                    UploadcareFilesFragment.this.mEmptyView.setVisibility(0);
                }
            }
        });
    }

    public void changeChunk(int position) {
        if (position == this.currentChunk) {
            return;
        }
        this.searchFragment = false;
        this.currentChunk = position;
        this.mSearchView.setVisibility(8);
        this.getChunkData(false, null);
    }

    public void refreshChunk() {
        this.getChunkData(false, null);
    }

    public List<Chunk> getChunks() {
        return this.mChunks;
    }

    public String getTitle() {
        return this.title;
    }

    public static float convertDpToPixel(float dp, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    public boolean onQueryTextSubmit(String query) {
        this.getChunkData(false, query);
        return false;
    }

    public boolean onQueryTextChange(String newText) {
        return false;
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.ucw_search_view) {
            this.mSearchView.requestFocus();
        }
    }

    public static interface OnFileActionsListener {
        public void onError(String var1);

        public void onFileSelected(String var1);

        public void onAuthorizationNeeded(ChunkResponse var1);

        public void onChunkSelected(List<Chunk> var1, String var2);

        public int currentRootChunk();
    }
}

