/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi.params.types.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateRange {
    public static final DateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
    public Date start;
    public Date end;

    static {
        df.setLenient(false);
    }

    public DateRange(String range) throws ParseException {
        this.process(range);
    }

    private void process(String data) throws ParseException {
        if (data == null) {
            this.start = null;
            this.end = null;
            return;
        }
        if (data.toLowerCase().startsWith("last ")) {
            int amount = 0;
            int field = 5;
            if (data.toLowerCase().endsWith(" days")) {
                amount = Integer.valueOf(data.substring(5, data.length() - 5));
                field = 5;
            } else if (data.toLowerCase().endsWith(" weeks")) {
                amount = Integer.valueOf(data.substring(5, data.length() - 6)) * 7;
                field = 5;
            } else if (data.toLowerCase().endsWith(" months")) {
                amount = Integer.valueOf(data.substring(5, data.length() - 7));
                field = 2;
            } else if (data.toLowerCase().endsWith(" years")) {
                amount = Integer.valueOf(data.substring(5, data.length() - 6));
                field = 1;
            } else {
                throw new ParseException("Cannot process 'last X timeframe'", 0);
            }
            Calendar now = Calendar.getInstance();
            now.add(field, -1 * amount);
            now.set(11, 0);
            now.set(12, 0);
            now.set(13, 0);
            now.set(14, 0);
            this.start = now.getTime();
        } else if (data.endsWith(" days")) {
            Calendar now = Calendar.getInstance();
            now.add(5, Integer.valueOf(data.substring(0, data.length() - 5)));
            now.set(11, 0);
            now.set(12, 0);
            now.set(13, 0);
            now.set(14, 0);
            this.start = now.getTime();
        } else if (data.endsWith(" weeks")) {
            Calendar now = Calendar.getInstance();
            now.add(5, Integer.valueOf(data.substring(0, data.length() - 6)) * 7);
            now.set(11, 0);
            now.set(12, 0);
            now.set(13, 0);
            now.set(14, 0);
            this.start = now.getTime();
        } else if (data.endsWith(" months")) {
            Calendar now = Calendar.getInstance();
            now.add(2, Integer.valueOf(data.substring(0, data.length() - 7)));
            now.set(11, 0);
            now.set(12, 0);
            now.set(13, 0);
            now.set(14, 0);
            this.start = now.getTime();
        } else if (data.endsWith(" years")) {
            Calendar now = Calendar.getInstance();
            now.add(1, Integer.valueOf(data.substring(0, data.length() - 6)));
            now.set(11, 0);
            now.set(12, 0);
            now.set(13, 0);
            now.set(14, 0);
            this.start = now.getTime();
        } else if (data.indexOf("=>") > -1) {
            int rangeIdx = data.indexOf("=>");
            this.start = this.getDate(data.substring(0, rangeIdx), true);
            this.end = this.getDate(data.substring(rangeIdx + 2), false);
        } else if (data.startsWith(">")) {
            this.start = this.getDate(data.substring(1), false);
        } else if (data.startsWith("<")) {
            this.end = this.getDate(data.substring(1), true);
        } else {
            this.start = this.getDate(data, true);
            this.end = this.getDate(data, false);
        }
    }

    public static String fixDate(String date, boolean lowMode) throws ParseException {
        if (date.length() < 14) {
            int dateLen = date.length();
            if (dateLen < 4 || dateLen % 2 == 1) {
                throw new ParseException("Cannot process date - invalid length! (must be at least 4 chars and even)", dateLen);
            }
            StringBuffer fix = new StringBuffer();
            fix.append(date);
            if (lowMode) {
                if (fix.length() == 4) {
                    fix.append("01");
                }
                if (fix.length() == 6) {
                    fix.append("01");
                }
                while (fix.length() < 14) {
                    fix.append("0");
                }
            } else {
                if (fix.length() == 4) {
                    fix.append("12");
                }
                if (fix.length() == 6) {
                    int month = Integer.valueOf(fix.substring(4, 6));
                    int append = 31;
                    if (month % 2 == 0) {
                        append = 30;
                    }
                    if (month == 2) {
                        append = 28;
                    }
                    fix.append(append);
                }
                if (fix.length() == 8) {
                    fix.append("23");
                }
                if (fix.length() == 10) {
                    fix.append("59");
                }
                if (fix.length() == 12) {
                    fix.append("59");
                }
            }
            date = fix.toString();
        }
        return date;
    }

    public Date getDate(String date, boolean lowMode) throws ParseException {
        if (date == null) {
            return null;
        }
        date = DateRange.fixDate(date, lowMode);
        return df.parse(date);
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }
}

