/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi.params.types;

import com.untzuntz.ustackserverapi.APIException;
import com.untzuntz.ustackserverapi.params.exceptions.ParamValueException;
import com.untzuntz.ustackserverapi.params.types.BaseParam;
import com.untzuntz.ustackserverapi.params.types.ParameterDefinitionInt;
import java.net.MalformedURLException;
import java.net.URL;

public class URLParam
extends BaseParam
implements ParameterDefinitionInt<URL> {
    private String forceType;

    public URLParam(String n, String d) {
        super(n, d);
    }

    public URLParam(String n, String d, String forceType) {
        super(n, d);
        this.forceType = forceType;
    }

    @Override
    public String getTypeDescription() {
        return "A string of text in the format of a uniform resource locator (ex: http://google.com/hello)";
    }

    @Override
    public void validate(String data) throws APIException {
        try {
            new URL(data);
        }
        catch (MalformedURLException mue) {
            throw new ParamValueException(this, "Provided value must be a valid URL in the format of: protocol://host:port/path");
        }
        if (this.forceType != null && data != null && !data.startsWith(this.forceType)) {
            throw new ParamValueException(this, "Invalid URL type, must be start with '" + this.forceType + "'");
        }
    }

    @Override
    public URL getValue(String data) {
        try {
            return new URL(data);
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }
}

