/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi.params.types;

import com.untzuntz.ustackserverapi.APIException;
import com.untzuntz.ustackserverapi.params.exceptions.ParamValueException;
import com.untzuntz.ustackserverapi.params.types.BaseParam;
import com.untzuntz.ustackserverapi.params.types.ParameterDefinitionInt;

public class StringParam
extends BaseParam
implements ParameterDefinitionInt<String> {
    private Integer minLen;
    private Integer maxLen;

    public StringParam(String n, String d) {
        super(n, d);
    }

    public StringParam(String n, String d, Integer minLen, Integer maxLen) {
        super(n, d);
        this.minLen = minLen;
        this.maxLen = maxLen;
    }

    public StringParam(String n, String d, Integer minLen) {
        super(n, d);
        this.minLen = minLen;
    }

    @Override
    public String getTypeDescription() {
        String msg = "";
        if (this.minLen != null && this.maxLen == null) {
            msg = " at least " + this.minLen + " chars long";
        } else if (this.minLen == null && this.maxLen != null) {
            msg = " at max " + this.minLen + " chars long";
        } else if (this.minLen != null && this.maxLen != null) {
            msg = " between " + this.minLen + " and " + this.maxLen + " chars long";
        }
        return "A string of text" + msg;
    }

    public Integer getMinLen() {
        return this.minLen;
    }

    public void setMinLen(Integer minLen) {
        this.minLen = minLen;
    }

    public Integer getMaxLen() {
        return this.maxLen;
    }

    public void setMaxLen(Integer maxLen) {
        this.maxLen = maxLen;
    }

    @Override
    public void validate(String data) throws APIException {
        if (data == null && this.minLen != null) {
            throw new ParamValueException(this, "String must be at least " + this.minLen + " characters");
        }
        if (this.minLen != null && data.length() < this.minLen) {
            throw new ParamValueException(this, "String must be at least " + this.minLen + " characters");
        }
        if (this.maxLen != null && data.length() > this.maxLen) {
            throw new ParamValueException(this, "String cannot exceed " + this.maxLen + " characters");
        }
    }

    @Override
    public String getValue(String data) {
        if (this.maxLen != null && data != null && data.length() > this.maxLen) {
            data = data.substring(0, this.maxLen);
        }
        return data;
    }
}

