/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi.params.types;

import com.untzuntz.ustackserverapi.APIException;
import com.untzuntz.ustackserverapi.params.exceptions.ParamValueException;
import com.untzuntz.ustackserverapi.params.types.BaseParam;
import com.untzuntz.ustackserverapi.params.types.ParameterDefinitionInt;

public class StringArrayParam
extends BaseParam
implements ParameterDefinitionInt<String[]> {
    private Integer minSize;
    private Integer maxSize;

    public StringArrayParam(String n, String d) {
        super(n, d);
    }

    public StringArrayParam(String n, String d, Integer minSize, Integer maxSize) {
        super(n, d);
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    public StringArrayParam(String n, String d, Integer minSize) {
        super(n, d);
        this.minSize = minSize;
    }

    @Override
    public String getTypeDescription() {
        String msg = "";
        if (this.minSize != null && this.maxSize == null) {
            msg = " at least " + this.minSize + " items";
        } else if (this.minSize == null && this.maxSize != null) {
            msg = " at max " + this.minSize + " items";
        } else if (this.minSize != null && this.maxSize != null) {
            msg = " between " + this.minSize + " and " + this.maxSize + " items";
        }
        return "A string array of text separated by commas" + msg + " (example: item1,item2";
    }

    @Override
    public void validate(String data) throws APIException {
        if (data == null && this.minSize != null) {
            throw new ParamValueException(this, "String array must have at least " + this.minSize + " items");
        }
        String[] ret = data.split(",");
        if (this.minSize != null && ret.length < this.minSize) {
            throw new ParamValueException(this, "String array must have at least " + this.minSize + " items");
        }
        if (this.maxSize != null && ret.length > this.maxSize) {
            throw new ParamValueException(this, "String array cannot have more than " + this.maxSize + " items");
        }
    }

    @Override
    public String[] getValue(String data) {
        if (data == null) {
            return null;
        }
        String[] ret = data.split(",");
        if (this.maxSize != null && ret.length > this.maxSize) {
            return null;
        }
        return ret;
    }
}

