/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi.params.types;

import com.untzuntz.ustackserverapi.APIException;
import com.untzuntz.ustackserverapi.params.exceptions.ParamValueException;
import com.untzuntz.ustackserverapi.params.types.BaseParam;
import com.untzuntz.ustackserverapi.params.types.ParameterDefinitionInt;

public class RegexParam
extends BaseParam
implements ParameterDefinitionInt<String> {
    private String regex;
    private boolean required;

    public RegexParam(String n, String d) {
        super(n, d);
    }

    public RegexParam(String n, String d, String regex, boolean required) {
        super(n, d);
        this.regex = regex;
        this.required = required;
    }

    @Override
    public String getTypeDescription() {
        return String.format("A string of text matching the regex '%s'", this.regex);
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    @Override
    public void validate(String data) throws APIException {
        if (data == null && this.required) {
            throw new ParamValueException(this, "This parameter must have a value");
        }
        if (data != null && !data.matches(this.regex)) {
            throw new ParamValueException(this, String.format("This parameter does not match the required regex '%s'", this.regex));
        }
    }

    @Override
    public String getValue(String data) {
        if (data != null && data.matches(this.regex)) {
            return data;
        }
        return null;
    }
}

