/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi.params.types;

import com.untzuntz.ustackserverapi.APIException;
import com.untzuntz.ustackserverapi.params.exceptions.ParamValueException;
import com.untzuntz.ustackserverapi.params.types.BaseParam;
import com.untzuntz.ustackserverapi.params.types.ParameterDefinitionInt;

public class LongParam
extends BaseParam
implements ParameterDefinitionInt<Long> {
    private Long minVal;
    private Long maxVal;

    public LongParam(String n, String d, Long minVal, Long maxVal) {
        super(n, d);
        this.minVal = minVal;
        this.maxVal = maxVal;
    }

    public LongParam(String n, String d, Long maxVal) {
        super(n, d);
        this.maxVal = maxVal;
    }

    @Override
    public String getTypeDescription() {
        String mv = "" + this.minVal;
        if (this.minVal == null) {
            mv = "-2^63";
        }
        String mxv = "" + this.maxVal;
        if (this.maxVal == null) {
            mxv = "2^63";
        }
        return "A number between " + mv + " and " + mxv;
    }

    public Long getMinVal() {
        return this.minVal;
    }

    public void setMinVal(Long minVal) {
        this.minVal = minVal;
    }

    public Long getMaxVal() {
        return this.maxVal;
    }

    public void setMaxVal(Long maxVal) {
        this.maxVal = maxVal;
    }

    @Override
    public void validate(String data) throws APIException {
        if (data == null && this.minVal != null) {
            throw new ParamValueException(this, "Long must be greater than " + this.minVal);
        }
        long intVal = -1L;
        try {
            intVal = Long.valueOf(data);
        }
        catch (NumberFormatException nfe) {
            throw new ParamValueException(this, "Field must have a valid value");
        }
        if (this.minVal != null && intVal < this.minVal) {
            throw new ParamValueException(this, "Long must be greater than " + this.minVal);
        }
        if (this.maxVal != null && intVal > this.maxVal) {
            throw new ParamValueException(this, "Long must be less than " + this.maxVal);
        }
    }

    @Override
    public Long getValue(String data) {
        try {
            long ret = Long.valueOf(data);
            if (this.minVal != null && ret < this.minVal) {
                ret = this.minVal;
            }
            if (this.maxVal != null && ret > this.maxVal) {
                ret = this.maxVal;
            }
            return ret;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }
}

