/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi.params.types;

import com.untzuntz.ustackserverapi.APIException;
import com.untzuntz.ustackserverapi.params.exceptions.ParamValueException;
import com.untzuntz.ustackserverapi.params.types.BaseParam;
import com.untzuntz.ustackserverapi.params.types.ParameterDefinitionInt;
import java.util.ArrayList;

public class LongArrayParam
extends BaseParam
implements ParameterDefinitionInt<Long[]> {
    private Integer minSize;
    private Integer maxSize;

    public LongArrayParam(String n, String d) {
        super(n, d);
    }

    public LongArrayParam(String n, String d, Integer minSize, Integer maxSize) {
        super(n, d);
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    public LongArrayParam(String n, String d, Integer minSize) {
        super(n, d);
        this.minSize = minSize;
    }

    @Override
    public String getTypeDescription() {
        String msg = "";
        if (this.minSize != null && this.maxSize == null) {
            msg = " at least " + this.minSize + " items";
        } else if (this.minSize == null && this.maxSize != null) {
            msg = " at max " + this.minSize + " items";
        } else if (this.minSize != null && this.maxSize != null) {
            msg = " between " + this.minSize + " and " + this.maxSize + " items";
        }
        return "A Long array of text separated by commas" + msg + " (example: 124,444)";
    }

    @Override
    public void validate(String data) throws APIException {
        if (data == null && this.minSize != null) {
            throw new ParamValueException(this, "Long array must have at least " + this.minSize + " items");
        }
        if (data == null) {
            throw new ParamValueException(this, "The Long array has no value");
        }
        Long[] ret = this.getLongs(data.split(","));
        if (this.minSize != null && ret.length < this.minSize) {
            throw new ParamValueException(this, "Long array must have at least " + this.minSize + " items");
        }
        if (this.maxSize != null && ret.length > this.maxSize) {
            throw new ParamValueException(this, "Long array cannot have more than " + this.maxSize + " items");
        }
    }

    @Override
    public Long[] getValue(String data) {
        if (data == null) {
            return null;
        }
        Long[] ret = this.getLongs(data.split(","));
        if (this.maxSize != null && ret.length > this.maxSize) {
            return null;
        }
        return ret;
    }

    private Long[] getLongs(String[] vals) {
        ArrayList<Long> ret = new ArrayList<Long>();
        String[] stringArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            try {
                ret.add(Long.valueOf(val.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
        Long[] retArray = new Long[ret.size()];
        return ret.toArray(retArray);
    }
}

