/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi.params.types;

import com.untzuntz.ustackserverapi.APIException;
import com.untzuntz.ustackserverapi.params.exceptions.ParamValueException;
import com.untzuntz.ustackserverapi.params.types.BaseParam;
import com.untzuntz.ustackserverapi.params.types.ParameterDefinitionInt;

public class IntParam
extends BaseParam
implements ParameterDefinitionInt<Integer> {
    private Integer minVal;
    private Integer maxVal;

    public IntParam(String n, String d) {
        super(n, d);
    }

    public IntParam(String n, String d, Integer minVal, Integer maxVal) {
        super(n, d);
        this.minVal = minVal;
        this.maxVal = maxVal;
    }

    public IntParam(String n, String d, Integer maxVal) {
        super(n, d);
        this.maxVal = maxVal;
    }

    @Override
    public String getTypeDescription() {
        String mv = "" + this.minVal;
        if (this.minVal == null) {
            mv = "-2^31";
        }
        String mxv = "" + this.maxVal;
        if (this.maxVal == null) {
            mxv = "2^31";
        }
        return "A number between " + mv + " and " + mxv;
    }

    public Integer getMinVal() {
        return this.minVal;
    }

    public void setMinVal(Integer minVal) {
        this.minVal = minVal;
    }

    public Integer getMaxVal() {
        return this.maxVal;
    }

    public void setMaxVal(Integer maxVal) {
        this.maxVal = maxVal;
    }

    @Override
    public void validate(String data) throws APIException {
        if (data == null && this.minVal != null) {
            throw new ParamValueException(this, "Integer must be greater than " + this.minVal);
        }
        int intVal = -1;
        try {
            intVal = Integer.valueOf(data);
        }
        catch (NumberFormatException nfe) {
            throw new ParamValueException(this, "Field must have a valid value");
        }
        if (this.minVal != null && intVal < this.minVal) {
            throw new ParamValueException(this, "Integer must be greater than " + this.minVal);
        }
        if (this.maxVal != null && intVal > this.maxVal) {
            throw new ParamValueException(this, "Integer must be less than " + this.maxVal);
        }
    }

    @Override
    public Integer getValue(String data) {
        try {
            int ret = Integer.valueOf(data);
            if (this.minVal != null && ret < this.minVal) {
                ret = this.minVal;
            }
            if (this.maxVal != null && ret > this.maxVal) {
                ret = this.maxVal;
            }
            return ret;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }
}

