/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi.params.types;

import com.untzuntz.ustackserverapi.APIException;
import com.untzuntz.ustackserverapi.params.exceptions.ParamValueException;
import com.untzuntz.ustackserverapi.params.types.BaseParam;
import com.untzuntz.ustackserverapi.params.types.ParameterDefinitionInt;

public class FloatParam
extends BaseParam
implements ParameterDefinitionInt<Float> {
    private Float minVal;
    private Float maxVal;

    public FloatParam(String n, String d, Float minVal, Float maxVal) {
        super(n, d);
        this.minVal = minVal;
        this.maxVal = maxVal;
    }

    public FloatParam(String n, String d, Float maxVal) {
        super(n, d);
        this.maxVal = maxVal;
    }

    @Override
    public String getTypeDescription() {
        String mv = "" + this.minVal;
        if (this.minVal == null) {
            mv = "-2^63";
        }
        String mxv = "" + this.maxVal;
        if (this.maxVal == null) {
            mxv = "2^63";
        }
        return "A number between " + mv + " and " + mxv;
    }

    public Float getMinVal() {
        return this.minVal;
    }

    public void setMinVal(Float minVal) {
        this.minVal = minVal;
    }

    public Float getMaxVal() {
        return this.maxVal;
    }

    public void setMaxVal(Float maxVal) {
        this.maxVal = maxVal;
    }

    @Override
    public void validate(String data) throws APIException {
        if (data == null && this.minVal != null) {
            throw new ParamValueException(this, "Float must be greater than " + this.minVal);
        }
        Float intVal = Float.valueOf(-1.0f);
        try {
            intVal = Float.valueOf(data);
        }
        catch (NumberFormatException nfe) {
            throw new ParamValueException(this, "Field must have a valid value");
        }
        if (this.minVal != null && intVal.floatValue() < this.minVal.floatValue()) {
            throw new ParamValueException(this, "Float must be greater than " + this.minVal);
        }
        if (this.maxVal != null && intVal.floatValue() > this.maxVal.floatValue()) {
            throw new ParamValueException(this, "Float must be less than " + this.maxVal);
        }
    }

    @Override
    public Float getValue(String data) {
        if (data == null) {
            return null;
        }
        try {
            Float ret = Float.valueOf(data);
            if (this.minVal != null && ret.floatValue() < this.minVal.floatValue()) {
                ret = this.minVal;
            }
            if (this.maxVal != null && ret.floatValue() > this.maxVal.floatValue()) {
                ret = this.maxVal;
            }
            return ret;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }
}

