/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi.params.types;

import com.untzuntz.ustackserverapi.APIException;
import com.untzuntz.ustackserverapi.params.exceptions.ParamValueException;
import com.untzuntz.ustackserverapi.params.types.BaseParam;
import com.untzuntz.ustackserverapi.params.types.ParameterDefinitionInt;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class EmailParam
extends BaseParam
implements ParameterDefinitionInt<InternetAddress> {
    private final String regex = "^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$";
    private boolean required;

    public EmailParam(String n, String d) {
        super(n, d);
    }

    public EmailParam(String n, String d, boolean required) {
        super(n, d);
        this.required = required;
    }

    @Override
    public String getTypeDescription() {
        return "A valid email address";
    }

    @Override
    public void validate(String data) throws APIException {
        if (data == null && this.required) {
            throw new ParamValueException(this, "This parameter must have a value");
        }
        if (data != null && !data.matches("^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$")) {
            throw new ParamValueException(this, "This parameter must be an email address (ex: a@b.com)");
        }
    }

    @Override
    public InternetAddress getValue(String data) {
        if (data != null && data.matches("^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$")) {
            try {
                return new InternetAddress(data);
            }
            catch (AddressException addressException) {
                // empty catch block
            }
        }
        return null;
    }
}

