/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi.params.types;

import com.untzuntz.ustackserverapi.APIException;
import com.untzuntz.ustackserverapi.params.exceptions.ParamValueException;
import com.untzuntz.ustackserverapi.params.types.BaseParam;
import com.untzuntz.ustackserverapi.params.types.ParameterDefinitionInt;

public class DoubleParam
extends BaseParam
implements ParameterDefinitionInt<Double> {
    private Double minVal;
    private Double maxVal;

    public DoubleParam(String n, String d, Double minVal, Double maxVal) {
        super(n, d);
        this.minVal = minVal;
        this.maxVal = maxVal;
    }

    public DoubleParam(String n, String d, Double maxVal) {
        super(n, d);
        this.maxVal = maxVal;
    }

    @Override
    public String getTypeDescription() {
        String mv = "" + this.minVal;
        if (this.minVal == null) {
            mv = "-2^63";
        }
        String mxv = "" + this.maxVal;
        if (this.maxVal == null) {
            mxv = "2^63";
        }
        return "A number between " + mv + " and " + mxv;
    }

    public Double getMinVal() {
        return this.minVal;
    }

    public void setMinVal(Double minVal) {
        this.minVal = minVal;
    }

    public Double getMaxVal() {
        return this.maxVal;
    }

    public void setMaxVal(Double maxVal) {
        this.maxVal = maxVal;
    }

    @Override
    public void validate(String data) throws APIException {
        if (data == null && this.minVal != null) {
            throw new ParamValueException(this, "Double must be greater than " + this.minVal);
        }
        double intVal = -1.0;
        try {
            intVal = Double.valueOf(data);
        }
        catch (NumberFormatException nfe) {
            throw new ParamValueException(this, "Field must have a valid value");
        }
        if (this.minVal != null && intVal < this.minVal) {
            throw new ParamValueException(this, "Double must be greater than " + this.minVal);
        }
        if (this.maxVal != null && intVal > this.maxVal) {
            throw new ParamValueException(this, "Double must be less than " + this.maxVal);
        }
    }

    @Override
    public Double getValue(String data) {
        if (data == null) {
            return null;
        }
        try {
            double ret = Double.valueOf(data);
            if (this.minVal != null && ret < this.minVal) {
                ret = this.minVal;
            }
            if (this.maxVal != null && ret > this.maxVal) {
                ret = this.maxVal;
            }
            return ret;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }
}

