/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi.auth;

import com.untzuntz.ustack.aaa.Authentication;
import com.untzuntz.ustack.aaa.Authorization;
import com.untzuntz.ustack.aaa.UStackPermissionEnum;
import com.untzuntz.ustack.data.UserAccount;
import com.untzuntz.ustack.exceptions.AuthenticationException;
import com.untzuntz.ustack.exceptions.AuthorizationException;
import com.untzuntz.ustackserverapi.APIException;
import com.untzuntz.ustackserverapi.CallParameters;
import com.untzuntz.ustackserverapi.MethodDefinition;
import com.untzuntz.ustackserverapi.auth.APIAuthenticationException;
import com.untzuntz.ustackserverapi.auth.APIAuthorizationException;
import com.untzuntz.ustackserverapi.auth.AuthenticationInt;
import com.untzuntz.ustackserverapi.params.ParamNames;
import com.untzuntz.ustackserverapi.params.types.ParameterDefinitionInt;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.handler.codec.http.HttpRequest;

public class UserNamePasswordAuth
implements AuthenticationInt<UserAccount> {
    @Override
    public String getAuthenticationDescription() {
        return "Username and password combo (in request parameters) required.";
    }

    @Override
    public boolean isBasicAuth() {
        return false;
    }

    @Override
    public List<ParameterDefinitionInt<?>> getAuthenticationParameters() {
        ArrayList ret = new ArrayList();
        ret.add(ParamNames.username);
        ret.add(ParamNames.password);
        return ret;
    }

    @Override
    public UserAccount authenticate(MethodDefinition method, HttpRequest req, CallParameters params) throws APIException {
        UserAccount user = null;
        try {
            user = Authentication.authenticateUser((String)params.get(ParamNames.username), (String)params.get(ParamNames.password));
        }
        catch (AuthenticationException e) {
            throw new APIAuthenticationException(e.getMessage());
        }
        if (method.getAuthenticationGroup() != null) {
            try {
                Authorization.authorizeUser((UserAccount)user, (String)"*", null, (UStackPermissionEnum)method.getAuthenticationGroup());
            }
            catch (AuthorizationException e) {
                throw new APIAuthorizationException("Not Authorized");
            }
        }
        return user;
    }
}

