/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi.auth;

import com.untzuntz.ustack.data.AccessToken;
import com.untzuntz.ustack.data.UserAccount;
import com.untzuntz.ustackserverapi.APIException;
import com.untzuntz.ustackserverapi.CallParameters;
import com.untzuntz.ustackserverapi.MethodDefinition;
import com.untzuntz.ustackserverapi.auth.APIAuthenticationException;
import com.untzuntz.ustackserverapi.auth.AuthenticationInt;
import com.untzuntz.ustackserverapi.params.ParamNames;
import com.untzuntz.ustackserverapi.params.types.ParameterDefinitionInt;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpRequest;

public class AccessTokenAuth
implements AuthenticationInt<UserAccount> {
    static Logger logger = Logger.getLogger(AccessTokenAuth.class);

    @Override
    public String getAuthenticationDescription() {
        return "Access token in request parameters required.";
    }

    @Override
    public boolean isBasicAuth() {
        return false;
    }

    @Override
    public List<ParameterDefinitionInt<?>> getAuthenticationParameters() {
        ArrayList ret = new ArrayList();
        ret.add(ParamNames.token);
        return ret;
    }

    @Override
    public UserAccount authenticate(MethodDefinition method, HttpRequest req, CallParameters params) throws APIException {
        AccessToken.AccessTokenDetails details = AccessToken.decode((String)params.get(ParamNames.token));
        if (details == null) {
            logger.warn((Object)String.format("Invalid Token => '%s'", params.get(ParamNames.token)));
            throw new APIAuthenticationException("Invalid Token");
        }
        if (details.expirationAge < System.currentTimeMillis()) {
            throw new APIAuthenticationException("Token has expired");
        }
        params.setParameterValue(ParamNames.client_id.getName(), details.clientId);
        return UserAccount.getUser((String)details.userName);
    }
}

