/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi.auth;

import com.untzuntz.ustack.data.APIMapping;
import com.untzuntz.ustack.data.UserAccount;
import com.untzuntz.ustackserverapi.APIException;
import com.untzuntz.ustackserverapi.CallParameters;
import com.untzuntz.ustackserverapi.MethodDefinition;
import com.untzuntz.ustackserverapi.auth.APIAuthenticationException;
import com.untzuntz.ustackserverapi.auth.APIAuthorizationException;
import com.untzuntz.ustackserverapi.auth.APIClientKeyAuth;
import com.untzuntz.ustackserverapi.auth.AuthTypes;
import com.untzuntz.ustackserverapi.auth.AuthenticationInt;
import com.untzuntz.ustackserverapi.params.ParamNames;
import com.untzuntz.ustackserverapi.params.types.ParameterDefinitionInt;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpRequest;

public class APIClientKeyTokenSecretAuth
implements AuthenticationInt<UserAccount> {
    static Logger logger = Logger.getLogger(APIClientKeyAuth.class);

    @Override
    public String getAuthenticationDescription() {
        return "Your client ID/API Key via HTTP Basic Authentication and a user identifier and secret (in request parameters) required.";
    }

    @Override
    public boolean isBasicAuth() {
        return true;
    }

    @Override
    public List<ParameterDefinitionInt<?>> getAuthenticationParameters() {
        List<ParameterDefinitionInt<?>> ret = AuthTypes.ClientKey.getAuthenticationParameters();
        ret.add(ParamNames.user_identifier);
        ret.add(ParamNames.secret);
        return ret;
    }

    @Override
    public UserAccount authenticate(MethodDefinition method, HttpRequest req, CallParameters params) throws APIException {
        AuthTypes.ClientKey.authenticate(method, req, params);
        if (params.get(ParamNames.user_identifier) == null) {
            throw new APIAuthorizationException("Missing User Idenfitier Value");
        }
        UserAccount user = UserAccount.getByAPIToken((String)params.get(ParamNames.client_id), (String)params.get(ParamNames.user_identifier));
        if (user == null) {
            throw new APIAuthorizationException("Invalid User Idenfitier Value");
        }
        APIMapping api = user.getAPIMapping(params.get(ParamNames.client_id));
        if (!api.checkAPIKey(params.get(ParamNames.secret))) {
            throw new APIAuthenticationException("Bad Token/Secret");
        }
        return user;
    }
}

