/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi;

import com.untzuntz.ustack.aaa.UStackPermissionEnum;
import com.untzuntz.ustackserverapi.APIException;
import com.untzuntz.ustackserverapi.CallParameters;
import com.untzuntz.ustackserverapi.auth.AuthenticationInt;
import com.untzuntz.ustackserverapi.auth.AuthorizationInt;
import com.untzuntz.ustackserverapi.params.APICallParam;
import com.untzuntz.ustackserverapi.params.Validated;
import com.untzuntz.ustackserverapi.params.types.ParameterDefinitionInt;
import com.untzuntz.ustackserverapi.version.VersionInt;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;

public class MethodDefinition {
    static Logger logger = Logger.getLogger(MethodDefinition.class);
    public static final int HASH_ENFORCEMENT_NONE = 0;
    public static final int HASH_ENFORCEMENT_WARN = 1;
    public static final int HASH_ENFORCEMENT_REJECT = 2;
    private String path;
    private boolean methodGET;
    private boolean methodPOST;
    private boolean methodPUT;
    private boolean methodDELETE;
    private AuthenticationInt authMethod;
    private Class apiClass;
    private HashMap<String, Object> data;
    private String methodName;
    private String description;
    private VersionInt sinceVersion;
    private List<Object> paramVal;
    private List<ParameterDefinitionInt<?>> variesParams;
    private int order;
    private String overrideResponse;
    private String hashKey;
    private String docGroup;
    private int hashEnforcementLevel;
    private List<APICallParam> apiParams;
    private List<AuthorizationInt> authorizationMethods;
    private HashMap<Class, Object> objectInstances;
    private HashMap<String, Method> methodInstances;
    private boolean allowNoClientVer;
    private UStackPermissionEnum authenticationGroup;
    private String extraInfo;
    private String sampleHttpMethod;
    private String sampleCall;
    private String sampleResponse;

    public String getDocumentationGroup() {
        return this.docGroup;
    }

    public MethodDefinition setDocumentationGroup(String dg) {
        this.docGroup = dg;
        return this;
    }

    public List<Object> getParameterValidation() {
        return this.paramVal;
    }

    public boolean isClientVerCheckDisabled() {
        return this.allowNoClientVer;
    }

    public MethodDefinition disableClientVerCheck() {
        this.allowNoClientVer = true;
        return this;
    }

    public MethodDefinition(String path, Class apiClass, String methodName) {
        this.path = path;
        this.apiClass = apiClass;
        this.methodName = methodName;
        this.apiParams = new ArrayList<APICallParam>();
        this.data = new HashMap();
        this.objectInstances = new HashMap();
        this.methodInstances = new HashMap();
        this.paramVal = new ArrayList<Object>();
        this.variesParams = new ArrayList();
        this.authorizationMethods = new ArrayList<AuthorizationInt>();
        this.order = 1000;
    }

    public void setHashKey(int hashEnforcementLevel, String hashKey) {
        this.setHashKey(hashKey);
        this.setHashEnforcement(hashEnforcementLevel);
    }

    public String getHashKey() {
        return this.hashKey;
    }

    public void setHashKey(String k) {
        this.hashKey = k;
    }

    public int getHashEnforcement() {
        return this.hashEnforcementLevel;
    }

    public void setHashEnforcement(int l) {
        this.hashEnforcementLevel = l;
    }

    public void overrideDocumentationResponse(String or) {
        this.overrideResponse = or;
    }

    public String getOverrideDocumentationResponse() {
        return this.overrideResponse;
    }

    public void setSinceVersion(VersionInt v) {
        this.sinceVersion = v;
    }

    public VersionInt getSinceVersion() {
        return this.sinceVersion;
    }

    public void setOrder(int o) {
        this.order = o;
    }

    public int getOrder() {
        return this.order;
    }

    public List<APICallParam> getAPIParameters() {
        return this.apiParams;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setData(String name, Object o) {
        if (name == null) {
            return;
        }
        if (o == null) {
            this.data.remove(name);
        } else {
            this.data.put(name, o);
        }
    }

    public Object getData(String name) {
        if (name == null) {
            return null;
        }
        return this.data.get(name);
    }

    public String getPath() {
        return this.path;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public MethodDefinition authenticationMethod(AuthenticationInt b) {
        this.authMethod = b;
        return this;
    }

    public List<AuthorizationInt> getAuthorizationMethods() {
        return this.authorizationMethods;
    }

    public MethodDefinition addAuthorizationMethod(AuthorizationInt a) {
        this.authorizationMethods.add(a);
        return this;
    }

    public MethodDefinition enableGET(boolean b) {
        this.methodGET = b;
        return this;
    }

    public MethodDefinition enablePOST(boolean b) {
        this.methodPOST = b;
        return this;
    }

    public MethodDefinition enablePUT(boolean b) {
        this.methodPUT = b;
        return this;
    }

    public MethodDefinition enableDELETE(boolean b) {
        this.methodDELETE = b;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAuthenticationRequired() {
        return this.authMethod != null;
    }

    public AuthenticationInt<?> getAuthenticationMethod() {
        return this.authMethod;
    }

    public boolean isAuthorizationRequired() {
        return this.authorizationMethods.size() > 0;
    }

    public void authenticationGroup(UStackPermissionEnum ag) {
        this.authenticationGroup = ag;
    }

    public UStackPermissionEnum getAuthenticationGroup() {
        return this.authenticationGroup;
    }

    public boolean isMethodGET() {
        return this.methodGET;
    }

    public boolean isMethodPOST() {
        return this.methodPOST;
    }

    public boolean isMethodPUT() {
        return this.methodPUT;
    }

    public boolean isMethodDELETE() {
        return this.methodDELETE;
    }

    public boolean isMethodEnabled(HttpMethod method) {
        if (method == HttpMethod.DELETE && !this.methodDELETE) {
            return false;
        }
        if (method == HttpMethod.PUT && !this.methodPUT) {
            return false;
        }
        if (method == HttpMethod.POST && !this.methodPOST) {
            return false;
        }
        return method != HttpMethod.GET || this.methodGET;
    }

    public void addRequiredParam(Validated val) {
        this.paramVal.add(val);
    }

    public void addRequiredParam(ParameterDefinitionInt val) {
        this.paramVal.add(val);
    }

    public void addVariesParam(ParameterDefinitionInt val) {
        this.variesParams.add(val);
    }

    public void addVariesParams(List<ParameterDefinitionInt<?>> vals) {
        this.variesParams.addAll(vals);
    }

    public List<ParameterDefinitionInt<?>> getVariesParams() {
        return this.variesParams;
    }

    public void validateCall(CallParameters callParams) throws APIException {
        for (Object val : this.paramVal) {
            if (val instanceof Validated) {
                ((Validated)val).validate(callParams);
                continue;
            }
            if (val instanceof ParameterDefinitionInt) {
                this.getParamter((ParameterDefinitionInt)val).validate(callParams);
                continue;
            }
            if (val instanceof APICallParam) {
                this.getParamter(((APICallParam)val).getParamDetails()).validate(callParams);
                continue;
            }
            logger.warn((Object)("Unknown Parameter Validation Type: " + val));
        }
        for (APICallParam param : this.apiParams) {
            if (param.defaultValue == null || callParams.getParameter(param.getParamDetails().getName()) != null) continue;
            callParams.setParameterValue(param.getParamDetails().getName(), param.defaultValue);
        }
    }

    public void handleCall(Channel channel, HttpRequest req, CallParameters callParams) throws Exception {
        Object apiInt = this.objectInstances.get(this.apiClass);
        Method m = this.methodInstances.get(this.methodName);
        if (m == null) {
            if (apiInt == null) {
                apiInt = this.apiClass.newInstance();
                this.objectInstances.put(this.apiClass, apiInt);
            }
            Class[] partypes = new Class[]{MethodDefinition.class, Channel.class, HttpRequest.class, CallParameters.class};
            m = this.apiClass.getMethod(this.methodName, partypes);
            this.methodInstances.put(this.methodName, m);
        }
        Object[] arglist = new Object[]{this, channel, req, callParams};
        channel.setAttachment((Object)new Long(System.currentTimeMillis()));
        m.invoke(apiInt, arglist);
    }

    public APICallParam getParamter(ParameterDefinitionInt param) {
        for (APICallParam call : this.apiParams) {
            if (!call.getParamDetails().equals(param)) continue;
            return call;
        }
        return null;
    }

    public void addParameter(APICallParam param) {
        this.apiParams.add(param);
    }

    public void addParameter(APICallParam param, boolean required) {
        this.apiParams.add(param);
        if (required) {
            this.addRequiredParam(param);
        }
    }

    public void setExtraInfo(String extra) {
        this.extraInfo = extra;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public void setSampleCall(String httpMethod, String call) {
        this.sampleHttpMethod = httpMethod;
        this.sampleCall = call;
    }

    public void setSampleResponse(String r) {
        this.sampleResponse = r;
    }

    public String getSampleHttpMethod() {
        return this.sampleHttpMethod;
    }

    public String getSampleCall() {
        return this.sampleCall;
    }

    public String getSampleResponse() {
        return this.sampleResponse;
    }
}

