/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.untzuntz.ustackserverapi.auth.AuthenticationInt;
import com.untzuntz.ustackserverapi.params.types.ParameterDefinitionInt;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;

public class CallParameters {
    static Logger logger = Logger.getLogger(CallParameters.class);
    private QueryStringDecoder qsd;
    private String path;
    private Map<String, List<String>> qsdMap;
    private static final String UTF8_CHARSET = "UTF-8";
    private static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";
    private static final Hashtable<String, Mac> keys = new Hashtable();
    private Object authObject;

    public CallParameters(String uri) {
        this.qsd = new QueryStringDecoder(uri);
        this.path = uri.indexOf("?") > -1 ? uri.substring(0, uri.indexOf("?")) : uri;
        this.qsdMap = this.qsd.getParameters() == null ? new HashMap<String, List<String>>() : new HashMap<String, List<String>>(this.qsd.getParameters());
    }

    public void setParameterValue(String param, String val) {
        if (param == null) {
            return;
        }
        if (val == null) {
            this.qsdMap.remove(param);
            return;
        }
        ArrayList<String> valList = new ArrayList<String>();
        valList.add(val);
        this.qsdMap.put(param, valList);
    }

    public String getPath() {
        return this.qsd.getPath();
    }

    public String getRequestSignature(String key) {
        TreeMap<String, String> sortedParamMap = new TreeMap<String, String>();
        Map params = this.qsd.getParameters();
        for (String param : params.keySet()) {
            if ("sig".equalsIgnoreCase(param)) continue;
            List val = (List)params.get(param);
            String valStr = "";
            if (val.size() > 0) {
                valStr = (String)val.get(0);
            }
            sortedParamMap.put(param, valStr);
        }
        String canonicalQS = String.valueOf(this.path) + "?" + this.canonicalize(sortedParamMap);
        String sig = this.hmac(key, canonicalQS);
        String psig = CallParameters.percentEncodeRfc3986(sig);
        logger.info((Object)("Full Request to Encode: " + canonicalQS + " => Signature: " + psig));
        return psig;
    }

    private String canonicalize(SortedMap<String, String> sortedParamMap) {
        if (sortedParamMap.isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Iterator<Map.Entry<String, String>> iter = sortedParamMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> kvpair = iter.next();
            buffer.append(CallParameters.percentEncodeRfc3986(kvpair.getKey()));
            buffer.append("=");
            buffer.append(CallParameters.percentEncodeRfc3986(kvpair.getValue()));
            if (!iter.hasNext()) continue;
            buffer.append("&");
        }
        String cannoical = buffer.toString();
        return cannoical;
    }

    public static String percentEncodeRfc3986(String s) {
        String out;
        if (s == null) {
            return null;
        }
        try {
            out = URLEncoder.encode(s, UTF8_CHARSET).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            out = s;
        }
        return out;
    }

    private String hmac(String key, String stringToSign) {
        if (key == null) {
            return null;
        }
        Mac mac = keys.get(key);
        if (mac == null) {
            try {
                byte[] secretyKeyBytes = key.getBytes(UTF8_CHARSET);
                SecretKeySpec secretKeySpec = new SecretKeySpec(secretyKeyBytes, HMAC_SHA256_ALGORITHM);
                mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
                mac.init(secretKeySpec);
                keys.put(key, mac);
            }
            catch (Exception e) {
                return null;
            }
        }
        String signature = null;
        try {
            byte[] data = stringToSign.getBytes(UTF8_CHARSET);
            byte[] rawHmac = mac.doFinal(data);
            Base64 encoder = new Base64();
            signature = new String(encoder.encode(rawHmac));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 is unsupported!", e);
        }
        return signature;
    }

    public BasicDBList getParameterList() {
        BasicDBList ret = new BasicDBList();
        Map params = this.qsd.getParameters();
        for (String param : params.keySet()) {
            if ("sig".equalsIgnoreCase(param)) continue;
            List val = (List)params.get(param);
            String valStr = "";
            if (val.size() > 0) {
                valStr = (String)val.get(0);
            }
            ret.add((Object)new BasicDBObject(param, (Object)valStr));
        }
        return ret;
    }

    public <T> boolean has(ParameterDefinitionInt<T> param) {
        return param.hasValue(this.getParameter(param.getName()));
    }

    public <T> T get(ParameterDefinitionInt<T> param) {
        return param.getValue(this.getParameter(param.getName()));
    }

    public String getParameter(String name) {
        List<String> val = this.qsdMap.get(name);
        if (val == null || val.size() == 0) {
            return null;
        }
        return val.get(0);
    }

    public void setAuthInfo(Object o) {
        this.authObject = o;
    }

    public <T> T getAuthInfo(AuthenticationInt<T> authType) {
        return (T)this.authObject;
    }
}

