/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import com.untzuntz.ustackserverapi.CallParameters;
import com.untzuntz.ustackserverapi.params.ParamNames;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import org.bson.BSONObject;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.util.CharsetUtil;

public class APIResponse {
    static Logger logger = Logger.getLogger(APIResponse.class);
    public static String AccessControlAllowOrigin;
    public static final String ContentTypeTextXML = "text/xml";
    public static final String ContentTypeTextHTML = "text/html";
    public static final String ContentTypeTextPlain = "text/plain";
    public static final String ContentTypeJSON = "application/json";
    public static final String ContentTypeJSONP = "application/javascript";

    private static void addHeaders(Channel channel, HttpResponse res, String jsonpFunction) {
        if (AccessControlAllowOrigin != null) {
            res.setHeader("Access-Control-Allow-Origin", (Object)AccessControlAllowOrigin);
        }
        if (jsonpFunction != null) {
            res.setHeader("Access-Control-Allow-Origin", (Object)"*");
            res.setHeader("Content-type", (Object)ContentTypeJSONP);
        }
        if (channel.getAttachment() instanceof Long) {
            res.setHeader("X-Processing-Time", (Object)(System.currentTimeMillis() - (Long)channel.getAttachment()));
        }
    }

    public static void httpOk(Channel channel, String text, String contentType, CallParameters params) {
        String jsonpFunction = params.get(ParamNames.json_callback);
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        res.setHeader("Content-type", (Object)contentType);
        APIResponse.addHeaders(channel, (HttpResponse)res, jsonpFunction);
        if (jsonpFunction != null) {
            StringBuffer json = new StringBuffer();
            json.append(jsonpFunction);
            json.append("(").append(text).append(");");
            text = json.toString();
        }
        res.setContent(ChannelBuffers.copiedBuffer((CharSequence)text, (Charset)CharsetUtil.UTF_8));
        HttpHeaders.setContentLength((HttpMessage)res, (long)res.getContent().readableBytes());
        channel.write((Object)res).addListener(ChannelFutureListener.CLOSE);
    }

    public static void httpResponse(Channel channel, String text, String contentType, HttpResponseStatus status, CallParameters params) {
        String jsonpFunction = params.get(ParamNames.json_callback);
        logger.warn((Object)("Returning API Response [" + channel.getRemoteAddress() + "] => " + text));
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        res.setHeader("Content-type", (Object)contentType);
        APIResponse.addHeaders(channel, (HttpResponse)res, jsonpFunction);
        if (jsonpFunction != null) {
            StringBuffer json = new StringBuffer();
            json.append(jsonpFunction);
            json.append("(").append(text).append(");");
            text = json.toString();
        }
        res.setContent(ChannelBuffers.copiedBuffer((CharSequence)text, (Charset)CharsetUtil.UTF_8));
        HttpHeaders.setContentLength((HttpMessage)res, (long)res.getContent().readableBytes());
        channel.write((Object)res).addListener(ChannelFutureListener.CLOSE);
    }

    public static void httpError(Channel channel, String text, String contentType, CallParameters params) {
        APIResponse.httpError(channel, text, contentType, HttpResponseStatus.BAD_REQUEST, params);
    }

    public static void httpError(Channel channel, String text, String contentType, HttpResponseStatus status, CallParameters params) {
        String jsonpFunction = params.get(ParamNames.json_callback);
        logger.warn((Object)("Returning API Error [" + channel.getRemoteAddress() + "] => " + text));
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        res.setHeader("Content-type", (Object)contentType);
        APIResponse.addHeaders(channel, (HttpResponse)res, jsonpFunction);
        if (jsonpFunction != null) {
            StringBuffer json = new StringBuffer();
            json.append(jsonpFunction);
            json.append("(").append(text).append(");");
            text = json.toString();
        }
        res.setContent(ChannelBuffers.copiedBuffer((CharSequence)text, (Charset)CharsetUtil.UTF_8));
        HttpHeaders.setContentLength((HttpMessage)res, (long)res.getContent().readableBytes());
        channel.write((Object)res).addListener(ChannelFutureListener.CLOSE);
    }

    public static void httpOk(Channel channel, DBObject dbObject, CallParameters params) {
        APIResponse.httpOk(channel, JSON.serialize((Object)dbObject), ContentTypeJSON, params);
    }

    public static void httpResponse(Channel channel, DBObject dbObject, HttpResponseStatus status, CallParameters params) {
        APIResponse.httpResponse(channel, JSON.serialize((Object)dbObject), ContentTypeJSON, status, params);
    }

    public static void httpError(Channel channel, DBObject dbObject, CallParameters params) {
        APIResponse.httpError(channel, JSON.serialize((Object)dbObject), ContentTypeJSON, params);
    }

    public static void httpError(Channel channel, DBObject dbObject, HttpResponseStatus status, CallParameters params) {
        APIResponse.httpError(channel, JSON.serialize((Object)dbObject), ContentTypeJSON, status, params);
    }

    public static DBObject getResponseObject(String status) {
        return APIResponse.getResponseObject(status, null);
    }

    public static DBObject getResponseObject(String status, String msg) {
        BasicDBObject obj = new BasicDBObject();
        BasicDBObject result = new BasicDBObject();
        obj.put("apiResult", (Object)result);
        result.put("status", (Object)status);
        if (msg != null) {
            result.put("message", (Object)msg);
        }
        return obj;
    }

    public static DBObject getResponseObject(String status, DBObject ret) {
        BasicDBObject obj = new BasicDBObject();
        BasicDBObject result = new BasicDBObject();
        obj.put("apiResult", (Object)result);
        result.put("status", (Object)status);
        if (ret != null) {
            obj.putAll((BSONObject)ret);
        }
        return obj;
    }

    public static DBObject success(DBObject ret) {
        return APIResponse.getResponseObject("SUCCESS", ret);
    }

    public static DBObject error(DBObject ret) {
        return APIResponse.getResponseObject("ERROR", ret);
    }

    public static DBObject success(String msg) {
        return APIResponse.getResponseObject("SUCCESS", msg);
    }

    public static DBObject success() {
        return APIResponse.getResponseObject("SUCCESS", null);
    }

    public static DBObject error(String msg) {
        return APIResponse.getResponseObject("ERROR", msg);
    }
}

