/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserverapi;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.untzuntz.ustack.aaa.Authorization;
import com.untzuntz.ustack.aaa.UStackPermissionEnum;
import com.untzuntz.ustackserverapi.APICalls;
import com.untzuntz.ustackserverapi.APIException;
import com.untzuntz.ustackserverapi.APIExceptionDocumentation;
import com.untzuntz.ustackserverapi.CallParameters;
import com.untzuntz.ustackserverapi.InvalidAPIRequestException;
import com.untzuntz.ustackserverapi.MethodDefinition;
import com.untzuntz.ustackserverapi.MethodOrder;
import com.untzuntz.ustackserverapi.TestHttpChannel;
import com.untzuntz.ustackserverapi.auth.AuthorizationInt;
import com.untzuntz.ustackserverapi.params.APICallParam;
import com.untzuntz.ustackserverapi.params.ParamNames;
import com.untzuntz.ustackserverapi.params.Validated;
import com.untzuntz.ustackserverapi.params.types.ParameterDefinitionInt;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class APIDocumentation {
    static Logger logger = Logger.getLogger(APIDocumentation.class);
    public static String SystemName;
    public static String logoUrl;
    public static String version;
    protected static final HttpResponse BAD_REQ;
    protected static TestHttpChannel channel;
    protected static HttpRequest req;
    public static final Font LARGE;
    public static final Font COURIER;
    public static final Font NORMAL;
    public static final Font BOLD;
    public static final Font ITALIC;
    public static final Font BOLDITALIC;

    static {
        BAD_REQ = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
        LARGE = new Font(Font.FontFamily.HELVETICA, 24.0f, 1);
        COURIER = new Font(Font.FontFamily.COURIER, 12.0f, 0);
        NORMAL = new Font(Font.FontFamily.HELVETICA, 12.0f, 0);
        BOLD = new Font(Font.FontFamily.HELVETICA, 12.0f, 1);
        ITALIC = new Font(Font.FontFamily.HELVETICA, 12.0f, 2);
        BOLDITALIC = new Font(Font.FontFamily.HELVETICA, 12.0f, 3);
    }

    public static String getStringFromDoc(org.w3c.dom.Document doc) {
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)doc.getImplementation());
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        return lsSerializer.writeToString(doc);
    }

    public static org.w3c.dom.Document getDocumentationXML(String baseUrl, String codeType, String client_id, String api_key, int methodsPerColumn, HashMap<String, String> documentationDefaults) throws ParserConfigurationException, UnsupportedEncodingException, InstantiationException, IllegalAccessException, JSONException {
        if (methodsPerColumn == -1) {
            methodsPerColumn = 14;
        }
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        org.w3c.dom.Document doc = docBuilder.newDocument();
        Element docs = doc.createElement("doc");
        doc.appendChild(docs);
        Element systemName = doc.createElement("systemName");
        systemName.setTextContent(String.valueOf(SystemName) + " API Documentation");
        docs.appendChild(systemName);
        Element logoUrlNode = doc.createElement("logoUrl");
        logoUrlNode.setTextContent(logoUrl);
        docs.appendChild(logoUrlNode);
        Element base = doc.createElement("baseUrl");
        base.setTextContent(baseUrl);
        docs.appendChild(base);
        Element ver = doc.createElement("version");
        ver.setTextContent(version);
        docs.appendChild(ver);
        Element clientid = doc.createElement("client_id");
        clientid.setTextContent(client_id);
        docs.appendChild(clientid);
        Element apikey = doc.createElement("api_key");
        apikey.setTextContent(api_key);
        docs.appendChild(apikey);
        Element code = doc.createElement("codeType");
        code.setTextContent(codeType);
        docs.appendChild(code);
        Element errorsXml = doc.createElement("errors");
        docs.appendChild(errorsXml);
        List<APIException> errors = APICalls.getErrors();
        for (APIException error : errors) {
            Element errorXml = doc.createElement("error");
            errorsXml.appendChild(errorXml);
            APIDocumentation.addErrorInformation(doc, errorXml, error);
        }
        List<MethodDefinition> methods = APICalls.getMethods();
        Collections.sort(methods, new MethodOrder());
        Element toc = doc.createElement("toc");
        docs.appendChild(toc);
        Element tocCol = doc.createElement("N1");
        toc.appendChild(tocCol);
        Element tocGroup = doc.createElement("group");
        tocCol.appendChild(tocGroup);
        HashMap<String, Element> tocGroups = new HashMap<String, Element>();
        int cnt = 1;
        int tocColIdx = 1;
        Element methodsXml = doc.createElement("methods");
        docs.appendChild(methodsXml);
        for (MethodDefinition method : methods) {
            if (method.getOrder() >= 0) {
                if (method.getAuthenticationGroup() != null && !Authorization.authorizeAPIBool((String)client_id, (UStackPermissionEnum)method.getAuthenticationGroup())) continue;
                Element methodXml = doc.createElement("method");
                methodsXml.appendChild(methodXml);
                Element parentToc = tocGroup;
                if (method.getDocumentationGroup() != null && (parentToc = (Element)tocGroups.get(method.getDocumentationGroup())) == null) {
                    parentToc = doc.createElement("group");
                    APIDocumentation.addNode(doc, parentToc, "name", method.getDocumentationGroup());
                    tocCol.appendChild(parentToc);
                    tocGroups.put(method.getDocumentationGroup(), parentToc);
                }
                Element tocEntry = doc.createElement("entry");
                APIDocumentation.addNode(doc, tocEntry, "name", method.getMethodName());
                APIDocumentation.addNode(doc, tocEntry, "internalname", method.getMethodName().toLowerCase());
                parentToc.appendChild(tocEntry);
                APIDocumentation.addMethodInformation(doc, methodXml, baseUrl, client_id, api_key, method, documentationDefaults);
            }
            if (++cnt <= methodsPerColumn) continue;
            cnt = 0;
            tocCol = doc.createElement("N" + ++tocColIdx);
            toc.appendChild(tocCol);
            tocGroup = doc.createElement("group");
            tocCol.appendChild(tocGroup);
            tocGroups.clear();
        }
        return doc;
    }

    private static void addErrorInformation(org.w3c.dom.Document doc, Element parent, APIException error) throws JSONException {
        APIDocumentation.addNode(doc, parent, "name", error.getClass().getSimpleName());
        APIDocumentation.addNode(doc, parent, "description", ((APIExceptionDocumentation)((Object)error)).getReason());
        Element extras = doc.createElement("extras");
        parent.appendChild(extras);
        Field[] fields = error.getClass().getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field f = fields[i];
            String fieldName = f.getName();
            if (!"serialVersionUID".equals(fieldName)) {
                Element field = doc.createElement("field");
                extras.appendChild(field);
                APIDocumentation.addNode(doc, field, "name", fieldName);
            }
            ++i;
        }
        try {
            logger.info((Object)("Outputting type: " + error.getClass().getSimpleName()));
            JSONTokener tokener = new JSONTokener("" + error.toDBObject());
            JSONObject finalResult = new JSONObject(tokener);
            APIDocumentation.addNode(doc, parent, "responseExample", finalResult.toString(3));
        }
        catch (Exception e) {
            logger.error((Object)"failed to output example", (Throwable)e);
        }
    }

    private static void addMethodInformation(org.w3c.dom.Document doc, Element parent, String baseUrl, String client_id, String api_key, MethodDefinition def, HashMap<String, String> exampleParameterValues) throws UnsupportedEncodingException {
        Element argument;
        APIDocumentation.addNode(doc, parent, "name", def.getMethodName());
        APIDocumentation.addNode(doc, parent, "internalname", def.getMethodName().toLowerCase());
        APIDocumentation.addNode(doc, parent, "description", def.getDescription());
        APIDocumentation.addNode(doc, parent, "returns", "returns");
        String xMethod = "-X GET";
        StringBuffer methods = new StringBuffer();
        if (def.isMethodGET()) {
            methods.append("GET ");
        }
        if (def.isMethodPUT()) {
            methods.append("PUT ");
            xMethod = "-X PUT";
        }
        if (def.isMethodPOST()) {
            methods.append("POST ");
            xMethod = "-X POST";
        }
        if (def.isMethodDELETE()) {
            methods.append("DELETE ");
            xMethod = "-X DELETE";
        }
        ArrayList<String> reqParams = new ArrayList<String>();
        APIDocumentation.addNode(doc, parent, "httpMethod", methods.toString());
        APIDocumentation.addNode(doc, parent, "httpURL", String.valueOf(baseUrl) + def.getPath());
        Element arguments = doc.createElement("arguments");
        parent.appendChild(arguments);
        if (def.getAuthenticationMethod() != null) {
            List<ParameterDefinitionInt<?>> secArgs = def.getAuthenticationMethod().getAuthenticationParameters();
            for (ParameterDefinitionInt parameterDefinitionInt : secArgs) {
                Element argument2 = doc.createElement("argument");
                arguments.appendChild(argument2);
                APIDocumentation.addNode(doc, argument2, "name", parameterDefinitionInt.getName());
                APIDocumentation.addNode(doc, argument2, "description", parameterDefinitionInt.getDescription());
                APIDocumentation.addNode(doc, argument2, "optionalRequired", "required");
                APIDocumentation.addNode(doc, argument2, "type", "Type: " + parameterDefinitionInt.getTypeDescription());
                reqParams.add(String.valueOf(parameterDefinitionInt.getName()) + "=" + APIDocumentation.getExampleParamValue(def.getMethodName(), parameterDefinitionInt.getName(), exampleParameterValues));
            }
            for (AuthorizationInt authorizationInt : def.getAuthorizationMethods()) {
                List<ParameterDefinitionInt<?>> params = authorizationInt.getAuthenticationParameters();
                for (ParameterDefinitionInt<?> arg : params) {
                    Element argument3 = doc.createElement("argument");
                    arguments.appendChild(argument3);
                    APIDocumentation.addNode(doc, argument3, "name", arg.getName());
                    APIDocumentation.addNode(doc, argument3, "description", arg.getDescription());
                    APIDocumentation.addNode(doc, argument3, "optionalRequired", "required");
                    APIDocumentation.addNode(doc, argument3, "type", "Type: " + arg.getTypeDescription());
                    reqParams.add(String.valueOf(arg.getName()) + "=" + APIDocumentation.getExampleParamValue(def.getMethodName(), arg.getName(), exampleParameterValues));
                }
            }
        }
        List<APICallParam> args = def.getAPIParameters();
        if (!def.isClientVerCheckDisabled()) {
            Element element = doc.createElement("argument");
            arguments.appendChild(element);
            APIDocumentation.addNode(doc, element, "name", ParamNames.client_ver.getName());
            APIDocumentation.addNode(doc, element, "description", ParamNames.client_ver.getDescription());
            APIDocumentation.addNode(doc, element, "type", "Type: " + ParamNames.client_ver.getTypeDescription());
            APIDocumentation.addNode(doc, element, "optionalRequired", "required");
            reqParams.add(String.valueOf(ParamNames.client_ver.getName()) + "=" + APIDocumentation.getExampleParamValue(def.getMethodName(), ParamNames.client_ver.getName(), exampleParameterValues));
        }
        for (APICallParam aPICallParam : args) {
            boolean required = APIDocumentation.isParamRequired(def, aPICallParam.getParamDetails().getName());
            argument = doc.createElement("argument");
            arguments.appendChild(argument);
            APIDocumentation.addNode(doc, argument, "name", aPICallParam.getParamDetails().getName());
            APIDocumentation.addNode(doc, argument, "description", aPICallParam.getDescription());
            if (required) {
                APIDocumentation.addNode(doc, argument, "optionalRequired", "required");
                reqParams.add(String.valueOf(aPICallParam.getParamDetails().getName()) + "=" + APIDocumentation.getExampleParamValue(def.getMethodName(), aPICallParam.getParamDetails().getName(), exampleParameterValues));
            }
            APIDocumentation.addNode(doc, argument, "type", "Type: " + aPICallParam.getParamDetails().getTypeDescription());
            if (aPICallParam.getDefaultValue() != null) {
                APIDocumentation.addNode(doc, argument, "default", "Default value is " + aPICallParam.getDefaultValue());
            }
            if (aPICallParam.getVersion() == null) continue;
            APIDocumentation.addNode(doc, argument, "since", "Since: " + aPICallParam.getVersion().getVersionId());
        }
        List<ParameterDefinitionInt<?>> list = def.getVariesParams();
        for (ParameterDefinitionInt<?> arg : list) {
            argument = doc.createElement("argument");
            arguments.appendChild(argument);
            APIDocumentation.addNode(doc, argument, "name", arg.getName());
            APIDocumentation.addNode(doc, argument, "description", arg.getDescription());
            APIDocumentation.addNode(doc, argument, "optionalRequired", "varies");
            APIDocumentation.addNode(doc, argument, "type", "Type: " + arg.getTypeDescription());
            reqParams.add(String.valueOf(arg.getName()) + "=" + APIDocumentation.getExampleParamValue(def.getMethodName(), arg.getName(), exampleParameterValues));
        }
        boolean hasAnd = false;
        boolean dashDMode = true;
        StringBuffer params = new StringBuffer();
        StringBuffer csStr = new StringBuffer();
        int i = 0;
        while (i < reqParams.size()) {
            String cs = (String)reqParams.get(i);
            if (def.isMethodGET()) {
                if (dashDMode) {
                    csStr.append(" \\\n   -d ").append(cs);
                } else {
                    if (i == 0) {
                        csStr.append("?");
                    }
                    csStr.append(cs);
                    if (i + 1 < reqParams.size()) {
                        hasAnd = true;
                        csStr.append("&");
                    }
                }
            } else if (def.isMethodPUT() || def.isMethodDELETE()) {
                if (i == 0) {
                    csStr.append("?");
                }
                csStr.append(cs);
                if (i + 1 < reqParams.size()) {
                    hasAnd = true;
                    csStr.append("&");
                }
            } else if (def.isMethodPOST()) {
                csStr.append(" \\\n   -d ").append(cs);
            }
            params.append(cs);
            params.append("&");
            ++i;
        }
        String start = "curl " + xMethod + " ";
        if (hasAnd) {
            start = String.valueOf(start) + "\"";
            csStr.append("\"");
        }
        if (dashDMode && def.isMethodGET() && csStr.length() > 0) {
            csStr.append(" \\\n   -G");
        }
        if (def.getAuthenticationMethod() != null) {
            APIDocumentation.addNode(doc, parent, "authenticationInfo", def.getAuthenticationMethod().getAuthenticationDescription());
            if (def.getAuthenticationMethod().isBasicAuth()) {
                csStr.append(" \\\n   -u " + client_id + ":" + api_key);
            }
        }
        APIDocumentation.addNode(doc, parent, "codeSample", String.valueOf(start) + baseUrl + def.getPath() + csStr.toString());
        if (def.getOverrideDocumentationResponse() != null) {
            APIDocumentation.addNode(doc, parent, "responseExample", def.getOverrideDocumentationResponse());
        } else {
            String requestStr = String.format("%sclient_id=%s&api_key=%s&app_name=api_docs", params.toString(), client_id, api_key);
            String resp = null;
            try {
                resp = APIDocumentation.handleCall(def.getPath(), requestStr);
                JSONTokener tokener = new JSONTokener(resp);
                JSONObject finalResult = new JSONObject(tokener);
                APIDocumentation.addNode(doc, parent, "responseExample", finalResult.toString(3));
            }
            catch (Exception e) {
                logger.warn((Object)("Error generating documentation. Request was:\n" + def.getPath() + "?" + requestStr + "\nResponse is:\n" + resp), (Throwable)e);
                APIDocumentation.addNode(doc, parent, "responseExample", "(ERROR)");
            }
        }
    }

    private static String handleCall(String path, String params) throws Exception {
        if (channel == null) {
            req = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "");
            channel = new TestHttpChannel();
        }
        channel.write(null);
        StringBuffer fullQuery = new StringBuffer();
        fullQuery.append(path);
        fullQuery.append("?").append(params);
        MethodDefinition def = APICalls.getCallByURI(path);
        if (def == null) {
            throw new Exception("Invalid Path => " + path);
        }
        CallParameters cp = new CallParameters(fullQuery.toString());
        if (def.isAuthenticationRequired()) {
            cp.setAuthInfo(def.getAuthenticationMethod().authenticate(def, null, cp));
        }
        try {
            def.handleCall(channel, req, cp);
        }
        catch (InvalidAPIRequestException e) {
            channel.write(BAD_REQ);
        }
        catch (Exception iar) {
            logger.error((Object)"Failed to process sample call", (Throwable)iar);
            channel.write(BAD_REQ);
        }
        return channel.getResponseString();
    }

    private static String getExampleParamValue(String methodName, String arg, HashMap<String, String> exampleParameterValues) throws UnsupportedEncodingException {
        if (exampleParameterValues == null) {
            return "";
        }
        String exVal = exampleParameterValues.get(String.valueOf(methodName) + "-" + arg);
        if (exVal != null) {
            return APIDocumentation.urlEncode(exVal);
        }
        exVal = exampleParameterValues.get(arg);
        if (exVal != null) {
            return APIDocumentation.urlEncode(exVal);
        }
        return "";
    }

    private static String urlEncode(String val) throws UnsupportedEncodingException {
        return URLEncoder.encode(val, "UTF-8");
    }

    private static boolean isParamRequired(MethodDefinition def, String paramName) {
        for (Object val : def.getParameterValidation()) {
            APICallParam param;
            if (!(val instanceof APICallParam ? (param = (APICallParam)val).getParamDetails().getName().equals(paramName) : !(val instanceof Validated) && val instanceof ParameterDefinitionInt && ((ParameterDefinitionInt)val).getName().equals(paramName))) continue;
            return true;
        }
        return false;
    }

    private static void addNode(org.w3c.dom.Document doc, Element parent, String nodeName, String nodeVal) {
        if (nodeVal == null) {
            return;
        }
        Element methodXml = doc.createElement(nodeName);
        parent.appendChild(methodXml);
        methodXml.setTextContent(nodeVal);
    }

    public static void createPdf(String filename, String title, String version) throws IOException, DocumentException, SQLException {
        Document document = new Document();
        PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(filename));
        document.open();
        APIDocumentation.addTitle(document, title, version);
        APIDocumentation.addBasicInfo(document);
        List<MethodDefinition> methods = APICalls.getMethods();
        Collections.sort(methods, new MethodOrder());
        for (MethodDefinition method : methods) {
            System.out.println("Method: " + method.getMethodName());
        }
        for (MethodDefinition method : methods) {
            Paragraph p = APIDocumentation.createMethodInformation(method);
            p.setAlignment(0);
            p.setIndentationLeft(18.0f);
            p.setFirstLineIndent(-18.0f);
            document.add((com.itextpdf.text.Element)p);
            PdfPTable table = new PdfPTable(2);
            table.setWidths(new int[]{20, 80});
            table.setSpacingBefore(10.0f);
            table.setSpacingAfter(5.0f);
            table.setWidthPercentage(100.0f);
            table.getDefaultCell().setPadding(4.0f);
            APIDocumentation.addURI(method, table);
            APIDocumentation.addHTTPMethods(method, table);
            APIDocumentation.addAuthRequirements(method, table);
            APIDocumentation.addHashEnforcement(method, table);
            APIDocumentation.addSinceVersion(method, table);
            document.add((com.itextpdf.text.Element)table);
            table = new PdfPTable(4);
            table.setWidths(new int[]{20, 55, 15, 10});
            table.setSpacingBefore(10.0f);
            table.setSpacingAfter(20.0f);
            table.setWidthPercentage(100.0f);
            table.getDefaultCell().setPadding(4.0f);
            table.addCell(new Phrase("Parameter Name", BOLD));
            table.addCell(new Phrase("Description", BOLD));
            table.addCell(new Phrase("Required", BOLD));
            table.addCell(new Phrase("Since", BOLD));
            APIDocumentation.addParameters(method, table);
            document.add((com.itextpdf.text.Element)table);
        }
        document.close();
    }

    public static void addTitle(Document document, String title, String version) throws DocumentException {
        Paragraph p = new Paragraph();
        p.setFont(NORMAL);
        p.setAlignment(1);
        p.add((com.itextpdf.text.Element)new Phrase("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n" + title + "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n", LARGE));
        document.add((com.itextpdf.text.Element)p);
        p = new Paragraph();
        p.setFont(NORMAL);
        p.setAlignment(2);
        p.add((com.itextpdf.text.Element)new Phrase("Version " + version));
        document.add((com.itextpdf.text.Element)p);
        document.newPage();
    }

    public static void addBasicInfo(Document document) throws DocumentException {
        Paragraph p = new Paragraph();
        p.add((com.itextpdf.text.Element)new Phrase("Basic Request Information", BOLD));
        document.add((com.itextpdf.text.Element)p);
        p = new Paragraph();
        p.add((com.itextpdf.text.Element)new Phrase("The API users HTTP GET, POST, DELETE, and PUT requests for message exchange. Implementations may require a SSL-encrypted connection. Please note that all parameters should be properly encoded for use in HTTP.\n\n\n"));
        document.add((com.itextpdf.text.Element)p);
        p = new Paragraph();
        p.add((com.itextpdf.text.Element)new Phrase("Request Format", BOLD));
        document.add((com.itextpdf.text.Element)p);
        PdfPTable table = new PdfPTable(2);
        table.setWidths(new int[]{20, 80});
        table.setSpacingBefore(10.0f);
        table.setSpacingAfter(25.0f);
        table.setWidthPercentage(100.0f);
        table.getDefaultCell().setPadding(4.0f);
        table.addCell("GET");
        table.addCell("/api/path/method?param1=value1&param2=value2...");
        table.addCell("POST");
        table.addCell("/api/path/method\nRequest parameters posted per RFC 2616");
        document.add((com.itextpdf.text.Element)table);
        p = new Paragraph();
        p.add((com.itextpdf.text.Element)new Phrase("Request Signature", BOLD));
        document.add((com.itextpdf.text.Element)p);
        p = new Paragraph();
        p.add((com.itextpdf.text.Element)new Phrase("Certain API requests may require a request signature to be included as a parameter. The request signature should be calculated by sorting all request parameters alphabetically and performing a hmacSHA256 hash on the resulting URL encoded query string.\n\nExample Request: \n/api/test/hashtest?paramH=value1&paramA=value2 \n\nshould be calculated as the hash of:\n/api/test/hashtest?paramA=value2&paramH=value1\n\nNote: you can test your algorithm with the /api/test/hashtest call.\n\n\n"));
        document.add((com.itextpdf.text.Element)p);
        p = new Paragraph();
        p.add((com.itextpdf.text.Element)new Phrase("Authentication", BOLD));
        document.add((com.itextpdf.text.Element)p);
        p = new Paragraph();
        p.add((com.itextpdf.text.Element)new Phrase("If authentication is required the 'username' and 'accesscode' (user's password) parameters must be provided in each request.\n\nNote: If providing the hashed version of the user's password you must include the parameter s2=true\n\n\n"));
        document.add((com.itextpdf.text.Element)p);
        p = new Paragraph();
        p.add((com.itextpdf.text.Element)new Phrase("JSON", BOLD));
        document.add((com.itextpdf.text.Element)p);
        p = new Paragraph();
        p.add((com.itextpdf.text.Element)new Phrase("The API will respond with data in JSON format. See an example reponse below:"));
        document.add((com.itextpdf.text.Element)p);
        p = new Paragraph();
        p.add((com.itextpdf.text.Element)new Phrase("{\napiResult : { status : \"SUCCESS\" }\nmessage : \"Sample Message\"\nexampleObject : { a1 : 31, b1 : \"test\" }\n}", COURIER));
        document.add((com.itextpdf.text.Element)p);
        document.newPage();
    }

    public static Paragraph createMethodInformation(MethodDefinition method) {
        Paragraph p = new Paragraph();
        p.setFont(NORMAL);
        p.add((com.itextpdf.text.Element)APIDocumentation.getMethodHeader(method));
        p.add((com.itextpdf.text.Element)APIDocumentation.getMethodDescription(method));
        return p;
    }

    private static Paragraph getMethodHeader(MethodDefinition method) {
        Paragraph p = new Paragraph();
        p.setFont(NORMAL);
        p.add((com.itextpdf.text.Element)new Phrase("Method: "));
        p.add((com.itextpdf.text.Element)new Phrase(method.getMethodName(), BOLD));
        return p;
    }

    private static Paragraph getMethodDescription(MethodDefinition method) {
        Paragraph p = new Paragraph();
        p.setFont(NORMAL);
        p.add((com.itextpdf.text.Element)new Phrase(method.getDescription()));
        return p;
    }

    private static void addURI(MethodDefinition method, PdfPTable table) {
        table.addCell("URI");
        table.addCell("/api/" + method.getPath());
    }

    private static void addSinceVersion(MethodDefinition method, PdfPTable table) {
        table.addCell("Since Version");
        table.addCell(method.getSinceVersion().getVersionId());
    }

    private static void addAuthRequirements(MethodDefinition method, PdfPTable table) {
        table.addCell("Authentication");
        if (method.isAuthenticationRequired()) {
            table.addCell("Required");
        } else {
            table.addCell("No");
        }
    }

    private static void addHashEnforcement(MethodDefinition method, PdfPTable table) {
        table.addCell("Request Sig");
        if (method.getHashEnforcement() == 0) {
            table.addCell("No");
        } else if (method.getHashEnforcement() == 1) {
            table.addCell("Warn");
        } else if (method.getHashEnforcement() == 2) {
            table.addCell("Enforce");
        }
    }

    private static void addParameters(MethodDefinition method, PdfPTable table) {
        List<APICallParam> params = method.getAPIParameters();
        for (APICallParam param : params) {
            table.addCell(param.getParamDetails().getName());
            table.addCell(param.getDescription());
            table.addCell("TBD");
            table.addCell(param.getVersion().getVersionId());
        }
    }

    private static void addHTTPMethods(MethodDefinition method, PdfPTable table) {
        table.addCell("HTTP Method(s)");
        StringBuilder s = new StringBuilder();
        if (method.isMethodDELETE()) {
            s.append("DELETE ");
        }
        if (method.isMethodGET()) {
            s.append("GET ");
        }
        if (method.isMethodPOST()) {
            s.append("POST ");
        }
        if (method.isMethodPUT()) {
            s.append("PUT ");
        }
        table.addCell(s.toString());
    }
}

