/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserver.server;

import com.untzuntz.ustack.main.UOpts;
import com.untzuntz.ustackserver.peer.PeerDelivery;
import com.untzuntz.ustackserver.peer.PeerHandler;
import com.untzuntz.ustackserverapi.APICalls;
import com.untzuntz.ustackserverapi.APIException;
import com.untzuntz.ustackserverapi.APIResponse;
import com.untzuntz.ustackserverapi.CallParameters;
import com.untzuntz.ustackserverapi.InvalidAPIRequestException;
import com.untzuntz.ustackserverapi.MethodDefinition;
import com.untzuntz.ustackserverapi.auth.AuthorizationInt;
import com.untzuntz.ustackserverapi.params.ParamNames;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelUpstreamHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.util.CharsetUtil;
import org.jboss.netty.util.internal.ConcurrentHashMap;

public class ServerHandler
extends IdleStateAwareChannelUpstreamHandler {
    static Logger logger = Logger.getLogger(ServerHandler.class);
    static final ConcurrentHashMap<String, ChannelGroup> channels = new ConcurrentHashMap();
    private HttpRequest request;
    private boolean readingChunks;
    private String userName;
    private boolean realtimeEnabled;
    private final StringBuilder buf = new StringBuilder();

    static {
        UOpts.addMessageBundle((String)"com.untzuntz.ustack.resources.Messages");
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelOpen(ctx, e);
        logger.debug((Object)String.format("%s => Connection started", e.getChannel().getRemoteAddress()));
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (!this.readingChunks) {
            Object msg = e.getMessage();
            if (msg instanceof HttpRequest) {
                this.request = (HttpRequest)msg;
                if (HttpHeaders.is100ContinueExpected((HttpMessage)this.request)) {
                    this.send100Continue(e);
                }
                if (this.request.isChunked()) {
                    this.readingChunks = true;
                } else {
                    ChannelBuffer content = this.request.getContent();
                    this.handleHttpRequest(ctx, (HttpRequest)msg, content.toString(CharsetUtil.UTF_8));
                }
            }
        } else {
            HttpChunk chunk = (HttpChunk)e.getMessage();
            if (chunk.isLast()) {
                this.readingChunks = false;
                this.handleHttpRequest(ctx, this.request, this.buf.toString());
            } else {
                this.buf.append(chunk.getContent().toString(CharsetUtil.UTF_8));
            }
        }
    }

    private void send100Continue(MessageEvent e) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        e.getChannel().write((Object)response);
    }

    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) throws Exception {
        super.channelIdle(ctx, e);
        if (this.realtimeEnabled) {
            logger.info((Object)(e.getChannel().getRemoteAddress() + " => IDLE : " + e.getLastActivityTimeMillis() + " - " + e.getState()));
        }
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest req, String params) throws Exception {
        String[] uri = req.getUri().split("/");
        if ("index.html".equalsIgnoreCase(uri[1])) {
            APIResponse.httpOk(ctx.getChannel(), " ", "text/plain", null);
        } else if ("favicon.ico".equalsIgnoreCase(uri[1]) || uri.length < 1) {
            this.sendHttpResponse(ctx, req, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND));
        } else if ("api".equalsIgnoreCase(uri[1])) {
            this.handleAPI(ctx, req, params);
        } else {
            this.sendHttpResponse(ctx, req, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND));
        }
    }

    private void handleAPI(ChannelHandlerContext ctx, HttpRequest req, String paramStr) {
        String path = req.getUri().substring(5);
        if (req.getMethod() == HttpMethod.POST) {
            if (!path.endsWith("?") && paramStr.length() > 0) {
                path = String.valueOf(path) + "?";
            }
            path = String.valueOf(path) + paramStr;
        }
        CallParameters params = new CallParameters(path);
        path = params.getPath();
        logger.debug((Object)String.format("%s => API Path: %s [Client Ver: %s]", ctx.getChannel().getRemoteAddress(), path, params.get(ParamNames.client_ver)));
        long apiCallStart = System.currentTimeMillis();
        MethodDefinition cls = APICalls.getCallByURI(path);
        if (cls == null) {
            APIResponse.httpError(ctx.getChannel(), APIResponse.error("Unknown API Call Requested"), HttpResponseStatus.NOT_FOUND, params);
            return;
        }
        if (!(cls.isClientVerCheckDisabled() || params.get(ParamNames.client_ver) != null && params.get(ParamNames.client_ver).length() != 0)) {
            APIResponse.httpError(ctx.getChannel(), APIResponse.error("Client Version not provided"), HttpResponseStatus.BAD_REQUEST, params);
            return;
        }
        if (!cls.isMethodEnabled(req.getMethod())) {
            logger.info((Object)String.format("%s => API Path: %s || Invalid Method: %s", ctx.getChannel().getRemoteAddress(), path, req.getMethod().toString()));
            APIResponse.httpError(ctx.getChannel(), APIResponse.error("Invalid HTTP Method for API Call"), HttpResponseStatus.BAD_REQUEST, params);
            return;
        }
        if (cls.isAuthenticationRequired()) {
            try {
                params.setAuthInfo(cls.getAuthenticationMethod().authenticate(cls, req, params));
            }
            catch (APIException e) {
                APIResponse.httpError(ctx.getChannel(), APIResponse.error(e.getMessage()), HttpResponseStatus.BAD_REQUEST, params);
                return;
            }
        }
        if (cls.getHashEnforcement() > 0) {
            String sig = params.getRequestSignature(params.get(ParamNames.api_key));
            boolean failed = true;
            if (sig != null && params.has(ParamNames.RequestSignature) && sig.equals(params.get(ParamNames.RequestSignature))) {
                failed = false;
            }
            if (failed) {
                if (cls.getHashEnforcement() > 2) {
                    logger.warn((Object)String.format("%s [%s] Request Signature Mismatch -> Client Sent [%s], we expected [%s]", ctx.getChannel().getRemoteAddress(), path, params.get(ParamNames.RequestSignature), sig));
                } else if (cls.getHashEnforcement() > 2) {
                    APIResponse.httpError(ctx.getChannel(), APIResponse.error("Bad Request Signature"), HttpResponseStatus.BAD_REQUEST, params);
                    return;
                }
            }
        }
        try {
            cls.validateCall(params);
        }
        catch (APIException apiErr) {
            logger.warn((Object)String.format("%s [%s] API Exception => %s", ctx.getChannel().getRemoteAddress(), path, apiErr));
            APIResponse.httpError(ctx.getChannel(), APIResponse.error(apiErr.toDBObject()), HttpResponseStatus.BAD_REQUEST, params);
            return;
        }
        if (cls.isAuthorizationRequired()) {
            try {
                List<AuthorizationInt> auths = cls.getAuthorizationMethods();
                for (AuthorizationInt auth : auths) {
                    auth.authorize(cls, params);
                }
            }
            catch (ClassCastException cce) {
                logger.error((Object)String.format("%s [%s] Authorization failed due to an invalid authentication/authorization combo", ctx.getChannel().getRemoteAddress(), path), (Throwable)cce);
                APIResponse.httpError(ctx.getChannel(), APIResponse.error("Invalid Authentication/Authorization Combo"), HttpResponseStatus.BAD_REQUEST, params);
                return;
            }
            catch (APIException e) {
                APIResponse.httpError(ctx.getChannel(), APIResponse.error(e.getMessage()), HttpResponseStatus.BAD_REQUEST, params);
                return;
            }
        }
        try {
            cls.handleCall(ctx.getChannel(), req, params);
        }
        catch (APIException apiErr) {
            logger.warn((Object)String.format("%s [%s] API Exception => %s", ctx.getChannel().getRemoteAddress(), path, apiErr));
            APIResponse.httpError(ctx.getChannel(), APIResponse.error(apiErr.toDBObject()), HttpResponseStatus.BAD_REQUEST, params);
        }
        catch (InvalidAPIRequestException iar) {
            logger.warn((Object)String.format("%s [%s] Bad API Call", ctx.getChannel().getRemoteAddress(), path), (Throwable)iar);
            APIResponse.httpError(ctx.getChannel(), APIResponse.error("Invalid Request to API Call"), HttpResponseStatus.BAD_REQUEST, params);
        }
        catch (InvocationTargetException ierr) {
            if (ierr.getCause() != null) {
                if (ierr.getCause() instanceof APIException) {
                    APIException apiErr = (APIException)ierr.getCause();
                    logger.warn((Object)String.format("%s [%s] API Exception => %s", ctx.getChannel().getRemoteAddress(), path, apiErr));
                    APIResponse.httpError(ctx.getChannel(), APIResponse.error(apiErr.toDBObject()), HttpResponseStatus.BAD_REQUEST, params);
                } else {
                    if (ierr.getCause() instanceof NullPointerException) {
                        logger.warn((Object)String.format("%s [%s] Bad API Call => %s", ctx.getChannel().getRemoteAddress(), path, ierr.getCause()), ierr.getCause());
                    } else {
                        logger.warn((Object)String.format("%s [%s] Bad API Call => %s", ctx.getChannel().getRemoteAddress(), path, ierr.getCause()));
                    }
                    APIResponse.httpError(ctx.getChannel(), APIResponse.error(ierr.getCause().getMessage()), HttpResponseStatus.BAD_REQUEST, params);
                }
            } else {
                logger.warn((Object)String.format("%s [%s] Bad API Call", ctx.getChannel().getRemoteAddress(), path), (Throwable)ierr);
                APIResponse.httpError(ctx.getChannel(), APIResponse.error("Bad Request to API Call"), HttpResponseStatus.BAD_REQUEST, params);
            }
        }
        catch (Exception err) {
            logger.warn((Object)String.format("%s [%s] Uncaught Exception during API call", ctx.getChannel().getRemoteAddress(), path), (Throwable)err);
            APIResponse.httpError(ctx.getChannel(), APIResponse.error("Unknown Error"), HttpResponseStatus.BAD_REQUEST, params);
        }
        long apiCallFinish = System.currentTimeMillis();
        logger.info((Object)String.format("%s => API Path: %s [Client Ver: %s|%s] -> %d ms", ctx.getChannel().getRemoteAddress(), path, params.get(ParamNames.app_name), params.get(ParamNames.client_ver), apiCallFinish - apiCallStart));
    }

    public void handleRealtime(ChannelHandlerContext ctx, String[] uri) {
        this.realtimeEnabled = true;
        this.userName = uri[2];
        String targetName = uri[3];
        logger.info((Object)("LOGIN: " + this.userName));
        ChannelGroup cg = ServerHandler.getChannel(this.userName, true);
        cg.add((Object)ctx.getChannel());
        ChannelGroup tgt = ServerHandler.getChannel(targetName, false);
        if (tgt == null) {
            logger.info((Object)("Sending message to target via peers: " + targetName));
            PeerHandler.sendToPeers(new PeerDelivery(targetName));
            return;
        }
        logger.info((Object)("Sending message to target: " + targetName + " (" + tgt.size() + " connections)"));
        ServerHandler.sendToGroup(tgt, targetName);
    }

    public static void sendToGroup(ChannelGroup tgt, String message) {
        for (Channel c : tgt) {
            DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            res.setContent(ChannelBuffers.copiedBuffer((CharSequence)(String.valueOf(message) + "\r\n"), (Charset)CharsetUtil.UTF_8));
            HttpHeaders.setContentLength((HttpMessage)res, (long)res.getContent().readableBytes());
            c.write((Object)res).addListener(ChannelFutureListener.CLOSE);
        }
    }

    public static ChannelGroup getChannel(String u, boolean add) {
        ChannelGroup cg = (ChannelGroup)channels.get((Object)u);
        if (cg == null && add) {
            cg = new DefaultChannelGroup();
            channels.put((Object)u, (Object)cg);
        }
        return cg;
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, HttpResponse res) {
        if (res.getStatus().getCode() != 200) {
            res.setContent(ChannelBuffers.copiedBuffer((CharSequence)res.getStatus().toString(), (Charset)CharsetUtil.UTF_8));
            HttpHeaders.setContentLength((HttpMessage)res, (long)res.getContent().readableBytes());
        }
        ChannelFuture f = ctx.getChannel().write((Object)res);
        if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().getCode() != 200) {
            f.addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (e.getCause() instanceof IOException) {
            logger.info((Object)String.format("%s => Client closed their request", e.getChannel().getRemoteAddress()));
        } else {
            logger.warn((Object)String.format("%s => Error during API handling [%s]", e.getChannel().getRemoteAddress(), e.getCause()), e.getCause());
        }
        e.getChannel().close();
        this.cleanup(e.getChannel());
    }

    private void cleanup(Channel channel) {
        if (this.userName != null) {
            logger.info((Object)("Cleaning channel : " + this.userName));
            ChannelGroup cg = (ChannelGroup)channels.get((Object)this.userName);
            if (cg != null) {
                cg.remove((Object)channel);
                if (cg.size() == 0) {
                    channels.remove((Object)this.userName);
                }
            }
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelClosed(ctx, e);
        this.cleanup(e.getChannel());
        long timing = 0L;
        if (e.getChannel().getAttachment() != null) {
            timing = System.currentTimeMillis() - (Long)e.getChannel().getAttachment();
        }
        logger.info((Object)String.format("%s => Connection Closed [%d ms]", e.getChannel().getRemoteAddress(), timing));
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelDisconnected(ctx, e);
        this.cleanup(e.getChannel());
    }
}

