/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserver.peer;

import com.untzuntz.ustackserver.peer.PeerDelivery;
import com.untzuntz.ustackserver.server.ServerHandler;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;

public class PeerHandler
extends SimpleChannelUpstreamHandler {
    static Logger logger = Logger.getLogger(PeerHandler.class);
    static final ChannelGroup peers = new DefaultChannelGroup();

    public static ChannelGroup getPeerChannelGroup() {
        return peers;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelOpen(ctx, e);
        peers.add((Object)ctx.getChannel());
    }

    public static void sendToPeers(PeerDelivery delivery) {
        logger.info((Object)("\t- Sending to " + peers.size() + " peers"));
        for (Channel c : PeerHandler.getPeerChannelGroup()) {
            c.write((Object)delivery);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        if (e.getMessage() instanceof PeerDelivery) {
            PeerDelivery delivery = (PeerDelivery)e.getMessage();
            ChannelGroup tgt = ServerHandler.getChannel(delivery.getTarget(), false);
            if (tgt != null) {
                logger.info((Object)("Delivery to : " + delivery.getTarget()));
                ServerHandler.sendToGroup(tgt, "Test Message");
            } else {
                logger.info((Object)("Delivery to unknown : " + delivery.getTarget()));
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        logger.warn((Object)"Unexpected exception from downstream.", e.getCause());
        e.getChannel().close();
    }
}

