/*
 * Decompiled with CFR 0.152.
 */
package com.untzuntz.ustackserver.loadtest;

import com.untzuntz.ustackserver.loadtest.HttpClientPipelineFactory;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;

public class RunTest {
    static Logger logger = Logger.getLogger(RunTest.class);
    private long totalTime;
    private long totalConnTime;
    private int totalCount;
    private long start;

    public synchronized void add(int cnt, long time, long connTime) {
        this.totalTime += time;
        this.totalConnTime += connTime;
        this.totalCount += cnt;
        if (this.totalCount % 100 == 0) {
            long runTime = System.currentTimeMillis() - this.start;
            long rps = (long)((float)this.totalCount / ((float)runTime / 1000.0f));
            long avg = (long)((float)this.totalTime / (float)this.totalCount);
            long cavg = (long)((float)this.totalConnTime / (float)this.totalCount);
            logger.info((Object)(String.valueOf(runTime) + " | " + rps + " req/sec : " + this.totalCount + " @ " + avg + " ms average (connection time avg: " + cavg + "ms)"));
            if (runTime > 300000L) {
                System.exit(0);
            }
        }
    }

    public static void main(String[] args) {
        int runThreads = 100;
        if (args.length >= 1) {
            runThreads = Integer.valueOf(args[0]);
        }
        RunTest rt = new RunTest();
        rt.go(runThreads);
    }

    private void go(int runThreads) {
        DOMConfigurator.configure((String)"log4j.xml");
        ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new HttpClientPipelineFactory());
        bootstrap.setOption("reuseAddress", (Object)true);
        bootstrap.setOption("tcpNoDelay", (Object)true);
        bootstrap.setOption("keepAlive", (Object)false);
        bootstrap.setOption("connectTimeoutMillis", (Object)20000);
        this.start = System.currentTimeMillis();
        InetSocketAddress serverAddr = new InetSocketAddress("twf-api1.untzuntz.com", 80);
        int i = 1;
        while (i <= runThreads) {
            Worker W = new Worker(serverAddr, bootstrap);
            W.start();
            if (i % 50 == 0) {
                logger.info((Object)("Created " + i + " threads..."));
            }
            ++i;
        }
    }

    class Worker
    extends Thread
    implements Runnable {
        private int count;
        private long total;
        private long ctotal;
        private boolean stop = false;

        public Worker(InetSocketAddress s, ClientBootstrap bs) {
        }

        @Override
        public void run() {
            URL url = null;
            try {
                url = new URL("http://ifc4.cvg.intelegrid.net/api/music/status");
            }
            catch (Exception exception) {}
            while (!this.stop) {
                try {
                    long cstart = System.currentTimeMillis();
                    long st = System.currentTimeMillis();
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    long cend = System.currentTimeMillis() - cstart;
                    if (conn.getResponseCode() == 200) {
                        long tot = System.currentTimeMillis() - st;
                        ++this.count;
                        this.total += tot;
                        this.ctotal += cend;
                        if (this.count == 10) {
                            RunTest.this.add(this.count, this.total, this.ctotal);
                            this.total = 0L;
                            this.count = 0;
                        }
                        conn.disconnect();
                        continue;
                    }
                    logger.warn((Object)"Invalid Response");
                }
                catch (Throwable e) {
                    logger.error((Object)"Error while getting status from client", e);
                }
            }
        }
    }
}

